/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ٸ߼PWMʱ PWM1P/PWM1N,PWM2P/PWM2N,PWM3P/PWM3N,PWM4P/PWM4N ÿͨɶʵPWMԳ.

8ͨPWMöӦP08˿.

ͨP0ӵ8LEDƣPWMʵֺЧ.

PWMںռձȿԸҪã߿ɴ65535.

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

/****************************** û ***********************************/

#define MAIN_Fosc       24000000UL
#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))   //Timer 0 жƵ, 1000/

/*****************************************************************************/

#define    HSCK_MCLK        0
#define    HSCK_PLL         1
#define    HSCK_SEL         HSCK_PLL

#define    PLL_96M          0
#define    PLL_144M         1
#define    PLL_SEL          PLL_144M

#define    CKMS             0x80
#define    HSIOCK           0x40
#define    MCK2SEL_MSK      0x0c
#define    MCK2SEL_SEL1     0x00
#define    MCK2SEL_PLL      0x04
#define    MCK2SEL_PLLD2    0x08
#define    MCK2SEL_IRC48    0x0c
#define    MCKSEL_MSK       0x03
#define    MCKSEL_HIRC      0x00
#define    MCKSEL_XOSC      0x01
#define    MCKSEL_X32K      0x02
#define    MCKSEL_IRC32K    0x03

#define    ENCKM            0x80
#define    PCKI_MSK         0x60
#define    PCKI_D1          0x00
#define    PCKI_D2          0x20
#define    PCKI_D4          0x40
#define    PCKI_D8          0x60

/*************  س    **************/

#define PWM1_0      0x00    //P:P1.0  N:P1.1
#define PWM1_1      0x01    //P:P0.0  N:P0.1
#define PWM1_2      0x02    //P:P2.0  N:P2.1

#define PWM2_0      0x00    //P:P1.2  N:P1.3
#define PWM2_1      0x04    //P:P0.2  N:P0.3
#define PWM2_2      0x08    //P:P2.2  N:P2.3

#define PWM3_0      0x00    //P:P1.4  N:P1.5
#define PWM3_1      0x10    //P:P0.4  N:P0.5
#define PWM3_2      0x20    //P:P2.4  N:P2.5

#define PWM4_0      0x00    //P:P1.6  N:P1.7
#define PWM4_1      0x40    //P:P0.6  N:P0.7
#define PWM4_2      0x80    //P:P2.6  N:P2.7

#define ENO1P       0x01
#define ENO1N       0x02
#define ENO2P       0x04
#define ENO2N       0x08
#define ENO3P       0x10
#define ENO3N       0x20
#define ENO4P       0x40
#define ENO4N       0x80

#define PWM_PERIOD  1023    //ֵ

/*************  ر    **************/

bit B_1ms;          //1ms־

u16 PWM1_Duty;
u16 PWM2_Duty;
u16 PWM3_Duty;
u16 PWM4_Duty;

bit PWM1_Flag;
bit PWM2_Flag;
bit PWM3_Flag;
bit PWM4_Flag;

void PllConfig(void);
void HSPwmConfig(void);
void UpdatePwm(void);

/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    PWM1_Flag = 0;
    PWM2_Flag = 0;
    PWM3_Flag = 0;
    PWM4_Flag = 0;
    
    PWM1_Duty = 0;
    PWM2_Duty = 256;
    PWM3_Duty = 512;
    PWM4_Duty = 1024;

    //  Timer0ʼ
    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;        //Timer0 interrupt enable
    TR0 = 1;        //Tiner0 run

    P6SR = 0x00;    //IOڵƽתٶȼӿ

    PWMA_PS = 0x00; //߼ PWM ͨѡλ
    PWMA_PS |= PWM1_1; //ѡ PWM1_1 ͨ
    PWMA_PS |= PWM2_1; //ѡ PWM2_1 ͨ
    PWMA_PS |= PWM3_1; //ѡ PWM3_1 ͨ
    PWMA_PS |= PWM4_1; //ѡ PWM4_1 ͨ

    PllConfig();
    HSPwmConfig();

    P40 = 0;    //LED
    EA = 1;     //ж

    while (1);
}

/********************** Timer0 1msжϺ ************************/
void timer0(void) interrupt 1
{
    if(!PWM1_Flag)
    {
        PWM1_Duty++;
        if(PWM1_Duty > PWM_PERIOD) PWM1_Flag = 1;
    }
    else
    {
        PWM1_Duty--;
        if(PWM1_Duty <= 0) PWM1_Flag = 0;
    }

    if(!PWM2_Flag)
    {
        PWM2_Duty++;
        if(PWM2_Duty > PWM_PERIOD) PWM2_Flag = 1;
    }
    else
    {
        PWM2_Duty--;
        if(PWM2_Duty <= 0) PWM2_Flag = 0;
    }

    if(!PWM3_Flag)
    {
        PWM3_Duty++;
        if(PWM3_Duty > PWM_PERIOD) PWM3_Flag = 1;
    }
    else
    {
        PWM3_Duty--;
        if(PWM3_Duty <= 0) PWM3_Flag = 0;
    }

    if(!PWM4_Flag)
    {
        PWM4_Duty++;
        if(PWM4_Duty > PWM_PERIOD) PWM4_Flag = 1;
    }
    else
    {
        PWM4_Duty--;
        if(PWM4_Duty <= 0) PWM4_Flag = 0;
    }
    
    UpdatePwm();
}

//========================================================================
// : delay(void)
// : ʱ. 
// : none.
// : none.
// 汾: V1.0, 2022-03-16
//========================================================================
void delay(void)
{
    u8 i;
    for(i=0; i<100; i++);
}

//========================================================================
// : ReadPWMA(void)
// : 첽ȡPWMA⹦ܼĴ. 
// : addr: ȡ⹦ܼĴַ.
// : dat:  ȡ⹦ܼĴ.
// 汾: V1.0, 2022-03-16
//========================================================================
//u8 ReadPWMA(u8 addr)
//{
//    u8 dat;
//    
//    while (HSPWMA_ADR & 0x80);    //ȴǰһ첽д
//    HSPWMA_ADR = addr | 0x80;     //üӷʵַ,ֻҪԭXFRַĵ7λ
//                                  //HSPWMA_ADDRĴλд1,ʾ
//    while (HSPWMA_ADR & 0x80);    //ȴǰ첽ȡ
//    dat = HSPWMA_DAT;             //ȡ첽
//    
//    return dat;
//}

//========================================================================
// : WritePWMA(void)
// : 첽ȡPWMA⹦ܼĴ. 
// : addr: д⹦ܼĴַ.
// : dat:  д⹦ܼĴ.
// : none.
// 汾: V1.0, 2022-03-16
//========================================================================
void WritePWMA(u8    addr, u8 dat)
{
    while (HSPWMA_ADR & 0x80);  //ȴǰһ첽д
    HSPWMA_DAT = dat;           //׼Ҫд
    HSPWMA_ADR = addr & 0x7f;   //üӷʵַ,ֻҪԭXFRַĵ7λ
                                //HSPWMA_ADDRĴλд0,ʾд
}

//========================================================================
// : PllConfig(void)
// : PWMʱӳʼ. 
// : none.
// : none.
// 汾: V1.0, 2022-03-16
//========================================================================
void PllConfig(void)
{
    //ѡPLLʱ
#if(PLL_SEL ==    PLL_96M)
    CLKSEL &= ~CKMS;            //ѡPLL96MΪPLLʱ
#elif(PLL_SEL == PLL_144M)
    CLKSEL |= CKMS;             //ѡPLL144MΪPLLʱ
#else
    CLKSEL &= ~CKMS;            //ĬѡPLL96MΪPLLʱ
#endif
    
    //ѡPLLʱӷƵ,֤ʱΪ12M
    USBCLK &= ~PCKI_MSK;
#if(MAIN_Fosc == 12000000UL)
    USBCLK |= PCKI_D1;            //PLLʱ1Ƶ
#elif(MAIN_Fosc    == 24000000UL)
    USBCLK |= PCKI_D2;            //PLLʱ2Ƶ
#elif(MAIN_Fosc    == 48000000UL)
    USBCLK |= PCKI_D4;            //PLLʱ4Ƶ
#elif(MAIN_Fosc    == 96000000UL)
    USBCLK |= PCKI_D8;            //PLLʱ8Ƶ
#else
    USBCLK |= PCKI_D1;            //ĬPLLʱ1Ƶ
#endif

    //PLL
    USBCLK |= ENCKM;            //ʹPLLƵ
    
    delay();                    //ȴPLLƵ

    //ѡHSPWM/HSSPIʱ
#if(HSCK_SEL == HSCK_MCLK)
    CLKSEL &= ~HSIOCK;          //HSPWM/HSSPIѡʱΪʱԴ
#elif(HSCK_SEL    == HSCK_PLL)
    CLKSEL |= HSIOCK;           //HSPWM/HSSPIѡPLLʱΪʱԴ
#else
    CLKSEL &= ~HSIOCK;          //ĬHSPWM/HSSPIѡʱΪʱԴ
#endif

    HSCLKDIV = 0;               //HSPWM/HSSPIʱԴƵ
}

//========================================================================
// : HSPwmConfig(void)
// : PWMʼ. 
// : none.
// : none.
// 汾: V1.0, 2022-03-16
//========================================================================
void HSPwmConfig(void)
{
    HSPWMA_CFG = 0x03;            //ʹPWMAؼĴ첽ʹ
    
    //ͨ첽ʽPWMAؼĴ
    WritePWMA((u8)&PWMA_CCER1, 0x00);
    WritePWMA((u8)&PWMA_CCER2, 0x00);
    WritePWMA((u8)&PWMA_CCMR1, 0x60);            //ͨģʽ
    WritePWMA((u8)&PWMA_CCMR2, 0x60);
    WritePWMA((u8)&PWMA_CCMR3, 0x60);
    WritePWMA((u8)&PWMA_CCMR4, 0x60);
    WritePWMA((u8)&PWMA_CCER1, 0x55);            //ͨʹܺͼ
    WritePWMA((u8)&PWMA_CCER2, 0x55);
    WritePWMA((u8)&PWMA_CCMR1, 0x68);            //PWMA_CCR1Ԥתع(ҪCC1E=1ſд)
    WritePWMA((u8)&PWMA_CCMR2, 0x68);
    WritePWMA((u8)&PWMA_CCMR3, 0x68);
    WritePWMA((u8)&PWMA_CCMR4, 0x68);
    WritePWMA((u8)&PWMA_ENO, ENO1P|ENO1N|ENO2P|ENO2N|ENO3P|ENO3N|ENO4P|ENO4N);    //ʹPWMź˿
    WritePWMA((u8)&PWMA_CCR1H, (u8)(PWM1_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR1L, (u8)PWM1_Duty);
    WritePWMA((u8)&PWMA_CCR2H, (u8)(PWM2_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR2L, (u8)PWM2_Duty);
    WritePWMA((u8)&PWMA_CCR3H, (u8)(PWM3_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR3L, (u8)PWM3_Duty);
    WritePWMA((u8)&PWMA_CCR4H, (u8)(PWM4_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR4L, (u8)PWM4_Duty);
    WritePWMA((u8)&PWMA_ARRH,  (u8)(PWM_PERIOD >> 8));   //PWM
    WritePWMA((u8)&PWMA_ARRL,  (u8)PWM_PERIOD);
    WritePWMA((u8)&PWMA_DTR, 10);                  //ûԳPWM
    WritePWMA((u8)&PWMA_BKR, 0x80);                //ʹ
    WritePWMA((u8)&PWMA_CR1, 0x81);                //ʹARRԤװأʼPWM
}

//========================================================================
// : UpdatePwm(void)
// : PWMռձ. 
// : none.
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void UpdatePwm(void)
{
    WritePWMA((u8)&PWMA_CCR1H, (u8)(PWM1_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR1L, (u8)PWM1_Duty);
    WritePWMA((u8)&PWMA_CCR2H, (u8)(PWM2_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR2L, (u8)PWM2_Duty);
    WritePWMA((u8)&PWMA_CCR3H, (u8)(PWM3_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR3L, (u8)PWM3_Duty);
    WritePWMA((u8)&PWMA_CCR4H, (u8)(PWM4_Duty >> 8));    //PWMռձ
    WritePWMA((u8)&PWMA_CCR4L, (u8)PWM4_Duty);
}
