
/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/



#include	"stc.h"
#include	"usb.h"
#include	"uart.h"
#include 	<math.h>
#include	"T-A-LAW.h"	//Aʶ, ƽʹöʾ


/*************	˵	**************

ʹAI8051UϵMCU256FFT, ϴaiapp-ispʾƵ. MCUƵ:40MHz.
ADCʹDMA
ʹAI8051UʵV1.1֤, ʾ·Ƶź, ADCFFT, aiapp-ispʾʾ.

: 25600Hz, ʱ10ms
FFT: 256.
FFTƵʵ: 128.
FFTƵƵ: 0~12700Hz, ֱ100Hz.

ƬϴЭ飺
ϴһ֡ݣFB DAT0 DAT1 ..... DAT127 FF
    FB֡
    DAT0 ... DAT127128YݣֵΪ0~250ֽ0~399Xᡣ
    FF֡ݽ

AI8051U @40MHz : 25.6KHz, ʱ10ms, Ӳ+, ֻ6.5ms, +ϴ 6.8ms, 2ϴһ, ʾˢƵ50Hz, Ƶˢ.


******************************************/


//---------------------------------------------------------------------


/*************	س	**************/


/*************	IO	**************/


/*************	ر	**************/

#define  CHANNEL  2			  //ADCͨ(ͷͨ),   ȡֵΪ0~7, ӦP1.0~P1.7, ʹñADCҪ޸ADCʼ.
#define	SAMPLE_RATE	36000	//, ʵʲΪ25600Hz, ΪADC DMAԶʱADCɲDMAݺʼʱġʵʼʱ = ADCʱ+DMAʱ+ʱ
#define	SAMPLES		256		//

int	xdata adc_buf1[SAMPLES*3];	//ADCŵ, [n][0]Ϊÿתֵ, [n][1]ֽΪADCͨ,ֽΪȡƽֵ,  [n][2)]Ϊƽֵ
int	xdata adc_buf2[SAMPLES*3];	//ADCŵ, [n][0]Ϊÿתֵ, [n][1]ֽΪADCͨ,ֽΪȡƽֵ,  [n][2)]Ϊƽֵ
bit	B_ADC_DMA_ok;	//ADC DMAɱ־(û־)

int	xdata	sample[SAMPLES];	// ADC
int xdata	FFT_Real[SAMPLES];	// fftʵ
int xdata	FFT_Image[SAMPLES];	// fft鲿
u16	xdata 	FFT_A[SAMPLES/2];	// Ƶķ
u8	cal_cnt;	//
u8	edata amplitude[SAMPLES/2];	//
bit	B_adc_buf;	// 0: adc_buf1[], 1: adc_buf2[],
bit	B_SampleOk;	// 0: adc_buf1[], 1: adc_buf2[],

u8	KeyCode;


/*************	غ	**************/


#define	SCALE	1024	//ֵֵŴϵ

//0~180ұŴ1024(256FFTʱ)
const int COS_TABLE[SAMPLES/2]=
{
  1024,  1024,  1023,  1021,  1019,  1016,  1013,  1009,  1004,  999,   993,   987,   980,   972,   964,   955,
   946,   936,   926,   915,   903,   891,   878,   865,   851,  837,   822,   807,   792,   775,   759,   742,
   724,   706,   688,   669,   650,   630,   610,  590,    569,  548,   526,   505,   483,   460,   438,   415,
   392,   369,   345,   321,   297,   273,   249,   224,   200,  175,   150,   125,   100,    75,    50,    25,
     0,   -25,   -50,   -75,  -100,  -125,  -150,  -175,  -200, -224,  -249,  -273,  -297,  -321,  -345,  -369,
  -392,  -415,  -438,  -460,  -483,  -505,  -526,  -548,  -569, -590,  -610,  -630,  -650,  -669,  -688,  -706,
  -724,  -742,  -759,  -775,  -792,  -807,  -822,  -837,  -851, -865,  -878,  -891,  -903,  -915,  -926,  -936,
  -946,  -955,  -964,  -972,  -980,  -987,  -993,  -999, -1004,-1009, -1013, -1016, -1019, -1021, -1023,  -1024
};

//0~180ұŴ1024(256FFTʱ)
const int SIN_TABLE[SAMPLES/2]=
{
     0,    25,    50,    75,   100,   125,   150,   175,   200,   224,   249,   273,   297,   321,   345,   369,
   392,   415,   438,   460,   483,   505,   526,   548,   569,   590,   610,   630,   650,   669,   688,   706,
   724,   742,   759,   775,   792,   807,   822,   837,   851,   865,   878,   891,   903,   915,   926,   936,
   946,   955,   964,   972,   980,   987,   993,   999,  1004,  1009,  1013,  1016,  1019,  1021,  1023,  1024,
  1024,  1024,  1023,  1021,  1019,  1016,  1013,  1009,  1004,   999,   993,   987,   980,   972,   964,   955,
   946,   936,   926,   915,   903,   891,   878,   865,   851,   837,   822,   807,   792,   775,   759,   742,
   724,   706,   688,   669,   650,   630,   610,   590,   569,   548,   526,   505,   483,   460,   438,   415,
   392,   369,   345,   321,   297,   273,   249,   224,   200,   175,   150,   125,   100,    75,    50,    25,
};

//洢б()	FFT 256㷴ʮ:
const u8 LIST_TAB[256] = {
   0, 128,  64, 192,  32, 160,  96, 224,  16, 144,  80, 208,  48, 176, 112, 240,
   8, 136,  72, 200,  40, 168, 104, 232,  24, 152,  88, 216,  56, 184, 120, 248,
   4, 132,  68, 196,  36, 164, 100, 228,  20, 148,  84, 212,  52, 180, 116, 244,
  12, 140,  76, 204,  44, 172, 108, 236,  28, 156,  92, 220,  60, 188, 124, 252,
   2, 130,  66, 194,  34, 162,  98, 226,  18, 146,  82, 210,  50, 178, 114, 242,
  10, 138,  74, 202,  42, 170, 106, 234,  26, 154,  90, 218,  58, 186, 122, 250,
   6, 134,  70, 198,  38, 166, 102, 230,  22, 150,  86, 214,  54, 182, 118, 246,
  14, 142,  78, 206,  46, 174, 110, 238,  30, 158,  94, 222,  62, 190, 126, 254,
   1, 129,  65, 193,  33, 161,  97, 225,  17, 145,  81, 209,  49, 177, 113, 241,
   9, 137,  73, 201,  41, 169, 105, 233,  25, 153,  89, 217,  57, 185, 121, 249,
   5, 133,  69, 197,  37, 165, 101, 229,  21, 149,  85, 213,  53, 181, 117, 245,
  13, 141,  77, 205,  45, 173, 109, 237,  29, 157,  93, 221,  61, 189, 125, 253,
   3, 131,  67, 195,  35, 163,  99, 227,  19, 147,  83, 211,  51, 179, 115, 243,
  11, 139,  75, 203,  43, 171, 107, 235,  27, 155,  91, 219,  59, 187, 123, 251,
   7, 135,  71, 199,  39, 167, 103, 231,  23, 151,  87, 215,  55, 183, 119, 247,
  15, 143,  79, 207,  47, 175, 111, 239,  31, 159,  95, 223,  63, 191, 127, 255
};


/********************************************************************
ܣFFT㡣
ڲnone.
    أnone.
********************************************************************/
void FFT(void)
{
	u16 i,j;
	u16 BlockSize;
	int tr,ti;
	u8 OffSet1,OffSet2;
	long co,si;

	for(j=0; j<SAMPLES; j+=2)	//ȼ2
	{
		tr       = sample[j+1];
		FFT_Real[j+1] = (sample[j] - tr);
		FFT_Image[j+1] = 0;
		FFT_Real[j]   = (sample[j] + tr);
		FFT_Image[j]   = 0;
	}

	for(BlockSize=4; BlockSize<=SAMPLES; BlockSize<<=1) //һ
	{
		for(j=0; j<SAMPLES; j+=BlockSize)
		{
			for(i=0; i<BlockSize/2; i++)
			{
				OffSet1 = SAMPLES/BlockSize * i;
				co = (long)COS_TABLE[OffSet1];
				si = (long)SIN_TABLE[OffSet1];

				OffSet1 = i + j;
				OffSet2 = OffSet1 + BlockSize/2;
				tr = (co*FFT_Real[ OffSet2] + si*FFT_Image[OffSet2]) / SCALE;
				ti = (co*FFT_Image[OffSet2] - si*FFT_Real[ OffSet2]) / SCALE;

				FFT_Real[ OffSet2] = (FFT_Real[ OffSet1] - tr) >> 1;
				FFT_Image[OffSet2] = (FFT_Image[OffSet1] - ti) >> 1;
				FFT_Real[ OffSet1] = (FFT_Real[ OffSet1] + tr) >> 1;
				FFT_Image[OffSet1] = (FFT_Image[OffSet1] + ti) >> 1;
			}
		}
	}
	FFT_Real[0]  = FFT_Real[0]  >> 1;
	FFT_Image[0] = FFT_Image[0] >> 1;
}



//================== USB-CDC ======================
void CDC_RetuanData(void)
{
	u8	edata *xp;
	u8	i,j;
	u16	y;

	if(++cal_cnt == 2)	cal_cnt = 0;	//2ˢһ

	for(j=0; j<128; j++)
	{
		if(cal_cnt == 0)	//һٶ
		{
			if(amplitude[j] != 0)	amplitude[j]--;		//ˢ˥
		}

		y = FFT_A[j];	//ȡ
		if((y & 0xf800) != 0)	y = 2047;	//	if(y >= 2048)	y = 2047;	//޷
		i = T_Alaw_encode[y];	//ȡ, AѹĶ, ûԼʹʲô.
		if(amplitude[j] < i)	amplitude[j] = i;	//ֵ, ʾ
	}
	amplitude[0] = 0;	//һֱƽ(0Hz), Ҫ, д0

	if(cal_cnt == 0)
	{
		TxBuffer[0] = 0xfb;	//ϴһ֡ݣFB DAT0 DAT1 ..... DAT127 FF
		y = 1;		//ֽ
		xp = &amplitude[0];	//׵ַ
		amplitude[0] = 0;	//ֱƽƵź
		for(i=0; i<128; i++)
		{
			TxBuffer[y++] = *xp;
			xp++;
		}
		TxBuffer[y++] = 0xff;	//
		uart_send(y);	//. Ҫ͵ݱTxBuffer, Ȼuart_send(n)ݷ,Ϊ͵ֽ. һɷ64K,ڲԶUSBְ.
	}
}



//========================================================================
// : void  delay_ms(u16 ms)
// : ʱ
// : ms,Ҫʱms, 1~65535ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע:
//========================================================================
void  delay_ms(u16 ms)
{
     u16 i;
	 do
	 {
	 	i = MAIN_Fosc / 6000;
		while(--i)	;
     }while(--ms);
}


void delay(void)
{
	u16	i;
	for	(i=0; i<100; i++);
}

//========================================================================
// : void	ADC_config(void)
// : ADCʼ
// : none.
// : none.
// 汾: VER1.0
// : 2024-8-1
// ע:
//========================================================================
#define D_ADC_POWER	(1<<7)	/* ADCԴ10ر */
#define D_ADC_START	(1<<6)	/* תԶ0 */
#define D_ADC_FLAG	(1<<5)	/* ɱ־0 */
#define D_ADC_EPWMT	(1<<4)	/* PWMAADC */

#define	D_ADC_SPEED	4		/* 0~15, ADCʱ = SYSclk/2/(n+1) */
#define	D_RES_FMT	(1<<5)	/* ADCʽ 0: , ADC_RES: D9 D8 D7 D6 D5 D4 D3 D2, ADC_RESL: D1 D0 0  0  0  0  0  0 */
							/*             1: Ҷ, ADC_RES: 0  0  0  0  0  0  D9 D8, ADC_RESL: D7 D6 D5 D4 D3 D2 D1 D0 */
#define CSSETUP		(1<<7)	/* 0~1,  ADCͨѡʱ      0: 1ADCʱ, 1: 2ADCʱ,  Ĭ0(Ĭ1ADCʱ)	*/
#define CSHOLD		(1<<5)	/* 0~3,  ADCͨѡ񱣳ʱ  (n+1)ADCʱ, Ĭ1(Ĭ2ADCʱ)					*/
#define SMPDUTY		23		/* 10~31, ADCģźŲʱ  (n+1)ADCʱ, Ĭ10(Ĭ11ADCʱ)				*/
							/* ADCתʱ: 10λADC̶Ϊ10ADCʱ, 12λADC̶Ϊ12ADCʱ. 				*/
void	ADC_config(void)
{
//	EAXSFR();	//SFR enable
	P1n_pure_input(1<<CHANNEL);	//ҪADCIO
	ADC_CONTR = D_ADC_POWER + CHANNEL;	//ADC on + channel
	ADCCFG = D_RES_FMT + D_ADC_SPEED;
	ADCTIM = CSSETUP + CSHOLD + SMPDUTY;
//	    ADC_CONTR |= ADC_START;	//ADCת,ɺԶ
//	    ADC_CONTR &= ~ADC_FLAG;	//ADC(ж)־
//	    ADC_CONTR |= ADC_EPWMT;	//PWMADC
//	EADC  = 1;	//ADCж
//	IPH |= PADCH;	//ADC жȼλ
//	PADC  = 1;	//ADC жȼ
}

void	ADC_DMA_config(void)	//ʼADC DMA
{
	DMA_ADC_CFG2 = 0;		//ÿͨתĴ, 0-->1, 8-->2, 9-->4, 10-->8, 11-->16, 12-->32, 13-->64, 14-->128, 15-->256.
	DMA_ADC_CFG  = (1<<7) + (0<<2) + 0;	//bit7=1: ADC_DMAж, 0:ֹ.  bit3 bit2: ADC_DMAжȼ(0~3), bit1 bit0: ADC_DMA߷ȼ(0~3)
	DMA_ADC_STA  = 0;		//bit0: ADC_DMA(ж)־, Ҫ0.
	DMA_ADC_AMTH = (u8)((SAMPLES-1)/256);		//ظ = 9DMA_ADC_AMTH*256+DMA_ADC_AMT)+1
	DMA_ADC_AMT  = (u8)((SAMPLES-1)%256);		//
	DMA_ADC_CHSW1 = 0;				//ADCͨʹ, bit7~bit0Ӧͨ15~8.
	DMA_ADC_CHSW0 = (1<<CHANNEL);	//ADCͨʹ, bit7~bit0Ӧͨ7~0.
	DMA_ADC_ITVH = (u8)(((MAIN_Fosc + SAMPLE_RATE/2) / SAMPLE_RATE) /256);   	/*  ADC_DMAʱĴֽ */
	DMA_ADC_ITVL = (u8)(((MAIN_Fosc + SAMPLE_RATE/2) / SAMPLE_RATE) %256);   /*  ADC_DMAʱĴֽ */
//	DMA_ADC_RXAH = (u8)((u16)(&adc_buf1) /256);	//ŵĵַ
//	DMA_ADC_RXAL = (u8)((u16)(&adc_buf1) %256);	//ŵĵַ
//	DMA_ADC_CR   = (1<<7) + (1<<6);		//ADC_DMA,  bit7=1:ADC_DMA, 0:ֹ.   bit6=1:ADC_DMA.
}

//========================================================================
// : void	ADC_DMA_ISR(void) interrupt DMA_ADC_VECTOR
// : ADC DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2024-8-1
// ע:
//========================================================================
void	ADC_DMA_ISR(void) interrupt DMA_ADC_VECTOR
{
	if(!B_adc_buf)	//1,	2
	{
		DMA_ADC_RXAH  = (u8)((u16)(&adc_buf2)/256);	//ŵĵַ
		DMA_ADC_RXAL  = (u8)((u16)(&adc_buf2)%256);	//ŵĵַ
	}
	else //2,	1
	{
		DMA_ADC_RXAH  = (u8)((u16)(&adc_buf1)/256);	//ŵĵַ
		DMA_ADC_RXAL  = (u8)((u16)(&adc_buf1)%256);	//ŵĵַ
	}
	DMA_ADC_CR   = (1<<7) + (1<<6);		//ADC_DMA,  bit7=1:ADC_DMA, 0:ֹ.   bit6=1:ADC_DMA.

	DMA_ADC_STA = 0;	//ADC_DMA(ж)־
	B_SampleOk = B_adc_buf;	//0: adc_buf1[], B1: adc_buf2[]
	B_adc_buf = ~B_adc_buf;		//ָһ
	B_ADC_DMA_ok = 1;	//־
}


//==============================================================================================================
//	*******************		   					main()							*********************************
//===============================================================================================================

void main(void)
{
	u16	i,j;

	EAXSFR();	//SFR enable
	WTST  = 0;
	CKCON = 0;

	P0n_standard(0xff);	P0 = 0xff;
	P1n_standard(0xff);	P1 = 0xff;
	P2n_standard(0xff);	P2 = 0xff;
	P3n_standard(0xfc);	P3 = 0xff;
	P4n_standard(0xff);	P4 = 0xff;
	P5n_standard(0xff);	P5 = 0xff;
	P6n_standard(0xff);	P6 = 0xff;
	P7n_standard(0xff);	P7 = 0xff;
	P54 = 1;

	HSCLKDIV    = 1;	//ʱӷƵ 1~255 (Ĭ2)
	TFPU_CLKDIV = 1;	//TFPUƵ
//	MCLKO47_DIV(100);	//ƵƵ

	DMAIR = 0x3f;		//㵥Ԫ
	CLKSEL  = 0x00;						//ʹ40M, PLL=40M/4*12=120MHz, FPU.
	CLKSEL |= 0x80;						//ڲPLLʱѡ, |=0x80: ѡPLL 144MHz, &=~0x80: ѡ96MHz(Ĭ)
	USBCLK  = (USBCLK &~0x60) | (2<<5);	//ѡPLLʱӷƵ,֤ʱΪ12M, 0: 1Ƶ(Ӧ12MHz), 1: 2Ƶ(Ӧ24MHz), 2: 4Ƶ(Ӧ48MHz), 3: 8Ƶ(Ӧ96MHz)
	USBCLK |= 0x80;						//PLLƵ, |=0x80: ʹPLLƵ. &= ~0x80: ֹPLLƵ
	delay();							//ȴPLLƵ
	CLKSEL |= 0x00;						//IOʱԴѡ, |=0x40: ѡPLLCLK,  &=~0x40: ѡMCLK(Ĭ)
	CLKDIV  = 1; 						//ʱӷƵϵ, 1~255,  144/5=28.8MHz
//	HSCLKDIV = 1;						//ʱӷƵ 1~255 (Ĭ2)
//	TFPU_CLKDIV = 1;					//TFPUƵ
	CLKSEL |= (0<<2);					//ʱԴѡ2, 0: MCKSELѡʱԴ(Ĭ), 1: ڲPLL, 2: ڲPLL/2, 3: ڲ48MHzIRC
	CLKSEL |=  0;						//ʱԴѡ,  0: ڲ߾IRC(Ĭ), 1: ⲿپ, 2: ⲿ32K, 3: ڲ32KIRC


	P3n_pure_input(0x03);	//P3.0(D-)P3.1(D+)Ϊ
	IRC48MCR = 0x80;
	while (!(IRC48MCR & 0x01));

	uart_init();
	usb_init();
	EA = 1;

	delay_ms(1500);
	while(DeviceState != DEVSTATE_CONFIGURED)	//ȴUSBʼ
	{
		NOP(3);
	}

	ADC_config();
	ADC_DMA_config();

	for(i=0; i<SAMPLES; i++)
	{
		FFT_Real[i]   = 0;	// fftʵ
		FFT_Image[i]  = 0;	// fft鲿
	}
	for(i=0; i<SAMPLES/2; i++)
	{
		FFT_A[i]     = 0;	// Ƶʵķ
		amplitude[i] = 0;	//
	}


	B_adc_buf = 0;	//1
	DMA_ADC_RXAH  = (u8)((u16)(&adc_buf1)/256);	//ADC DMAŵĵַֽ
	DMA_ADC_RXAL  = (u8)((u16)(&adc_buf1)%256);	//ADC DMAŵĵַֽ
	DMA_ADC_CR   = (1<<7) + (1<<6);		//ADC_DMA,  bit7=1:ADC_DMA, 0:ֹ.   bit6=1:ADC_DMA.

	while(1)
	{
		if (RxFlag)                         //RxFlagΪ1ʱ,ʾѽյCDC
											//յݴСRxCount,ÿ64ֽ
											//ݱRxBuffer
		{
			if((RxCount == 4) && (RxBuffer[0]==0xfe) &&(RxBuffer[1] == 0x01) && (RxBuffer[3] == 0xff))
			KeyCode = RxBuffer[2];			//PC´룺FE 01 DAT0 FF
			uart_recv_done();               //Խյݴɺ,һҪһ,ԱCDCһʴ
		}

		if(B_ADC_DMA_ok)    // DMA
		{
			B_ADC_DMA_ok = 0;
			if(!B_SampleOk)	//1,	׼188us @40MHz++
			{
				for(i=0,j=0; i<SAMPLES; i++,j+=3)	sample[LIST_TAB[i]] = adc_buf1[j]-2048;
			}
			else //2
			{
				for(i=0,j=0; i<SAMPLES; i++,j+=3)	sample[LIST_TAB[i]] = adc_buf2[j]-2048;
			}

			FFT();		//FFT AI8051U 5.5ms @40MHz +

			for(i=0; i<SAMPLES/2; i++)
			{
				FFT_A[i] = sqrt((long)FFT_Real[i]*(long)FFT_Real[i] + (long)FFT_Image[i]*(long)FFT_Image[i]);   //ģֵ,   KEILƽ670us @40MHz +.
			}

			CDC_RetuanData();	//  AI8051U @40MHz(+), 115us, +ϴ 475us
		}
	}
}


