
/*************  ˵    **************

̻AI8051UΪоƬʵV1.1汾бдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ɫSPIӿTFT LCD240x240ʾͨSPI DMA3200ֽڵͼƬ͵ʱռCPUʱ䡣

ʾͼΣ֣Ӣģ. TFT LCD240X240ʹо԰ҺICͺΪST7789V3

ͼʾʹSPIѯʽ(11ֽ)ͼƬʹSPI DMA40MHz, ÿSPI DMAʱ1.52ms. ˢ55mms.

Ҫʾݷ1024ֽڵԴУDMA伴ɡ

ʱ, ѡʱ 40MHz (û޸Ƶʺ±뼴).

******************************************/

	#define	FOSC	40000000UL

	#include "../comm/AI8051U.h"
	#include 	"LCD.h"
	#include	"lcdfont.h"
	#include 	"pic.h"
	
#define	Pin0		0x01	//IO Px.0
#define	Pin1		0x02	//IO Px.1
#define	Pin2		0x04	//IO Px.2
#define	Pin3		0x08	//IO Px.3
#define	Pin4		0x10	//IO Px.4
#define	Pin5		0x20	//IO Px.5
#define	Pin6		0x40	//IO Px.6
#define	Pin7		0x80	//IO Px.7
#define	PinAll		0xFF	//IO
#define P1n_standard(bitn)			P1M1 &= ~(bitn),	P1M0 &= ~(bitn)
#define P1n_push_pull(bitn)			P1M1 &= ~(bitn),	P1M0 |=  (bitn)
#define P1n_pure_input(bitn)		P1M1 |=  (bitn),	P1M0 &= ~(bitn)
#define P1n_open_drain(bitn)		P1M1 |=  (bitn),	P1M0 |=  (bitn)

#define P2n_standard(bitn)			P2M1 &= ~(bitn),	P2M0 &= ~(bitn)
#define P2n_push_pull(bitn)			P2M1 &= ~(bitn),	P2M0 |=  (bitn)
#define P2n_pure_input(bitn)		P2M1 |=  (bitn),	P2M0 &= ~(bitn)
#define P2n_open_drain(bitn)		P2M1 |=  (bitn),	P2M0 |=  (bitn)

#define P3n_standard(bitn)			P3M1 &= ~(bitn),	P3M0 &= ~(bitn)
#define P3n_push_pull(bitn)			P3M1 &= ~(bitn),	P3M0 |=  (bitn)
#define P3n_pure_input(bitn)		P3M1 |=  (bitn),	P3M0 &= ~(bitn)
#define P3n_open_drain(bitn)		P3M1 |=  (bitn),	P3M0 |=  (bitn)

#define P4n_standard(bitn)			P4M1 &= ~(bitn),	P4M0 &= ~(bitn)
#define P4n_push_pull(bitn)			P4M1 &= ~(bitn),	P4M0 |=  (bitn)
#define P4n_pure_input(bitn)		P4M1 |=  (bitn),	P4M0 &= ~(bitn)
#define P4n_open_drain(bitn)		P4M1 |=  (bitn),	P4M0 |=  (bitn)

//=============================================================================================================
#define	PullUpEnable(port, pu)		port |=  (pu)		/* ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullUpDisable(port, pu)		port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownEnable(port, pu)	port |=  (pu)		/* ˿ڲ       PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownDisable(port, pu)	port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitEnable(port, smt)		port &= ~(smt)		/* ˿ʩش(Ĭ) PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitDisable(port, smt)	port |=  (smt)		/* ˿ʩش       PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateNormal(port, sr)	port |=  (sr)		/* ˿Ϊͨٶ(Ĭ) PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateHigh(port, sr)		port &= ~(sr)		/* ˿Ϊģʽ       PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentNormal(port, cu)		port |=  (cu)		/* ˿Ϊͨģʽ(Ĭ) PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentHigt(port, cu)		port &= ~(cu)		/* ˿Ϊģʽ     PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	InputEnable(port, ie)		port |=  (ie)		/* ˿(Ĭ) PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	InputDisable(port, ie)		port &= ~(ie)		/* ֹ˿       PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	BypassEnable(port, bp)		port &= ~(bp)		/* Զƶ˿       PxBP, ҪõĶ˿ڶӦλΪ1 */
#define	BypassDisable(port, bp)		port |=  (bp)		/* ֹԶƶ˿(Ĭ) PxBP, ҪõĶ˿ڶӦλΪ1 */
//=============================================================================================================


//-----------------LCD˿ڶ----------------
/*	ӿ	*/
							//GND	AI8051Uʵ V1.1
							//VCC	3~5V
//sbit P_LCD_CLK	=  	P3^2;	//D0	SPI or II2 ʱӽ
//sbit P_LCD_SDA	=   P3^3;	//D1	SPI or II2 ݽ
//sbit P_LCD_RST	=  	P4^7;	//RES	λ, ͵ƽλ
//sbit P_LCD_DC	=  	P1^1;	//DC	ݻ
//sbit P_LCD_CS	=	P3^5;	//CS	Ƭѡ


// ʾ
#define USE_HORIZONTAL 3 //úʾ 01Ϊ 23Ϊ
#define LCD_W 240
#define LCD_H 240


//---------------------------------
bit	B_SPI_DMA_busy;		//SPI DMAæ־ 1־SPI-DMAæSPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0
u16	SPI_TxAddr;			//SPI DMAҪݵ׵ַ
u8	xdata DisTmp[3200];	//ʾ壬ҪʾݷԴDMA. LCM DMA4ֽڶ⣬ﶨλԵַΪ4ı


//N msʱ
void delay_ms(u16 ms)	// 1~65535 ms
{
	u16 i;
	do
	{
		i = FOSC / 6000;	//STC32ϵ
		while(--i)	;
	}while(--ms);
}


//========================================================================
// : void  SPI_Config(u8 SPI_io, u8 SPI_speed)
// : SPIʼ
// : io: лIO,            SS  MOSI MISO SCLK
//                       0: л P1.4 P1.5 P1.6 P1.7
//                       1: л P2.4 P2.5 P2.6 P2.7
//                       2: л P4.0 P4.1 P4.2 P4.3
//                       3: л P3.5 P3.4 P3.3 P3.2
//       SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
// : none.
// 汾: VER1.0
// : 2024-8-13
// ע:
//========================================================================
void  SPI_Config(u8 SPI_io, u8 SPI_speed)
{
	SPI_io &= 3;

	SPCTL = SPI_speed & 3;	//SPI ٶ, ִָ, ˳Bit7~Bit20
	SPCTL |= SSIG;	//1: SSţMSTRλǴӻ		0: SSھǴӻ
	SPCTL |= SPEN;	//1: SPI								0ֹSPISPIܽžΪͨIO
	SPCTL &= ~DORD;	//1LSBȷ								0MSBȷ
	SPCTL |= MSTR;	//1Ϊ								0Ϊӻ
	SPCTL |= CPOL;	//1: ʱSCLKΪߵƽ					0ʱSCLKΪ͵ƽ
	SPCTL |= CPHA;	//1: SCLKǰ,ز.			0: SCLKǰز,.
//	SPCTL &= ~SPR1;	//SPR1,SPR0   00: fosc/4,     01: fosc/8
//	SPCTL &= ~SPR0;	//            10: fosc/16,    11: fosc/2
	P_SW1 = (P_SW1 & ~0x0c) | ((SPI_io<<2) & 0x0c);		//лIO

	HSCLKDIV   = 1;					//HSCLKDIVʱӷƵ
	SPI_CLKDIV = 1;					//SPI_CLKDIVʱӷƵ
	SPSTAT = 0x80 + 0x40;			//0 SPIFWCOL־

	if(SPI_io == 0)
	{
		P1n_standard(0xf0);			//л P1.4(SS) P1.5(MOSI) P1.6(MISO) P1.7(SCLK), Ϊ׼˫
		PullUpEnable(P1PU, 0xf0);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P1n_push_pull(Pin7+Pin5);	//MOSI SCLKΪ
		SlewRateHigh(P1SR, Pin7+Pin5);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
	else if(SPI_io == 1)
	{
		P2n_standard(0xf0);			//лP2.4(SS) P2.5(MOSI) P2.6(MISO) P2.7(SCLK), Ϊ׼˫
		PullUpEnable(P2PU, 0xf0);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P2n_push_pull(Pin7+Pin5);	//MOSI SCLKΪ
		SlewRateHigh(P2SR, Pin7+Pin5);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
	else if(SPI_io == 2)
	{
		P4n_standard(0x0f);			//лP4.0(SS) P4.1(MOSI) P4.2(MISO) P4.3(SCLK), Ϊ׼˫
		PullUpEnable(P4PU, 0x0f);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P4n_push_pull(Pin3+Pin1);	//MOSI SCLKΪ
		SlewRateHigh(P4SR, Pin3+Pin1);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
	else if(SPI_io == 3)
	{
		P3n_standard(0x3C);		//лP3.5(SS) P3.4(MOSI) P3.3(MISO) P3.2(SCLK), Ϊ׼˫
		PullUpEnable(P3PU, 0x3c);	//    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
		P3n_push_pull(Pin4+Pin2);	//MOSI SCLKΪ
		SlewRateHigh(P3SR, Pin4+Pin2);	//MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
	}
}


//========================================================================
// : дSPIһֽں
// : .
// : 
//========================================================================

void	LCD_SendByte(u8 dat)
{
	SPDAT = dat;	//һֽ
	while((SPSTAT & SPIF)==0)	;			//ȴ
	SPSTAT = 0x80 + 0x40;			//0 SPIFWCOL־
}


/******************************************************************************
      ˵LCDд
      ݣdat д
      ֵ  
******************************************************************************/
void LCD_WR_DATA8(u8 dat)
{
	P_LCD_CS = 0;
	LCD_SendByte(dat);
	P_LCD_CS = 1;
}


/******************************************************************************
      ˵LCDд
      ݣdat д
      ֵ  
******************************************************************************/
void LCD_WR_DATA16(u16 dat)
{
	P_LCD_CS = 0;
	LCD_SendByte((u8)(dat>>8));
	LCD_SendByte((u8)dat);
	P_LCD_CS = 1;
}


/******************************************************************************
      ˵LCDд
      ݣdat д
      ֵ  
******************************************************************************/
void LCD_WR_REG(u8 dat)
{
	P_LCD_DC = 0;//д
	P_LCD_CS = 0;
	LCD_SendByte(dat);
	P_LCD_CS = 1;
	P_LCD_DC = 1;//д
}


/******************************************************************************
      ˵ʼͽַ
      ݣx1,x2 еʼͽַ
                y1,y2 еʼͽַ
      ֵ  
******************************************************************************/
void LCD_Address_Set(u16 x1,u16 y1,u16 x2,u16 y2)
{
	#if USE_HORIZONTAL == 1
		y1 += 80;
		y2 += 80;
	#endif
	
	#if USE_HORIZONTAL == 3
		x1 += 80;
		x2 += 80;
	#endif
	

	LCD_WR_REG(0x2a);//еַ
	LCD_WR_DATA16(x1);
	LCD_WR_DATA16(x2);
	LCD_WR_REG(0x2b);//еַ
	LCD_WR_DATA16(y1);
	LCD_WR_DATA16(y2);
	LCD_WR_REG(0x2c);//д
}


/******************************************************************************
      ˵LCDʼ
      ݣ
      ֵ  
******************************************************************************/
void LCD_Init(void)
{
	P_LCD_CLK = 1;//SCLK
	P_LCD_SDA = 1;//MOSI
	P_LCD_RST = 1;//RES
	P_LCD_DC  = 1;//DC
	P_LCD_CS  = 1;//CS

	P_LCD_RST = 0;
	delay_ms(100);
	P_LCD_RST = 1;
	delay_ms(100);

	LCD_WR_REG(0x11); 	//Sleep out ˳˯
	delay_ms(120);		//Delay 120ms
	LCD_WR_REG(0x36);	//Դʿ
		 if(USE_HORIZONTAL == 0)	LCD_WR_DATA8(0x00);
	else if(USE_HORIZONTAL == 1)	LCD_WR_DATA8(0xC0);
	else if(USE_HORIZONTAL == 2)	LCD_WR_DATA8(0x70);
	else LCD_WR_DATA8(0xA0);

	LCD_WR_REG(0x3A);	//ӿڸʽ
	LCD_WR_DATA8(0x05);

	LCD_WR_REG(0xB2);
	LCD_WR_DATA8(0x1F);
	LCD_WR_DATA8(0x1F);
	LCD_WR_DATA8(0x00);
	LCD_WR_DATA8(0x33);
	LCD_WR_DATA8(0x33);

	LCD_WR_REG(0xB7);
	LCD_WR_DATA8(0x35);

	LCD_WR_REG(0xBB);
	LCD_WR_DATA8(0x20);   //2b

	LCD_WR_REG(0xC0);
	LCD_WR_DATA8(0x2C);

	LCD_WR_REG(0xC2);
	LCD_WR_DATA8(0x01);

	LCD_WR_REG(0xC3);
	LCD_WR_DATA8(0x01);

	LCD_WR_REG(0xC4);
	LCD_WR_DATA8(0x18);   //VDV, 0x20:0v

	LCD_WR_REG(0xC6);
	LCD_WR_DATA8(0x13);   //0x13:60Hz

	LCD_WR_REG(0xD0);
	LCD_WR_DATA8(0xA4);
	LCD_WR_DATA8(0xA1);

	LCD_WR_REG(0xD6);
	LCD_WR_DATA8(0xA1);   //sleep ingateΪGND

	//---------------ST7789V gamma setting-------------//
	LCD_WR_REG(0xE0);	//Set Gamma
	LCD_WR_DATA8(0xF0);
	LCD_WR_DATA8(0x04);
	LCD_WR_DATA8(0x07);
	LCD_WR_DATA8(0x04);
	LCD_WR_DATA8(0x04);
	LCD_WR_DATA8(0x04);
	LCD_WR_DATA8(0x25);
	LCD_WR_DATA8(0x33);
	LCD_WR_DATA8(0x3C);
	LCD_WR_DATA8(0x36);
	LCD_WR_DATA8(0x14);
	LCD_WR_DATA8(0x12);
	LCD_WR_DATA8(0x29);
	LCD_WR_DATA8(0x30);

	LCD_WR_REG(0xE1);	//Set Gamma
	LCD_WR_DATA8(0xF0);
	LCD_WR_DATA8(0x02);
	LCD_WR_DATA8(0x04);
	LCD_WR_DATA8(0x05);
	LCD_WR_DATA8(0x05);
	LCD_WR_DATA8(0x21);
	LCD_WR_DATA8(0x25);
	LCD_WR_DATA8(0x32);
	LCD_WR_DATA8(0x3B);
	LCD_WR_DATA8(0x38);
	LCD_WR_DATA8(0x12);
	LCD_WR_DATA8(0x14);
	LCD_WR_DATA8(0x27);
	LCD_WR_DATA8(0x31);

	LCD_WR_REG(0xE4);
	LCD_WR_DATA8(0x1D);   //ʹ240gate  (N+1)*8
	LCD_WR_DATA8(0x00);   //趨gateλ
	LCD_WR_DATA8(0x00);   //gateûʱbit4(TMG)Ϊ0

	LCD_WR_REG(0x21);

	LCD_WR_REG(0x29);	//ʾ
}

/******************************************************************************
      ˵ָɫ
      ݣxsta,ysta   ʼ
                xend,yend   ֹ
								color       Ҫɫ
      ֵ  
******************************************************************************/
void LCD_Fill(u16 xsta,u16 ysta,u16 xend,u16 yend,u16 color)
{
	u16 i,j;
	LCD_Address_Set(xsta,ysta,xend-1,yend-1);//ʾΧ
	for(i=ysta;i<yend;i++)
	{
		for(j=xsta;j<xend;j++)
		{
			LCD_WR_DATA16(color);
		}
	}
}

/******************************************************************************
      ˵ָλû
      ݣx,y 
                color ɫ
      ֵ  
******************************************************************************/
void LCD_DrawPoint(u16 x,u16 y,u16 color)
{
	LCD_Address_Set(x,y,x,y);//ùλ
	LCD_WR_DATA16(color);
}

/******************************************************************************
      ˵ʾ12x12
      ݣx,yʾ
                *s Ҫʾĺ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowChinese12x12(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	u8 i,j,m=0;
	u16 k;
	u16 HZnum;//Ŀ
	u16 TypefaceNum;//һַռֽڴС
	u16 x0=x;
	TypefaceNum=(sizey/8+((sizey%8)?1:0))*sizey;

	HZnum=sizeof(tfont12)/sizeof(typFNT_GB12);	//ͳƺĿ
	for(k=0;k<HZnum;k++)
	{
		if((tfont12[k].Index[0]==*(s))&&(tfont12[k].Index[1]==*(s+1)))
		{
			LCD_Address_Set(x,y,x+sizey-1,y+sizey-1);
			for(i=0;i<TypefaceNum;i++)
			{
				for(j=0;j<8;j++)
				{
					if(!mode)//ǵӷʽ
					{
						if(tfont12[k].Msk[i]&(0x01<<j))		LCD_WR_DATA16(fc);
						else LCD_WR_DATA16(bc);
						m++;
						if(m%sizey==0)
						{
							m=0;
							break;
						}
					}
					else//ӷʽ
					{
						if(tfont12[k].Msk[i]&(0x01<<j))	LCD_DrawPoint(x,y,fc);//һ
						x++;
						if((x-x0)==sizey)
						{
							x=x0;
							y++;
							break;
						}
					}
				}
			}
		}
		continue;  //ҵӦֿ˳ֹظȡģӰ
	}
}

/******************************************************************************
      ˵ʾ16x16
      ݣx,yʾ
                *s Ҫʾĺ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowChinese16x16(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	u8 i,j,m=0;
	u16 k;
	u16 HZnum;//Ŀ
	u16 TypefaceNum;//һַռֽڴС
	u16 x0=x;
  TypefaceNum=(sizey/8+((sizey%8)?1:0))*sizey;
	HZnum=sizeof(tfont16)/sizeof(typFNT_GB16);	//ͳƺĿ
	for(k=0;k<HZnum;k++)
	{
		if ((tfont16[k].Index[0]==*(s))&&(tfont16[k].Index[1]==*(s+1)))
		{
			LCD_Address_Set(x,y,x+sizey-1,y+sizey-1);
			for(i=0;i<TypefaceNum;i++)
			{
				for(j=0;j<8;j++)
				{
					if(!mode)//ǵӷʽ
					{
						if(tfont16[k].Msk[i]&(0x01<<j))	LCD_WR_DATA16(fc);
						else LCD_WR_DATA16(bc);
						m++;
						if(m%sizey==0)
						{
							m=0;
							break;
						}
					}
					else//ӷʽ
					{
						if(tfont16[k].Msk[i]&(0x01<<j))	LCD_DrawPoint(x,y,fc);//һ
						x++;
						if((x-x0)==sizey)
						{
							x=x0;
							y++;
							break;
						}
					}
				}
			}
		}
		continue;  //ҵӦֿ˳ֹظȡģӰ
	}
}


/******************************************************************************
      ˵ʾ24x24
      ݣx,yʾ
                *s Ҫʾĺ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowChinese24x24(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	u8 i,j,m=0;
	u16 k;
	u16 HZnum;//Ŀ
	u16 TypefaceNum;//һַռֽڴС
	u16 x0=x;
	TypefaceNum=(sizey/8+((sizey%8)?1:0))*sizey;
	HZnum=sizeof(tfont24)/sizeof(typFNT_GB24);	//ͳƺĿ
	for(k=0;k<HZnum;k++)
	{
		if ((tfont24[k].Index[0]==*(s))&&(tfont24[k].Index[1]==*(s+1)))
		{
			LCD_Address_Set(x,y,x+sizey-1,y+sizey-1);
			for(i=0;i<TypefaceNum;i++)
			{
				for(j=0;j<8;j++)
				{
					if(!mode)//ǵӷʽ
					{
						if(tfont24[k].Msk[i]&(0x01<<j))	LCD_WR_DATA16(fc);
						else LCD_WR_DATA16(bc);
						m++;
						if(m%sizey==0)
						{
							m=0;
							break;
						}
					}
					else//ӷʽ
					{
						if(tfont24[k].Msk[i]&(0x01<<j))	LCD_DrawPoint(x,y,fc);//һ
						x++;
						if((x-x0)==sizey)
						{
							x=x0;
							y++;
							break;
						}
					}
				}
			}
		}
		continue;  //ҵӦֿ˳ֹظȡģӰ
	}
}

/******************************************************************************
      ˵ʾ32x32
      ݣx,yʾ
                *s Ҫʾĺ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowChinese32x32(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	u8 i,j,m=0;
	u16 k;
	u16 HZnum;//Ŀ
	u16 TypefaceNum;//һַռֽڴС
	u16 x0=x;
	TypefaceNum=(sizey/8+((sizey%8)?1:0))*sizey;
	HZnum=sizeof(tfont32)/sizeof(typFNT_GB32);	//ͳƺĿ
	for(k=0;k<HZnum;k++)
	{
		if ((tfont32[k].Index[0]==*(s))&&(tfont32[k].Index[1]==*(s+1)))
		{
			LCD_Address_Set(x,y,x+sizey-1,y+sizey-1);
			for(i=0;i<TypefaceNum;i++)
			{
				for(j=0;j<8;j++)
				{
					if(!mode)//ǵӷʽ
					{
						if(tfont32[k].Msk[i]&(0x01<<j))	LCD_WR_DATA16(fc);
						else LCD_WR_DATA16(bc);
						m++;
						if(m%sizey==0)
						{
							m=0;
							break;
						}
					}
					else//ӷʽ
					{
						if(tfont32[k].Msk[i]&(0x01<<j))	LCD_DrawPoint(x,y,fc);//һ
						x++;
						if((x-x0)==sizey)
						{
							x=x0;
							y++;
							break;
						}
					}
				}
			}
		}
		continue;  //ҵӦֿ˳ֹظȡģӰ
	}
}


/******************************************************************************
      ˵ʾַ
      ݣx,yʾ
                num Ҫʾַ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowChar(u16 x,u16 y,u8 num,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	u8 temp,sizex,t,m=0;
	u16 i,TypefaceNum;//һַռֽڴС
	u16 x0=x;
	sizex=sizey/2;
	TypefaceNum=(sizex/8+((sizex%8)?1:0))*sizey;
	num=num-' ';    //õƫƺֵ
	LCD_Address_Set(x,y,x+sizex-1,y+sizey-1);  //ùλ
	for(i=0;i<TypefaceNum;i++)
	{
		if(sizey==12)temp=ascii_1206[num][i];		       //6x12
		else if(sizey==16)temp=ascii_1608[num][i];		 //8x16
		else if(sizey==24)temp=ascii_2412[num][i];		 //12x24
		else if(sizey==32)temp=ascii_3216[num][i];		 //16x32
		else return;
		for(t=0;t<8;t++)
		{
			if(!mode)//ǵģʽ
			{
				if(temp&(0x01<<t))	LCD_WR_DATA16(fc);
				else LCD_WR_DATA16(bc);
				m++;
				if(m%sizex==0)
				{
					m=0;
					break;
				}
			}
			else//ģʽ
			{
				if(temp&(0x01<<t))LCD_DrawPoint(x,y,fc);//һ
				x++;
				if((x-x0)==sizex)
				{
					x=x0;
					y++;
					break;
				}
			}
		}
	}
}


/******************************************************************************
      ˵ʾִ
      ݣx,yʾ
                *s Ҫʾĺִ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ ѡ 16 24 32
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowChinese(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	while(*s!=0)
	{
			 if(sizey==12) LCD_ShowChinese12x12(x,y,s,fc,bc,sizey,mode);
		else if(sizey==16) LCD_ShowChinese16x16(x,y,s,fc,bc,sizey,mode);
		else if(sizey==24) LCD_ShowChinese24x24(x,y,s,fc,bc,sizey,mode);
		else if(sizey==32) LCD_ShowChinese32x32(x,y,s,fc,bc,sizey,mode);
		else return;
		s+=2;
		x+=sizey;
	}
}

/******************************************************************************
      ˵ʾַ
      ݣx,yʾ
                *p Ҫʾַ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
                mode:  0ǵģʽ  1ģʽ
      ֵ  
******************************************************************************/
void LCD_ShowString(u16 x,u16 y,const u8 *p,u16 fc,u16 bc,u8 sizey,u8 mode)
{
	while(*p!='\0')
	{
		LCD_ShowChar(x,y,*p,fc,bc,sizey,mode);
		x+=sizey/2;
		p++;
	}
}


/******************************************************************************
      ˵ʾ
      ݣmnָ
      ֵ  
******************************************************************************/
u32 mypow(u8 m,u8 n)
{
	u32 result=1;
	while(n--)result*=m;
	return result;
}


/******************************************************************************
      ˵ʾ
      ݣx,yʾ
                num Ҫʾ
                len Ҫʾλ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
      ֵ  
******************************************************************************/
void LCD_ShowIntNum(u16 x,u16 y,u16 num,u8 len,u16 fc,u16 bc,u8 sizey)
{
	u8 t,temp;
	u8 enshow=0;
	u8 sizex=sizey/2;
	for(t=0;t<len;t++)
	{
		temp = (num/mypow(10, (u8)(len-t-1)))%10;
		if(enshow==0&&t<(len-1))
		{
			if(temp==0)
			{
				LCD_ShowChar(x+t*sizex,y,' ',fc,bc,sizey,0);
				continue;
			}else enshow=1;

		}
	 	LCD_ShowChar(x+t*sizex,y, (u8)(temp+48),fc,bc,sizey,0);
	}
}


/******************************************************************************
      ˵ʾλС
      ݣx,yʾ
                num ҪʾС
                len Ҫʾλ
                fc ֵɫ
                bc ֵıɫ
                sizey ֺ
      ֵ  
******************************************************************************/
void LCD_ShowFloatNum1(u16 x,u16 y,float num,u8 len,u16 fc,u16 bc,u8 sizey)
{
	u8 t,temp,sizex;
	u16 num1;
	sizex=sizey/2;
	num1=num*100;
	for(t=0;t<len;t++)
	{
		temp=(num1/mypow(10, (u8)(len-t-1)))%10;
		if(t==(len-2))
		{
			LCD_ShowChar(x+(len-2)*sizex,y,'.',fc,bc,sizey,0);
			t++;
			len+=1;
		}
	 	LCD_ShowChar(x+t*sizex,y,(u8)(temp+48),fc,bc,sizey,0);
	}
}


/******************************************************************************
      ˵ʾͼƬ
      ݣx,y
                length ͼƬ
                width  ͼƬ
                pic[]  ͼƬ
      ֵ  
******************************************************************************/
void LCD_ShowPicture(u16 x,u16 y,u16 length,u16 width, u8 *pic)
{
	LCD_Address_Set(x,y,x+length-1,y+width-1);
	SPI_DMA_TRIG(pic);	//SPI DAMһͼƬ
	while(B_SPI_DMA_busy);	//ȴͼƬ
}


//DMA_SPI_CR 	SPI_DMAƼĴ
#define		DMA_ENSPI		(1<<7)	// SPI DMAʹܿλ    bit7, 0:ֹSPI DMAܣ  1SPI DMAܡ
#define		SPI_TRIG_M		(1<<6)	// SPI DMAģʽλbit6, 0:д0Ч          1д1ʼSPI DMAģʽ
#define		SPI_TRIG_S		(0<<5)	// SPI DMAӻģʽλbit5, 0:д0Ч          1д1ʼSPI DMAӻģʽ
#define		SPI_CLRFIFO		1		// SPI DMAFIFOλbit0, 0:д0Ч          1д1λFIFOָ롣


//DMA_SPI_CFG 	SPI_DMAüĴ
#define		DMA_SPIIE	(1<<7)	// SPI DMAжʹܿλbit7, 0:ֹSPI DMAжϣ     1жϡ
#define		SPI_ACT_TX	(1<<6)	// SPI DMAݿλbit6, 0:ֹSPI DMAݣֻʱӲݣӻҲ. 1͡
#define		SPI_ACT_RX	(0<<5)	// SPI DMAݿλbit5, 0:ֹSPI DMAݣֻʱӲݣӻҲ. 1ա
#define		DMA_SPIIP	(0<<2)	// SPI DMAжȼλbit3~bit2, ()0~3().
#define		DMA_SPIPTY	0		// SPI DMA߷ȼλbit1~bit0, ()0~3().

//DMA_SPI_CFG2 	SPI_DMAüĴ2
#define		SPI_WRPSS	(0<<2)	// SPI DMAʹSSſλbit2, 0: SPI DMA̲ԶSSš  1ԶSSš
#define		SPI_SSS	    3		// SPI DMAԶSSѡλbit1~bit0, 0: P1.4,  1P2.4,  2: P4.0,  3:P3.5

//DMA_SPI_STA 	SPI_DMA״̬Ĵ
#define		SPI_TXOVW	(1<<2)	// SPI DMAݸǱ־λbit2, 0.
#define		SPI_RXLOSS	(1<<1)	// SPI DMAݶ־λbit1, 0.
#define		DMA_SPIIF	1		// SPI DMAж־λbit0, 0.

//HSSPI_CFG  SPIüĴ
#define		SS_HOLD		(0<<4)	//ģʽʱSSźŵHOLDʱ䣬 0~15, Ĭ3. DMAлNϵͳʱӣSPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.
#define		SS_SETUP		3	//ģʽʱSSźŵSETUPʱ䣬0~15, Ĭ3. DMAвӰʱ䣬       SPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.

//HSSPI_CFG2  SPIüĴ2
#define		SPI_IOSW	(1<<6)	//bit6:MOSIMISOλ01
#define		HSSPIEN		(0<<5)	//bit5:SPIʹλ0رոģʽ1ʹܸģʽ
#define		FIFOEN		(1<<4)	//bit4:SPIFIFOģʽʹλ0رFIFOģʽ1ʹFIFOģʽʹFIFOģʽDMAм13ϵͳʱ䡣
#define		SS_DACT			3	//bit3~0:ģʽʱSSźŵDEACTIVEʱ䣬0~15, Ĭ3, ӰDMAʱ.  SPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.


void	SPI_DMA_TRIG(u8 xdata *TxBuf)
{
				//@40MHz, Fosc/4, 200ֽ258us100ֽ  130us50ֽ66usNֽںʱ N*1.280+2 us, 51Tһֽڣ״̬19T, ʱ32T.
				//@40MHz, Fosc/2, 200ֽ177us100ֽ 89.5us50ֽ46usNֽںʱ N*0.875+2 us, 35Tһֽڣ״̬19T, ʱ16T.
				//@40MHz, Fosc/2, SPI DMAһֽ, FIFO=1, HOLD=0ʱ16+3=19T(0.475us), HOLD=3ʱ16+6=22T(0.55us).
				//@40MHz, Fosc/4, SPI DMAһֽ, FIFO=1, HOLD=0ʱ32+3=35T(0.875us), HOLD=3ʱ32+6=38T(0.95us).
	HSSPI_CFG  = SS_HOLD | SS_SETUP;	//SS_HOLDNϵͳʱ, SS_SETUPûʱӡOLED 40MHzʱSS_HOLDΪ0
	HSSPI_CFG2 = SPI_IOSW | FIFOEN | SS_DACT;	//FIFOENFIFOС13ʱ.

	P_LCD_DC  = 1;	//д
	P_LCD_CS  = 0;	//Ƭѡ
	B_SPI_DMA_busy = 1;	//־SPI-DMAæSPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0

	SPI_TxAddr   = (u16)TxBuf;		//Ҫݵ׵ַ
	DMA_SPI_TXAH = (u8)(SPI_TxAddr >> 8);		//͵ַĴֽ
	DMA_SPI_TXAL = (u8)SPI_TxAddr;				//͵ַĴֽ
	DMA_SPI_AMTH = (u8)((3200-1)/256);		//ôֽ(8λ),	ôֽ = N+1
	DMA_SPI_AMT  = (u8)(3200-1);			//ôֽ(8λ).
	DMA_SPI_ITVH = 0;
	DMA_SPI_ITVL = 0;
	DMA_SPI_STA  = 0x00;
	DMA_SPI_CFG  = DMA_SPIIE | SPI_ACT_TX | SPI_ACT_RX | DMA_SPIIP | DMA_SPIPTY;
	DMA_SPI_CFG2 = SPI_WRPSS | SPI_SSS;
	DMA_SPI_CR   = DMA_ENSPI | SPI_TRIG_M | SPI_TRIG_S | SPI_CLRFIFO;	//SPI DMA
}


//========================================================================
// : void SPI_DMA_ISR (void) interrupt DMA_SPI_VECTOR
// :  SPI_DMAжϺ.
// : none.
// : none.
// 汾: V1.0, 2024-1-5
//========================================================================
void SPI_DMA_ISR (void) interrupt USER_VECTOR//DMA_SPI_VECTOR
{
	DMA_SPI_CR = 0;			//رSPI DMA
	B_SPI_DMA_busy = 0;		//SPI-DMAæ־SPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0
	SPSTAT = 0x80 + 0x40;	//0 SPIFWCOL־
	HSSPI_CFG2 = SPI_IOSW | SS_DACT;	//ʹSPIѯжϷʽʱҪֹFIFO
	P_LCD_CS = 1;
	DMA_SPI_STA = 0;		//жϱ־
}




void main(void)
{
	u16 i;
	u8	j;
	float t=0;

	EAXSFR();	//չĴ
	WTST  = 0;
	CKCON = 0;

	P0M1 = 0;	P0M0 = 0;	//Ϊ׼˫
	P1M1 = 0;	P1M0 = 0;	//Ϊ׼˫
	P2M1 = 0;	P2M0 = 0;	//Ϊ׼˫
	P3M1 = 0;	P3M0 = 0;	//Ϊ׼˫
	P4M1 = 0;	P4M0 = 0;	//Ϊ׼˫
	P5M1 = 0;	P5M0 = 0;	//Ϊ׼˫
	P6M1 = 0;	P6M0 = 0;	//Ϊ׼˫
	P7M1 = 0;	P7M0 = 0;	//Ϊ׼˫

	//==================== SPIʼ ==================================
	SPI_Config(3, 3);	//(SPI_io, SPI_speed), : 	SPI_io: лIO(SS MOSI MISO SCLK), 0: лP1.4 P1.5 P1.6 P1.7,  1: лP2.4 P2.5 P2.6 P2.7, 2: лP4.0 P4.1 P4.2 P4.3,  3: лP3.5 P3.4 P3.3 P3.2,
						//								SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
	HSSPI_CFG2 = 0x40;	//MOSI MISO, P3.3MOSI

	P1n_standard(Pin1);			//SPIΪ׼˫, SPIͿź
	PullUpEnable(P1PU, Pin1);	// ˿ڲ     PxPU, ҪõĶ˿ڶӦλΪ1
	P3n_standard(0x2c);			//SPIΪ׼˫, SPIͿź
	PullUpEnable(P3PU, 0x2c);	// ˿ڲ     PxPU, ҪõĶ˿ڶӦλΪ1
	P4n_standard(Pin7);			//SPIΪ׼˫, SPIͿź
	PullUpEnable(P4PU, Pin7);	// ˿ڲ     PxPU, ҪõĶ˿ڶӦλΪ1
	//=================================================================

	LCD_Init();//LCDʼ
	LCD_Fill(0,0,LCD_W,LCD_H,WHITE);
	EA = 1;

	while(1)
	{
		LCD_Fill(0,0,LCD_W,LCD_H,WHITE);
		LCD_ShowChinese(0,0,"ڹо˹",RED,WHITE,24,0);
		LCD_ShowString(0,40,"LCD_W:",RED,WHITE,16,0);
		LCD_ShowIntNum(48,40,LCD_W,3,RED,WHITE,16);
		LCD_ShowString(80,40,"LCD_H:",RED,WHITE,16,0);
		LCD_ShowIntNum(128,40,LCD_H,3,RED,WHITE,16);
		LCD_ShowString(80,40,"LCD_H:",RED,WHITE,16,0);
		LCD_ShowString(0,70,"Increaseing Nun:",RED,WHITE,16,0);
		LCD_ShowFloatNum1(128,70,t,4,RED,WHITE,16);
		t+=0.11;
		delay_ms(3000);	// 1~65535 ms

		for(i=0; i<3200; i++)	DisTmp[i] = Image_1[i];	//ͼƬװصԴ
		for(j=0; j<6; j++)		//6ͼƬ, 36ͼƬ @40MHz FIFOEN=1, SS_HOLD=0ʱ55ms @2T
		{
			for(i=0; i<6; i++)	//һ6ͼƬ
			{
				LCD_ShowPicture(40*i, j*40, 40, 40, DisTmp);	//SPI DMAʾһͼƬ, 3200ֽ 1.52ms @40MHz
			}
		}
		delay_ms(3000);	// 1~65535 ms

		for(i=0; i<3200; i++)	DisTmp[i] = Image_2[i];	//ͼƬװصԴ
		for(j=0; j<6; j++)		//6ͼƬ, 36ͼƬ @40MHz FIFOEN=1, SS_HOLD=0ʱ55ms @2T
		{
			for(i=0; i<6; i++)	//һ6ͼƬ
			{
				LCD_ShowPicture(40*i, j*40, 40, 40, DisTmp);	//SPI DMAʾһͼƬ, 3200ֽ 1.52ms @40MHz
			}
		}
		delay_ms(3000);
	}
}









