
#ifndef __LCD_H
#define __LCD_H

//-----------------LCD˿ڶ----------------
/*	ӿ	*/
							//GND	AI8051Uʵ V1.1
							//VCC	3~5V
sbit P_LCD_CLK	=  	P3^2;	//D0	SPI or II2 ʱӽ
sbit P_LCD_SDA	=   P3^3;	//D1	SPI or II2 ݽ
sbit P_LCD_RST	=  	P4^7;	//RES	λ, ͵ƽλ
sbit P_LCD_DC	=  	P1^1;	//DC	ݻ
sbit P_LCD_CS	=	P3^5;	//CS	Ƭѡ


// ʾ
#define USE_HORIZONTAL 3 //úʾ 01Ϊ 23Ϊ
#define LCD_W 240
#define LCD_H 240
typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

//ɫ
#define WHITE         	 0xFFFF
#define BLACK         	 0x0000
#define BLUE           	 0x001F
#define BRED             0XF81F
#define GRED 			       0XFFE0
#define GBLUE			       0X07FF
#define RED           	 0xF800
#define MAGENTA       	 0xF81F
#define GREEN         	 0x07E0
#define CYAN          	 0x7FFF
#define YELLOW        	 0xFFE0
#define BROWN 			     0XBC40 //ɫ
#define BRRED 			     0XFC07 //غɫ
#define GRAY  			     0X8430 //ɫ
#define DARKBLUE      	 0X01CF	//ɫ
#define LIGHTBLUE      	 0X7D7C	//ǳɫ
#define GRAYBLUE       	 0X5458 //ɫ
#define LIGHTGREEN     	 0X841F //ǳɫ
#define LGRAY 			     0XC618 //ǳɫ(PANNEL),屳ɫ
#define LGRAYBLUE        0XA651 //ǳɫ(мɫ)
#define LBBLUE           0X2B12 //ǳɫ(ѡĿķɫ)


void delay_ms(unsigned int ms);//׼ȷʱ
void LCD_GPIO_Init(void);//ʼGPIO
void LCD_SendByte(u8 dat);
void LCD_WR_DATA8(u8 dat);//дһֽ
void LCD_WR_DATA16(u16 dat);//дֽ
void LCD_WR_REG(u8 dat);//дһָ
void LCD_Address_Set(u16 x1,u16 y1,u16 x2,u16 y2);//꺯
void LCD_Init(void);//LCDʼ

extern	u16	SPI_TxCnt;		//SPI DMAʹ, һ128ֽ, һ8
extern	bit	B_SPI_DMA_busy;	//SPI DMAæ־ 1־SPI-DMAæSPI DMAж˱־ʹSPI DMAǰҪȷϴ˱־Ϊ0
extern	u16	SPI_TxAddr;		//SPI DMAҪݵ׵ַ
extern	bit	B_TxCmd;		//ѷ־
extern	u8 xdata CmdTmp[];	//
extern	u8	xdata DisTmp[3200];	//ʾ壬ҪʾݷԴDMA. LCM DMA4ֽڶ⣬ﶨλԵַΪ4ı
void	SPI_DMA_TRIG(u8 xdata *TxBuf);

void LCD_Fill(u16 xsta,u16 ysta,u16 xend,u16 yend,u16 color);//ָɫ
void LCD_DrawPoint(u16 x,u16 y,u16 color);//ָλûһ
void LCD_DrawLine(u16 x1,u16 y1,u16 x2,u16 y2,u16 color);//ָλûһ
void LCD_DrawRectangle(u16 x1, u16 y1, u16 x2, u16 y2,u16 color);//ָλûһ
void Draw_Circle(u16 x0,u16 y0,u8 r,u16 color);//ָλûһԲ

void LCD_ShowChinese(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾִ
void LCD_ShowChinese12x12(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾ12x12
void LCD_ShowChinese16x16(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾ16x16
void LCD_ShowChinese24x24(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾ24x24
void LCD_ShowChinese32x32(u16 x,u16 y,u8 *s,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾ32x32

void LCD_ShowChar(u16 x,u16 y,u8 num,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾһַ
void LCD_ShowString(u16 x,u16 y,const u8 *p,u16 fc,u16 bc,u8 sizey,u8 mode);//ʾַ
u32 mypow(u8 m,u8 n);//
void LCD_ShowIntNum(u16 x,u16 y,u16 num,u8 len,u16 fc,u16 bc,u8 sizey);//ʾ
void LCD_ShowFloatNum1(u16 x,u16 y,float num,u8 len,u16 fc,u16 bc,u8 sizey);//ʾλС

void LCD_ShowPicture(u16 x,u16 y,u16 length,u16 width, u8 pic[]);//ʾͼƬ


#endif





