
#define     MAIN_Fosc        25600000UL    //ʱ

#include "../comm/AI8051U.h"


/*************    ˵    **************

ȱ޸ĳ, ֱ"SPI.hex", ʱѡƵ24MHz25.6MHz. ʵ20~30MHz

ʹSPI-MOSIֱWS2812ɫʵ, DMA䣬ռCPUʱ䡣32ƣӳɻ״
ʹUSART1-SPIģʽP1.5-MOSIźֱWS2812
ʹSPIģʽP1.6P1.7SPIռãá
DMAʱ䣺@25.6MHz, DMAһֽںʱ67T(2.6172us)һҪ12ֽںʱ31.5us32Kֽxdataһ2730.

ÿ3ֽڣֱӦ̡졢MSBȷ.
800KHz, 0(1/4ռձ): H=0.3125us  L=0.9375us, 1(3/4ռձ): H=0.9375us  L=0.3125us, RESET>=50us.
ߵƽʱҪȷҪķΧ, ͵ƽʱ䲻Ҫȷ, ҪСֵСRES50us.

WS2812Sı׼ʱ:
TH+TL = 1.25us150ns, RES>50us
T0H = 0.25us150ns = 0.10us - 0.40us
T0L = 1.00us150ns = 0.85us - 1.15us
T1H = 1.00us150ns = 0.85us - 1.15us
T1L = 0.25us150ns = 0.10us - 0.40us
λ֮ļҪСRES50us.

SPI:
ʹSPIģʽP1.5-MOSIźֱWS2812
ʹSPIģʽP1.6P1.7SPIռãá

SPI, ٶ3.0~3.5MHz3.2MHzΪ, MSBȷ, ÿֽڸ4λ͵4λֱӦһλ, 1000Ϊ0, 1110Ϊ1.
SPIλ       D7 D6 D5 D4    D3 D2 D1 D0
SPI         1  0  0  0     1  1  1  0
               WS28120    WS28121
SPIݸֽ߰ڶӦWS28120-->0x80, 1-->0xe0,
SPIݵͰֽڶӦWS28120-->0x08, 1-->0x0e,
Ƶ25.6MHz, SPIƵ8 = 3.2MHz. .

******************************************/


#include <intrins.h>
typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;
#define	Pin0		0x01	//IO Px.0
#define	Pin1		0x02	//IO Px.1
#define	Pin2		0x04	//IO Px.2
#define	Pin3		0x08	//IO Px.3
#define	Pin4		0x10	//IO Px.4
#define	Pin5		0x20	//IO Px.5
#define	Pin6		0x40	//IO Px.6
#define	Pin7		0x80	//IO Px.7
#define	PinAll		0xFF	//IO
#define P1n_standard(bitn)			P1M1 &= ~(bitn),	P1M0 &= ~(bitn)
#define P1n_push_pull(bitn)			P1M1 &= ~(bitn),	P1M0 |=  (bitn)
#define P1n_pure_input(bitn)		P1M1 |=  (bitn),	P1M0 &= ~(bitn)
#define P1n_open_drain(bitn)		P1M1 |=  (bitn),	P1M0 |=  (bitn)

#define P2n_standard(bitn)			P2M1 &= ~(bitn),	P2M0 &= ~(bitn)
#define P2n_push_pull(bitn)			P2M1 &= ~(bitn),	P2M0 |=  (bitn)
#define P2n_pure_input(bitn)		P2M1 |=  (bitn),	P2M0 &= ~(bitn)
#define P2n_open_drain(bitn)		P2M1 |=  (bitn),	P2M0 |=  (bitn)

#define P3n_standard(bitn)			P3M1 &= ~(bitn),	P3M0 &= ~(bitn)
#define P3n_push_pull(bitn)			P3M1 &= ~(bitn),	P3M0 |=  (bitn)
#define P3n_pure_input(bitn)		P3M1 |=  (bitn),	P3M0 &= ~(bitn)
#define P3n_open_drain(bitn)		P3M1 |=  (bitn),	P3M0 |=  (bitn)

#define P4n_standard(bitn)			P4M1 &= ~(bitn),	P4M0 &= ~(bitn)
#define P4n_push_pull(bitn)			P4M1 &= ~(bitn),	P4M0 |=  (bitn)
#define P4n_pure_input(bitn)		P4M1 |=  (bitn),	P4M0 &= ~(bitn)
#define P4n_open_drain(bitn)		P4M1 |=  (bitn),	P4M0 |=  (bitn)

//=============================================================================================================
#define	PullUpEnable(port, pu)		port |=  (pu)		/* ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullUpDisable(port, pu)		port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownEnable(port, pu)	port |=  (pu)		/* ˿ڲ       PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownDisable(port, pu)	port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitEnable(port, smt)		port &= ~(smt)		/* ˿ʩش(Ĭ) PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitDisable(port, smt)	port |=  (smt)		/* ˿ʩش       PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateNormal(port, sr)	port |=  (sr)		/* ˿Ϊͨٶ(Ĭ) PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateHigh(port, sr)		port &= ~(sr)		/* ˿Ϊģʽ       PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentNormal(port, cu)		port |=  (cu)		/* ˿Ϊͨģʽ(Ĭ) PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentHigt(port, cu)		port &= ~(cu)		/* ˿Ϊģʽ     PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	InputEnable(port, ie)		port |=  (ie)		/* ˿(Ĭ) PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	InputDisable(port, ie)		port &= ~(ie)		/* ֹ˿       PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	BypassEnable(port, bp)		port &= ~(bp)		/* Զƶ˿       PxBP, ҪõĶ˿ڶӦλΪ1 */
#define	BypassDisable(port, bp)		port |=  (bp)		/* ֹԶƶ˿(Ĭ) PxBP, ҪõĶ˿ڶӦλΪ1 */
//=============================================================================================================

/*************    س    **************/


/*************    ر    **************/


/*************    غ    **************/

#define COLOR    50                //ȣ255

#define LED_NUM    32              //LEDƸ
#define SPI_NUM    (LED_NUM*12)    //LEDƶӦSPIֽ

u8 xdata  led_RGB[LED_NUM][3];    //LEDӦRGBled_buff[i][0]-->̣led_buff[i][1]-->죬led_buff[i][0]-->.
u8 xdata  led_SPI[SPI_NUM];       //LEDƶӦSPIֽ

/*************  ⲿͱ *****************/
void SPI_Config(u8 SPI_io, u8 SPI_speed);    //SPIʼ, :  SPI_io: лIO, 0: лP5.4 P1.3 P1.4 P1.5,  1: лP2.2 P2.3 P2.4 P2.5, 2: лP5.4 P4.0 P4.1 P4.3,  3: лP3.5 P3.4 P3.3 P3.2,
                                                //                        SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
void LoadSPI(void);
void SPI_DMA_TxTRIG(u8 xdata *TxBuf, u16 num);
void delay_ms(u16 ms);

/***************  *******************************/

void main(void)
{
    u16    i,k;
    u8    xdata *px;

    EAXSFR();    //չĴ
    WTST  = 0;
    CKCON = 0;
//    MCLKO47_DIV(100);    //ƵƵڲƵ
    P1M0=0; P1M1 = 0;

    SPI_Config(0, 1);    //(SPI_io, SPI_speed), :     SPI_io: лIO(SS MOSI MISO SCLK), 0: лP1.4 P1.5 P1.6 P1.7,  1: лP2.4 P2.5 P2.6 P2.7, 2: лP4.0 P4.1 P4.2 P4.3,  3: лP3.5 P3.4 P3.3 P3.2,
                        //                                SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
    P1n_pure_input(Pin6);            // MISO-P1.6Ϊ裬裬SPIɺMOSIǵ͵ƽ
    PullUpDisable(P1PU, Pin6);       // ֹ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
    PullDownEnable(P1PD, Pin6);      // ˿ڲ   PxPD, ҪõĶ˿ڶӦλΪ1
    EA = 1;

    k = 0;

    while (1)
    {
        px = &led_RGB[0][0];    //(ɫ)׵ַ
        for(i=0; i<(LED_NUM*3); i++, px++)    *px = 0;    //еɫ

        i = k;
        led_RGB[i][1] = COLOR;        //ɫ
        if(++i >= LED_NUM)    i = 0;  //һ
        led_RGB[i][0] = COLOR;        //ɫ
        if(++i >= LED_NUM)    i = 0;  //һ
        led_RGB[i][2] = COLOR;        //ɫ

        LoadSPI();    //ɫװصSPI
        SPI_DMA_TxTRIG(led_SPI, SPI_NUM);    //u8 xdata *TxBuf, u16 num), SPI DMA, 720ֽһʱ2.08ms @25.6MHz

        if(++k >= LED_NUM)    k = 0;            //˳ʱ
    //    if(--k >= LED_NUM)    k = LED_NUM-1;    //ʱ
        delay_ms(50);
    }
}

//================ N msʱ ==============
void  delay_ms(u16 ms)
{
    u16 i;
    do
    {
        i = MAIN_Fosc / 6000;
        while(--i)    ;
    }while(--ms);
}

//================ ɫװصSPI ==============
void LoadSPI(void)
{
    u8    xdata *px;
    u16   i,j;
    u8    k;
    u8    dat;

    for(i=0; i<SPI_NUM; i++)    led_SPI[i] = 0;
    px = &led_RGB[0][0];    //׵ַ
    for(i=0, j=0; i<(LED_NUM*3); i++)
    {
        dat = *px;
        px++;
        for(k=0; k<4; k++)
        {
            if(dat & 0x80)  led_SPI[j]  = 0xE0;    //1
            else            led_SPI[j]  = 0x80;    //0
            if(dat & 0x40)  led_SPI[j] |= 0x0E;    //1
            else            led_SPI[j] |= 0x08;    //0
            dat <<= 2;
            j++;
        }
    }
}

//========================================================================
// : void SPI_Config(u8 io, u8 speed)
// : SPIʼ
// : io: лIO,            SS  MOSI MISO SCLK
//                       0: л P1.4 P1.5 P1.6 P1.7
//                       1: л P2.4 P2.5 P2.6 P2.7
//                       2: л P4.0 P4.1 P4.2 P4.3
//                       3: л P3.5 P3.4 P3.3 P3.2
//       SPI_speed: SPIٶ, 0: fosc/4,  1: fosc/8,  2: fosc/16,  3: fosc/2
// : none.
// 汾: VER1.0
// : 2018-6-13
// ע:
//========================================================================

void SPI_Config(u8 SPI_io, u8 SPI_speed)
{
    SPCTL = SPI_speed & 3;    //SPI ٶ, ָڵһλ, Bit7~Bit20
    SPCTL |= SSIG;    //1: SSţMSTRλǴӻ  0: SSھǴӻ
    SPCTL |= SPEN;    //1: SPI                          0ֹSPISPIܽžΪͨIO
    SPCTL &= ~DORD;    //1LSBȷ                          0MSBȷ
    SPCTL |= MSTR;    //1Ϊ                           0Ϊӻ
    SPCTL &= ~CPOL;    //1: ʱSCLKΪߵƽ               0ʱSCLKΪ͵ƽ
    SPCTL &= ~CPHA;    //1: SCLKǰ,ز.        0: SCLKǰز,.
    P_SW1 = (P_SW1 & ~0x0c) | ((SPI_io<<2) & 0x0c);      //лIO

    HSCLKDIV   = 1;        //HSCLKDIVʱӷƵ
    SPI_CLKDIV = 1;        //SPI_CLKDIVʱӷƵ
    if(SPI_io == 0)
    {
        P1n_standard(0xf0);             //л P1.4(SS) P1.5(MOSI) P1.6(MISO) P1.7(SCLK), Ϊ׼˫
        PullUpEnable(P1PU, 0xf0);       //    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
        P1n_push_pull(Pin7+Pin5);       //MOSI SCLKΪ
        SlewRateHigh(P1SR, Pin7+Pin5);  //MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
    }
    else if(SPI_io == 1)
    {
        P2n_standard(0xf0);            //лP2.4(SS) P2.5(MOSI) P2.6(MISO) P2.7(SCLK), Ϊ׼˫
        PullUpEnable(P2PU, 0xf0);       //    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
        P2n_push_pull(Pin7+Pin5);       //MOSI SCLKΪ
        SlewRateHigh(P2SR, Pin7+Pin5);  //MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
    }
    else if(SPI_io == 2)
    {
        P4n_standard(0x0f);         //лP4.0(SS) P4.1(MOSI) P4.2(MISO) P4.3(SCLK), Ϊ׼˫
        PullUpEnable(P4PU, 0x0f);   //    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
        P4n_push_pull(Pin3+Pin1);   //MOSI SCLKΪ
        SlewRateHigh(P4SR, Pin3+Pin1);  //MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
    }
    else if(SPI_io == 3)
    {
        P3n_standard(0x3C);         //лP3.5(SS) P3.4(MOSI) P3.3(MISO) P3.2(SCLK), Ϊ׼˫
        PullUpEnable(P3PU, 0x3c);   //    ˿ڲ   PxPU, ҪõĶ˿ڶӦλΪ1
        P3n_push_pull(Pin4+Pin2);   //MOSI SCLKΪ
        SlewRateHigh(P3SR, Pin4+Pin2);  //MOSI SCLK˿Ϊģʽ   PxSR, ҪõĶ˿ڶӦλΪ1.    ģʽ3.3VʱٶȿԵ13.5MHz(27MHzƵSPIٶ2Ƶ)
    }
}


//DMA_SPI_CR     SPI_DMAƼĴ
#define        DMA_ENSPI    (1<<7)    // SPI DMAʹܿλ    bit7, 0:ֹSPI DMAܣ  1SPI DMAܡ
#define        SPI_TRIG_M   (1<<6)    // SPI DMAģʽλbit6, 0:д0Ч          1д1ʼSPI DMAģʽ
#define        SPI_TRIG_S   (1<<5)    // SPI DMAӻģʽλbit5, 0:д0Ч          1д1ʼSPI DMAӻģʽ
#define        SPI_CLRFIFO       1    // SPI DMAFIFOλbit0, 0:д0Ч          1д1λFIFOָ롣


//DMA_SPI_CFG     SPI_DMAüĴ
#define        DMA_SPIIE    (1<<7)    // SPI DMAжʹܿλbit7, 0:ֹSPI DMAжϣ     1жϡ
#define        SPI_ACT_TX   (1<<6)    // SPI DMAݿλbit6, 0:ֹSPI DMAݣֻʱӲݣӻҲ. 1͡
#define        SPI_ACT_RX   (1<<5)    // SPI DMAݿλbit5, 0:ֹSPI DMAݣֻʱӲݣӻҲ. 1ա
#define        DMA_SPIIP    (0<<2)    // SPI DMAжȼλbit3~bit2, ()0~3().
#define        DMA_SPIPTY        0    // SPI DMA߷ȼλbit1~bit0, ()0~3().

//DMA_SPI_CFG2     SPI_DMAüĴ2
#define        SPI_WRPSS    (0<<2)    // SPI DMAʹSSſλbit2, 0: SPI DMA̲ԶSSš  1ԶSSš
#define        SPI_SSS           0    // SPI DMAԶSSѡλbit1~bit0, 0: P1.4,  1P2.4,  2: P4.0,  3:P3.5

//DMA_SPI_STA     SPI_DMA״̬Ĵ
#define        SPI_TXOVW    (1<<2)    // SPI DMAݸǱ־λbit2, 0.
#define        SPI_RXLOSS   (1<<1)    // SPI DMAݶ־λbit1, 0.
#define        DMA_SPIIF         1    // SPI DMAж־λbit0, 0.

//HSSPI_CFG  SPIüĴ
#define        SS_HOLD      (0<<4)    //ģʽʱSSźŵHOLDʱ䣬 0~15, Ĭ3. DMAлNϵͳʱӣSPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.
#define        SS_SETUP          3    //ģʽʱSSźŵSETUPʱ䣬0~15, Ĭ3. DMAвӰʱ䣬       SPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.

//HSSPI_CFG2  SPIüĴ2
#define        SPI_IOSW     (1<<6)    //bit6:MOSIMISOλ01
#define        HSSPIEN      (1<<5)    //bit5:SPIʹλ0رոģʽ1ʹܸģʽ
#define        FIFOEN       (1<<4)    //bit4:SPIFIFOģʽʹλ0رFIFOģʽ1ʹFIFOģʽʹFIFOģʽDMAм13ϵͳʱ䡣
#define        SS_DACT           3    //bit3~0:ģʽʱSSźŵDEACTIVEʱ䣬0~15, Ĭ3. SPIٶΪϵͳʱ/2ʱִDMASS_HOLDSS_SETUPSS_DACTô2ֵ.

/*****************************************************************************
 * @name       :void SPI_DMA_TxTRIG(u8 xdata *TxBuf, u16 num)
 * @date       :2024-1-5
 * @function   :Config SPI DMA
 * @parameters :None
 * @retvalue   :None
******************************************************************************/
void SPI_DMA_TxTRIG(u8 xdata *TxBuf, u16 num)
{
    u16 j;
    HSSPI_CFG  = SS_HOLD | SS_SETUP;    //SS_HOLDNϵͳʱ, SS_SETUPûʱӡ
    HSSPI_CFG2 = HSSPIEN | FIFOEN | SS_DACT;    //FIFOENFIFOС13ʱ, 67T @8Ƶ.

    j = (u16)TxBuf;        //ȡ׵ַ
    DMA_SPI_TXAH = (u8)(j >> 8);        //͵ַĴֽ
    DMA_SPI_TXAL = (u8)j;               //͵ַĴֽ
    DMA_SPI_AMTH = (u8)((num-1)/256);   //ôֽ = n+1
    DMA_SPI_AMT  = (u8)((num-1)%256);   //ôֽ = n+1
    DMA_SPI_ITVH = 0;                   //ӵļʱ䣬N+1ϵͳʱ
    DMA_SPI_ITVL = 0;
    DMA_SPI_STA  = 0x00;
    DMA_SPI_CFG  = DMA_SPIIE | SPI_ACT_TX | DMA_SPIIP | DMA_SPIPTY;
    DMA_SPI_CFG2 = SPI_WRPSS | SPI_SSS;
    DMA_SPI_CR   = DMA_ENSPI | SPI_TRIG_M | SPI_CLRFIFO;
    P10 = 1;
}

//========================================================================
// : void SPI_DMA_ISR (void) interrupt DMA_SPI_VECTOR
// :  SPI_DMAжϺ.
// : none.
// : none.
// 汾: V1.0, 2024-1-5
//========================================================================
void SPI_DMA_ISR (void) interrupt USER_VECTOR//DMA_SPI_VECTOR
{
    P10 = 0;
    DMA_SPI_STA = 0;        //жϱ־
}
