#include "Uart1.h"


u8  TX1_Cnt;    //ͼ
u8  RX1_Cnt;    //ռ
bit B_TX1_Busy; //æ־
u8 RX1_TimeOut;
u8  xdata RX1_Buffer[UART1_BUF_LENGTH]; //ջ

char putchar(char c){
	UART1_TxByte(c);
	return c;
}
//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)
{
    AUXR &= ~(1<<4);		//Timer stop
    AUXR &= ~(1<<3);	//Timer2 set As Timer
    AUXR |= (1<<2);	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);		//Timer run enable
}


//========================================================================
// : void UART1_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART1_TxByte(u8 dat)
{
    B_TX1_Busy = 1;
    SBUF = dat;
    while(B_TX1_Busy);
}

//========================================================================
// : void PrintString1(u8 *puts)
// : 3ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString1(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        UART1_TxByte(*puts);
    }
}


//========================================================================
// : void UART1_config(u8 brt)
// : UART1ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
    /*********** ʹöʱ2 *****************/
    if(brt == 2)
    {
        AUXR |= S1BRT;	//S1 BRT Use Timer2;
        SetTimer2Baudraye(65536UL - (MAIN_Fosc / 4) / Baudrate1);
    }

    /*********** ʹöʱ1 *****************/
    else
    {
        TR1 = 0;
        AUXR &= ~S1BRT;		//S1 BRT Use Timer1;
        TMOD &= ~(1<<6);		//Timer1 set As Timer
        AUXR |= (1<<6);		//Timer1 set as 1T mode
        TMOD &= ~0x30;//Timer1_16bitAutoReload;
        TH1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) / 256);
        TL1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) % 256);
        ET1 = 0;    //ֹж
        TR1 = 1;
    }
    /*************************************************/

    SCON = (SCON & 0x3f) | 0x40;    //UART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//  PS  = 1;    //ȼж
    ES  = 1;    //ж
    REN = 1;    //
    P_SW1 &= 0x3f;
    P_SW1 |= 0x40;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

    B_TX1_Busy = 0;
    TX1_Cnt = 0;
    RX1_Cnt = 0;

}


//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : UART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_int (void) interrupt UART1_VECTOR
{
    if(RI)
    {
        RI = 0;    //Clear Rx flag
        RX1_Buffer[RX1_Cnt] = SBUF;
        if(++RX1_Cnt >= UART1_BUF_LENGTH)   RX1_Cnt = 0;
        RX1_TimeOut = 5;
    }

    if(TI)
    {
        TI = 0;   //Clear Tx flag
        B_TX1_Busy = 0;
    }
}
