
/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/



//	STC8051UϵеEEPROMд
#include "../../comm/AI8051U.h"
#include "eeprom.h"

#define		IAP_STANDBY()	IAP_CMD = 0		/* ISPֹ*/
#define		IAP_READ()		IAP_CMD = 1		/* ISP		*/
#define		IAP_WRITE()		IAP_CMD = 2		/* ISPд		*/
#define		IAP_ERASE()		IAP_CMD = 3		/* ISP		*/
//========================================================================
// : void	ISP_Disable(void)
// : ֹISP/IAP.
// : non.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void	DisableEEPROM(void)	//ֹEEPROM
{
	IAP_TPS   = 0;
	IAP_CONTR = 0;			//ֹISP/IAP
	IAP_CMD   = 0;			//ȥISP/IAP
	IAP_TRIG  = 0;			//ֹISP/IAP󴥷
	IAP_ADDRE = 0xff;       //ַõ IAP 
	IAP_ADDRH = 0xff;		//0ַֽ
	IAP_ADDRL = 0xff;		//0ַֽڣָEEPROMֹ
}

//========================================================================
// : void EEPROM_Trig(void)
// : EEPROM.
// : none.
// : none.
// 汾: V1.0, 2024-6-30
//========================================================================
void EEPROM_Trig(void)
{
//	EA = 0;				//ֹж. ֻѭжвEEPROMҪжϣ߶EEPROMѭвEEPROMж⾺
	IAP_TRIG = 0x5A;	//5AHA5HIAPĴÿζҪ
	IAP_TRIG = 0xA5;	//A5HIAP, CPUȴIAPɺ󣬲Żִг
	_nop_();			//STC8051Ƕ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
	_nop_();
	_nop_();
	_nop_();
//	EA = 1;		//ж
}

//========================================================================
// : void EEPROM_SectorErase(u32 EE_address)
// : һ.
// : EE_address:  ҪEEPROMеһֽڵַ.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_SectorErase(u16 EE_address)
{											//ֻûֽڲ512ֽ/ һֽڵַַ
	IAP_CONTR = IAPEN;						//ISP/IAP
	IAP_TPS = (u8)(MAIN_Fosc / 1000000UL);	//Ƶ
    IAP_CMD = 3;                        	//, ıʱ
    IAP_ADDRE = 0; 							//ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (u8)(EE_address >> 8);		//ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (u8)EE_address;				//ַֽڣַҪıʱ͵ַ
    EEPROM_Trig();							//EEPROM
    DisableEEPROM();						//ֹEEPROM
}

//========================================================================
// : void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 lenth)
// : Nֽں.
// : EE_address:  ҪEEPROM׵ַ.
//       DataAddress: Ҫݵָ.
//       length:      Ҫĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_read_n(u16 EE_address, u8 *DataAddress, u8 length)
{
	IAP_CONTR = IAPEN;						//ISP/IAP
	IAP_TPS = (u8)(MAIN_Fosc / 1000000UL);	//ݹƵõȴʱ
    IAP_CMD = 1;                             //ֽڶıʱ
    do
    {
        IAP_ADDRE = 0; 						//͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        *DataAddress = IAP_DATA;            //
        EE_address++;
        DataAddress++;
    }while(--length);
	DisableEEPROM();		//ֹEEPWOM
}


//========================================================================
// : u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
// : дNֽں.
// : EE_address:  ҪдEEPROM׵ַ.
//       DataAddress: Ҫдݵָ.
//       length:      Ҫдĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
u8 EEPROM_write_n(u16 EE_address, u8 *DataAddress, u8 length)
{
    u8  i;
    u16 j;
    u8  *p;

    if(length == 0) return 1;   //Ϊ0

	IAP_CONTR = IAPEN;						//ISP/IAP
	IAP_TPS = (u8)(MAIN_Fosc / 1000000UL);	//ݹƵõȴʱ
    i = length;
    j = EE_address;
    p = DataAddress;
    IAP_WRITE();                            //, ֽд
    do
    {
        IAP_ADDRE = 0; 						//͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA  = *DataAddress;           //ݵIAP_DATAֻݸıʱ
        EEPROM_Trig();                      //EEPROM
        EE_address++;                       //һַ
        DataAddress++;                      //һ
    }while(--length);                       //ֱ

    EE_address = j;
    length = i;
    DataAddress = p;
    i = 0;
    IAP_READ();                             //NֽڲȽ
    do
    {
        IAP_ADDRE = 0; 						//͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        if(*DataAddress != IAP_DATA)        //ԴݱȽ
        {
            i = 2;
            break;
        }
        EE_address++;
        DataAddress++;
    }while(--length);
	DisableEEPROM();		//ֹEEPWOM
    return i;
}

