/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбд.

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʹP0ʾƣ

ʹUSBӵԸMCU
ͨжP32ڰִMCUλָUSBģʽ
ȻAIapp-ISP/̡ťء
λISPλRSTFLAGϵͳISPжP3.2ƽP3.0/P3.1ͬʱΪ͵ƽĻͻUSBģʽ

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "../comm/AI8051U.h"

//==========================================================================

typedef unsigned char   u8;
typedef unsigned int    u16;
typedef unsigned long   u32;

/*************  س    **************/

#define MAIN_Fosc       24000000L   //ʱ
#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/

/*************  IOڶ    **************/


/*************  ر    **************/

//P3.2ڰλ
bit Key_Flag;
u16 Key_cnt;

/*************  غ    **************/

void Timer0_Init(void);
void delay_ms(u8 ms);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;   //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR();  //չĴ(XFR)ʹ
    CKCON = 0;  //߷XRAMٶ

    RSTFLAG |= 0x04;   //λ־д1㣬ӲλҪP3.2״̬ѡӲλϵͳISP⵽P3.2Ϊ͵ƽŻUSBģʽ

    P0M1 = 0x00;   P0M0 = 0xff;   //Ϊ
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    Timer0_Init();
    EA = 1;         //ж
    P40 = 0;        //LED Power On

    while(1)
    {
        P00 = 0;        //LED On
        delay_ms(250);
        P00 = 1;        //LED Off

        P01 = 0;        //LED On
        delay_ms(250);
        P01 = 1;        //LED Off

        P02 = 0;        //LED On
        delay_ms(250);
        P02 = 1;        //LED Off

        P03 = 0;        //LED On
        delay_ms(250);
        P03 = 1;        //LED Off

        P04 = 0;        //LED On
        delay_ms(250);
        P04 = 1;        //LED Off

        P05 = 0;        //LED On
        delay_ms(250);
        P05 = 1;        //LED Off

        P06 = 0;        //LED On
        delay_ms(250);
        P06 = 1;        //LED Off

        P07 = 0;        //LED On
        delay_ms(250);
        P07 = 1;        //LED Off
    }
}

//========================================================================
// : void Timer0_Init(void)
// : ʱ0ʼ
// : none.
// : none.
// 汾: VER1.0
// : 2022-6-2
// ע: 
//========================================================================
void Timer0_Init(void)
{
    // Timer0ʼ
    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;    //Timer0 interrupt enable
    TR0 = 1;    //Tiner0 run
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2022-6-3
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);   //6T per loop
    }while(--ms);
}

//========================================================================
// : void KeyResetScan(void)
// : P3.2ڰ1봥λUSBģʽ
// : none.
// : none.
// 汾: VER1.0
// : 2022-6-11
// ע: 
//========================================================================
void KeyResetScan(void)
{
    if(!P32)
    {
        if(!Key_Flag)
        {
            Key_cnt++;
            if(Key_cnt >= 1000)		//1000msЧ
            {
                Key_Flag = 1;		//ð״ֹ̬ظ

//                USBCON = 0x00;      //USBãйUSBõĻҪ
//                USBCLK = 0x00;
//                IRC48MCR = 0x00;
                
                delay_ms(10);
                IAP_CONTR = 0x60;   //λISPʼִУλλRSTFLAGISPҪжP3.2ƽ
                while (1);
            }
        }
    }
    else
    {
        Key_cnt = 0;
        Key_Flag = 0;
    }
}

//========================================================================
// : void timer0_int(void)
// : Timer0 1msжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2022-6-11
// ע: 
//========================================================================
void timer0_int(void) interrupt 1  //1ms жϺ
{
    KeyResetScan();   //P3.2ڰλUSBģʽҪ˹ܿɾд
}
