/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

#include "config.h"
#include "uart.h"

BYTE xdata UartTxBuffer[64];
BYTE xdata UartRxBuffer[64];
BYTE bUartRxStage;

void delay_ms(u8 ms);

void uart_init()
{
    P_SW1 &= ~S1_S0;
    P_SW1 &= ~S1_S1;
    SCON = 0x50;
    AUXR |= S1BRT;
    AUXR |= (1<<2);
    T2L = BAUD;
    T2H = BAUD >> 8;
    AUXR = (AUXR & ~0x10) | (1 << 4);
    ES = 1;
    
    bUartRxStage = 0;
}

void uart_isr() interrupt 4
{
    BYTE dat;

    if (TI)
    {
        TI = 0;
    }
    
    if (RI)
    {
        RI = 0;
        
        dat = SBUF;
        switch (bUartRxStage)
        {
        case 0:
L_CheckHeader:
            bUartRxStage = 0;
            if (dat == '@')
                bUartRxStage = 1;
            break;
        case 1:
            if (dat != 'S')
                goto L_CheckHeader;
            bUartRxStage = 2;
            break;
        case 2:
            if (dat != 'T')
                goto L_CheckHeader;
            bUartRxStage = 3;
            break;
        case 3:
            if (dat != 'C')
                goto L_CheckHeader;
            bUartRxStage = 4;
            break;
        case 4:
            if (dat != 'I')
                goto L_CheckHeader;
            bUartRxStage = 5;
            break;
        case 5:
            if (dat != 'S')
                goto L_CheckHeader;
            bUartRxStage = 6;
            break;
        case 6:
            if (dat != 'P')
                goto L_CheckHeader;
            bUartRxStage = 7;
            break;
        case 7:
            if (dat != '#')
                goto L_CheckHeader;
            bUartRxStage = 0;
            delay_ms(200);
            IAP_CONTR = 0x60;   //λISPʼִ
            while (1);
            break;
        default:
            bUartRxStage = 0;
            break;
        }
    }
}

void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}
