/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбд.

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʱ016λԶװ, жƵΪ1000HZΪɨʾ.

ʱ116λԶװ, жƵΪ10000HZΪźſȼ.

STCMCUIOʽ74HC5958λܡ

P33(INT1)ڲ͵ƽ(ûԶ޸Ķ˿ڸƽ)ʱмʱƽ仯ֹͣʱ

ʾźſȣλ0.1msΧ0.1ms~6553.5ms.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "../comm/AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

//==========================================================================

#define Timer0_Reload   (MAIN_Fosc / 1000)      //Timer 0 жƵ, 1000/
#define Timer1_Reload   (MAIN_Fosc / 10000)     //Timer 1 жƵ, 10000/

#define DIS_DOT     0x20
#define DIS_BLACK   0x10
#define DIS_        0x11

/*************  س    **************/
const u8 code t_display[]={                       //׼ֿ
//   0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
    0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x77,0x7C,0x39,0x5E,0x79,0x71,
//black  -     H    J    K    L    N    o   P    U     t    G    Q    r   M    y
    0x00,0x40,0x76,0x1E,0x70,0x38,0x37,0x5C,0x73,0x3E,0x78,0x3d,0x67,0x50,0x37,0x6e,
    0xBF,0x86,0xDB,0xCF,0xE6,0xED,0xFD,0x87,0xFF,0xEF,0x46};    //0. 1. 2. 3. 4. 5. 6. 7. 8. 9. -1

const u8 code T_COM[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};      //λ

/*************  IOڶ    **************/
//sbit    P_HC595_SER   = P3^4;   //pin 14    SER     data input
SBIT(P_HC595_SER,0xb0/*P3*/,4);
//sbit    P_HC595_RCLK  = P3^5;   //pin 12    RCLk    store (latch) clock
SBIT(P_HC595_RCLK,0xb0/*P3*/,5);
//sbit    P_HC595_SRCLK = P3^2;   //pin 11    SRCLK   Shift data clock
SBIT(P_HC595_SRCLK,0xb0/*P3*/,2);

/*************  ر    **************/

u8  LED8[8];        //ʾ
u8  display_index;  //ʾλ
bit B_1ms;          //1ms־
u16 msecond;
u16 Test_cnt;   //ʾõļ
u16 Temp_cnt;   //õļ

/*************  غ    **************/

void Timer0_init(void);
void Timer1_init(void);
void DisplayScan(void);
void Display(void);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    u8  i;
    
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    P_SW2 |= EAXFR; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    Test_cnt = 0;
    Temp_cnt = 0;
    for(i=0; i<8; i++)  LED8[i] = DIS_BLACK;    //ϵ
    
    Timer0_init();
    Timer1_init();
    EA = 1;     //ж

    while (1)
    {
        if(B_1ms)   //1ms
        {
            B_1ms = 0;
            if(++msecond >= 1000)   //1뵽
            {
                msecond = 0;        //1000ms
                Display();          //ʾ
            }
        }
    }
}

//========================================================================
// : void Timer0_init(void)
// : timer0ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer0_init(void)
{
        TR0 = 0;    //ֹͣ

    #if (Timer0_Reload < 64)    // ûֵʣ ʱ
        #error "Timer0õжϹ!"

    #elif ((Timer0_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET0 = 1;    //ж
    //  PT0 = 1;    //ȼж
TMOD&=~0x03;
        TMOD |= 0;  //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
    //  TMOD |= T0_CT;  //
TMOD&=~T0_CT;//ʱ
    //  INTCLKO |= T0CLKO; //ʱ
INTCLKO&=~T0CLKO;//ʱ

        #if (Timer0_Reload < 65536UL)
            AUXR |= T0x12;  //1T mode
            TH0 = (u8)((65536UL - Timer0_Reload) / 256);
            TL0 = (u8)((65536UL - Timer0_Reload) % 256);
        #else
AUXR&=~T0x12;//12Tmode
            TH0 = (u8)((65536UL - Timer0_Reload/12) / 256);
            TL0 = (u8)((65536UL - Timer0_Reload/12) % 256);
        #endif

        TR0 = 1;    //ʼ

    #else
        #error "Timer0õжϹ!"
    #endif
}

//========================================================================
// : void Timer1_init(void)
// : timer1ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer1_init(void)
{
        TR1 = 0;    //ֹͣ

    #if (Timer1_Reload < 64)    // ûֵʣ ʱ
        #error "Timer1õжϹ!"

    #elif ((Timer1_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET1 = 1;    //ж
    //  PT1 = 1;    //ȼж
TMOD&=~0x30;
        TMOD |= (0 << 4);   //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ
    //  TMOD |= T1_CT;  //
TMOD&=~T1_CT;//ʱ
    //  INTCLKO |= T1CLKO; //ʱ
INTCLKO&=~T1CLKO;//ʱ

        #if (Timer1_Reload < 65536UL)
            AUXR |= T1x12;  //1T mode
            TH1 = (u8)((65536UL - Timer1_Reload) / 256);
            TL1 = (u8)((65536UL - Timer1_Reload) % 256);
        #else
AUXR&=~T1x12;//12Tmode
            TH1 = (u8)((65536UL - Timer1_Reload/12) / 256);
            TL1 = (u8)((65536UL - Timer1_Reload/12) % 256);
        #endif

        TR1 = 1;    //ʼ

    #else
        #error "Timer1õжϹ!"
    #endif
}

//========================================================================
// : void timer0_int (void) interrupt TIMER0_VECTOR
// :  timer0жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer0_int (void) interrupt 1
INTERRUPT(timer0_int,TMR0_VECTOR)
{
    DisplayScan();  //1msɨʾһλ
    B_1ms = 1;      //1ms־
}

//========================================================================
// : void timer1_int (void) interrupt TIMER1_VECTOR
// :  timer1жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer1_int (void) interrupt 3
INTERRUPT(timer1_int,TMR1_VECTOR)
{
   if(!P33)
   {
      Temp_cnt++;
   }
   else
   {
      if(Temp_cnt>10)		//Чź > 1ms
      {
         Test_cnt = Temp_cnt;
      }
      Temp_cnt = 0;
   }
}

/**************** HC595һֽں ******************/
void Send_595(u8 dat)
{
    u8  i;
    for(i=0; i<8; i++)
    {
        dat <<= 1;
        P_HC595_SER   = CY;
        P_HC595_SRCLK = 1;
        P_HC595_SRCLK = 0;
    }
}

/********************** ʾɨ躯 ************************/
void DisplayScan(void)
{
    Send_595(t_display[LED8[display_index]]);   //
    Send_595(~T_COM[display_index]);            //λ

    P_HC595_RCLK = 1;
    P_HC595_RCLK = 0;
   if(++display_index >= 8)   display_index = 0;  //8λ0
}

/********************** ʾ ************************/
void Display(void)
{
    u8  i;
    
    LED8[3] = Test_cnt / 10000;
    LED8[4] = (Test_cnt % 10000) / 1000;
    LED8[5] = (Test_cnt % 1000) / 100;
    LED8[6] = (Test_cnt % 100) / 10;
    LED8[7] = Test_cnt % 10;
    
    for(i=3; i<7; i++)  //Ч0
    {
        if(LED8[i] > 0) break;
        LED8[i] = DIS_BLACK;
    }
}
