/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʾЧΪ: ϵʾ2, Ȼ˯ģʽ.

ϵINT0INT1, ʾ2ٽ˯ģʽ.

һֱ(INT0/INT1Ϊ͵ƽ), MCU˯, ֱINT0/INT1ΪߵƽΪֹ.

INT2, INT3, INT4 ʵû԰Ҫʱοʹ.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "../comm/AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

//==========================================================================

//   sbit INT1     = P3^3;
//   sbit INT0     = P3^2;

//==========================================================================

#define MAIN_Fosc       24000000UL

/*************  س    **************/

const u8 code ledNum[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

/*************  ر    **************/

u8 ledIndex;
u16 msecond;        //1000ms

/*************  غ    **************/

void delay_ms(u8 ms);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    P_SW2 |= EAXFR; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    P40 = 0;    //LED Power On
    EA = 1;     //ж

    while(1)
    {
        delay_ms(100);      //ʱ100ms
        //ָʾ״̬
        P0 = ~ledNum[ledIndex];    //
        ledIndex++;
        if(ledIndex > 7)
        {
            ledIndex = 0;
        }

        //2MCU״̬
        if(++msecond >= 20)
        {
            msecond = 0;        //

            if(INT0 && INT1)    //ж϶ǸߵƽʱŽ˯ߣ½ػѡ
            {
                P0 = 0xff;      //ȹرʾʡ

                IE0  = 0;       //ж0־λ
                IE1  = 0;       //ж1־λ
                EX0 = 1;        //INT0 Enable
                EX1 = 1;        //INT1 Enable

                IT0 = 1;        //INT0 ½ж       
            //  IT0 = 0;        //INT0 ,½ж  
                IT1 = 1;        //INT1 ½ж       
            //  IT1 = 0;        //INT1 ,½ж  

            //  INTCLKO |= EX2;        //ʹ INT2 ½ж
            //  INTCLKO |= EX3;        //ʹ INT3 ½ж
            //  INTCLKO |= EX4;        //ʹ INT4 ½ж
                                
                PCON |= PD;         //Sleep
                _nop_();
                _nop_();
                _nop_();
                _nop_();
                _nop_();
                _nop_();
                _nop_();
            }
        }
    }
}

//========================================================================
// : void delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

/********************* INT0жϺ *************************/
//void INT0_int (void) interrupt 0      //жʱѾ־
INTERRUPT(INT0_int,INT0_VECTOR)
{
    EX0 = 0;    //INT0 Disable
}

/********************* INT1жϺ *************************/
//void INT1_int (void) interrupt 2      //жʱѾ־
INTERRUPT(INT1_int,INT1_VECTOR)
{
    EX1 = 0;    //INT1 Disable
}

/********************* INT2жϺ *************************/
//void INT2_int (void) interrupt 10     //жʱѾ־
INTERRUPT(INT2_int,INT2_VECTOR)
{
INTCLKO&=~EX2;//INT2Disable
}

/********************* INT3жϺ *************************/
//void INT3_int (void) interrupt 11     //жʱѾ־
INTERRUPT(INT3_int,INT3_VECTOR)
{
INTCLKO&=~EX3;//INT3Disable
}

/********************* INT4жϺ *************************/
//void INT4_int (void) interrupt 16     //жʱѾ־
INTERRUPT(INT4_int,INT4_VECTOR)
{
INTCLKO&=~EX4;//INT4Disable
}
