/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

4ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյͨ4յԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        22118400L   //ʱӣȷ115200ʣ

//==========================================================================

#define Baudrate4   (65536 - MAIN_Fosc / 115200 / 4)

#define UART4_BUF_LENGTH    64

//==========================================================================

/*************  س    **************/


/*************  IOڶ    **************/

/*************  ر    **************/

u8  TX4_Cnt;    //ͼ
u8  RX4_Cnt;    //ռ
bit B_TX4_Busy; //æ־

u8  RX4_Buffer[UART4_BUF_LENGTH]; //ջ

/*************  غ    **************/

void UART4_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
void PrintString4(u8 *puts);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART4_config(0);    //ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
    EA = 1;             //ȫж

    PrintString4((u8 *)"AI8051U UART4 Test Programme!\r\n");  //UART4һַ

    while (1)
    {
        if((TX4_Cnt != RX4_Cnt) && (!B_TX4_Busy))   //յ, Ϳ
        {
            S4BUF = RX4_Buffer[TX4_Cnt];
            B_TX4_Busy = 1;
            if(++TX4_Cnt >= UART4_BUF_LENGTH)   TX4_Cnt = 0;
        }
    }
}

//========================================================================
// : void PrintString4(u8 *puts)
// : 4ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString4(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        S4BUF = *puts;
        B_TX4_Busy = 1;
        while(B_TX4_Busy);
    }
}

//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)  // ʹTimer2.
{
AUXR&=~(1<<4);		//Timerstop
AUXR&=~(1<<3);	//Timer2setAsTimer
    AUXR |= (1<<2);	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);		//Timer run enable
}

//========================================================================
// : void UART4_config(u8 brt)
// : UART4ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART4_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
{
    if(brt == 2)
    {
        SetTimer2Baudraye(Baudrate4);
        S4CON = 0x10;       //8λ, ʹTimer2ʷ, 
    }
    else
    {
T4T3M&=~(1<<7);	//Timerstop
        S4CON = 0x50;       //8λ, ʹTimer4ʷ, 
        T4H = (u8)(Baudrate4 / 256);
        T4L = (u8)(Baudrate4 % 256);
T4T3M&=~(1<<6);	//Timer3setAsTimer
        T4T3M |= (1<<5);	//Timer3 set as 1T mode
        T4T3M = (T4T3M & ~0x80) | (1 << 7);	//Timer run enable
    }
    IE2 |= ES4;       //UART4ж
P_SW2&=~S4_S;//UART4switchbit2to:0:P0.2P0.3,1:P5.2P5.3

    B_TX4_Busy = 0;
    TX4_Cnt = 0;
    RX4_Cnt = 0;
}


//========================================================================
// : void UART4_int (void) interrupt UART4_VECTOR
// : UART4жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
//void UART4_int (void) interrupt 18
INTERRUPT(UART4_int,UART4_VECTOR)
{
    if(S4CON & S4RI)
    {
S4CON&=~S4RI;//ClearRxflag
        RX4_Buffer[RX4_Cnt] = S4BUF;
        if(++RX4_Cnt >= UART4_BUF_LENGTH)   RX4_Cnt = 0;
    }

    if(S4CON & S4TI)
    {
S4CON&=~S4TI;//ClearTxflag
        B_TX4_Busy = 0;
    }
}

