/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵  **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

STCMCUIOʽ74HC5958λܡ

ʹTimer016λԶװ1ms,,û޸MCUʱƵʱ,Զʱ1ms.

û"û"޸ĵ籣EEPROMַ

ʾЧΪ: ϵʾ, ΧΪ0~10000ʾұߵ5ܡ

MCUѹжϣб档MCUϵʱʾ

û"û"ѡ˲ݴС
ĵ(1000uF)󱣳ֵʱ䳤ڵѹжв(Ҫ20msʱ)Ȼд롣
Сĵݣ󱣳ֵʱ, ʼʱȲ.

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
ע⣺ʱؽ"Ӳѡ"Ҫ̶:

ѡ  ѹλ(ֹѹж)ѹѹѡֵ

ûEEPROMСȷ"û"趨ĵַEEPROMõĴСΧ֮ڣEEPROMСûϵͳ
Ҫûϵͳ4KEEPROM8KôûEEPROMСҪ12K

޸ĹӲѡҪƬϵŻЧ

ѡʱ 24MHZ (û޸Ƶ)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

ֱʹõѹжϼ͵ѹȻ󱣴EEPROMݣ
ΪѹжʱMCUѹѾܵͣһ㹻ʱв/EEPROMݣ

οȽ½ڷʹñȽⲿӣ
ͨȽѹǰѹֵ㹻ʱв/EEPROMݡ

******************************************/

#include "..\comm\AI8051U.h"
#include "intrins.h"

#define     MAIN_Fosc       24000000L   //ʱ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

#define DIS_DOT     0x20
#define DIS_BLACK   0x10
#define DIS_        0x11

/****************************** û ***********************************/

#define     LargeCapacitor  0   //0: ˲ݱȽС,  1: ˲ݱȽϴ

#define     EE_ADDRESS  0x000000  //EEPROMʼַ

#define     Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/

#define     Tip_Delay   (MAIN_Fosc / 1000000)

/*****************************************************************************/

//sbit    P_HC595_SER   = P3^4;   //pin 14    SER     data input
SBIT(P_HC595_SER,0xb0/*P3*/,4);
//sbit    P_HC595_RCLK  = P3^5;   //pin 12    RCLk    store (latch) clock
SBIT(P_HC595_RCLK,0xb0/*P3*/,5);
//sbit    P_HC595_SRCLK = P3^2;   //pin 11    SRCLK   Shift data clock
SBIT(P_HC595_SRCLK,0xb0/*P3*/,2);

/*************  س    **************/
const u8 code t_display[]={                       //׼ֿ
//   0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
    0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x77,0x7C,0x39,0x5E,0x79,0x71,
//black  -     H    J    K    L    N    o   P    U     t    G    Q    r   M    y
    0x00,0x40,0x76,0x1E,0x70,0x38,0x37,0x5C,0x73,0x3E,0x78,0x3d,0x67,0x50,0x37,0x6e,
    0xBF,0x86,0xDB,0xCF,0xE6,0xED,0xFD,0x87,0xFF,0xEF,0x46};    //0. 1. 2. 3. 4. 5. 6. 7. 8. 9. -1

const u8 code T_COM[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};      //λ


u8  LED8[8];        //ʾ
u8  display_index;  //ʾλ
bit B_1ms;          //1ms־
u16 msecond;

u16 Test_cnt;   //õ
u8  tmp[2];     //ͨ


void    Display(void);
void    DisableEEPROM(void);
void    EEPROM_read_n(u32 EE_address,u8 *DataAddress,u16 number);
void    EEPROM_write_n(u32 EE_address,u8 *DataAddress,u16 number);
void    EEPROM_SectorErase(u32 EE_address);

/**********************  ************************/
void main(void)
{
    u8  i;
    
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    display_index = 0;
    for(i=0; i<8; i++)  LED8[i] = DIS_BLACK;    //ȫ
    
    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;    //Timer0 interrupt enable
    TR0 = 1;    //Tiner0 run
    EA = 1;     //ж
    
    for(msecond=0; msecond < 200; ) //ʱ200ms
    {
        if(B_1ms)   //1ms
        {
            B_1ms = 0;
            msecond ++;
        }
    }

    EEPROM_read_n(EE_ADDRESS,tmp,2);        //2ֽ
    Test_cnt = ((u16)tmp[0] << 8) + tmp[1]; //
    if(Test_cnt > 10000)    Test_cnt = 0;   //ΧΪ0~10000
    
    #if (LargeCapacitor == 0)   //˲ݱȽСݱʱȽ϶̣Ȳ
        EEPROM_SectorErase(EE_ADDRESS); //һ
    #endif
    
    Display();      //ʾ
    
PCON&=~LVDF;//ѹ־0
    ELVD = 1;   //ѹж
    PLVD = 1;   //ѹж ȼ

    while(1)
    {
        if(B_1ms)   //1ms
        {
            B_1ms = 0;
            if(++msecond >= 1000)   //1뵽
            {
                msecond = 0;        //1000ms
                Test_cnt++;         //+1
                if(Test_cnt > 10000)    Test_cnt = 0;   //ΧΪ0~10000
                Display();          //ʾ
            }
        }
    }
} 
/**********************************************/

/********************** ѹжϺ ************************/
//void LVD_Routine(void) interrupt 6
INTERRUPT(LVD_Routine,LVD_VECTOR)
{
    u8  i;

    P_HC595_SER = 0;
    for(i=0; i<16; i++)     //ȹرʾʡ
    {
        P_HC595_SRCLK = 1;
        P_HC595_SRCLK = 0;
    }
    P_HC595_RCLK = 1;
    P_HC595_RCLK = 0;       //

//    P42 = 0;
    #if (LargeCapacitor > 0)    //˲ݱȽϴ󣬵ݱʱȽϳ(50ms)ж
        EEPROM_SectorErase(EE_ADDRESS); //һ
    #endif

    tmp[0] = (u8)(Test_cnt >> 8);
    tmp[1] = (u8)Test_cnt;
    EEPROM_write_n(EE_ADDRESS,tmp,2);
//    P42 = 1;

    while(LVDF)        //ǷȻ͵ѹ
    {
PCON&=~LVDF;//ѹ־0
        for(i=0; i<100; i++)    ;   //ʱһ
    }
}

/********************** ʾ ************************/
void Display(void)
{
    u8  i;
    
    LED8[3] = Test_cnt / 10000;
    LED8[4] = (Test_cnt % 10000) / 1000;
    LED8[5] = (Test_cnt % 1000) / 100;
    LED8[6] = (Test_cnt % 100) / 10;
    LED8[7] = Test_cnt % 10;
    
    for(i=3; i<7; i++)  //Ч0
    {
        if(LED8[i] > 0) break;
        LED8[i] = DIS_BLACK;
    }
}

//========================================================================
// : void   ISP_Disable(void)
// : ֹISP/IAP.
// : non.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void DisableEEPROM(void)
{
    IAP_CONTR = 0;          //ر IAP 
    IAP_CMD = 0;            //Ĵ
    IAP_TRIG = 0;           //Ĵ
    IAP_ADDRE = 0xff;       //ַõ IAP 
    IAP_ADDRH = 0xff;       //ַõ IAP 
    IAP_ADDRL = 0xff;
}

//========================================================================
// : void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u16 number)
// : ָEEPROM׵ַnֽڷָĻ.
// : EE_address:  EEPROM׵ַ.
//       DataAddress: ݷŻ׵ַ.
//       number:      ֽڳ.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u16 number)
{
    EA = 0;     //ֹж

    IAP_CONTR = 0x80; //ʹ IAP
    IAP_TPS = Tip_Delay; //òȴ 24MHz
    IAP_CMD = 1;  // IAP 
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_TRIG = 0x5a; //д(0x5a)
        IAP_TRIG = 0xa5; //д(0xa5)
        _nop_();   //༶ˮߵָϵͳ4NOP֤IAP_DATA׼
        _nop_();
        _nop_();
        _nop_();
        *DataAddress = IAP_DATA; // IAP 
        EE_address++;
        DataAddress++;
    }while(--number);
    DisableEEPROM();
    EA = 1;     //ж
}

//========================================================================
// : void EEPROM_SectorErase(u32 EE_address)
// : ַָEEPROM.
// : EE_address:  ҪEEPROMĵַ.
// : non.
// 汾: V1.0, 2013-5-10
//========================================================================
void EEPROM_SectorErase(u32 EE_address)
{
    EA = 0;     //ֹж

    IAP_CONTR = 0x80; //ʹ IAP
    IAP_TPS = Tip_Delay;     //òȴ 24MHz
    IAP_CMD = 3;      // IAP 
    IAP_ADDRE = (u8)(EE_address >> 16); //ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (u8)(EE_address >> 8);  //ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (u8)EE_address;         //ַֽڣַҪıʱ͵ַ
    IAP_TRIG = 0x5a; //д(0x5a)
    IAP_TRIG = 0xa5; //д(0xa5)
    _nop_();   //༶ˮߵָϵͳ4NOP֤IAP_DATA׼
    _nop_();
    _nop_();
    _nop_();
    DisableEEPROM();
    EA = 1;     //ж
}

//========================================================================
// : void EEPROM_write_n(u32 EE_address,u8 *DataAddress,u16 number)
// : ѻnֽдָ׵ַEEPROM.
// : EE_address:  дEEPROM׵ַ.
//       DataAddress: дԴݵĻ׵ַ.
//       number:      дֽڳ.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void EEPROM_write_n(u32 EE_address,u8 *DataAddress,u16 number)
{
    EA = 0;     //ֹж

    IAP_CONTR = 0x80; //ʹ IAP
    IAP_TPS = Tip_Delay; //òȴ 24MHz
    IAP_CMD = 2;  // IAP д
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA = *DataAddress; //д IAP 
        IAP_TRIG = 0x5a; //д(0x5a)
        IAP_TRIG = 0xa5; //д(0xa5)
        _nop_();   //༶ˮߵָϵͳ4NOP֤IAP_DATA׼
        _nop_();
        _nop_();
        _nop_();
        EE_address++;
        DataAddress++;
    }while(--number);

    DisableEEPROM();
    EA = 1;     //ж
}

/**************** HC595һֽں ******************/
void Send_595(u8 dat)
{
    u8  i;
    for(i=0; i<8; i++)
    {
        dat <<= 1;
        P_HC595_SER   = CY;
        P_HC595_SRCLK = 1;
        P_HC595_SRCLK = 0;
    }
}

/********************** ʾɨ躯 ************************/
void DisplayScan(void)
{
    Send_595(t_display[LED8[display_index]]);   //
    Send_595(~T_COM[display_index]);            //λ

    P_HC595_RCLK = 1;
    P_HC595_RCLK = 0;
    if(++display_index >= 8)    display_index = 0;  //8λ0
}

/********************** Timer0 1msжϺ ************************/
//void timer0 (void) interrupt 1
INTERRUPT(timer0,TMR0_VECTOR)
{
    DisplayScan();  //1msɨʾһλ
    B_1ms = 1;      //1ms־
}
