/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

#include "config.h"
#include "app.h"

//========================================================================
//                                IO
//========================================================================
void GPIO_config(void)
{
    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x09;   P1M0 = 0x00;   //Ϊ׼˫, P1.0,P1.3
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x02;   //Ϊ׼˫, P5.1
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    P51 = 1;    //NTC
}

//========================================================================
//                               ʱ
//========================================================================
void Timer_config(void)
{
    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;        //Timer0 interrupt enable
    TR0 = 1;        //Tiner0 run
}

//========================================================================
//                              ADCʼ
//========================================================================
void ADC_config(void)
{
    ADCTIM = 0x3f;      // ADC ڲʱADCʱ佨ֵ
    ADCCFG = 0x2f;      // ADC ʱΪϵͳʱ/2/16/16
    ADC_CONTR = 0x80;   //ʹ ADC ģ
}

//========================================================================
//                              PWMʼ
//========================================================================
void PWM_config(void)
{
    PWMB_CCER1 = 0x00;  //д CCMRx ǰ CCxE رͨ
    PWMB_CCMR1 = 0x30;  //ͨģʽãתģʽ
    PWMB_CCER1 = 0x01;  //ͨʹܺͼ

    PWMB_ARRH = 0x07;   //ʱ
    PWMB_ARRL = 0xff;

    PWMB_ENO = 0x00;    //PWM5ر
//    PWMB_ENO = 0x01;    //PWM5ʹ
    PWMB_PS = 0x03;     //߼ PWM ͨѡλ, P50

    PWMB_BKR = 0x80;    //ʹ
    PWMB_CR1 |= 0x01;   //ʼʱ
}

//========================================================================
//                              UARTʼ
//========================================================================
void UartInit(void)
{
#if(PrintUart == 1)
P_SW1&=~S1_S1;//UART1switchto,00:P3.0P3.1,01:P3.6P3.7,10:P1.6P1.7,11:P4.3P4.4
P_SW1&=~S1_S0;
    SCON = (SCON & 0x3f) | 0x40;
    AUXR |= (1<<6);      //ʱʱ1Tģʽ
AUXR&=~S1BRT;//1ѡʱ1Ϊʷ
    TL1  = TM;
    TH1  = TM>>8;
    TR1 = 1;        //ʱ1ʼʱ

//    SCON = (SCON & 0x3f) | 0x40; 
//    T2L  = TM;
//    T2H  = TM>>8;
//    AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
    P_SW2 |= S2_S;       //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
    S2CON = (SCON & 0x3f) | 0x40; 
    T2L  = TM;
    T2H  = TM>>8;
    AUXR |= 0x14;   //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
    SBUF = dat; 
    while(TI == 0);
    TI = 0;
#else
    S2BUF  = dat; 
while((S2CON & S2TI)==0);
S2CON&=~S2TI;//ClearTxflag
#endif
}

//char putchar(char c)
PUTCHAR_FUN()
{
    UartPutc(c);
    return c;
}

//========================================================================
//                                ϵͳʼ
//========================================================================
void SYS_Init(void)
{
    GPIO_config();
    Timer_config();
    ADC_config();
    PWM_config();
    UartInit();
    EA = 1;

    APP_config();
}
