#include <compiler.h>
#if defined(_USE_IAR_COMPILER_)

#ifndef IOAI8051U_H
#define IOAI8051U_H
#define __AI8051U__

#ifdef __IAR_SYSTEMS_ICC__
#ifndef _SYSTEM_BUILD
    #pragma system_include
#endif
#pragma language=save
#pragma language=extended

/////////////////////////////////////////////////

__sfr __no_init volatile unsigned char         P0          @           0x80;
    __bit __no_init bool     P00         @           0x80^0;
    __bit __no_init bool     P01         @           0x80^1;
    __bit __no_init bool     P02         @           0x80^2;
    __bit __no_init bool     P03         @           0x80^3;
    __bit __no_init bool     P04         @           0x80^4;
    __bit __no_init bool     P05         @           0x80^5;
    __bit __no_init bool     P06         @           0x80^6;
    __bit __no_init bool     P07         @           0x80^7;

__sfr __no_init volatile unsigned char         SP          @           0x81;
__sfr __no_init volatile unsigned char         DPL         @           0x82;
__sfr __no_init volatile unsigned char         DPH         @           0x83;
__sfr __no_init volatile unsigned char         DPXL        @           0x84;
__sfr __no_init volatile unsigned char         SPH         @           0x85;

__sfr __no_init volatile unsigned char         PCON        @           0x87;
    #define SMOD                    0x80
    #define SMOD0                   0x40
    #define LVDF                    0x20
    #define POF                     0x10
    #define GF1                     0x08
    #define GF0                     0x04
    #define PD                      0x02
    #define IDL                     0x01

__sfr __no_init volatile unsigned char         TCON        @           0x88;
    __bit __no_init bool     TF1         @           0x88^7;
    __bit __no_init bool     TR1         @           0x88^6;
    __bit __no_init bool     TF0         @           0x88^5;
    __bit __no_init bool     TR0         @           0x88^4;
    __bit __no_init bool     IE1         @           0x88^3;
    __bit __no_init bool     IT1         @           0x88^2;
    __bit __no_init bool     IE0         @           0x88^1;
    __bit __no_init bool     IT0         @           0x88^0;

__sfr __no_init volatile unsigned char         TMOD        @           0x89;
    #define T1_GATE                 0x80
    #define T1_CT                   0x40
    #define T1_M1                   0x20
    #define T1_M0                   0x10
    #define T0_GATE                 0x08
    #define T0_CT                   0x04
    #define T0_M1                   0x02
    #define T0_M0                   0x01

__sfr __no_init volatile unsigned char         TL0         @           0x8a;
__sfr __no_init volatile unsigned char         TL1         @           0x8b;
__sfr __no_init volatile unsigned char         TH0         @           0x8c;
__sfr __no_init volatile unsigned char         TH1         @           0x8d;

__sfr __no_init volatile unsigned char         AUXR        @           0x8e;
    #define T0x12                   0x80
    #define T1x12                   0x40
    #define S1M0x6                  0x20
    #define T2R                     0x10
    #define T2_CT                   0x08
    #define T2x12                   0x04
    #define EXTRAM                  0x02
    #define S1BRT                   0x01

__sfr __no_init volatile unsigned char         INTCLKO     @           0x8f;
    #define EX4                     0x40
    #define EX3                     0x20
    #define EX2                     0x10
    #define T2CLKO                  0x04
    #define T1CLKO                  0x02
    #define T0CLKO                  0x01

__sfr __no_init volatile unsigned char         P1          @           0x90;
    __bit __no_init bool     P10         @           0x90^0;
    __bit __no_init bool     P11         @           0x90^1;
    __bit __no_init bool     P12         @           0x90^2;
    __bit __no_init bool     P13         @           0x90^3;
    __bit __no_init bool     P14         @           0x90^4;
    __bit __no_init bool     P15         @           0x90^5;
    __bit __no_init bool     P16         @           0x90^6;
    __bit __no_init bool     P17         @           0x90^7;

__sfr __no_init volatile unsigned char         P1M1        @           0x91;
__sfr __no_init volatile unsigned char         P1M0        @           0x92;
__sfr __no_init volatile unsigned char         P0M1        @           0x93;
__sfr __no_init volatile unsigned char         P0M0        @           0x94;
__sfr __no_init volatile unsigned char         P2M1        @           0x95;
__sfr __no_init volatile unsigned char         P2M0        @           0x96;

__sfr __no_init volatile unsigned char         AUXR2       @           0x97;
    #define RAMTINY                 0x80
    #define CPUMODE                 0x40
    #define RAMEXE                  0x20
    #define CANFD                   0x10
    #define CANSEL                  0x08
    #define CAN2EN                  0x04
    #define CANEN                   0x02
    #define LINEN                   0x01

__sfr __no_init volatile unsigned char         SCON        @           0x98;
    __bit __no_init bool     SM0         @           0x98^7;
    __bit __no_init bool     SM1         @           0x98^6;
    __bit __no_init bool     SM2         @           0x98^5;
    __bit __no_init bool     REN         @           0x98^4;
    __bit __no_init bool     TB8         @           0x98^3;
    __bit __no_init bool     RB8         @           0x98^2;
    __bit __no_init bool     TI          @           0x98^1;
    __bit __no_init bool     RI          @           0x98^0;

__sfr __no_init volatile unsigned char         SBUF        @           0x99;

__sfr __no_init volatile unsigned char         S2CON       @           0x9a;
    #define S2SM0                   0x80
    #define S2SM1                   0x40
    #define S2SM2                   0x20
    #define S2REN                   0x10
    #define S2TB8                   0x08
    #define S2RB8                   0x04
    #define S2TI                    0x02
    #define S2RI                    0x01

__sfr __no_init volatile unsigned char         S2BUF       @           0x9b;

__sfr __no_init volatile unsigned char         IRCBAND     @           0x9d;
    #define USBCKS                  0x80
    #define USBCKS2                 0x40
    #define HIRCSEL1                0x02
    #define HIRCSEL0                0x01

__sfr __no_init volatile unsigned char         LIRTRIM     @           0x9e;
__sfr __no_init volatile unsigned char         IRTRIM      @           0x9f;

__sfr __no_init volatile unsigned char         P2          @           0xa0;
    __bit __no_init bool     P20         @           0xa0^0;
    __bit __no_init bool     P21         @           0xa0^1;
    __bit __no_init bool     P22         @           0xa0^2;
    __bit __no_init bool     P23         @           0xa0^3;
    __bit __no_init bool     P24         @           0xa0^4;
    __bit __no_init bool     P25         @           0xa0^5;
    __bit __no_init bool     P26         @           0xa0^6;
    __bit __no_init bool     P27         @           0xa0^7;

__sfr __no_init volatile unsigned char         BUS_SPEED   @           0xa1;

__sfr __no_init volatile unsigned char         P_SW1       @           0xa2;
    #define S1_S1                   0x80
    #define S1_S0                   0x40
    #define CAN_S1                  0x20
    #define CAN_S0                  0x10
    #define SPI_S1                  0x08
    #define SPI_S0                  0x04
    #define LIN_S1                  0x02
    #define LIN_S0                  0x01

__sfr __no_init volatile unsigned char         VRTRIM      @           0xa6;

__sfr __no_init volatile unsigned char         IE          @           0xa8;
    __bit __no_init bool     EA          @           0xa8^7;
    __bit __no_init bool     ELVD        @           0xa8^6;
    __bit __no_init bool     EADC        @           0xa8^5;
    __bit __no_init bool     ES          @           0xa8^4;
    __bit __no_init bool     ET1         @           0xa8^3;
    __bit __no_init bool     EX1         @           0xa8^2;
    __bit __no_init bool     ET0         @           0xa8^1;
    __bit __no_init bool     EX0         @           0xa8^0;

__sfr __no_init volatile unsigned char         SADDR       @           0xa9;
__sfr __no_init volatile unsigned char         WKTCL       @           0xaa;
__sfr __no_init volatile unsigned char         WKTCH       @           0xab;
    #define WKTEN                   0x80

__sfr __no_init volatile unsigned char         S3CON       @           0xac;
    #define S3SM0                   0x80
    #define S3ST3                   0x40
    #define S3SM2                   0x20
    #define S3REN                   0x10
    #define S3TB8                   0x08
    #define S3RB8                   0x04
    #define S3TI                    0x02
    #define S3RI                    0x01

__sfr __no_init volatile unsigned char         S3BUF       @           0xad;
__sfr __no_init volatile unsigned char         TA          @           0xae;

__sfr __no_init volatile unsigned char         IE2         @           0xaf;
    #define EUSB                    0x80
    #define ET4                     0x40
    #define ET3                     0x20
    #define ES4                     0x10
    #define ES3                     0x08
    #define ET2                     0x04
    #define ESPI                    0x02
    #define ES2                     0x01

__sfr __no_init volatile unsigned char         P3          @           0xb0;
    __bit __no_init bool     P30         @           0xb0^0;
    __bit __no_init bool     P31         @           0xb0^1;
    __bit __no_init bool     P32         @           0xb0^2;
    __bit __no_init bool     P33         @           0xb0^3;
    __bit __no_init bool     P34         @           0xb0^4;
    __bit __no_init bool     P35         @           0xb0^5;
    __bit __no_init bool     P36         @           0xb0^6;
    __bit __no_init bool     P37         @           0xb0^7;

    __bit __no_init bool     RD          @           0xb0^7;
    __bit __no_init bool     WR          @           0xb0^6;
    __bit __no_init bool     T1          @           0xb0^5;
    __bit __no_init bool     T0          @           0xb0^4;
    __bit __no_init bool     INT1        @           0xb0^3;
    __bit __no_init bool     INT0        @           0xb0^2;
    __bit __no_init bool     TXD         @           0xb0^1;
    __bit __no_init bool     RXD         @           0xb0^0;

__sfr __no_init volatile unsigned char         P3M1        @           0xb1;
__sfr __no_init volatile unsigned char         P3M0        @           0xb2;
__sfr __no_init volatile unsigned char         P4M1        @           0xb3;
__sfr __no_init volatile unsigned char         P4M0        @           0xb4;

__sfr __no_init volatile unsigned char         IP2         @           0xb5;
    #define PUSB                    0x80
    #define PI2C                    0x40
    #define PCMP                    0x20
    #define PX4                     0x10
    #define PPWMB                   0x08
    #define PPWMA                   0x04
    #define PSPI                    0x02
    #define PS2                     0x01

__sfr __no_init volatile unsigned char         IP2H        @           0xb6;
    #define PUSBH                   0x80
    #define PI2CH                   0x40
    #define PCMPH                   0x20
    #define PX4H                    0x10
    #define PPWMBH                  0x08
    #define PPWMAH                  0x04
    #define PSPIH                   0x02
    #define PS2H                    0x01

__sfr __no_init volatile unsigned char         IPH         @           0xb7;
    #define PPCAH                   0x80
    #define PLVDH                   0x40
    #define PADCH                   0x20
    #define PSH                     0x10
    #define PT1H                    0x08
    #define PX1H                    0x04
    #define PT0H                    0x02
    #define PX0H                    0x01

__sfr __no_init volatile unsigned char         IP          @           0xb8;
    __bit __no_init bool     PPCA        @           0xb8^7;
    __bit __no_init bool     PLVD        @           0xb8^6;
    __bit __no_init bool     PADC        @           0xb8^5;
    __bit __no_init bool     PS          @           0xb8^4;
    __bit __no_init bool     PT1         @           0xb8^3;
    __bit __no_init bool     PX1         @           0xb8^2;
    __bit __no_init bool     PT0         @           0xb8^1;
    __bit __no_init bool     PX0         @           0xb8^0;

__sfr __no_init volatile unsigned char         SADEN       @           0xb9;

__sfr __no_init volatile unsigned char         P_SW2       @           0xba;
    #define EAXFR                   0x80
    #define I2C_S1                  0x20
    #define I2C_S0                  0x10
    #define CMPO_S                  0x08
    #define S4_S                    0x04
    #define S3_S                    0x02
    #define S2_S                    0x01

__sfr __no_init volatile unsigned char         P_SW3       @           0xbb;
    #define I2S_S1                  0x80
    #define I2S_S0                  0x40
    #define S2SPI_S1                0x20
    #define S2SPI_S0                0x10
    #define S1SPI_S1                0x08
    #define S1SPI_S0                0x04
    #define CAN2_S1                 0x02
    #define CAN2_S0                 0x01

__sfr __no_init volatile unsigned char         ADC_CONTR   @           0xbc;
    #define ADC_POWER               0x80
    #define ADC_START               0x40
    #define ADC_FLAG                0x20
    #define ADC_EPWMT               0x10

__sfr __no_init volatile unsigned char         ADC_RES     @           0xbd;
__sfr __no_init volatile unsigned char         ADC_RESL    @           0xbe;

__sfr __no_init volatile unsigned char         P_SW4       @           0xbf;
    #define QSPI_S1                 0x02
    #define QSPI_S0                 0x01

__sfr __no_init volatile unsigned char         P4          @           0xc0;
    __bit __no_init bool     P40         @           0xc0^0;
    __bit __no_init bool     P41         @           0xc0^1;
    __bit __no_init bool     P42         @           0xc0^2;
    __bit __no_init bool     P43         @           0xc0^3;
    __bit __no_init bool     P44         @           0xc0^4;
    __bit __no_init bool     P45         @           0xc0^5;
    __bit __no_init bool     P46         @           0xc0^6;
    __bit __no_init bool     P47         @           0xc0^7;

__sfr __no_init volatile unsigned char         WDT_CONTR   @           0xc1;
    #define WDT_FLAG                0x80
    #define EN_WDT                  0x20
    #define CLR_WDT                 0x10
    #define IDL_WDT                 0x08

__sfr __no_init volatile unsigned char         IAP_DATA    @           0xc2;
__sfr __no_init volatile unsigned char         IAP_ADDRH   @           0xc3;
__sfr __no_init volatile unsigned char         IAP_ADDRL   @           0xc4;
__sfr __no_init volatile unsigned char         IAP_CMD     @           0xc5;
__sfr __no_init volatile unsigned char         IAP_TRIG    @           0xc6;

__sfr __no_init volatile unsigned char         IAP_CONTR   @           0xc7;
    #define IAPEN                   0x80
    #define SWBS                    0x40
    #define SWRST                   0x20
    #define CMD_FAIL                0x10
    #define SWBS2                   0x08

__sfr __no_init volatile unsigned char         P5          @           0xc8;
    __bit __no_init bool     P50         @           0xc8^0;
    __bit __no_init bool     P51         @           0xc8^1;
    __bit __no_init bool     P52         @           0xc8^2;
    __bit __no_init bool     P53         @           0xc8^3;
    __bit __no_init bool     P54         @           0xc8^4;
    __bit __no_init bool     P55         @           0xc8^5;
    __bit __no_init bool     P56         @           0xc8^6;
    __bit __no_init bool     P57         @           0xc8^7;

__sfr __no_init volatile unsigned char         P5M1        @           0xc9;
__sfr __no_init volatile unsigned char         P5M0        @           0xca;
__sfr __no_init volatile unsigned char         P6M1        @           0xcb;
__sfr __no_init volatile unsigned char         P6M0        @           0xcc;

__sfr __no_init volatile unsigned char         SPSTAT      @           0xcd;
    #define SPIF                    0x80
    #define WCOL                    0x40

__sfr __no_init volatile unsigned char         SPCTL       @           0xce;
    #define SSIG                    0x80
    #define SPEN                    0x40
    #define DORD                    0x20
    #define MSTR                    0x10
    #define CPOL                    0x08
    #define CPHA                    0x04
    #define SPR1                    0x02
    #define SPR0                    0x01

__sfr __no_init volatile unsigned char         SPDAT       @           0xcf;

__sfr __no_init volatile unsigned char         PSW         @           0xd0;
    __bit __no_init bool     CY          @           0xd0^7;
    __bit __no_init bool     AC          @           0xd0^6;
    __bit __no_init bool     F0          @           0xd0^5;
    __bit __no_init bool     RS1         @           0xd0^4;
    __bit __no_init bool     RS0         @           0xd0^3;
    __bit __no_init bool     OV          @           0xd0^2;
    __bit __no_init bool     F1          @           0xd0^1;
    __bit __no_init bool     P           @           0xd0^0;

__sfr __no_init volatile unsigned char         PSW1        @           0xd1;
    #define N                       0x20
    #define Z                       0x02

__sfr __no_init volatile unsigned char         TH4         @           0xd2;
__sfr __no_init volatile unsigned char         TL4         @           0xd3;
__sfr __no_init volatile unsigned char         TH3         @           0xd4;
__sfr __no_init volatile unsigned char         TL3         @           0xd5;
__sfr __no_init volatile unsigned char         TH2         @           0xd6;
__sfr __no_init volatile unsigned char         TL2         @           0xd7;

__sfr __no_init volatile unsigned char         T4H         @           0xd2;
__sfr __no_init volatile unsigned char         T4L         @           0xd3;
__sfr __no_init volatile unsigned char         T3H         @           0xd4;
__sfr __no_init volatile unsigned char         T3L         @           0xd5;
__sfr __no_init volatile unsigned char         T2H         @           0xd6;
__sfr __no_init volatile unsigned char         T2L         @           0xd7;

__sfr __no_init volatile unsigned char         USBCLK      @           0xdc;

__sfr __no_init volatile unsigned char         T3T4M       @           0xdd;
__sfr __no_init volatile unsigned char         T4T3M       @           0xdd;
    #define T4R                     0x80
    #define T4_CT                   0x40
    #define T4x12                   0x20
    #define T4CLKO                  0x10
    #define T3R                     0x08
    #define T3_CT                   0x04
    #define T3x12                   0x02
    #define T3CLKO                  0x01

__sfr __no_init volatile unsigned char         ADCCFG      @           0xde;
    #define RESFMT                  0x20

__sfr __no_init volatile unsigned char         IP3         @           0xdf;
    #define PI2S                    0x08
    #define PRTC                    0x04
    #define PS4                     0x02
    #define PS3                     0x01

__sfr __no_init volatile unsigned char         ACC         @           0xe0;
__sfr __no_init volatile unsigned char         P7M1        @           0xe1;
__sfr __no_init volatile unsigned char         P7M0        @           0xe2;
__sfr __no_init volatile unsigned char         DPS         @           0xe3;

__sfr __no_init volatile unsigned char         CMPCR1      @           0xe6;
    #define CMPEN                   0x80
    #define CMPIF                   0x40
    #define CMPPIE                     0x20
    #define CMPNIE                     0x10
    #define CMPOE                   0x02
    #define CMPRES                  0x01

__sfr __no_init volatile unsigned char         CMPCR2      @           0xe7;
    #define INVCMPO                 0x80
    #define DISFLT                  0x40

__sfr __no_init volatile unsigned char         P6          @           0xe8;
    __bit __no_init bool     P60         @           0xe8^0;
    __bit __no_init bool     P61         @           0xe8^1;
    __bit __no_init bool     P62         @           0xe8^2;
    __bit __no_init bool     P63         @           0xe8^3;
    __bit __no_init bool     P64         @           0xe8^4;
    __bit __no_init bool     P65         @           0xe8^5;
    __bit __no_init bool     P66         @           0xe8^6;
    __bit __no_init bool     P67         @           0xe8^7;

__sfr __no_init volatile unsigned char         WTST        @           0xe9;
__sfr __no_init volatile unsigned char         CKCON       @           0xea;
__sfr __no_init volatile unsigned char         MXAX        @           0xeb;
__sfr __no_init volatile unsigned char         USBDAT      @           0xec;
__sfr __no_init volatile unsigned char         DMAIR       @           0xed;

__sfr __no_init volatile unsigned char         IP3H        @           0xee;
    #define PI2SH                   0x08
    #define PRTCH                   0x04
    #define PS4H                    0x02
    #define PS3H                    0x01

__sfr __no_init volatile unsigned char         AUXINTIF    @           0xef;
    #define INT4IF                  0x40
    #define INT3IF                  0x20
    #define INT2IF                  0x10
    #define T4IF                    0x04
    #define T3IF                    0x02
    #define T2IF                    0x01

__sfr __no_init volatile unsigned char         B           @           0xf0;

__sfr __no_init volatile unsigned char         USBCON      @           0xf4;
    #define ENUSB                   0x80
    #define ENUSBRST                0x40
    #define PS2M                    0x20
    #define PUEN                    0x10
    #define PDEN                    0x08
    #define DFREC                   0x04
    #define DP                      0x02
    #define DM                      0x01

__sfr __no_init volatile unsigned char         IAP_TPS     @           0xf5;
__sfr __no_init volatile unsigned char         IAP_ADDRE   @           0xf6;

__sfr __no_init volatile unsigned char         P7          @           0xf8;
    __bit __no_init bool     P70         @           0xf8^0;
    __bit __no_init bool     P71         @           0xf8^1;
    __bit __no_init bool     P72         @           0xf8^2;
    __bit __no_init bool     P73         @           0xf8^3;
    __bit __no_init bool     P74         @           0xf8^4;
    __bit __no_init bool     P75         @           0xf8^5;
    __bit __no_init bool     P76         @           0xf8^6;
    __bit __no_init bool     P77         @           0xf8^7;

__sfr __no_init volatile unsigned char         USBADR      @           0xfc;

__sfr __no_init volatile unsigned char         S4CON       @           0xfd;
    #define S4SM0                   0x80
    #define S4ST4                   0x40
    #define S4SM2                   0x20
    #define S4REN                   0x10
    #define S4TB8                   0x08
    #define S4RB8                   0x04
    #define S4TI                    0x02
    #define S4RI                    0x01

__sfr __no_init volatile unsigned char         S4BUF       @           0xfe;

__sfr __no_init volatile unsigned char         RSTCFG      @           0xff;
    #define ENLVR                   0x40
    #define P47RST                  0x10

/////////////////////////////////////////////////
//
//⹦ܼĴλչRAM
//ЩĴ,ȽEAXFRΪ1,ſд
//    EAXFR = 1;
//
//    P_SW2 |= 0x80;
///////////////////////////////////////////////////

/////////////////////////////////////////////////
//7E:FF00H-7E:FFFFH
/////////////////////////////////////////////////



/////////////////////////////////////////////////
//7E:FE00H-7E:FEFFH
/////////////////////////////////////////////////

__xdata __no_init volatile unsigned char    CLKSEL           @ 0xFE00;
__xdata __no_init volatile unsigned char    CLKDIV           @ 0xFE01;
__xdata __no_init volatile unsigned char    HIRCCR           @ 0xFE02;
__xdata __no_init volatile unsigned char    XOSCCR           @ 0xFE03;
__xdata __no_init volatile unsigned char    IRC32KCR         @ 0xFE04;
__xdata __no_init volatile unsigned char    MCLKOCR          @ 0xFE05;
__xdata __no_init volatile unsigned char    IRCDB            @ 0xFE06;
__xdata __no_init volatile unsigned char    IRC48MCR         @ 0xFE07;
__xdata __no_init volatile unsigned char    X32KCR           @ 0xFE08;
__xdata __no_init volatile unsigned char    HSCLKDIV         @ 0xFE0B;

__xdata __no_init volatile unsigned char    P0PU             @ 0xFE10;
__xdata __no_init volatile unsigned char    P1PU             @ 0xFE11;
__xdata __no_init volatile unsigned char    P2PU             @ 0xFE12;
__xdata __no_init volatile unsigned char    P3PU             @ 0xFE13;
__xdata __no_init volatile unsigned char    P4PU             @ 0xFE14;
__xdata __no_init volatile unsigned char    P5PU             @ 0xFE15;
__xdata __no_init volatile unsigned char    P6PU             @ 0xFE16;
__xdata __no_init volatile unsigned char    P7PU             @ 0xFE17;
__xdata __no_init volatile unsigned char    P0NCS            @ 0xFE18;
__xdata __no_init volatile unsigned char    P1NCS            @ 0xFE19;
__xdata __no_init volatile unsigned char    P2NCS            @ 0xFE1A;
__xdata __no_init volatile unsigned char    P3NCS            @ 0xFE1B;
__xdata __no_init volatile unsigned char    P4NCS            @ 0xFE1C;
__xdata __no_init volatile unsigned char    P5NCS            @ 0xFE1D;
__xdata __no_init volatile unsigned char    P6NCS            @ 0xFE1E;
__xdata __no_init volatile unsigned char    P7NCS            @ 0xFE1F;
__xdata __no_init volatile unsigned char    P0SR             @ 0xFE20;
__xdata __no_init volatile unsigned char    P1SR             @ 0xFE21;
__xdata __no_init volatile unsigned char    P2SR             @ 0xFE22;
__xdata __no_init volatile unsigned char    P3SR             @ 0xFE23;
__xdata __no_init volatile unsigned char    P4SR             @ 0xFE24;
__xdata __no_init volatile unsigned char    P5SR             @ 0xFE25;
__xdata __no_init volatile unsigned char    P6SR             @ 0xFE26;
__xdata __no_init volatile unsigned char    P7SR             @ 0xFE27;
__xdata __no_init volatile unsigned char    P0DR             @ 0xFE28;
__xdata __no_init volatile unsigned char    P1DR             @ 0xFE29;
__xdata __no_init volatile unsigned char    P2DR             @ 0xFE2A;
__xdata __no_init volatile unsigned char    P3DR             @ 0xFE2B;
__xdata __no_init volatile unsigned char    P4DR             @ 0xFE2C;
__xdata __no_init volatile unsigned char    P5DR             @ 0xFE2D;
__xdata __no_init volatile unsigned char    P6DR             @ 0xFE2E;
__xdata __no_init volatile unsigned char    P7DR             @ 0xFE2F;
__xdata __no_init volatile unsigned char    P0IE             @ 0xFE30;
__xdata __no_init volatile unsigned char    P1IE             @ 0xFE31;
__xdata __no_init volatile unsigned char    P2IE             @ 0xFE32;
__xdata __no_init volatile unsigned char    P3IE             @ 0xFE33;
__xdata __no_init volatile unsigned char    P4IE             @ 0xFE34;
__xdata __no_init volatile unsigned char    P5IE             @ 0xFE35;
__xdata __no_init volatile unsigned char    P6IE             @ 0xFE36;
__xdata __no_init volatile unsigned char    P7IE             @ 0xFE37;
__xdata __no_init volatile unsigned char    P0PD             @ 0xFE40;
__xdata __no_init volatile unsigned char    P1PD             @ 0xFE41;
__xdata __no_init volatile unsigned char    P2PD             @ 0xFE42;
__xdata __no_init volatile unsigned char    P3PD             @ 0xFE43;
__xdata __no_init volatile unsigned char    P4PD             @ 0xFE44;
__xdata __no_init volatile unsigned char    P5PD             @ 0xFE45;
__xdata __no_init volatile unsigned char    P6PD             @ 0xFE46;
__xdata __no_init volatile unsigned char    P7PD             @ 0xFE47;
__xdata __no_init volatile unsigned char    P0BP             @ 0xFE48;
__xdata __no_init volatile unsigned char    P1BP             @ 0xFE49;
__xdata __no_init volatile unsigned char    P2BP             @ 0xFE4A;
__xdata __no_init volatile unsigned char    P3BP             @ 0xFE4B;
__xdata __no_init volatile unsigned char    P4BP             @ 0xFE4C;
__xdata __no_init volatile unsigned char    P5BP             @ 0xFE4D;
__xdata __no_init volatile unsigned char    P6BP             @ 0xFE4E;
__xdata __no_init volatile unsigned char    P7BP             @ 0xFE4F;

__xdata __no_init volatile unsigned char    LCMIFCFG         @ 0xFE50;
__xdata __no_init volatile unsigned char    LCMIFCFG2        @ 0xFE51;
__xdata __no_init volatile unsigned char    LCMIFCR          @ 0xFE52;
__xdata __no_init volatile unsigned char    LCMIFSTA         @ 0xFE53;
__xdata __no_init volatile unsigned char    LCMIFDATL        @ 0xFE54;
__xdata __no_init volatile unsigned char    LCMIFDATH        @ 0xFE55;
__xdata __no_init volatile unsigned char    LCMIFPSCR        @ 0xFE56;

__xdata __no_init volatile unsigned char    RTCCR            @ 0xFE60;
__xdata __no_init volatile unsigned char    RTCCFG           @ 0xFE61;
__xdata __no_init volatile unsigned char    RTCIEN           @ 0xFE62;
__xdata __no_init volatile unsigned char    RTCIF            @ 0xFE63;
__xdata __no_init volatile unsigned char    ALAHOUR          @ 0xFE64;
__xdata __no_init volatile unsigned char    ALAMIN           @ 0xFE65;
__xdata __no_init volatile unsigned char    ALASEC           @ 0xFE66;
__xdata __no_init volatile unsigned char    ALASSEC          @ 0xFE67;
__xdata __no_init volatile unsigned char    INIYEAR          @ 0xFE68;
__xdata __no_init volatile unsigned char    INIMONTH         @ 0xFE69;
__xdata __no_init volatile unsigned char    INIDAY           @ 0xFE6A;
__xdata __no_init volatile unsigned char    INIHOUR          @ 0xFE6B;
__xdata __no_init volatile unsigned char    INIMIN           @ 0xFE6C;
__xdata __no_init volatile unsigned char    INISEC           @ 0xFE6D;
__xdata __no_init volatile unsigned char    INISSEC          @ 0xFE6E;
__xdata __no_init volatile unsigned char    INIWEEK          @ 0xFE6F;
__xdata __no_init volatile unsigned char    WEEK             @ 0xFE6F;
__xdata __no_init volatile unsigned char    YEAR             @ 0xFE70;
__xdata __no_init volatile unsigned char    MONTH            @ 0xFE71;
__xdata __no_init volatile unsigned char    DAY              @ 0xFE72;
__xdata __no_init volatile unsigned char    HOUR             @ 0xFE73;
__xdata __no_init volatile unsigned char    MIN              @ 0xFE74;
__xdata __no_init volatile unsigned char    SEC              @ 0xFE75;
__xdata __no_init volatile unsigned char    SSEC             @ 0xFE76;

__xdata __no_init volatile unsigned char    T11CR            @ 0xFE78;
__xdata __no_init volatile unsigned char    T11PS            @ 0xFE79;
__xdata __no_init volatile unsigned char    T11H             @ 0xFE7A;
__xdata __no_init volatile unsigned char    T11L             @ 0xFE7B;

__xdata __no_init volatile unsigned char    I2CCFG           @ 0xFE80;
__xdata __no_init volatile unsigned char    I2CMSCR          @ 0xFE81;
__xdata __no_init volatile unsigned char    I2CMSST          @ 0xFE82;
__xdata __no_init volatile unsigned char    I2CSLCR          @ 0xFE83;
__xdata __no_init volatile unsigned char    I2CSLST          @ 0xFE84;
__xdata __no_init volatile unsigned char    I2CSLADR         @ 0xFE85;
__xdata __no_init volatile unsigned char    I2CTXD           @ 0xFE86;
__xdata __no_init volatile unsigned char    I2CRXD           @ 0xFE87;
__xdata __no_init volatile unsigned char    I2CMSAUX         @ 0xFE88;
__xdata __no_init volatile unsigned char    I2CPSCR          @ 0xFE89;

__xdata __no_init volatile unsigned char    SPI_CLKDIV       @ 0xFE90;
__xdata __no_init volatile unsigned char    PWMA_CLKDIV      @ 0xFE91;
__xdata __no_init volatile unsigned char    PWMB_CLKDIV      @ 0xFE92;
__xdata __no_init volatile unsigned char    TFPU_CLKDIV      @ 0xFE93;
__xdata __no_init volatile unsigned char    I2S_CLKDIV       @ 0xFE94;

__xdata __no_init volatile unsigned char    RSTFLAG          @ 0xFE99;
__xdata __no_init volatile unsigned char    RSTCR0           @ 0xFE9A;
__xdata __no_init volatile unsigned char    RSTCR1           @ 0xFE9B;
__xdata __no_init volatile unsigned char    RSTCR2           @ 0xFE9C;
__xdata __no_init volatile unsigned char    RSTCR3           @ 0xFE9D;
__xdata __no_init volatile unsigned char    RSTCR4           @ 0xFE9E;
__xdata __no_init volatile unsigned char    RSTCR5           @ 0xFE9F;

__xdata __no_init volatile unsigned char    TM0PS            @ 0xFEA0;
__xdata __no_init volatile unsigned char    TM1PS            @ 0xFEA1;
__xdata __no_init volatile unsigned char    TM2PS            @ 0xFEA2;
__xdata __no_init volatile unsigned char    TM3PS            @ 0xFEA3;
__xdata __no_init volatile unsigned char    TM4PS            @ 0xFEA4;
__xdata __no_init volatile unsigned char    ADCTIM           @ 0xFEA8;
__xdata __no_init volatile unsigned char    ADCEXCFG         @ 0xFEAD;
__xdata __no_init volatile unsigned char    CMPEXCFG         @ 0xFEAE;

__xdata __no_init volatile unsigned char    PWMA_ETRPS       @ 0xFEB0;
__xdata __no_init volatile unsigned char    PWMA_ENO         @ 0xFEB1;
__xdata __no_init volatile unsigned char    PWMA_PS          @ 0xFEB2;
__xdata __no_init volatile unsigned char    PWMA_IOAUX       @ 0xFEB3;
__xdata __no_init volatile unsigned char    PWMB_ETRPS       @ 0xFEB4;
__xdata __no_init volatile unsigned char    PWMB_ENO         @ 0xFEB5;
__xdata __no_init volatile unsigned char    PWMB_PS          @ 0xFEB6;
__xdata __no_init volatile unsigned char    PWMB_IOAUX       @ 0xFEB7;
__xdata __no_init volatile unsigned char    PWMA_PS2         @ 0xFEB8;
__xdata __no_init volatile unsigned char    PWMA_RCRH        @ 0xFEB9;
__xdata __no_init volatile unsigned char    PWMB_RCRH        @ 0xFEBA;

__xdata __no_init volatile unsigned char    PWMA_CR1         @ 0xFEC0;
__xdata __no_init volatile unsigned char    PWMA_CR2         @ 0xFEC1;
__xdata __no_init volatile unsigned char    PWMA_SMCR        @ 0xFEC2;
__xdata __no_init volatile unsigned char    PWMA_ETR         @ 0xFEC3;
__xdata __no_init volatile unsigned char    PWMA_IER         @ 0xFEC4;
__xdata __no_init volatile unsigned char    PWMA_SR1         @ 0xFEC5;
__xdata __no_init volatile unsigned char    PWMA_SR2         @ 0xFEC6;
__xdata __no_init volatile unsigned char    PWMA_EGR         @ 0xFEC7;
__xdata __no_init volatile unsigned char    PWMA_CCMR1       @ 0xFEC8;
__xdata __no_init volatile unsigned char    PWMA_CCMR2       @ 0xFEC9;
__xdata __no_init volatile unsigned char    PWMA_CCMR3       @ 0xFECA;
__xdata __no_init volatile unsigned char    PWMA_CCMR4       @ 0xFECB;
__xdata __no_init volatile unsigned char    PWMA_CCER1       @ 0xFECC;
__xdata __no_init volatile unsigned char    PWMA_CCER2       @ 0xFECD;
__xdata __no_init volatile unsigned char    PWMA_CNTRH       @ 0xFECE;
__xdata __no_init volatile unsigned char    PWMA_CNTRL       @ 0xFECF;
__xdata __no_init volatile unsigned char    PWMA_PSCRH       @ 0xFED0;
__xdata __no_init volatile unsigned char    PWMA_PSCRL       @ 0xFED1;
__xdata __no_init volatile unsigned char    PWMA_ARRH        @ 0xFED2;
__xdata __no_init volatile unsigned char    PWMA_ARRL        @ 0xFED3;
__xdata __no_init volatile unsigned char    PWMA_RCR         @ 0xFED4;
__xdata __no_init volatile unsigned char    PWMA_CCR1H       @ 0xFED5;
__xdata __no_init volatile unsigned char    PWMA_CCR1L       @ 0xFED6;
__xdata __no_init volatile unsigned char    PWMA_CCR2H       @ 0xFED7;
__xdata __no_init volatile unsigned char    PWMA_CCR2L       @ 0xFED8;
__xdata __no_init volatile unsigned char    PWMA_CCR3H       @ 0xFED9;
__xdata __no_init volatile unsigned char    PWMA_CCR3L       @ 0xFEDA;
__xdata __no_init volatile unsigned char    PWMA_CCR4H       @ 0xFEDB;
__xdata __no_init volatile unsigned char    PWMA_CCR4L       @ 0xFEDC;
__xdata __no_init volatile unsigned char    PWMA_BKR         @ 0xFEDD;
__xdata __no_init volatile unsigned char    PWMA_DTR         @ 0xFEDE;
__xdata __no_init volatile unsigned char    PWMA_OISR        @ 0xFEDF;

__xdata __no_init volatile unsigned char    PWMB_CR1         @ 0xFEE0;
__xdata __no_init volatile unsigned char    PWMB_CR2         @ 0xFEE1;
__xdata __no_init volatile unsigned char    PWMB_SMCR        @ 0xFEE2;
__xdata __no_init volatile unsigned char    PWMB_ETR         @ 0xFEE3;
__xdata __no_init volatile unsigned char    PWMB_IER         @ 0xFEE4;
__xdata __no_init volatile unsigned char    PWMB_SR1         @ 0xFEE5;
__xdata __no_init volatile unsigned char    PWMB_SR2         @ 0xFEE6;
__xdata __no_init volatile unsigned char    PWMB_EGR         @ 0xFEE7;
__xdata __no_init volatile unsigned char    PWMB_CCMR1       @ 0xFEE8;
__xdata __no_init volatile unsigned char    PWMB_CCMR2       @ 0xFEE9;
__xdata __no_init volatile unsigned char    PWMB_CCMR3       @ 0xFEEA;
__xdata __no_init volatile unsigned char    PWMB_CCMR4       @ 0xFEEB;
__xdata __no_init volatile unsigned char    PWMB_CCER1       @ 0xFEEC;
__xdata __no_init volatile unsigned char    PWMB_CCER2       @ 0xFEED;
__xdata __no_init volatile unsigned char    PWMB_CNTRH       @ 0xFEEE;
__xdata __no_init volatile unsigned char    PWMB_CNTRL       @ 0xFEEF;
__xdata __no_init volatile unsigned char    PWMB_PSCRH       @ 0xFEF0;
__xdata __no_init volatile unsigned char    PWMB_PSCRL       @ 0xFEF1;
__xdata __no_init volatile unsigned char    PWMB_ARRH        @ 0xFEF2;
__xdata __no_init volatile unsigned char    PWMB_ARRL        @ 0xFEF3;
__xdata __no_init volatile unsigned char    PWMB_RCR         @ 0xFEF4;
__xdata __no_init volatile unsigned char    PWMB_CCR5H       @ 0xFEF5;
__xdata __no_init volatile unsigned char    PWMB_CCR5L       @ 0xFEF6;
__xdata __no_init volatile unsigned char    PWMB_CCR6H       @ 0xFEF7;
__xdata __no_init volatile unsigned char    PWMB_CCR6L       @ 0xFEF8;
__xdata __no_init volatile unsigned char    PWMB_CCR7H       @ 0xFEF9;
__xdata __no_init volatile unsigned char    PWMB_CCR7L       @ 0xFEFA;
__xdata __no_init volatile unsigned char    PWMB_CCR8H       @ 0xFEFB;
__xdata __no_init volatile unsigned char    PWMB_CCR8L       @ 0xFEFC;
__xdata __no_init volatile unsigned char    PWMB_BKR         @ 0xFEFD;
__xdata __no_init volatile unsigned char    PWMB_DTR         @ 0xFEFE;
__xdata __no_init volatile unsigned char    PWMB_OISR        @ 0xFEFF;

/////////////////////////////////////////////////
//7E:FD00H-7E:FDFFH
/////////////////////////////////////////////////

__xdata __no_init volatile unsigned char    P0INTE           @ 0xFD00;
__xdata __no_init volatile unsigned char    P1INTE           @ 0xFD01;
__xdata __no_init volatile unsigned char    P2INTE           @ 0xFD02;
__xdata __no_init volatile unsigned char    P3INTE           @ 0xFD03;
__xdata __no_init volatile unsigned char    P4INTE           @ 0xFD04;
__xdata __no_init volatile unsigned char    P5INTE           @ 0xFD05;
__xdata __no_init volatile unsigned char    P6INTE           @ 0xFD06;
__xdata __no_init volatile unsigned char    P7INTE           @ 0xFD07;
__xdata __no_init volatile unsigned char    P0INTF           @ 0xFD10;
__xdata __no_init volatile unsigned char    P1INTF           @ 0xFD11;
__xdata __no_init volatile unsigned char    P2INTF           @ 0xFD12;
__xdata __no_init volatile unsigned char    P3INTF           @ 0xFD13;
__xdata __no_init volatile unsigned char    P4INTF           @ 0xFD14;
__xdata __no_init volatile unsigned char    P5INTF           @ 0xFD15;
__xdata __no_init volatile unsigned char    P6INTF           @ 0xFD16;
__xdata __no_init volatile unsigned char    P7INTF           @ 0xFD17;
__xdata __no_init volatile unsigned char    P0IM0            @ 0xFD20;
__xdata __no_init volatile unsigned char    P1IM0            @ 0xFD21;
__xdata __no_init volatile unsigned char    P2IM0            @ 0xFD22;
__xdata __no_init volatile unsigned char    P3IM0            @ 0xFD23;
__xdata __no_init volatile unsigned char    P4IM0            @ 0xFD24;
__xdata __no_init volatile unsigned char    P5IM0            @ 0xFD25;
__xdata __no_init volatile unsigned char    P6IM0            @ 0xFD26;
__xdata __no_init volatile unsigned char    P7IM0            @ 0xFD27;
__xdata __no_init volatile unsigned char    P0IM1            @ 0xFD30;
__xdata __no_init volatile unsigned char    P1IM1            @ 0xFD31;
__xdata __no_init volatile unsigned char    P2IM1            @ 0xFD32;
__xdata __no_init volatile unsigned char    P3IM1            @ 0xFD33;
__xdata __no_init volatile unsigned char    P4IM1            @ 0xFD34;
__xdata __no_init volatile unsigned char    P5IM1            @ 0xFD35;
__xdata __no_init volatile unsigned char    P6IM1            @ 0xFD36;
__xdata __no_init volatile unsigned char    P7IM1            @ 0xFD37;
__xdata __no_init volatile unsigned char    P0WKUE           @ 0xFD40;
__xdata __no_init volatile unsigned char    P1WKUE           @ 0xFD41;
__xdata __no_init volatile unsigned char    P2WKUE           @ 0xFD42;
__xdata __no_init volatile unsigned char    P3WKUE           @ 0xFD43;
__xdata __no_init volatile unsigned char    P4WKUE           @ 0xFD44;
__xdata __no_init volatile unsigned char    P5WKUE           @ 0xFD45;
__xdata __no_init volatile unsigned char    P6WKUE           @ 0xFD46;
__xdata __no_init volatile unsigned char    P7WKUE           @ 0xFD47;

__xdata __no_init volatile unsigned char    CCAPM2           @ 0xFD50;
__xdata __no_init volatile unsigned char    CCAP2L           @ 0xFD51;
__xdata __no_init volatile unsigned char    CCAP2H           @ 0xFD52;
__xdata __no_init volatile unsigned char    PCA_PWM2         @ 0xFD53;
__xdata __no_init volatile unsigned char    CCAPM3           @ 0xFD54;
__xdata __no_init volatile unsigned char    CCAP3L           @ 0xFD55;
__xdata __no_init volatile unsigned char    CCAP3H           @ 0xFD56;
__xdata __no_init volatile unsigned char    PCA_PWM3         @ 0xFD57;
__xdata __no_init volatile unsigned char    CCAPM0           @ 0xFD58;
__xdata __no_init volatile unsigned char    CCAP0L           @ 0xFD59;
__xdata __no_init volatile unsigned char    CCAP0H           @ 0xFD5A;
__xdata __no_init volatile unsigned char    PCA_PWM0         @ 0xFD5B;
__xdata __no_init volatile unsigned char    CCAPM1           @ 0xFD5C;
__xdata __no_init volatile unsigned char    CCAP1L           @ 0xFD5D;
__xdata __no_init volatile unsigned char    CCAP1H           @ 0xFD5E;
__xdata __no_init volatile unsigned char    PCA_PWM1         @ 0xFD5F;

__xdata __no_init volatile unsigned char    PINIPL           @ 0xFD60;
__xdata __no_init volatile unsigned char    PINIPH           @ 0xFD61;

__xdata __no_init volatile unsigned char    CCON             @ 0xFD64;
    #define     CF                  0x80
    #define     CR                  0x40
    #define     CCF2                0x04
    #define     CCF1                0x02
    #define     CCF0                0x01

__xdata __no_init volatile unsigned char    CL               @ 0xFD65;
__xdata __no_init volatile unsigned char    CH               @ 0xFD66;

__xdata __no_init volatile unsigned char    CMOD             @ 0xFD67;
    #define     CIDL                0x80
    #define     ECF                 0x01

__xdata __no_init volatile unsigned char    UR1TOCR          @ 0xFD70;
__xdata __no_init volatile unsigned char    UR1TOSR          @ 0xFD71;
__xdata __no_init volatile unsigned char    UR1TOTH          @ 0xFD72;
__xdata __no_init volatile unsigned char    UR1TOTL          @ 0xFD73;
__xdata __no_init volatile unsigned char    UR2TOCR          @ 0xFD74;
__xdata __no_init volatile unsigned char    UR2TOSR          @ 0xFD75;
__xdata __no_init volatile unsigned char    UR2TOTH          @ 0xFD76;
__xdata __no_init volatile unsigned char    UR2TOTL          @ 0xFD77;
__xdata __no_init volatile unsigned char    UR3TOCR          @ 0xFD78;
__xdata __no_init volatile unsigned char    UR3TOSR          @ 0xFD79;
__xdata __no_init volatile unsigned char    UR3TOTH          @ 0xFD7A;
__xdata __no_init volatile unsigned char    UR3TOTL          @ 0xFD7B;
__xdata __no_init volatile unsigned char    UR4TOCR          @ 0xFD7C;
__xdata __no_init volatile unsigned char    UR4TOSR          @ 0xFD7D;
__xdata __no_init volatile unsigned char    UR4TOTH          @ 0xFD7E;
__xdata __no_init volatile unsigned char    UR4TOTL          @ 0xFD7F;

__xdata __no_init volatile unsigned char    SPITOCR          @ 0xFD80;
__xdata __no_init volatile unsigned char    SPITOSR          @ 0xFD81;
__xdata __no_init volatile unsigned char    SPITOTH          @ 0xFD82;
__xdata __no_init volatile unsigned char    SPITOTL          @ 0xFD83;
__xdata __no_init volatile unsigned char    I2CTOCR          @ 0xFD84;
__xdata __no_init volatile unsigned char    I2CTOSR          @ 0xFD85;
__xdata __no_init volatile unsigned char    I2CTOTH          @ 0xFD86;
__xdata __no_init volatile unsigned char    I2CTOTL          @ 0xFD87;

__xdata __no_init volatile unsigned char    UR1TOTE          @ 0xFD88;
__xdata __no_init volatile unsigned char    UR2TOTE          @ 0xFD89;
__xdata __no_init volatile unsigned char    UR3TOTE          @ 0xFD8A;
__xdata __no_init volatile unsigned char    UR4TOTE          @ 0xFD8B;
__xdata __no_init volatile unsigned char    SPITOTE          @ 0xFD8C;
__xdata __no_init volatile unsigned char    I2CTOTE          @ 0xFD8D;

__xdata __no_init volatile unsigned char    I2SCR            @ 0xFD98;
__xdata __no_init volatile unsigned char    I2SSR            @ 0xFD99;
__xdata __no_init volatile unsigned char    I2SDRH           @ 0xFD9A;
__xdata __no_init volatile unsigned char    I2SDRL           @ 0xFD9B;
__xdata __no_init volatile unsigned char    I2SPRH           @ 0xFD9C;
__xdata __no_init volatile unsigned char    I2SPRL           @ 0xFD9D;
__xdata __no_init volatile unsigned char    I2SCFGH          @ 0xFD9E;
__xdata __no_init volatile unsigned char    I2SCFGL          @ 0xFD9F;
__xdata __no_init volatile unsigned char    I2SMD            @ 0xFDA0;
__xdata __no_init volatile unsigned char    I2SMCKDIV        @ 0xFDA1;

__xdata __no_init volatile unsigned char    CRECR            @ 0xFDA8;
__xdata __no_init volatile unsigned char    CRECNTH          @ 0xFDA9;
__xdata __no_init volatile unsigned char    CRECNTL          @ 0xFDAA;
__xdata __no_init volatile unsigned char    CRERES           @ 0xFDAB;

__xdata __no_init volatile unsigned char    S2CFG            @ 0xFDB4;
__xdata __no_init volatile unsigned char    S2ADDR           @ 0xFDB5;
__xdata __no_init volatile unsigned char    S2ADEN           @ 0xFDB6;
__xdata __no_init volatile unsigned char    USARTCR1         @ 0xFDC0;
__xdata __no_init volatile unsigned char    USARTCR2         @ 0xFDC1;
__xdata __no_init volatile unsigned char    USARTCR3         @ 0xFDC2;
__xdata __no_init volatile unsigned char    USARTCR4         @ 0xFDC3;
__xdata __no_init volatile unsigned char    USARTCR5         @ 0xFDC4;
__xdata __no_init volatile unsigned char    USARTGTR         @ 0xFDC5;
__xdata __no_init volatile unsigned char    USARTBRH         @ 0xFDC6;
__xdata __no_init volatile unsigned char    USARTBRL         @ 0xFDC7;
__xdata __no_init volatile unsigned char    USART2CR1        @ 0xFDC8;
__xdata __no_init volatile unsigned char    USART2CR2        @ 0xFDC9;
__xdata __no_init volatile unsigned char    USART2CR3        @ 0xFDCA;
__xdata __no_init volatile unsigned char    USART2CR4        @ 0xFDCB;
__xdata __no_init volatile unsigned char    USART2CR5        @ 0xFDCC;
__xdata __no_init volatile unsigned char    USART2GTR        @ 0xFDCD;
__xdata __no_init volatile unsigned char    USART2BRH        @ 0xFDCE;
__xdata __no_init volatile unsigned char    USART2BRL        @ 0xFDCF;

__xdata __no_init volatile unsigned char    CHIPID           @ 0xfde0;
__xdata __no_init volatile unsigned char    CHIPID0          @ 0xFDE0;
__xdata __no_init volatile unsigned char    CHIPID1          @ 0xFDE1;
__xdata __no_init volatile unsigned char    CHIPID2          @ 0xFDE2;
__xdata __no_init volatile unsigned char    CHIPID3          @ 0xFDE3;
__xdata __no_init volatile unsigned char    CHIPID4          @ 0xFDE4;
__xdata __no_init volatile unsigned char    CHIPID5          @ 0xFDE5;
__xdata __no_init volatile unsigned char    CHIPID6          @ 0xFDE6;
__xdata __no_init volatile unsigned char    CHIPID7          @ 0xFDE7;
__xdata __no_init volatile unsigned char    CHIPID8          @ 0xFDE8;
__xdata __no_init volatile unsigned char    CHIPID9          @ 0xFDE9;
__xdata __no_init volatile unsigned char    CHIPID10         @ 0xFDEA;
__xdata __no_init volatile unsigned char    CHIPID11         @ 0xFDEB;
__xdata __no_init volatile unsigned char    CHIPID12         @ 0xFDEC;
__xdata __no_init volatile unsigned char    CHIPID13         @ 0xFDED;
__xdata __no_init volatile unsigned char    CHIPID14         @ 0xFDEE;
__xdata __no_init volatile unsigned char    CHIPID15         @ 0xFDEF;
__xdata __no_init volatile unsigned char    CHIPID16         @ 0xFDF0;
__xdata __no_init volatile unsigned char    CHIPID17         @ 0xFDF1;
__xdata __no_init volatile unsigned char    CHIPID18         @ 0xFDF2;
__xdata __no_init volatile unsigned char    CHIPID19         @ 0xFDF3;
__xdata __no_init volatile unsigned char    CHIPID20         @ 0xFDF4;
__xdata __no_init volatile unsigned char    CHIPID21         @ 0xFDF5;
__xdata __no_init volatile unsigned char    CHIPID22         @ 0xFDF6;
__xdata __no_init volatile unsigned char    CHIPID23         @ 0xFDF7;
__xdata __no_init volatile unsigned char    CHIPID24         @ 0xFDF8;
__xdata __no_init volatile unsigned char    CHIPID25         @ 0xFDF9;
__xdata __no_init volatile unsigned char    CHIPID26         @ 0xFDFA;
__xdata __no_init volatile unsigned char    CHIPID27         @ 0xFDFB;
__xdata __no_init volatile unsigned char    CHIPID28         @ 0xFDFC;
__xdata __no_init volatile unsigned char    CHIPID29         @ 0xFDFD;
__xdata __no_init volatile unsigned char    CHIPID30         @ 0xFDFE;
__xdata __no_init volatile unsigned char    CHIPID31         @ 0xFDFF;

/////////////////////////////////////////////////
//7E:FC00H-7E:FCFFH
/////////////////////////////////////////////////



/////////////////////////////////////////////////
//7E:FB00H-7E:FBFFH
/////////////////////////////////////////////////


__xdata __no_init volatile unsigned char    CHIPIDX          @ 0xfbd0;
__xdata __no_init volatile unsigned char    CHIPIDX0         @ 0xFBD0;
__xdata __no_init volatile unsigned char    CHIPIDX1         @ 0xFBD1;
__xdata __no_init volatile unsigned char    CHIPIDX2         @ 0xFBD2;
__xdata __no_init volatile unsigned char    CHIPIDX3         @ 0xFBD3;
__xdata __no_init volatile unsigned char    CHIPIDX4         @ 0xFBD4;
__xdata __no_init volatile unsigned char    CHIPIDX5         @ 0xFBD5;
__xdata __no_init volatile unsigned char    CHIPIDX6         @ 0xFBD6;
__xdata __no_init volatile unsigned char    CHIPIDX7         @ 0xFBD7;
__xdata __no_init volatile unsigned char    CHIPIDX8         @ 0xFBD8;
__xdata __no_init volatile unsigned char    CHIPIDX9         @ 0xFBD9;
__xdata __no_init volatile unsigned char    CHIPIDX10        @ 0xFBDA;
__xdata __no_init volatile unsigned char    CHIPIDX11        @ 0xFBDB;
__xdata __no_init volatile unsigned char    CHIPIDX12        @ 0xFBDC;
__xdata __no_init volatile unsigned char    CHIPIDX13        @ 0xFBDD;
__xdata __no_init volatile unsigned char    CHIPIDX14        @ 0xFBDE;
__xdata __no_init volatile unsigned char    CHIPIDX15        @ 0xFBDF;
__xdata __no_init volatile unsigned char    CHIPIDX16        @ 0xFBE0;
__xdata __no_init volatile unsigned char    CHIPIDX17        @ 0xFBE1;
__xdata __no_init volatile unsigned char    CHIPIDX18        @ 0xFBE2;
__xdata __no_init volatile unsigned char    CHIPIDX19        @ 0xFBE3;
__xdata __no_init volatile unsigned char    CHIPIDX20        @ 0xFBE4;
__xdata __no_init volatile unsigned char    CHIPIDX21        @ 0xFBE5;
__xdata __no_init volatile unsigned char    CHIPIDX22        @ 0xFBE6;
__xdata __no_init volatile unsigned char    CHIPIDX23        @ 0xFBE7;
__xdata __no_init volatile unsigned char    CHIPIDX24        @ 0xFBE8;
__xdata __no_init volatile unsigned char    CHIPIDX25        @ 0xFBE9;
__xdata __no_init volatile unsigned char    CHIPIDX26        @ 0xFBEA;
__xdata __no_init volatile unsigned char    CHIPIDX27        @ 0xFBEB;
__xdata __no_init volatile unsigned char    CHIPIDX28        @ 0xFBEC;
__xdata __no_init volatile unsigned char    CHIPIDX29        @ 0xFBED;
__xdata __no_init volatile unsigned char    CHIPIDX30        @ 0xFBEE;
__xdata __no_init volatile unsigned char    CHIPIDX31        @ 0xFBEF;

__xdata __no_init volatile unsigned char    HSPWMA_CFG       @ 0xFBF0;
__xdata __no_init volatile unsigned char    HSPWMA_ADR       @ 0xFBF1;
__xdata __no_init volatile unsigned char    HSPWMA_DAT       @ 0xFBF2;
__xdata __no_init volatile unsigned char    HSPWMA_ADRH      @ 0xFBF3;

__xdata __no_init volatile unsigned char    HSPWMB_CFG       @ 0xFBF4;
__xdata __no_init volatile unsigned char    HSPWMB_ADR       @ 0xFBF5;
__xdata __no_init volatile unsigned char    HSPWMB_DAT       @ 0xFBF6;
__xdata __no_init volatile unsigned char    HSPWMB_ADRH      @ 0xFBF7;

__xdata __no_init volatile unsigned char    HSSPI_CFG        @ 0xFBF8;
__xdata __no_init volatile unsigned char    HSSPI_CFG2       @ 0xFBF9;
__xdata __no_init volatile unsigned char    HSSPI_STA        @ 0xFBFA;
__xdata __no_init volatile unsigned char    HSSPI_PSCR       @ 0xFBFB;

/////////////////////////////////////////////////
//7E:FA00H-7E:FAFFH
/////////////////////////////////////////////////

__xdata __no_init volatile unsigned char    DMA_M2M_CFG      @ 0xFA00;
__xdata __no_init volatile unsigned char    DMA_M2M_CR       @ 0xFA01;
__xdata __no_init volatile unsigned char    DMA_M2M_STA      @ 0xFA02;
__xdata __no_init volatile unsigned char    DMA_M2M_AMT      @ 0xFA03;
__xdata __no_init volatile unsigned char    DMA_M2M_DONE     @ 0xFA04;
__xdata __no_init volatile unsigned char    DMA_M2M_TXAH     @ 0xFA05;
__xdata __no_init volatile unsigned char    DMA_M2M_TXAL     @ 0xFA06;
__xdata __no_init volatile unsigned char    DMA_M2M_RXAH     @ 0xFA07;
__xdata __no_init volatile unsigned char    DMA_M2M_RXAL     @ 0xFA08;

__xdata __no_init volatile unsigned char    DMA_ADC_CFG      @ 0xFA10;
__xdata __no_init volatile unsigned char    DMA_ADC_CR       @ 0xFA11;
__xdata __no_init volatile unsigned char    DMA_ADC_STA      @ 0xFA12;
__xdata __no_init volatile unsigned char    DMA_ADC_AMT      @ 0xFA13;
__xdata __no_init volatile unsigned char    DMA_ADC_DONE     @ 0xFA14;
__xdata __no_init volatile unsigned char    DMA_ADC_RXAH     @ 0xFA17;
__xdata __no_init volatile unsigned char    DMA_ADC_RXAL     @ 0xFA18;
__xdata __no_init volatile unsigned char    DMA_ADC_CFG2     @ 0xFA19;
__xdata __no_init volatile unsigned char    DMA_ADC_CHSW0    @ 0xFA1A;
__xdata __no_init volatile unsigned char    DMA_ADC_CHSW1    @ 0xFA1B;
__xdata __no_init volatile unsigned char    DMA_ADC_ITVH     @ 0xFA1E;
__xdata __no_init volatile unsigned char    DMA_ADC_ITVL     @ 0xFA1F;

__xdata __no_init volatile unsigned char    DMA_SPI_CFG      @ 0xFA20;
__xdata __no_init volatile unsigned char    DMA_SPI_CR       @ 0xFA21;
__xdata __no_init volatile unsigned char    DMA_SPI_STA      @ 0xFA22;
__xdata __no_init volatile unsigned char    DMA_SPI_AMT      @ 0xFA23;
__xdata __no_init volatile unsigned char    DMA_SPI_DONE     @ 0xFA24;
__xdata __no_init volatile unsigned char    DMA_SPI_TXAH     @ 0xFA25;
__xdata __no_init volatile unsigned char    DMA_SPI_TXAL     @ 0xFA26;
__xdata __no_init volatile unsigned char    DMA_SPI_RXAH     @ 0xFA27;
__xdata __no_init volatile unsigned char    DMA_SPI_RXAL     @ 0xFA28;
__xdata __no_init volatile unsigned char    DMA_SPI_CFG2     @ 0xFA29;
__xdata __no_init volatile unsigned char    DMA_SPI_ITVH     @ 0xFA2E;
__xdata __no_init volatile unsigned char    DMA_SPI_ITVL     @ 0xFA2F;

__xdata __no_init volatile unsigned char    DMA_UR1T_CFG     @ 0xFA30;
__xdata __no_init volatile unsigned char    DMA_UR1T_CR      @ 0xFA31;
__xdata __no_init volatile unsigned char    DMA_UR1T_STA     @ 0xFA32;
__xdata __no_init volatile unsigned char    DMA_UR1T_AMT     @ 0xFA33;
__xdata __no_init volatile unsigned char    DMA_UR1T_DONE    @ 0xFA34;
__xdata __no_init volatile unsigned char    DMA_UR1T_TXAH    @ 0xFA35;
__xdata __no_init volatile unsigned char    DMA_UR1T_TXAL    @ 0xFA36;
__xdata __no_init volatile unsigned char    DMA_UR1R_CFG     @ 0xFA38;
__xdata __no_init volatile unsigned char    DMA_UR1R_CR      @ 0xFA39;
__xdata __no_init volatile unsigned char    DMA_UR1R_STA     @ 0xFA3A;
__xdata __no_init volatile unsigned char    DMA_UR1R_AMT     @ 0xFA3B;
__xdata __no_init volatile unsigned char    DMA_UR1R_DONE    @ 0xFA3C;
__xdata __no_init volatile unsigned char    DMA_UR1R_RXAH    @ 0xFA3D;
__xdata __no_init volatile unsigned char    DMA_UR1R_RXAL    @ 0xFA3E;

__xdata __no_init volatile unsigned char    DMA_UR2T_CFG     @ 0xFA40;
__xdata __no_init volatile unsigned char    DMA_UR2T_CR      @ 0xFA41;
__xdata __no_init volatile unsigned char    DMA_UR2T_STA     @ 0xFA42;
__xdata __no_init volatile unsigned char    DMA_UR2T_AMT     @ 0xFA43;
__xdata __no_init volatile unsigned char    DMA_UR2T_DONE    @ 0xFA44;
__xdata __no_init volatile unsigned char    DMA_UR2T_TXAH    @ 0xFA45;
__xdata __no_init volatile unsigned char    DMA_UR2T_TXAL    @ 0xFA46;
__xdata __no_init volatile unsigned char    DMA_UR2R_CFG     @ 0xFA48;
__xdata __no_init volatile unsigned char    DMA_UR2R_CR      @ 0xFA49;
__xdata __no_init volatile unsigned char    DMA_UR2R_STA     @ 0xFA4A;
__xdata __no_init volatile unsigned char    DMA_UR2R_AMT     @ 0xFA4B;
__xdata __no_init volatile unsigned char    DMA_UR2R_DONE    @ 0xFA4C;
__xdata __no_init volatile unsigned char    DMA_UR2R_RXAH    @ 0xFA4D;
__xdata __no_init volatile unsigned char    DMA_UR2R_RXAL    @ 0xFA4E;

__xdata __no_init volatile unsigned char    DMA_UR3T_CFG     @ 0xFA50;
__xdata __no_init volatile unsigned char    DMA_UR3T_CR      @ 0xFA51;
__xdata __no_init volatile unsigned char    DMA_UR3T_STA     @ 0xFA52;
__xdata __no_init volatile unsigned char    DMA_UR3T_AMT     @ 0xFA53;
__xdata __no_init volatile unsigned char    DMA_UR3T_DONE    @ 0xFA54;
__xdata __no_init volatile unsigned char    DMA_UR3T_TXAH    @ 0xFA55;
__xdata __no_init volatile unsigned char    DMA_UR3T_TXAL    @ 0xFA56;
__xdata __no_init volatile unsigned char    DMA_UR3R_CFG     @ 0xFA58;
__xdata __no_init volatile unsigned char    DMA_UR3R_CR      @ 0xFA59;
__xdata __no_init volatile unsigned char    DMA_UR3R_STA     @ 0xFA5A;
__xdata __no_init volatile unsigned char    DMA_UR3R_AMT     @ 0xFA5B;
__xdata __no_init volatile unsigned char    DMA_UR3R_DONE    @ 0xFA5C;
__xdata __no_init volatile unsigned char    DMA_UR3R_RXAH    @ 0xFA5D;
__xdata __no_init volatile unsigned char    DMA_UR3R_RXAL    @ 0xFA5E;

__xdata __no_init volatile unsigned char    DMA_UR4T_CFG     @ 0xFA60;
__xdata __no_init volatile unsigned char    DMA_UR4T_CR      @ 0xFA61;
__xdata __no_init volatile unsigned char    DMA_UR4T_STA     @ 0xFA62;
__xdata __no_init volatile unsigned char    DMA_UR4T_AMT     @ 0xFA63;
__xdata __no_init volatile unsigned char    DMA_UR4T_DONE    @ 0xFA64;
__xdata __no_init volatile unsigned char    DMA_UR4T_TXAH    @ 0xFA65;
__xdata __no_init volatile unsigned char    DMA_UR4T_TXAL    @ 0xFA66;
__xdata __no_init volatile unsigned char    DMA_UR4R_CFG     @ 0xFA68;
__xdata __no_init volatile unsigned char    DMA_UR4R_CR      @ 0xFA69;
__xdata __no_init volatile unsigned char    DMA_UR4R_STA     @ 0xFA6A;
__xdata __no_init volatile unsigned char    DMA_UR4R_AMT     @ 0xFA6B;
__xdata __no_init volatile unsigned char    DMA_UR4R_DONE    @ 0xFA6C;
__xdata __no_init volatile unsigned char    DMA_UR4R_RXAH    @ 0xFA6D;
__xdata __no_init volatile unsigned char    DMA_UR4R_RXAL    @ 0xFA6E;

__xdata __no_init volatile unsigned char    DMA_LCM_CFG      @ 0xFA70;
__xdata __no_init volatile unsigned char    DMA_LCM_CR       @ 0xFA71;
__xdata __no_init volatile unsigned char    DMA_LCM_STA      @ 0xFA72;
__xdata __no_init volatile unsigned char    DMA_LCM_AMT      @ 0xFA73;
__xdata __no_init volatile unsigned char    DMA_LCM_DONE     @ 0xFA74;
__xdata __no_init volatile unsigned char    DMA_LCM_TXAH     @ 0xFA75;
__xdata __no_init volatile unsigned char    DMA_LCM_TXAL     @ 0xFA76;
__xdata __no_init volatile unsigned char    DMA_LCM_RXAH     @ 0xFA77;
__xdata __no_init volatile unsigned char    DMA_LCM_RXAL     @ 0xFA78;
__xdata __no_init volatile unsigned char    DMA_LCM_ITVH     @ 0xFA7E;
__xdata __no_init volatile unsigned char    DMA_LCM_ITVL     @ 0xFA7F;

__xdata __no_init volatile unsigned char    DMA_M2M_AMTH     @ 0xFA80;
__xdata __no_init volatile unsigned char    DMA_M2M_DONEH    @ 0xFA81;
__xdata __no_init volatile unsigned char    DMA_ADC_AMTH     @ 0xFA82;
__xdata __no_init volatile unsigned char    DMA_ADC_DONEH    @ 0xFA83;
__xdata __no_init volatile unsigned char    DMA_SPI_AMTH     @ 0xFA84;
__xdata __no_init volatile unsigned char    DMA_SPI_DONEH    @ 0xFA85;
__xdata __no_init volatile unsigned char    DMA_LCM_AMTH     @ 0xFA86;
__xdata __no_init volatile unsigned char    DMA_LCM_DONEH    @ 0xFA87;
__xdata __no_init volatile unsigned char    DMA_UR1T_AMTH    @ 0xFA88;
__xdata __no_init volatile unsigned char    DMA_UR1T_DONEH   @ 0xFA89;
__xdata __no_init volatile unsigned char    DMA_UR1R_AMTH    @ 0xFA8A;
__xdata __no_init volatile unsigned char    DMA_UR1R_DONEH   @ 0xFA8B;
__xdata __no_init volatile unsigned char    DMA_UR2T_AMTH    @ 0xFA8C;
__xdata __no_init volatile unsigned char    DMA_UR2T_DONEH   @ 0xFA8D;
__xdata __no_init volatile unsigned char    DMA_UR2R_AMTH    @ 0xFA8E;
__xdata __no_init volatile unsigned char    DMA_UR2R_DONEH   @ 0xFA8F;
__xdata __no_init volatile unsigned char    DMA_UR3T_AMTH    @ 0xFA90;
__xdata __no_init volatile unsigned char    DMA_UR3T_DONEH   @ 0xFA91;
__xdata __no_init volatile unsigned char    DMA_UR3R_AMTH    @ 0xFA92;
__xdata __no_init volatile unsigned char    DMA_UR3R_DONEH   @ 0xFA93;
__xdata __no_init volatile unsigned char    DMA_UR4T_AMTH    @ 0xFA94;
__xdata __no_init volatile unsigned char    DMA_UR4T_DONEH   @ 0xFA95;
__xdata __no_init volatile unsigned char    DMA_UR4R_AMTH    @ 0xFA96;
__xdata __no_init volatile unsigned char    DMA_UR4R_DONEH   @ 0xFA97;

__xdata __no_init volatile unsigned char    DMA_I2CT_CFG     @ 0xFA98;
__xdata __no_init volatile unsigned char    DMA_I2CT_CR      @ 0xFA99;
__xdata __no_init volatile unsigned char    DMA_I2CT_STA     @ 0xFA9A;
__xdata __no_init volatile unsigned char    DMA_I2CT_AMT     @ 0xFA9B;
__xdata __no_init volatile unsigned char    DMA_I2CT_DONE    @ 0xFA9C;
__xdata __no_init volatile unsigned char    DMA_I2CT_TXAH    @ 0xFA9D;
__xdata __no_init volatile unsigned char    DMA_I2CT_TXAL    @ 0xFA9E;
__xdata __no_init volatile unsigned char    DMA_I2CR_CFG     @ 0xFAA0;
__xdata __no_init volatile unsigned char    DMA_I2CR_CR      @ 0xFAA1;
__xdata __no_init volatile unsigned char    DMA_I2CR_STA     @ 0xFAA2;
__xdata __no_init volatile unsigned char    DMA_I2CR_AMT     @ 0xFAA3;
__xdata __no_init volatile unsigned char    DMA_I2CR_DONE    @ 0xFAA4;
__xdata __no_init volatile unsigned char    DMA_I2CR_RXAH    @ 0xFAA5;
__xdata __no_init volatile unsigned char    DMA_I2CR_RXAL    @ 0xFAA6;

__xdata __no_init volatile unsigned char    DMA_I2CT_AMTH    @ 0xFAA8;
__xdata __no_init volatile unsigned char    DMA_I2CT_DONEH   @ 0xFAA9;
__xdata __no_init volatile unsigned char    DMA_I2CR_AMTH    @ 0xFAAA;
__xdata __no_init volatile unsigned char    DMA_I2CR_DONEH   @ 0xFAAB;
__xdata __no_init volatile unsigned char    DMA_I2C_CR       @ 0xFAAD;
__xdata __no_init volatile unsigned char    DMA_I2C_ST1      @ 0xFAAE;
__xdata __no_init volatile unsigned char    DMA_I2C_ST2      @ 0xFAAF;

__xdata __no_init volatile unsigned char    DMA_I2ST_CFG     @ 0xFAB0;
__xdata __no_init volatile unsigned char    DMA_I2ST_CR      @ 0xFAB1;
__xdata __no_init volatile unsigned char    DMA_I2ST_STA     @ 0xFAB2;
__xdata __no_init volatile unsigned char    DMA_I2ST_AMT     @ 0xFAB3;
__xdata __no_init volatile unsigned char    DMA_I2ST_DONE    @ 0xFAB4;
__xdata __no_init volatile unsigned char    DMA_I2ST_TXAH    @ 0xFAB5;
__xdata __no_init volatile unsigned char    DMA_I2ST_TXAL    @ 0xFAB6;
__xdata __no_init volatile unsigned char    DMA_I2SR_CFG     @ 0xFAB8;
__xdata __no_init volatile unsigned char    DMA_I2SR_CR      @ 0xFAB9;
__xdata __no_init volatile unsigned char    DMA_I2SR_STA     @ 0xFABA;
__xdata __no_init volatile unsigned char    DMA_I2SR_AMT     @ 0xFABB;
__xdata __no_init volatile unsigned char    DMA_I2SR_DONE    @ 0xFABC;
__xdata __no_init volatile unsigned char    DMA_I2SR_RXAH    @ 0xFABD;
__xdata __no_init volatile unsigned char    DMA_I2SR_RXAL    @ 0xFABE;

__xdata __no_init volatile unsigned char    DMA_I2ST_AMTH    @ 0xFAC0;
__xdata __no_init volatile unsigned char    DMA_I2ST_DONEH   @ 0xFAC1;
__xdata __no_init volatile unsigned char    DMA_I2SR_AMTH    @ 0xFAC2;
__xdata __no_init volatile unsigned char    DMA_I2SR_DONEH   @ 0xFAC3;
__xdata __no_init volatile unsigned char    DMA_I2C_ITVH     @ 0xFAC4;
__xdata __no_init volatile unsigned char    DMA_I2C_ITVL     @ 0xFAC5;
__xdata __no_init volatile unsigned char    DMA_I2S_ITVH     @ 0xFAC6;
__xdata __no_init volatile unsigned char    DMA_I2S_ITVL     @ 0xFAC7;
__xdata __no_init volatile unsigned char    DMA_UR1_ITVH     @ 0xFAC8;
__xdata __no_init volatile unsigned char    DMA_UR1_ITVL     @ 0xFAC9;
__xdata __no_init volatile unsigned char    DMA_UR2_ITVH     @ 0xFACA;
__xdata __no_init volatile unsigned char    DMA_UR2_ITVL     @ 0xFACB;
__xdata __no_init volatile unsigned char    DMA_UR3_ITVH     @ 0xFACC;
__xdata __no_init volatile unsigned char    DMA_UR3_ITVL     @ 0xFACD;
__xdata __no_init volatile unsigned char    DMA_UR4_ITVH     @ 0xFACE;
__xdata __no_init volatile unsigned char    DMA_UR4_ITVL     @ 0xFACF;

__xdata __no_init volatile unsigned char    DMA_QSPI_CFG     @ 0xFAD0;
__xdata __no_init volatile unsigned char    DMA_QSPI_CR      @ 0xFAD1;
__xdata __no_init volatile unsigned char    DMA_QSPI_STA     @ 0xFAD2;
__xdata __no_init volatile unsigned char    DMA_QSPI_AMT     @ 0xFAD3;
__xdata __no_init volatile unsigned char    DMA_QSPI_DONE    @ 0xFAD4;
__xdata __no_init volatile unsigned char    DMA_QSPI_TXAH    @ 0xFAD5;
__xdata __no_init volatile unsigned char    DMA_QSPI_TXAL    @ 0xFAD6;
__xdata __no_init volatile unsigned char    DMA_QSPI_RXAH    @ 0xFAD7;
__xdata __no_init volatile unsigned char    DMA_QSPI_RXAL    @ 0xFAD8;
__xdata __no_init volatile unsigned char    DMA_QSPI_AMTH    @ 0xFADB;
__xdata __no_init volatile unsigned char    DMA_QSPI_DONEH   @ 0xFADC;
__xdata __no_init volatile unsigned char    DMA_QSPI_ITVH    @ 0xFADE;
__xdata __no_init volatile unsigned char    DMA_QSPI_ITVL    @ 0xFADF;

__xdata __no_init volatile unsigned char    DMA_P2P_CR1      @ 0xFAF0;
__xdata __no_init volatile unsigned char    DMA_P2P_CR2      @ 0xFAF1;
__xdata __no_init volatile unsigned char    DMA_ARB_CFG      @ 0xFAF8;
__xdata __no_init volatile unsigned char    DMA_ARB_STA      @ 0xFAF9;

/////////////////////////////////////////////////
//7E:F900H-7E:F9FFH
/////////////////////////////////////////////////

__xdata __no_init volatile unsigned char    QSPI_CR1         @ 0xF900;
__xdata __no_init volatile unsigned char    QSPI_CR2         @ 0xF901;
__xdata __no_init volatile unsigned char    QSPI_CR3         @ 0xF902;
__xdata __no_init volatile unsigned char    QSPI_CR4         @ 0xF903;
__xdata __no_init volatile unsigned char    QSPI_DCR1        @ 0xF904;
__xdata __no_init volatile unsigned char    QSPI_DCR2        @ 0xF905;
__xdata __no_init volatile unsigned char    QSPI_SR1         @ 0xF906;
__xdata __no_init volatile unsigned char    QSPI_SR2         @ 0xF907;
__xdata __no_init volatile unsigned char    QSPI_FCR         @ 0xF908;
__xdata __no_init volatile unsigned char    QSPI_HCR1        @ 0xF909;
__xdata __no_init volatile unsigned char    QSPI_HCR2        @ 0xF90A;
__xdata __no_init volatile unsigned char    QSPI_DLR1        @ 0xF910;
__xdata __no_init volatile unsigned char    QSPI_DLR2        @ 0xF911;
__xdata __no_init volatile unsigned char    QSPI_CCR1        @ 0xF914;
__xdata __no_init volatile unsigned char    QSPI_CCR2        @ 0xF915;
__xdata __no_init volatile unsigned char    QSPI_CCR3        @ 0xF916;
__xdata __no_init volatile unsigned char    QSPI_CCR4        @ 0xF917;
__xdata __no_init volatile unsigned char    QSPI_AR1         @ 0xF918;
__xdata __no_init volatile unsigned char    QSPI_AR2         @ 0xF919;
__xdata __no_init volatile unsigned char    QSPI_AR3         @ 0xF91A;
__xdata __no_init volatile unsigned char    QSPI_AR4         @ 0xF91B;
__xdata __no_init volatile unsigned char    QSPI_ABR         @ 0xF91C;
__xdata __no_init volatile unsigned char    QSPI_DR          @ 0xF920;
__xdata __no_init volatile unsigned char    QSPI_PSMKR1      @ 0xF924;
__xdata __no_init volatile unsigned char    QSPI_PSMAR1      @ 0xF928;
__xdata __no_init volatile unsigned char    QSPI_PIR1        @ 0xF92C;
__xdata __no_init volatile unsigned char    QSPI_PIR2        @ 0xF92D;

__xdata __no_init volatile unsigned char    PWMA_ENO2        @ 0xF930;
__xdata __no_init volatile unsigned char    PWMA_IOAUX2      @ 0xF931;
__xdata __no_init volatile unsigned char    PWMA_CR3         @ 0xF932;
__xdata __no_init volatile unsigned char    PWMA_SR3         @ 0xF933;
__xdata __no_init volatile unsigned char    PWMA_CCER3       @ 0xF934;
__xdata __no_init volatile unsigned char    PWMA_CCMR1X      @ 0xF938;
__xdata __no_init volatile unsigned char    PWMA_CCMR2X      @ 0xF939;
__xdata __no_init volatile unsigned char    PWMA_CCMR3X      @ 0xF93A;
__xdata __no_init volatile unsigned char    PWMA_CCMR4X      @ 0xF93B;
__xdata __no_init volatile unsigned char    PWMA_CCMR5       @ 0xF93C;
__xdata __no_init volatile unsigned char    PWMA_CCMR5X      @ 0xF93D;
__xdata __no_init volatile unsigned char    PWMA_CCMR6       @ 0xF93E;
__xdata __no_init volatile unsigned char    PWMA_CCMR6X      @ 0xF93F;
__xdata __no_init volatile unsigned char    PWMA_CCR5H       @ 0xF940;
__xdata __no_init volatile unsigned char    PWMA_CCR5L       @ 0xF941;
__xdata __no_init volatile unsigned char    PWMA_CCR5X       @ 0xF942;
__xdata __no_init volatile unsigned char    PWMA_CCR6H       @ 0xF943;
__xdata __no_init volatile unsigned char    PWMA_CCR6L       @ 0xF944;
__xdata __no_init volatile unsigned char    PWMA_DER         @ 0xF948;
__xdata __no_init volatile unsigned char    PWMA_DBA         @ 0xF949;
__xdata __no_init volatile unsigned char    PWMA_DBL         @ 0xF94A;
__xdata __no_init volatile unsigned char    PWMA_DMACR       @ 0xF94B;

__xdata __no_init volatile unsigned char    DMA_PWMAT_CFG    @ 0xF980;
__xdata __no_init volatile unsigned char    DMA_PWMAT_CR     @ 0xF981;
__xdata __no_init volatile unsigned char    DMA_PWMAT_STA    @ 0xF982;
__xdata __no_init volatile unsigned char    DMA_PWMAT_AMTH   @ 0xF984;
__xdata __no_init volatile unsigned char    DMA_PWMAT_AMT    @ 0xF985;
__xdata __no_init volatile unsigned char    DMA_PWMAT_DONEH  @ 0xF986;
__xdata __no_init volatile unsigned char    DMA_PWMAT_DONE   @ 0xF987;
__xdata __no_init volatile unsigned char    DMA_PWMAT_TXAH   @ 0xF988;
__xdata __no_init volatile unsigned char    DMA_PWMAT_TXAL   @ 0xF989;
__xdata __no_init volatile unsigned char    DMA_PWMA_ITVH    @ 0xF98E;
__xdata __no_init volatile unsigned char    DMA_PWMA_ITVL    @ 0xF98F;

__xdata __no_init volatile unsigned char    DMA_PWMAR_CFG    @ 0xF990;
__xdata __no_init volatile unsigned char    DMA_PWMAR_CR     @ 0xF991;
__xdata __no_init volatile unsigned char    DMA_PWMAR_STA    @ 0xF992;
__xdata __no_init volatile unsigned char    DMA_PWMAR_AMTH   @ 0xF994;
__xdata __no_init volatile unsigned char    DMA_PWMAR_AMT    @ 0xF995;
__xdata __no_init volatile unsigned char    DMA_PWMAR_DONEH  @ 0xF996;
__xdata __no_init volatile unsigned char    DMA_PWMAR_DONE   @ 0xF997;
__xdata __no_init volatile unsigned char    DMA_PWMAR_RXAH   @ 0xF998;
__xdata __no_init volatile unsigned char    DMA_PWMAR_RXAL   @ 0xF999;

/////////////////////////////////////////////////
//USB Control Regiter
/////////////////////////////////////////////////

#define     USBBASE                 0
#define     FADDR                   (USBBASE + 0)
#define     UPDATE                  0x80
#define     POWER                   (USBBASE + 1)
#define     ISOUD                   0x80
#define     USBRST                  0x08
#define     USBRSU                  0x04
#define     USBSUS                  0x02
#define     ENSUS                   0x01
#define     INTRIN1                 (USBBASE + 2)
#define     EP5INIF                 0x20
#define     EP4INIF                 0x10
#define     EP3INIF                 0x08
#define     EP2INIF                 0x04
#define     EP1INIF                 0x02
#define     EP0IF                   0x01
#define     INTROUT1                (USBBASE + 4)
#define     EP5OUTIF                0x20
#define     EP4OUTIF                0x10
#define     EP3OUTIF                0x08
#define     EP2OUTIF                0x04
#define     EP1OUTIF                0x02
#define     INTRUSB                 (USBBASE + 6)
#define     SOFIF                   0x08
#define     RSTIF                   0x04
#define     RSUIF                   0x02
#define     SUSIF                   0x01
#define     INTRIN1E                (USBBASE + 7)
#define     EP5INIE                 0x20
#define     EP4INIE                 0x10
#define     EP3INIE                 0x08
#define     EP2INIE                 0x04
#define     EP1INIE                 0x02
#define     EP0IE                   0x01
#define     INTROUT1E               (USBBASE + 9)
#define     EP5OUTIE                0x20
#define     EP4OUTIE                0x10
#define     EP3OUTIE                0x08
#define     EP2OUTIE                0x04
#define     EP1OUTIE                0x02
#define     INTRUSBE                (USBBASE + 11)
#define     SOFIE                   0x08
#define     RSTIE                   0x04
#define     RSUIE                   0x02
#define     SUSIE                   0x01
#define     FRAME1                  (USBBASE + 12)
#define     FRAME2                  (USBBASE + 13)
#define     INDEX                   (USBBASE + 14)
#define     INMAXP                  (USBBASE + 16)
#define     CSR0                    (USBBASE + 17)
#define     SSUEND                  0x80
#define     SOPRDY                  0x40
#define     SDSTL                   0x20
#define     SUEND                   0x10
#define     DATEND                  0x08
#define     STSTL                   0x04
#define     IPRDY                   0x02
#define     OPRDY                   0x01
#define     INCSR1                  (USBBASE + 17)
#define     INCLRDT                 0x40
#define     INSTSTL                 0x20
#define     INSDSTL                 0x10
#define     INFLUSH                 0x08
#define     INUNDRUN                0x04
#define     INFIFONE                0x02
#define     INIPRDY                 0x01
#define     INCSR2                  (USBBASE + 18)
#define     INAUTOSET               0x80
#define     INISO                   0x40
#define     INMODEIN                0x20
#define     INMODEOUT               0x00
#define     INENDMA                 0x10
#define     INFCDT                  0x08
#define     OUTMAXP                 (USBBASE + 19)
#define     OUTCSR1                 (USBBASE + 20)
#define     OUTCLRDT                0x80
#define     OUTSTSTL                0x40
#define     OUTSDSTL                0x20
#define     OUTFLUSH                0x10
#define     OUTDATERR               0x08
#define     OUTOVRRUN               0x04
#define     OUTFIFOFUL              0x02
#define     OUTOPRDY                0x01
#define     OUTCSR2                 (USBBASE + 21)
#define     OUTAUTOCLR              0x80
#define     OUTISO                  0x40
#define     OUTENDMA                0x20
#define     OUTDMAMD                0x10
#define     COUNT0                  (USBBASE + 22)
#define     OUTCOUNT1               (USBBASE + 22)
#define     OUTCOUNT2               (USBBASE + 23)
#define     FIFO0                   (USBBASE + 32)
#define     FIFO1                   (USBBASE + 33)
#define     FIFO2                   (USBBASE + 34)
#define     FIFO3                   (USBBASE + 35)
#define     FIFO4                   (USBBASE + 36)
#define     FIFO5                   (USBBASE + 37)
#define     UTRKCTL                 (USBBASE + 48)
#define     UTRKSTS                 (USBBASE + 49)

/////////////////////////////////////////////////
//Interrupt Vector
/////////////////////////////////////////////////

#define     INT0_VECTOR             0x03 //0       
#define     TMR0_VECTOR             0x0B //1       
#define     INT1_VECTOR             0x13 //2       
#define     TMR1_VECTOR             0x1B //3       
#define     UART1_VECTOR            0x23 //4       
#define     ADC_VECTOR              0x2B //5       
#define     LVD_VECTOR              0x33 //6       
#define     PCA_VECTOR              0x3B //7       
#define     UART2_VECTOR            0x43 //8       
#define     SPI_VECTOR              0x4B //9       
#define     INT2_VECTOR             0x53 //10      
#define     INT3_VECTOR             0x5B //11      
#define     TMR2_VECTOR             0x63 //12      
#define     USER_VECTOR             0x6B //13      
#define     INT4_VECTOR             0x83 //16      
#define     UART3_VECTOR            0x8B //17      
#define     UART4_VECTOR            0x93 //18      
#define     TMR3_VECTOR             0x9B //19      
#define     TMR4_VECTOR             0xA3 //20      
#define     CMP_VECTOR              0xAB //21      
#define     I2C_VECTOR              0xC3 //24      
#define     USB_VECTOR              0xCB //25      
#define     PWMA_VECTOR             0xD3 //26      
#define     PWMB_VECTOR             0xDB //27      

// #define     RTC_VECTOR              36      //0123H
// #define     P0INT_VECTOR            37      //012BH
// #define     P1INT_VECTOR            38      //0133H
// #define     P2INT_VECTOR            39      //013BH
// #define     P3INT_VECTOR            40      //0143H
// #define     P4INT_VECTOR            41      //014BH
// #define     P5INT_VECTOR            42      //0153H
// #define     P6INT_VECTOR            43      //015BH
// #define     P7INT_VECTOR            44      //0163H
// #define     DMA_M2M_VECTOR          47      //017BH
// #define     DMA_ADC_VECTOR          48      //0183H
// #define     DMA_SPI_VECTOR          49      //018BH
// #define     DMA_UR1T_VECTOR         50      //0193H
// #define     DMA_UR1R_VECTOR         51      //019BH
// #define     DMA_UR2T_VECTOR         52      //01A3H
// #define     DMA_UR2R_VECTOR         53      //01ABH
// #define     DMA_UR3T_VECTOR         54      //01B3H
// #define     DMA_UR3R_VECTOR         55      //01BBH
// #define     DMA_UR4T_VECTOR         56      //01C3H
// #define     DMA_UR4R_VECTOR         57      //01CBH
// #define     DMA_LCM_VECTOR          58      //01D3H
// #define     LCM_VECTOR              59      //01DBH
// #define     DMA_I2CT_VECTOR         60      //01E3H
// #define     DMA_I2CR_VECTOR         61      //01EBH
// #define     I2S_VECTOR              62      //01F3H
// #define     DMA_I2ST_VECTOR         63      //01FBH
// #define     DMA_I2SR_VECTOR         64      //0203H
// #define     DMA_QSPI_VECTOR         65      //020BH
// #define     QSPI_VECTOR             66      //0213H
// #define     TMR11_VECTOR            67      //021BH
// #define     DMA_PWMAT_VECTOR        72      //0243H
// #define     DMA_PWMAR_VECTOR        73      //024BH

/////////////////////////////////////////////////

#define	EAXSFR()		P_SW2 |= 0x80		/* MOVX A,@DPTR/MOVX @DPTR,AָĲΪչSFR(XSFR) */
#define	EAXRAM()		P_SW2 &= ~0x80		/* MOVX A,@DPTR/MOVX @DPTR,AָĲΪչRAM(XRAM) */

/////////////////////////////////////////////////
#define NOP1()  _nop_()
#define NOP2()  NOP1();NOP1()
#define NOP3()  NOP2();NOP1()
#define NOP4()  NOP3();NOP1()
#define NOP5()  NOP4();NOP1()
#define NOP6()  NOP5();NOP1()
#define NOP7()  NOP6();NOP1()
#define NOP8()  NOP7();NOP1()
#define NOP9()  NOP8();NOP1()
#define NOP10() NOP9();NOP1()
#define NOP11() NOP10();NOP1()
#define NOP12() NOP11();NOP1()
#define NOP13() NOP12();NOP1()
#define NOP14() NOP13();NOP1()
#define NOP15() NOP14();NOP1()
#define NOP16() NOP15();NOP1()
#define NOP17() NOP16();NOP1()
#define NOP18() NOP17();NOP1()
#define NOP19() NOP18();NOP1()
#define NOP20() NOP19();NOP1()
#define NOP21() NOP20();NOP1()
#define NOP22() NOP21();NOP1()
#define NOP23() NOP22();NOP1()
#define NOP24() NOP23();NOP1()
#define NOP25() NOP24();NOP1()
#define NOP26() NOP25();NOP1()
#define NOP27() NOP26();NOP1()
#define NOP28() NOP27();NOP1()
#define NOP29() NOP28();NOP1()
#define NOP30() NOP29();NOP1()
#define NOP31() NOP30();NOP1()
#define NOP32() NOP31();NOP1()
#define NOP33() NOP32();NOP1()
#define NOP34() NOP33();NOP1()
#define NOP35() NOP34();NOP1()
#define NOP36() NOP35();NOP1()
#define NOP37() NOP36();NOP1()
#define NOP38() NOP37();NOP1()
#define NOP39() NOP38();NOP1()
#define NOP40() NOP39();NOP1()
#define XNOP(N)  NOP##N()

/////////////////////////////////////////////////


#pragma language=restore
#endif /* __IAR_SYSTEMS_ICC__ */

#ifdef __IAR_SYSTEMS_ASM__

/////////////////////////////////////////////////

P0              DEFINE      0x80
    P00         DEFINE      0x80.0
    P01         DEFINE      0x80.1
    P02         DEFINE      0x80.2
    P03         DEFINE      0x80.3
    P04         DEFINE      0x80.4
    P05         DEFINE      0x80.5
    P06         DEFINE      0x80.6
    P07         DEFINE      0x80.7
SP              DEFINE      0x81
DPL             DEFINE      0x82
DPH             DEFINE      0x83
DPXL            DEFINE      0x84
SPH             DEFINE      0x85
PCON            DEFINE      0x87
TCON            DEFINE      0x88
    IT0         DEFINE      0x88.0
    IE0         DEFINE      0x88.1
    IT1         DEFINE      0x88.2
    IE1         DEFINE      0x88.3
    TR0         DEFINE      0x88.4
    TF0         DEFINE      0x88.5
    TR1         DEFINE      0x88.6
    TF1         DEFINE      0x88.7
TMOD            DEFINE      0x89
TL0             DEFINE      0x8A
TL1             DEFINE      0x8B
TH0             DEFINE      0x8C
TH1             DEFINE      0x8D
AUXR            DEFINE      0x8E
INTCLKO         DEFINE      0x8F
P1              DEFINE      0x90
    P10         DEFINE      0x90.0
    P11         DEFINE      0x90.1
    P12         DEFINE      0x90.2
    P13         DEFINE      0x90.3
    P14         DEFINE      0x90.4
    P15         DEFINE      0x90.5
    P16         DEFINE      0x90.6
    P17         DEFINE      0x90.7
P1M1            DEFINE      0x91
P1M0            DEFINE      0x92
P0M1            DEFINE      0x93
P0M0            DEFINE      0x94
P2M1            DEFINE      0x95
P2M0            DEFINE      0x96
AUXR2           DEFINE      0x97
SCON            DEFINE      0x98
    RI          DEFINE      0x98.0
    TI          DEFINE      0x98.1
    RB8         DEFINE      0x98.2
    TB8         DEFINE      0x98.3
    REN         DEFINE      0x98.4
    SM2         DEFINE      0x98.5
    SM1         DEFINE      0x98.6
    SM0         DEFINE      0x98.7
SBUF            DEFINE      0x99
S2CON           DEFINE      0x9A
S2BUF           DEFINE      0x9B
IRCBAND         DEFINE      0x9D
LIRTRIM         DEFINE      0x9E
IRTRIM          DEFINE      0x9F
P2              DEFINE      0xA0
    P20         DEFINE      0xA0.0
    P21         DEFINE      0xA0.1
    P22         DEFINE      0xA0.2
    P23         DEFINE      0xA0.3
    P24         DEFINE      0xA0.4
    P25         DEFINE      0xA0.5
    P26         DEFINE      0xA0.6
    P27         DEFINE      0xA0.7
BUS_SPEED       DEFINE      0xA1
P_SW1           DEFINE      0xA2
VRTRIM          DEFINE      0xA6
IE              DEFINE      0xA8
    EX0         DEFINE      0xA8.0
    ET0         DEFINE      0xA8.1
    EX1         DEFINE      0xA8.2
    ET1         DEFINE      0xA8.3
    ES          DEFINE      0xA8.4
    EADC        DEFINE      0xA8.5
    ELVD        DEFINE      0xA8.6
    EA          DEFINE      0xA8.7
SADDR           DEFINE      0xA9
WKTCL           DEFINE      0xAA
WKTCH           DEFINE      0xAB
S3CON           DEFINE      0xAC
S3BUF           DEFINE      0xAD
TA              DEFINE      0xAE
IE2             DEFINE      0xAF
P3              DEFINE      0xB0
    RXD         DEFINE      0xB0.0
    TXD         DEFINE      0xB0.1
    INT0        DEFINE      0xB0.2
    INT1        DEFINE      0xB0.3
    T0          DEFINE      0xB0.4
    T1          DEFINE      0xB0.5
    WR          DEFINE      0xB0.6
    RD          DEFINE      0xB0.7
P3M1            DEFINE      0xB1
P3M0            DEFINE      0xB2
P4M1            DEFINE      0xB3
P4M0            DEFINE      0xB4
IP2             DEFINE      0xB5
IP2H            DEFINE      0xB6
IPH             DEFINE      0xB7
IP              DEFINE      0xB8
    PX0         DEFINE      0xB8.0
    PT0         DEFINE      0xB8.1
    PX1         DEFINE      0xB8.2
    PT1         DEFINE      0xB8.3
    PS          DEFINE      0xB8.4
    PADC        DEFINE      0xB8.5
    PLVD        DEFINE      0xB8.6
    PPCA        DEFINE      0xB8.7
SADEN           DEFINE      0xB9
P_SW2           DEFINE      0xBA
P_SW3           DEFINE      0xBB
ADC_CONTR       DEFINE      0xBC
ADC_RES         DEFINE      0xBD
ADC_RESL        DEFINE      0xBE
P_SW4           DEFINE      0xBF
P4              DEFINE      0xC0
    P40         DEFINE      0xC0.0
    P41         DEFINE      0xC0.1
    P42         DEFINE      0xC0.2
    P43         DEFINE      0xC0.3
    P44         DEFINE      0xC0.4
    P45         DEFINE      0xC0.5
    P46         DEFINE      0xC0.6
    P47         DEFINE      0xC0.7
WDT_CONTR       DEFINE      0xC1
IAP_DATA        DEFINE      0xC2
IAP_ADDRH       DEFINE      0xC3
IAP_ADDRL       DEFINE      0xC4
IAP_CMD         DEFINE      0xC5
IAP_TRIG        DEFINE      0xC6
IAP_CONTR       DEFINE      0xC7
P5              DEFINE      0xC8
    P50         DEFINE      0xC8.0
    P51         DEFINE      0xC8.1
    P52         DEFINE      0xC8.2
    P53         DEFINE      0xC8.3
    P54         DEFINE      0xC8.4
    P55         DEFINE      0xC8.5
    P56         DEFINE      0xC8.6
    P57         DEFINE      0xC8.7
P5M1            DEFINE      0xC9
P5M0            DEFINE      0xCA
P6M1            DEFINE      0xCB
P6M0            DEFINE      0xCC
SPSTAT          DEFINE      0xCD
SPCTL           DEFINE      0xCE
SPDAT           DEFINE      0xCF
PSW             DEFINE      0xD0
    P           DEFINE      0xD0.0
    F1          DEFINE      0xD0.1
    OV          DEFINE      0xD0.2
    RS0         DEFINE      0xD0.3
    RS1         DEFINE      0xD0.4
    F0          DEFINE      0xD0.5
    AC          DEFINE      0xD0.6
    CY          DEFINE      0xD0.7
PSW1            DEFINE      0xD1
TH4             DEFINE      0xD2
TL4             DEFINE      0xD3
TH3             DEFINE      0xD4
TL3             DEFINE      0xD5
TH2             DEFINE      0xD6
TL2             DEFINE      0xD7
T4H             DEFINE      0xD2
T4L             DEFINE      0xD3
T3H             DEFINE      0xD4
T3L             DEFINE      0xD5
T2H             DEFINE      0xD6
T2L             DEFINE      0xD7
USBCLK          DEFINE      0xDC
T3T4M           DEFINE      0xDD
T4T3M           DEFINE      0xDD
ADCCFG          DEFINE      0xDE
IP3             DEFINE      0xDF
ACC             DEFINE      0xE0
P7M1            DEFINE      0xE1
P7M0            DEFINE      0xE2
DPS             DEFINE      0xE3
CMPCR1          DEFINE      0xE6
CMPCR2          DEFINE      0xE7
P6              DEFINE      0xE8
    P60         DEFINE      0xE8.0
    P61         DEFINE      0xE8.1
    P62         DEFINE      0xE8.2
    P63         DEFINE      0xE8.3
    P64         DEFINE      0xE8.4
    P65         DEFINE      0xE8.5
    P66         DEFINE      0xE8.6
    P67         DEFINE      0xE8.7
WTST            DEFINE      0xE9
CKCON           DEFINE      0xEA
MXAX            DEFINE      0xEB
USBDAT          DEFINE      0xEC
DMAIR           DEFINE      0xED
IP3H            DEFINE      0xEE
AUXINTIF        DEFINE      0xEF
B               DEFINE      0xF0
USBCON          DEFINE      0xF4
IAP_TPS         DEFINE      0xF5
IAP_ADDRE       DEFINE      0xF6
P7              DEFINE      0xF8
    P70         DEFINE      0xF8.0
    P71         DEFINE      0xF8.1
    P72         DEFINE      0xF8.2
    P73         DEFINE      0xF8.3
    P74         DEFINE      0xF8.4
    P75         DEFINE      0xF8.5
    P76         DEFINE      0xF8.6
    P77         DEFINE      0xF8.7
USBADR          DEFINE      0xFC
S4CON           DEFINE      0xFD
S4BUF           DEFINE      0xFE
RSTCFG          DEFINE      0xFF

/////////////////////////////////////////////////

CLKSEL          DEFINE      0xFE00
CLKDIV          DEFINE      0xFE01
HIRCCR          DEFINE      0xFE02
XOSCCR          DEFINE      0xFE03
IRC32KCR        DEFINE      0xFE04
MCLKOCR         DEFINE      0xFE05
IRCDB           DEFINE      0xFE06
IRC48MCR        DEFINE      0xFE07
X32KCR          DEFINE      0xFE08
IRC48ATRIM      DEFINE      0xFE09
IRC48BTRIM      DEFINE      0xFE0A
HSCLKDIV        DEFINE      0xFE0B
HPLLCR          DEFINE      0xFE0C
HPLLPSCR        DEFINE      0xFE0D
P0PU            DEFINE      0xFE10
P1PU            DEFINE      0xFE11
P2PU            DEFINE      0xFE12
P3PU            DEFINE      0xFE13
P4PU            DEFINE      0xFE14
P5PU            DEFINE      0xFE15
P6PU            DEFINE      0xFE16
P7PU            DEFINE      0xFE17
P0NCS           DEFINE      0xFE18
P1NCS           DEFINE      0xFE19
P2NCS           DEFINE      0xFE1A
P3NCS           DEFINE      0xFE1B
P4NCS           DEFINE      0xFE1C
P5NCS           DEFINE      0xFE1D
P6NCS           DEFINE      0xFE1E
P7NCS           DEFINE      0xFE1F
P0SR            DEFINE      0xFE20
P1SR            DEFINE      0xFE21
P2SR            DEFINE      0xFE22
P3SR            DEFINE      0xFE23
P4SR            DEFINE      0xFE24
P5SR            DEFINE      0xFE25
P6SR            DEFINE      0xFE26
P7SR            DEFINE      0xFE27
P0DR            DEFINE      0xFE28
P1DR            DEFINE      0xFE29
P2DR            DEFINE      0xFE2A
P3DR            DEFINE      0xFE2B
P4DR            DEFINE      0xFE2C
P5DR            DEFINE      0xFE2D
P6DR            DEFINE      0xFE2E
P7DR            DEFINE      0xFE2F
P0IE            DEFINE      0xFE30
P1IE            DEFINE      0xFE31
P2IE            DEFINE      0xFE32
P3IE            DEFINE      0xFE33
P4IE            DEFINE      0xFE34
P5IE            DEFINE      0xFE35
P6IE            DEFINE      0xFE36
P7IE            DEFINE      0xFE37
P0PD            DEFINE      0xFE40
P1PD            DEFINE      0xFE41
P2PD            DEFINE      0xFE42
P3PD            DEFINE      0xFE43
P4PD            DEFINE      0xFE44
P5PD            DEFINE      0xFE45
P6PD            DEFINE      0xFE46
P7PD            DEFINE      0xFE47
P0BP            DEFINE		0xFE48
P1BP            DEFINE		0xFE49
P2BP            DEFINE		0xFE4A
P3BP            DEFINE		0xFE4B
P4BP            DEFINE		0xFE4C
P5BP            DEFINE		0xFE4D
P6BP            DEFINE		0xFE4E
P7BP            DEFINE		0xFE4F
LCMIFCFG        DEFINE      0xFE50
LCMIFCFG2       DEFINE      0xFE51
LCMIFCR         DEFINE      0xFE52
LCMIFSTA        DEFINE      0xFE53
LCMIFDATL       DEFINE      0xFE54
LCMIFDATH       DEFINE      0xFE55
LCMIFPSCR       DEFINE      0xFE56
RTCCR           DEFINE      0xFE60
RTCCFG          DEFINE      0xFE61
RTCIEN          DEFINE      0xFE62
RTCIF           DEFINE      0xFE63
ALAHOUR         DEFINE      0xFE64
ALAMIN          DEFINE      0xFE65
ALASEC          DEFINE      0xFE66
ALASSEC         DEFINE      0xFE67
INIYEAR         DEFINE      0xFE68
INIMONTH        DEFINE      0xFE69
INIDAY          DEFINE      0xFE6A
INIHOUR         DEFINE      0xFE6B
INIMIN          DEFINE      0xFE6C
INISEC          DEFINE      0xFE6D
INISSEC         DEFINE      0xFE6E
INIWEEK         DEFINE      0xFE6F
WEEK            DEFINE      0xFE6F
YEAR            DEFINE      0xFE70
MONTH           DEFINE      0xFE71
DAY             DEFINE      0xFE72
HOUR            DEFINE      0xFE73
MIN             DEFINE      0xFE74
SEC             DEFINE      0xFE75
SSEC            DEFINE      0xFE76
T11CR           DEFINE      0xFE78
T11PS           DEFINE      0xFE79
T11H            DEFINE      0xFE7A
T11L            DEFINE      0xFE7B
I2CCFG          DEFINE      0xFE80
I2CMSCR         DEFINE      0xFE81
I2CMSST         DEFINE      0xFE82
I2CSLCR         DEFINE      0xFE83
I2CSLST         DEFINE      0xFE84
I2CSLADR        DEFINE      0xFE85
I2CTXD          DEFINE      0xFE86
I2CRXD          DEFINE      0xFE87
I2CMSAUX        DEFINE      0xFE88
I2CPSCR         DEFINE      0xFE89
SPI_CLKDIV      DEFINE      0xFE90
PWMA_CLKDIV     DEFINE      0xFE91
PWMB_CLKDIV     DEFINE      0xFE92
TFPU_CLKDIV     DEFINE      0xFE93
I2S_CLKDIV      DEFINE      0xFE94
RSTFLAG         DEFINE      0xFE99
RSTCR0          DEFINE      0xFE9A
RSTCR1          DEFINE      0xFE9B
RSTCR2          DEFINE      0xFE9C
RSTCR3          DEFINE      0xFE9D
RSTCR4          DEFINE      0xFE9E
RSTCR5          DEFINE      0xFE9F
TM0PS           DEFINE      0xFEA0
TM1PS           DEFINE      0xFEA1
TM2PS           DEFINE      0xFEA2
TM3PS           DEFINE      0xFEA3
TM4PS           DEFINE      0xFEA4
ADCTIM          DEFINE      0xFEA8
ADCEXCFG        DEFINE      0xFEAD
CMPEXCFG        DEFINE      0xFEAE
PWMA_ETRPS      DEFINE      0xFEB0
PWMA_ENO        DEFINE      0xFEB1
PWMA_PS         DEFINE      0xFEB2
PWMA_IOAUX      DEFINE      0xFEB3
PWMB_ETRPS      DEFINE      0xFEB4
PWMB_ENO        DEFINE      0xFEB5
PWMB_PS         DEFINE      0xFEB6
PWMB_IOAUX      DEFINE      0xFEB7
PWMA_PS2        DEFINE      0xFEB8
PWMA_RCRH       DEFINE      0xFEB9
PWMB_RCRH       DEFINE      0xFEBA
PWMA_CR1        DEFINE      0xFEC0
PWMA_CR2        DEFINE      0xFEC1
PWMA_SMCR       DEFINE      0xFEC2
PWMA_ETR        DEFINE      0xFEC3
PWMA_IER        DEFINE      0xFEC4
PWMA_SR1        DEFINE      0xFEC5
PWMA_SR2        DEFINE      0xFEC6
PWMA_EGR        DEFINE      0xFEC7
PWMA_CCMR1      DEFINE      0xFEC8
PWMA_CCMR2      DEFINE      0xFEC9
PWMA_CCMR3      DEFINE      0xFECA
PWMA_CCMR4      DEFINE      0xFECB
PWMA_CCER1      DEFINE      0xFECC
PWMA_CCER2      DEFINE      0xFECD
PWMA_CNTRH      DEFINE      0xFECE
PWMA_CNTRL      DEFINE      0xFECF
PWMA_PSCRH      DEFINE      0xFED0
PWMA_PSCRL      DEFINE      0xFED1
PWMA_ARRH       DEFINE      0xFED2
PWMA_ARRL       DEFINE      0xFED3
PWMA_RCR        DEFINE      0xFED4
PWMA_CCR1H      DEFINE      0xFED5
PWMA_CCR1L      DEFINE      0xFED6
PWMA_CCR2H      DEFINE      0xFED7
PWMA_CCR2L      DEFINE      0xFED8
PWMA_CCR3H      DEFINE      0xFED9
PWMA_CCR3L      DEFINE      0xFEDA
PWMA_CCR4H      DEFINE      0xFEDB
PWMA_CCR4L      DEFINE      0xFEDC
PWMA_BKR        DEFINE      0xFEDD
PWMA_DTR        DEFINE      0xFEDE
PWMA_OISR       DEFINE      0xFEDF
PWMB_CR1        DEFINE      0xFEE0
PWMB_CR2        DEFINE      0xFEE1
PWMB_SMCR       DEFINE      0xFEE2
PWMB_ETR        DEFINE      0xFEE3
PWMB_IER        DEFINE      0xFEE4
PWMB_SR1        DEFINE      0xFEE5
PWMB_SR2        DEFINE      0xFEE6
PWMB_EGR        DEFINE      0xFEE7
PWMB_CCMR1      DEFINE      0xFEE8
PWMB_CCMR2      DEFINE      0xFEE9
PWMB_CCMR3      DEFINE      0xFEEA
PWMB_CCMR4      DEFINE      0xFEEB
PWMB_CCER1      DEFINE      0xFEEC
PWMB_CCER2      DEFINE      0xFEED
PWMB_CNTRH      DEFINE      0xFEEE
PWMB_CNTRL      DEFINE      0xFEEF
PWMB_PSCRH      DEFINE      0xFEF0
PWMB_PSCRL      DEFINE      0xFEF1
PWMB_ARRH       DEFINE      0xFEF2
PWMB_ARRL       DEFINE      0xFEF3
PWMB_RCR        DEFINE      0xFEF4
PWMB_CCR5H      DEFINE      0xFEF5
PWMB_CCR5L      DEFINE      0xFEF6
PWMB_CCR6H      DEFINE      0xFEF7
PWMB_CCR6L      DEFINE      0xFEF8
PWMB_CCR7H      DEFINE      0xFEF9
PWMB_CCR7L      DEFINE      0xFEFA
PWMB_CCR8H      DEFINE      0xFEFB
PWMB_CCR8L      DEFINE      0xFEFC
PWMB_BKR        DEFINE      0xFEFD
PWMB_DTR        DEFINE      0xFEFE
PWMB_OISR       DEFINE      0xFEFF
P0INTE          DEFINE      0xFD00
P1INTE          DEFINE      0xFD01
P2INTE          DEFINE      0xFD02
P3INTE          DEFINE      0xFD03
P4INTE          DEFINE      0xFD04
P5INTE          DEFINE      0xFD05
P6INTE          DEFINE      0xFD06
P7INTE          DEFINE      0xFD07
P0INTF          DEFINE      0xFD10
P1INTF          DEFINE      0xFD11
P2INTF          DEFINE      0xFD12
P3INTF          DEFINE      0xFD13
P4INTF          DEFINE      0xFD14
P5INTF          DEFINE      0xFD15
P6INTF          DEFINE      0xFD16
P7INTF          DEFINE      0xFD17
P0IM0           DEFINE      0xFD20
P1IM0           DEFINE      0xFD21
P2IM0           DEFINE      0xFD22
P3IM0           DEFINE      0xFD23
P4IM0           DEFINE      0xFD24
P5IM0           DEFINE      0xFD25
P6IM0           DEFINE      0xFD26
P7IM0           DEFINE      0xFD27
P0IM1           DEFINE      0xFD30
P1IM1           DEFINE      0xFD31
P2IM1           DEFINE      0xFD32
P3IM1           DEFINE      0xFD33
P4IM1           DEFINE      0xFD34
P5IM1           DEFINE      0xFD35
P6IM1           DEFINE      0xFD36
P7IM1           DEFINE      0xFD37
P0WKUE          DEFINE      0xFD40
P1WKUE          DEFINE      0xFD41
P2WKUE          DEFINE      0xFD42
P3WKUE          DEFINE      0xFD43
P4WKUE          DEFINE      0xFD44
P5WKUE          DEFINE      0xFD45
P6WKUE          DEFINE      0xFD46
P7WKUE          DEFINE      0xFD47
CCAPM2          DEFINE      0xFD50
CCAP2L          DEFINE      0xFD51
CCAP2H          DEFINE      0xFD52
PCA_PWM2        DEFINE      0xFD53
CCAPM3          DEFINE      0xFD54
CCAP3L          DEFINE      0xFD55
CCAP3H          DEFINE      0xFD56
PCA_PWM3        DEFINE      0xFD57
CCAPM0          DEFINE      0xFD58
CCAP0L          DEFINE      0xFD59
CCAP0H          DEFINE      0xFD5A
PCA_PWM0        DEFINE      0xFD5B
CCAPM1          DEFINE      0xFD5C
CCAP1L          DEFINE      0xFD5D
CCAP1H          DEFINE      0xFD5E
PCA_PWM1        DEFINE      0xFD5F
PINIPL          DEFINE      0xFD60
PINIPH          DEFINE      0xFD61
CCON            DEFINE      0xFD64
CL              DEFINE      0xFD65
CH              DEFINE      0xFD66
CMOD            DEFINE      0xFD67
UR1TOCR         DEFINE      0xFD70
UR1TOSR         DEFINE      0xFD71
UR1TOTH         DEFINE      0xFD72
UR1TOTL         DEFINE      0xFD73
UR2TOCR         DEFINE      0xFD74
UR2TOSR         DEFINE      0xFD75
UR2TOTH         DEFINE      0xFD76
UR2TOTL         DEFINE      0xFD77
UR3TOCR         DEFINE      0xFD78
UR3TOSR         DEFINE      0xFD79
UR3TOTH         DEFINE      0xFD7A
UR3TOTL         DEFINE      0xFD7B
UR4TOCR         DEFINE      0xFD7C
UR4TOSR         DEFINE      0xFD7D
UR4TOTH         DEFINE      0xFD7E
UR4TOTL         DEFINE      0xFD7F
SPITOCR         DEFINE      0xFD80
SPITOSR         DEFINE      0xFD81
SPITOTH         DEFINE      0xFD82
SPITOTL         DEFINE      0xFD83
I2CTOCR         DEFINE      0xFD84
I2CTOSR         DEFINE      0xFD85
I2CTOTH         DEFINE      0xFD86
I2CTOTL         DEFINE      0xFD87
UR1TOTE         DEFINE      0xFD88
UR2TOTE         DEFINE      0xFD89
UR3TOTE         DEFINE      0xFD8A
UR4TOTE         DEFINE      0xFD8B
SPITOTE         DEFINE      0xFD8C
I2CTOTE         DEFINE      0xFD8D
I2SCR           DEFINE      0xFD98
I2SSR           DEFINE      0xFD99
I2SDRH          DEFINE      0xFD9A
I2SDRL          DEFINE      0xFD9B
I2SPRH          DEFINE      0xFD9C
I2SPRL          DEFINE      0xFD9D
I2SCFGH         DEFINE      0xFD9E
I2SCFGL         DEFINE      0xFD9F
I2SMD           DEFINE      0xFDA0
I2SMCKDIV       DEFINE      0xFDA1
CRECR           DEFINE      0xFDA8
CRECNTH         DEFINE      0xFDA9
CRECNTL         DEFINE      0xFDAA
CRERES          DEFINE      0xFDAB
S2CFG           DEFINE      0xFDB4
S2ADDR          DEFINE      0xFDB5
S2ADEN          DEFINE      0xFDB6
USARTCR1        DEFINE      0xFDC0
USARTCR2        DEFINE      0xFDC1
USARTCR3        DEFINE      0xFDC2
USARTCR4        DEFINE      0xFDC3
USARTCR5        DEFINE      0xFDC4
USARTGTR        DEFINE      0xFDC5
USARTBRH        DEFINE      0xFDC6
USARTBRL        DEFINE      0xFDC7
USART2CR1       DEFINE      0xFDC8
USART2CR2       DEFINE      0xFDC9
USART2CR3       DEFINE      0xFDCA
USART2CR4       DEFINE      0xFDCB
USART2CR5       DEFINE      0xFDCC
USART2GTR       DEFINE      0xFDCD
USART2BRH       DEFINE      0xFDCE
USART2BRL       DEFINE      0xFDCF
CHIPID0         DEFINE      0xFDE0
CHIPID1         DEFINE      0xFDE1
CHIPID2         DEFINE      0xFDE2
CHIPID3         DEFINE      0xFDE3
CHIPID4         DEFINE      0xFDE4
CHIPID5         DEFINE      0xFDE5
CHIPID6         DEFINE      0xFDE6
CHIPID7         DEFINE      0xFDE7
CHIPID8         DEFINE      0xFDE8
CHIPID9         DEFINE      0xFDE9
CHIPID10        DEFINE      0xFDEA
CHIPID11        DEFINE      0xFDEB
CHIPID12        DEFINE      0xFDEC
CHIPID13        DEFINE      0xFDED
CHIPID14        DEFINE      0xFDEE
CHIPID15        DEFINE      0xFDEF
CHIPID16        DEFINE      0xFDF0
CHIPID17        DEFINE      0xFDF1
CHIPID18        DEFINE      0xFDF2
CHIPID19        DEFINE      0xFDF3
CHIPID20        DEFINE      0xFDF4
CHIPID21        DEFINE      0xFDF5
CHIPID22        DEFINE      0xFDF6
CHIPID23        DEFINE      0xFDF7
CHIPID24        DEFINE      0xFDF8
CHIPID25        DEFINE      0xFDF9
CHIPID26        DEFINE      0xFDFA
CHIPID27        DEFINE      0xFDFB
CHIPID28        DEFINE      0xFDFC
CHIPID29        DEFINE      0xFDFD
CHIPID30        DEFINE      0xFDFE
CHIPID31        DEFINE      0xFDFF
CHIPIDX0        DEFINE      0xFBD0
CHIPIDX1        DEFINE      0xFBD1
CHIPIDX2        DEFINE      0xFBD2
CHIPIDX3        DEFINE      0xFBD3
CHIPIDX4        DEFINE      0xFBD4
CHIPIDX5        DEFINE      0xFBD5
CHIPIDX6        DEFINE      0xFBD6
CHIPIDX7        DEFINE      0xFBD7
CHIPIDX8        DEFINE      0xFBD8
CHIPIDX9        DEFINE      0xFBD9
CHIPIDX10       DEFINE      0xFBDA
CHIPIDX11       DEFINE      0xFBDB
CHIPIDX12       DEFINE      0xFBDC
CHIPIDX13       DEFINE      0xFBDD
CHIPIDX14       DEFINE      0xFBDE
CHIPIDX15       DEFINE      0xFBDF
CHIPIDX16       DEFINE      0xFBE0
CHIPIDX17       DEFINE      0xFBE1
CHIPIDX18       DEFINE      0xFBE2
CHIPIDX19       DEFINE      0xFBE3
CHIPIDX20       DEFINE      0xFBE4
CHIPIDX21       DEFINE      0xFBE5
CHIPIDX22       DEFINE      0xFBE6
CHIPIDX23       DEFINE      0xFBE7
CHIPIDX24       DEFINE      0xFBE8
CHIPIDX25       DEFINE      0xFBE9
CHIPIDX26       DEFINE      0xFBEA
CHIPIDX27       DEFINE      0xFBEB
CHIPIDX28       DEFINE      0xFBEC
CHIPIDX29       DEFINE      0xFBED
CHIPIDX30       DEFINE      0xFBEE
CHIPIDX31       DEFINE      0xFBEF
HSPWMA_CFG      DEFINE      0xFBF0
HSPWMA_ADR      DEFINE      0xFBF1
HSPWMA_DAT      DEFINE      0xFBF2
HSPWMA_ADRH     DEFINE      0xFBF3
HSPWMB_CFG      DEFINE      0xFBF4
HSPWMB_ADR      DEFINE      0xFBF5
HSPWMB_DAT      DEFINE      0xFBF6
HSPWMB_ADRH     DEFINE      0xFBF7
HSSPI_CFG       DEFINE      0xFBF8
HSSPI_CFG2      DEFINE      0xFBF9
HSSPI_STA       DEFINE      0xFBFA
HSSPI_PSCR      DEFINE      0xFBFB
DMA_M2M_CFG     DEFINE      0xFA00
DMA_M2M_CR      DEFINE      0xFA01
DMA_M2M_STA     DEFINE      0xFA02
DMA_M2M_AMT     DEFINE      0xFA03
DMA_M2M_DONE    DEFINE      0xFA04
DMA_M2M_TXAH    DEFINE      0xFA05
DMA_M2M_TXAL    DEFINE      0xFA06
DMA_M2M_RXAH    DEFINE      0xFA07
DMA_M2M_RXAL    DEFINE      0xFA08
DMA_ADC_CFG     DEFINE      0xFA10
DMA_ADC_CR      DEFINE      0xFA11
DMA_ADC_STA     DEFINE      0xFA12
DMA_ADC_AMT     DEFINE      0xFA13
DMA_ADC_DONE    DEFINE      0xFA24
DMA_ADC_RXAH    DEFINE      0xFA17
DMA_ADC_RXAL    DEFINE      0xFA18
DMA_ADC_CFG2    DEFINE      0xFA19
DMA_ADC_CHSW0   DEFINE      0xFA1A
DMA_ADC_CHSW1   DEFINE      0xFA1B
DMA_ADC_ITVH    DEFINE      0xFA1E
DMA_ADC_ITVL    DEFINE      0xFA1F
DMA_SPI_CFG     DEFINE      0xFA20
DMA_SPI_CR      DEFINE      0xFA21
DMA_SPI_STA     DEFINE      0xFA22
DMA_SPI_AMT     DEFINE      0xFA23
DMA_SPI_DONE    DEFINE      0xFA24
DMA_SPI_TXAH    DEFINE      0xFA25
DMA_SPI_TXAL    DEFINE      0xFA26
DMA_SPI_RXAH    DEFINE      0xFA27
DMA_SPI_RXAL    DEFINE      0xFA28
DMA_SPI_CFG2    DEFINE      0xFA29
DMA_SPI_ITVH    DEFINE      0xFA2E
DMA_SPI_ITVL    DEFINE      0xFA2F
DMA_UR1T_CFG    DEFINE      0xFA30
DMA_UR1T_CR     DEFINE      0xFA31
DMA_UR1T_STA    DEFINE      0xFA32
DMA_UR1T_AMT    DEFINE      0xFA33
DMA_UR1T_DONE   DEFINE      0xFA34
DMA_UR1T_TXAH   DEFINE      0xFA35
DMA_UR1T_TXAL   DEFINE      0xFA36
DMA_UR1R_CFG    DEFINE      0xFA38
DMA_UR1R_CR     DEFINE      0xFA39
DMA_UR1R_STA    DEFINE      0xFA3A
DMA_UR1R_AMT    DEFINE      0xFA3B
DMA_UR1R_DONE   DEFINE      0xFA3C
DMA_UR1R_RXAH   DEFINE      0xFA3D
DMA_UR1R_RXAL   DEFINE      0xFA3E
DMA_UR2T_CFG    DEFINE      0xFA40
DMA_UR2T_CR     DEFINE      0xFA41
DMA_UR2T_STA    DEFINE      0xFA42
DMA_UR2T_AMT    DEFINE      0xFA43
DMA_UR2T_DONE   DEFINE      0xFA44
DMA_UR2T_TXAH   DEFINE      0xFA45
DMA_UR2T_TXAL   DEFINE      0xFA46
DMA_UR2R_CFG    DEFINE      0xFA48
DMA_UR2R_CR     DEFINE      0xFA49
DMA_UR2R_STA    DEFINE      0xFA4A
DMA_UR2R_AMT    DEFINE      0xFA4B
DMA_UR2R_DONE   DEFINE      0xFA4C
DMA_UR2R_RXAH   DEFINE      0xFA4D
DMA_UR2R_RXAL   DEFINE      0xFA4E
DMA_UR3T_CFG    DEFINE      0xFA50
DMA_UR3T_CR     DEFINE      0xFA51
DMA_UR3T_STA    DEFINE      0xFA52
DMA_UR3T_AMT    DEFINE      0xFA53
DMA_UR3T_DONE   DEFINE      0xFA54
DMA_UR3T_TXAH   DEFINE      0xFA55
DMA_UR3T_TXAL   DEFINE      0xFA56
DMA_UR3R_CFG    DEFINE      0xFA58
DMA_UR3R_CR     DEFINE      0xFA59
DMA_UR3R_STA    DEFINE      0xFA5A
DMA_UR3R_AMT    DEFINE      0xFA5B
DMA_UR3R_DONE   DEFINE      0xFA5C
DMA_UR3R_RXAH   DEFINE      0xFA5D
DMA_UR3R_RXAL   DEFINE      0xFA5E
DMA_UR4T_CFG    DEFINE      0xFA60
DMA_UR4T_CR     DEFINE      0xFA61
DMA_UR4T_STA    DEFINE      0xFA62
DMA_UR4T_AMT    DEFINE      0xFA63
DMA_UR4T_DONE   DEFINE      0xFA64
DMA_UR4T_TXAH   DEFINE      0xFA65
DMA_UR4T_TXAL   DEFINE      0xFA66
DMA_UR4R_CFG    DEFINE      0xFA68
DMA_UR4R_CR     DEFINE      0xFA69
DMA_UR4R_STA    DEFINE      0xFA6A
DMA_UR4R_AMT    DEFINE      0xFA6B
DMA_UR4R_DONE   DEFINE      0xFA6C
DMA_UR4R_RXAH   DEFINE      0xFA6D
DMA_UR4R_RXAL   DEFINE      0xFA6E
DMA_LCM_CFG     DEFINE      0xFA70
DMA_LCM_CR      DEFINE      0xFA71
DMA_LCM_STA     DEFINE      0xFA72
DMA_LCM_AMT     DEFINE      0xFA73
DMA_LCM_DONE    DEFINE      0xFA74
DMA_LCM_TXAH    DEFINE      0xFA75
DMA_LCM_TXAL    DEFINE      0xFA76
DMA_LCM_RXAH    DEFINE      0xFA77
DMA_LCM_RXAL    DEFINE      0xFA78
DMA_LCM_ITVH    DEFINE      0xFA7E
DMA_LCM_ITVL    DEFINE      0xFA7F
DMA_M2M_AMTH    DEFINE      0xFA80
DMA_M2M_DONEH   DEFINE      0xFA81
DMA_ADC_AMTH    DEFINE      0xFA82
DMA_ADC_DONEH   DEFINE      0xFA83
DMA_SPI_AMTH    DEFINE      0xFA84
DMA_SPI_DONEH   DEFINE      0xFA85
DMA_LCM_AMTH    DEFINE      0xFA86
DMA_LCM_DONEH   DEFINE      0xFA87
DMA_UR1T_AMTH   DEFINE      0xFA88
DMA_UR1T_DONEH  DEFINE      0xFA89
DMA_UR1R_AMTH   DEFINE      0xFA8A
DMA_UR1R_DONEH  DEFINE      0xFA8B
DMA_UR2T_AMTH   DEFINE      0xFA8C
DMA_UR2T_DONEH  DEFINE      0xFA8D
DMA_UR2R_AMTH   DEFINE      0xFA8E
DMA_UR2R_DONEH  DEFINE      0xFA8F
DMA_UR3T_AMTH   DEFINE      0xFA90
DMA_UR3T_DONEH  DEFINE      0xFA91
DMA_UR3R_AMTH   DEFINE      0xFA92
DMA_UR3R_DONEH  DEFINE      0xFA93
DMA_UR4T_AMTH   DEFINE      0xFA94
DMA_UR4T_DONEH  DEFINE      0xFA95
DMA_UR4R_AMTH   DEFINE      0xFA96
DMA_UR4R_DONEH  DEFINE      0xFA97
DMA_I2CT_CFG    DEFINE      0xFA98
DMA_I2CT_CR     DEFINE      0xFA99
DMA_I2CT_STA    DEFINE      0xFA9A
DMA_I2CT_AMT    DEFINE      0xFA9B
DMA_I2CT_DONE   DEFINE      0xFA9C
DMA_I2CT_TXAH   DEFINE      0xFA9D
DMA_I2CT_TXAL   DEFINE      0xFA9E
DMA_I2CR_CFG    DEFINE      0xFAA0
DMA_I2CR_CR     DEFINE      0xFAA1
DMA_I2CR_STA    DEFINE      0xFAA2
DMA_I2CR_AMT    DEFINE      0xFAA3
DMA_I2CR_DONE   DEFINE      0xFAA4
DMA_I2CR_RXAH   DEFINE      0xFAA5
DMA_I2CR_RXAL   DEFINE      0xFAA6
DMA_I2CT_AMTH   DEFINE      0xFAA8
DMA_I2CT_DONEH  DEFINE      0xFAA9
DMA_I2CR_AMTH   DEFINE      0xFAAA
DMA_I2CR_DONEH  DEFINE      0xFAAB
DMA_I2C_CR      DEFINE      0xFAAD
DMA_I2C_ST1     DEFINE      0xFAAE
DMA_I2C_ST2     DEFINE      0xFAAF
DMA_I2ST_CFG    DEFINE      0xFAB0
DMA_I2ST_CR     DEFINE      0xFAB1
DMA_I2ST_STA    DEFINE      0xFAB2
DMA_I2ST_AMT    DEFINE      0xFAB3
DMA_I2ST_DONE   DEFINE      0xFAB4
DMA_I2ST_TXAH   DEFINE      0xFAB5
DMA_I2ST_TXAL   DEFINE      0xFAB6
DMA_I2SR_CFG    DEFINE      0xFAB8
DMA_I2SR_CR     DEFINE      0xFAB9
DMA_I2SR_STA    DEFINE      0xFABA
DMA_I2SR_AMT    DEFINE      0xFABB
DMA_I2SR_DONE   DEFINE      0xFABC
DMA_I2SR_RXAH   DEFINE      0xFABD
DMA_I2SR_RXAL   DEFINE      0xFABE
DMA_I2ST_AMTH   DEFINE      0xFAC0
DMA_I2ST_DONEH  DEFINE      0xFAC1
DMA_I2SR_AMTH   DEFINE      0xFAC2
DMA_I2SR_DONEH  DEFINE      0xFAC3
DMA_I2C_ITVH    DEFINE      0xFAC4
DMA_I2C_ITVL    DEFINE      0xFAC5
DMA_I2S_ITVH    DEFINE      0xFAC6
DMA_I2S_ITVL    DEFINE      0xFAC7
DMA_UR1_ITVH    DEFINE      0xFAC8
DMA_UR1_ITVL    DEFINE      0xFAC9
DMA_UR2_ITVH    DEFINE      0xFACA
DMA_UR2_ITVL    DEFINE      0xFACB
DMA_UR3_ITVH    DEFINE      0xFACC
DMA_UR3_ITVL    DEFINE      0xFACD
DMA_UR4_ITVH    DEFINE      0xFACE
DMA_UR4_ITVL    DEFINE      0xFACF
DMA_QSPI_CFG    DEFINE      0xFAD0
DMA_QSPI_CR     DEFINE      0xFAD1
DMA_QSPI_STA    DEFINE      0xFAD2
DMA_QSPI_AMT    DEFINE      0xFAD3
DMA_QSPI_DONE   DEFINE      0xFAD4
DMA_QSPI_TXAH   DEFINE      0xFAD5
DMA_QSPI_TXAL   DEFINE      0xFAD6
DMA_QSPI_RXAH   DEFINE      0xFAD7
DMA_QSPI_RXAL   DEFINE      0xFAD8
DMA_QSPI_AMTH   DEFINE      0xFADB
DMA_QSPI_DONEH  DEFINE      0xFADC
DMA_QSPI_ITVH   DEFINE      0xFADE
DMA_QSPI_ITVL   DEFINE      0xFADF
DMA_P2P_CR1     DEFINE      0xFAF0
DMA_P2P_CR2     DEFINE      0xFAF1
DMA_ARB_CFG     DEFINE      0xFAF8
DMA_ARB_STA     DEFINE      0xFAF9
QSPI_CR1        DEFINE      0xF900
QSPI_CR2        DEFINE      0xF901
QSPI_CR3        DEFINE      0xF902
QSPI_CR4        DEFINE      0xF903
QSPI_DCR1       DEFINE      0xF904
QSPI_DCR2       DEFINE      0xF905
QSPI_SR1        DEFINE      0xF906
QSPI_SR2        DEFINE      0xF907
QSPI_FCR        DEFINE      0xF908
QSPI_HCR1       DEFINE      0xF909
QSPI_HCR2       DEFINE      0xF90A
QSPI_DLR1       DEFINE      0xF910
QSPI_DLR2       DEFINE      0xF911
QSPI_CCR1       DEFINE      0xF914
QSPI_CCR2       DEFINE      0xF915
QSPI_CCR3       DEFINE      0xF916
QSPI_CCR4       DEFINE      0xF917
QSPI_AR1        DEFINE      0xF918
QSPI_AR2        DEFINE      0xF919
QSPI_AR3        DEFINE      0xF91A
QSPI_AR4        DEFINE      0xF91B
QSPI_ABR1       DEFINE      0xF91C
QSPI_DR         DEFINE      0xF920
QSPI_PSMKR1     DEFINE      0xF924
QSPI_PSMAR1     DEFINE      0xF928
QSPI_PIR1       DEFINE      0xF92C
QSPI_PIR2       DEFINE      0xF92D
PWMA_ENO2       DEFINE      0xF930
PWMA_IOAUX2     DEFINE      0xF931
PWMA_CR3        DEFINE      0xF932
PWMA_SR3        DEFINE      0xF933
PWMA_CCER3      DEFINE      0xF934
PWMA_CCMR1X     DEFINE      0xF938
PWMA_CCMR2X     DEFINE      0xF939
PWMA_CCMR3X     DEFINE      0xF93A
PWMA_CCMR4X     DEFINE      0xF93B
PWMA_CCMR5      DEFINE      0xF93C
PWMA_CCMR5X     DEFINE      0xF93D
PWMA_CCMR6      DEFINE      0xF93E
PWMA_CCMR6X     DEFINE      0xF93F
PWMA_CCR5H      DEFINE      0xF940
PWMA_CCR5L      DEFINE      0xF941
PWMA_CCR5X      DEFINE      0xF942
PWMA_CCR6H      DEFINE      0xF943
PWMA_CCR6L      DEFINE      0xF944
PWMA_DER        DEFINE      0xF948
PWMA_DBA        DEFINE      0xF949
PWMA_DBL        DEFINE      0xF94A
PWMA_DMACR      DEFINE      0xF94B
DMA_PWMAT_CFG   DEFINE      0xF980
DMA_PWMAT_CR    DEFINE      0xF981
DMA_PWMAT_STA   DEFINE      0xF982
DMA_PWMAT_AMTH  DEFINE      0xF984
DMA_PWMAT_AMT   DEFINE      0xF985
DMA_PWMAT_DONEH DEFINE      0xF986
DMA_PWMAT_DONE  DEFINE      0xF987
DMA_PWMAT_TXAH  DEFINE      0xF988
DMA_PWMAT_TXAL  DEFINE      0xF989
DMA_PWMA_ITVH   DEFINE      0xF98E
DMA_PWMA_ITVL   DEFINE      0xF98F
DMA_PWMAR_CFG   DEFINE      0xF990
DMA_PWMAR_CR    DEFINE      0xF991
DMA_PWMAR_STA   DEFINE      0xF992
DMA_PWMAR_AMTH  DEFINE      0xF994
DMA_PWMAR_AMT   DEFINE      0xF995
DMA_PWMAR_DONEH DEFINE      0xF996
DMA_PWMAR_DONE  DEFINE      0xF997
DMA_PWMAR_RXAH  DEFINE      0xF998
DMA_PWMAR_RXAL  DEFINE      0xF999

/////////////////////////////////////////////////

#endif /* __IAR_SYSTEMS_ASM__ */
#endif /* IOAI8051U_H */

#endif
