/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʾ5ʱʹ, ̾ʹ16λԶװ.

ʱ016λԶװ, жƵΪ1000HZжϺP0.7ȡ500HZź.

ʱ116λԶװ, жƵΪ2000HZжϺP0.6ȡ1000HZź.

ʱ216λԶװ, жƵΪ3000HZжϺP0.5ȡ1500HZź.

ʱ316λԶװ, жƵΪ4000HZжϺP0.4ȡ2000HZź.

ʱ416λԶװ, жƵΪ5000HZжϺP0.3ȡ2500HZź.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "../comm/AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

//==========================================================================

#define Timer0_Reload   (MAIN_Fosc / 1000)      //Timer 0 жƵ, 1000/
#define Timer1_Reload   (MAIN_Fosc / 2000)      //Timer 1 жƵ, 2000/
#define Timer2_Reload   (MAIN_Fosc / 3000)      //Timer 2 жƵ, 3000/
#define Timer3_Reload   (MAIN_Fosc / 4000)      //Timer 3 жƵ, 4000/
#define Timer4_Reload   (MAIN_Fosc / 5000)      //Timer 4 жƵ, 5000/

void    Timer0_init(void);
void    Timer1_init(void);
void    Timer2_init(void);
void    Timer3_init(void);
void    Timer4_init(void);

/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    P_SW2 |= EAXFR; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x0b;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    EA = 1;     //ж
    P40 = 0;		//LEDԴ
    
    Timer0_init();
    Timer1_init();
    Timer2_init();
    Timer3_init();
    Timer4_init();

    while (1);
}

//========================================================================
// : void Timer0_init(void)
// : timer0ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer0_init(void)
{
        TR0 = 0;    //ֹͣ

    #if (Timer0_Reload < 64)    // ûֵʣ ʱ
        #error "Timer0õжϹ!"

    #elif ((Timer0_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET0 = 1;    //ж
    //  PT0 = 1;    //ȼж
TMOD&=~0x03;
        TMOD |= 0;  //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
    //  TMOD |= T0_CT;  //
TMOD&=~T0_CT;//ʱ
    //  INTCLKO |= T0CLKO; //ʱ
INTCLKO&=~T0CLKO;//ʱ

        #if (Timer0_Reload < 65536UL)
            AUXR |= T0x12;  //1T mode
            TH0 = (u8)((65536UL - Timer0_Reload) / 256);
            TL0 = (u8)((65536UL - Timer0_Reload) % 256);
        #else
AUXR&=~T0x12;//12Tmode
            TH0 = (u8)((65536UL - Timer0_Reload/12) / 256);
            TL0 = (u8)((65536UL - Timer0_Reload/12) % 256);
        #endif

        TR0 = 1;    //ʼ

    #else
        #error "Timer0õжϹ!"
    #endif
}

//========================================================================
// : void Timer1_init(void)
// : timer1ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer1_init(void)
{
        TR1 = 0;    //ֹͣ

    #if (Timer1_Reload < 64)    // ûֵʣ ʱ
        #error "Timer1õжϹ!"

    #elif ((Timer1_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET1 = 1;    //ж
    //  PT1 = 1;    //ȼж
TMOD&=~0x30;
        TMOD |= (0 << 4);   //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ
    //  TMOD |= T1_CT;  //
TMOD&=~T1_CT;//ʱ
    //  INTCLKO |= T1CLKO; //ʱ
INTCLKO&=~T1CLKO;//ʱ

        #if (Timer1_Reload < 65536UL)
            AUXR |= T1x12;  //1T mode
            TH1 = (u8)((65536UL - Timer1_Reload) / 256);
            TL1 = (u8)((65536UL - Timer1_Reload) % 256);
        #else
AUXR&=~T1x12;//12Tmode
            TH1 = (u8)((65536UL - Timer1_Reload/12) / 256);
            TL1 = (u8)((65536UL - Timer1_Reload/12) % 256);
        #endif

        TR1 = 1;    //ʼ

    #else
        #error "Timer1õжϹ!"
    #endif
}

//========================================================================
// : void Timer2_init(void)
// : timer2ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer2_init(void)
{
AUXR&=~T2R;//ֹͣ

    #if (Timer2_Reload < 64)    // ûֵʣ ʱ
        #error "Timer2õжϹ!"

    #elif ((Timer2_Reload/12) < 65536UL)    // ûֵʣ ʱ
        IE2 |= ET2;    //ж
    //  AUXR |= T2_CT;  //
AUXR&=~T2_CT;//ʱ
    //  INTCLKO |= T2CLKO; //ʱ
INTCLKO&=~T2CLKO;//ʱ

        #if (Timer2_Reload < 65536UL)
            AUXR |= T2x12;    //1T mode
            T2H = (u8)((65536UL - Timer2_Reload) / 256);
            T2L = (u8)((65536UL - Timer2_Reload) % 256);
        #else
AUXR&=~T2x12;//12Tmode
            T2H = (u8)((65536UL - Timer2_Reload/12) / 256);
            T2L = (u8)((65536UL - Timer2_Reload/12) % 256);
        #endif

        AUXR |= T2R;    //ʼ

    #else
        #error "Timer2õжϹ!"
    #endif
}

//========================================================================
// : void Timer3_init(void)
// : timer3ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer3_init(void)
{
T4T3M&=~T3R;//ֹͣ

    #if (Timer3_Reload < 64)    // ûֵʣ ʱ
        #error "Timer3õжϹ!"

    #elif ((Timer3_Reload/12) < 65536UL)    // ûֵʣ ʱ
        IE2 |= ET3;    //ж
    //  T4T3M |= T3_CT;  //
T4T3M&=~T3_CT;//ʱ
    //  T4T3M |= T3CLKO; //ʱ
T4T3M&=~T3CLKO;//ʱ

        #if (Timer3_Reload < 65536UL)
            T4T3M |= T3x12;    //1T mode
            T3H = (u8)((65536UL - Timer3_Reload) / 256);
            T3L = (u8)((65536UL - Timer3_Reload) % 256);
        #else
T4T3M&=~T3x12;//12Tmode
            T3H = (u8)((65536UL - Timer3_Reload/12) / 256);
            T3L = (u8)((65536UL - Timer3_Reload/12) % 256);
        #endif

        T4T3M |= T3R;    //ʼ

    #else
        #error "Timer3õжϹ!"
    #endif
}

//========================================================================
// : void Timer4_init(void)
// : timer4ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer4_init(void)
{
T4T3M&=~T4R;//ֹͣ

    #if (Timer4_Reload < 64)    // ûֵʣ ʱ
        #error "Timer4õжϹ!"

    #elif ((Timer4_Reload/12) < 65536UL)    // ûֵʣ ʱ
        IE2 |= ET4;    //ж
    //  T4T3M |= T4_CT;  //
T4T3M&=~T4_CT;//ʱ
    //  T4T3M |= T4CLKO; //ʱ
T4T3M&=~T4CLKO;//ʱ

        #if (Timer4_Reload < 65536UL)
            T4T3M |= T4x12;    //1T mode
            T4H = (u8)((65536UL - Timer4_Reload) / 256);
            T4L = (u8)((65536UL - Timer4_Reload) % 256);
        #else
T4T3M&=~T4x12;//12Tmode
            T4H = (u8)((65536UL - Timer4_Reload/12) / 256);
            T4L = (u8)((65536UL - Timer4_Reload/12) % 256);
        #endif

        T4T3M |= T4R;    //ʼ

    #else
        #error "Timer4õжϹ!"
    #endif
}

//========================================================================
// : void timer0_int (void) interrupt TIMER0_VECTOR
// :  timer0жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer0_int (void) interrupt 1
INTERRUPT(timer0_int,TMR0_VECTOR)
{
   P07 = !P07;
}

//========================================================================
// : void timer1_int (void) interrupt TIMER1_VECTOR
// :  timer1жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer1_int (void) interrupt 3
INTERRUPT(timer1_int,TMR1_VECTOR)
{
   P06 = !P06;
}

//========================================================================
// : void timer2_int (void) interrupt TIMER2_VECTOR
// :  timer2жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer2_int (void) interrupt 12
INTERRUPT(timer2_int,TMR2_VECTOR)
{
    P05 = !P05;
}

//========================================================================
// : void timer3_int (void) interrupt TIMER3_VECTOR
// :  timer3жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer3_int(void) interrupt 19
INTERRUPT(timer3_int,TMR3_VECTOR)
{
    P04 = !P04;
}

//========================================================================
// : void timer4_int (void) interrupt TIMER4_VECTOR
// :  timer4жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
//void timer4_int(void) interrupt 20
INTERRUPT(timer4_int,TMR4_VECTOR)
{
    P03 = !P03;
}
