/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

2ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյͨ2յԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        22118400L   //ʱӣȷ115200ʣ

//==========================================================================

#define Baudrate2   (65536 - MAIN_Fosc / 115200 / 4)

#define UART2_BUF_LENGTH    128

//==========================================================================

/*************  س    **************/


/*************  IOڶ    **************/

/*************  ر    **************/

u8  TX2_Cnt;    //ͼ
u8  RX2_Cnt;    //ռ
bit B_TX2_Busy; //æ־

u8  RX2_Buffer[UART2_BUF_LENGTH]; //ջ

/*************  غ    **************/

void UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void PrintString2(u8 *puts);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    P40 = 0;
    P0 = 1;
    UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
    EA = 1;             //ȫж
    
    PrintString2("AI8051U UART2 Test Programme!\r\n");  //UART2һַ

    while (1)
    {
        if((TX2_Cnt != RX2_Cnt) && (!B_TX2_Busy))   //յ, Ϳ
        {
            P00 = !P00;
            S2BUF = RX2_Buffer[TX2_Cnt];
            B_TX2_Busy = 1;
            if(++TX2_Cnt >= UART2_BUF_LENGTH)   TX2_Cnt = 0;
        }
    }
}

//========================================================================
// : void PrintString2(u8 *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString2(u8 *puts)
{
    u8 i = 0;
    for (i=0; (*puts) != 0;  puts++)     //ֹͣ0
    {
        S2BUF = *puts;
        B_TX2_Busy = 1;
        while(B_TX2_Busy);
    }
}

//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)
{
    AUXR &= ~(1<<4);		//Timer stop
    AUXR &= ~(1<<3);	//Timer2 set As Timer
    AUXR |= (1<<2);	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);		//Timer run enable
}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    if(brt == 2)
    {
        SetTimer2Baudraye(Baudrate2);

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
        IE2 |= ES2;         //ж
        S2CON |= S2REN;         //
        P_SW2 |= S2_S;         //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3

        B_TX2_Busy = 0;
        TX2_Cnt = 0;
        RX2_Cnt = 0;
    }
}

//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
//void UART2_int (void) interrupt 8
INTERRUPT(UART2_int,UART2_VECTOR)
{
    if(S2CON & S2RI)
    {
        S2CON &= ~S2RI;    //Clear Rx flag
        RX2_Buffer[RX2_Cnt] = S2BUF;
        if(++RX2_Cnt >= UART2_BUF_LENGTH)   RX2_Cnt = 0;
    }

    if(S2CON & S2TI)
    {
        S2CON &= ~S2TI;    //Clear Tx flag
        B_TX2_Busy = 0;
    }
}

