/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

3ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյͨ3յԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        22118400L   //ʱӣȷ115200ʣ

//==========================================================================

#define Baudrate3   (65536 - MAIN_Fosc / 115200 / 4)

#define UART3_BUF_LENGTH    64

//==========================================================================

/*************  س    **************/


/*************  IOڶ    **************/

/*************  ر    **************/

u8  TX3_Cnt;    //ͼ
u8  RX3_Cnt;    //ռ
bit B_TX3_Busy; //æ־

u8  RX3_Buffer[UART3_BUF_LENGTH]; //ջ

/*************  غ    **************/

void    UART3_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
void    PrintString3(u8 *puts);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART3_config(0);    //ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
    EA = 1;             //ȫж

    PrintString3("AI8051U UART3 Test Programme!\r\n");  //UART3һַ

    while (1)
    {
        if((TX3_Cnt != RX3_Cnt) && (!B_TX3_Busy))   //յ, Ϳ
        {
            S3BUF = RX3_Buffer[TX3_Cnt];
            B_TX3_Busy = 1;
            if(++TX3_Cnt >= UART3_BUF_LENGTH)   TX3_Cnt = 0;
        }
    }
}

//========================================================================
// : void PrintString3(u8 *puts)
// : 3ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString3(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        S3BUF = *puts;
        B_TX3_Busy = 1;
        while(B_TX3_Busy);
    }
}

//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)  // ʹTimer2.
{
    AUXR &= ~(1<<4);		//Timer stop
    AUXR &= ~(1<<3);	//Timer2 set As Timer
    AUXR |= (1<<2);	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);		//Timer run enable
}

//========================================================================
// : void UART3_config(u8 brt)
// : UART3ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART3_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
{
    if(brt == 2)
    {
        SetTimer2Baudraye(Baudrate3);
        S3CON = 0x10;       //8λ, ʹTimer2ʷ, 
    }
    else
    {
        T4T3M &= ~(1<<3);		//Timer stop
        S3CON = 0x50;       //8λ, ʹTimer3ʷ, 
        T3H = (u8)(Baudrate3 / 256);
        T3L = (u8)(Baudrate3 % 256);
        T4T3M &= ~(1<<2);	//Timer3 set As Timer
        T4T3M |= (1<<1);	//Timer3 set as 1T mode
        T4T3M = (T4T3M & ~0x08) | (1<< 3);		//Timer run enable
    }
    IE2 |= ES3;       //UART3ж
    P_SW2 |= S3_S;       //UART3 switch bit1 to: 0: P0.0 P0.1,  1: P5.0 P5.1

    B_TX3_Busy = 0;
    TX3_Cnt = 0;
    RX3_Cnt = 0;
}


//========================================================================
// : void UART3_int (void) interrupt UART3_VECTOR
// : UART3жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
//void UART3_int (void) interrupt 17
INTERRUPT(UART3_int,UART3_VECTOR)
{
    if(S3CON & S3RI)
    {
        S3CON &= ~S3RI;    //Clear Rx flag
        RX3_Buffer[RX3_Cnt] = S3BUF;
        if(++RX3_Cnt >= UART3_BUF_LENGTH)   RX3_Cnt = 0;
    }

    if(S3CON & S3TI)
    {
        S3CON &= ~S3TI;   //Clear Tx flag
        B_TX3_Busy = 0;
    }
}

