/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбд.

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ôڴӡINTжϼINT0ܿƽӿڸãʾ

(P30,P31)Ĭã115200,N,8,1ʹıģʽӡ.

ڰǻе, ж, ûȥ, ԰һжҲ.

INT2, INT3, INT4 ʵû԰Ҫʱοʹ.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

//==========================================================================

#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/
#define Baudrate      115200L
#define TM            (65536 -(MAIN_Fosc/Baudrate/4))
#define PrintUart     2        //1:printf ʹ UART1; 2:printf ʹ UART2

/*************  ر    **************/

bit int0Flag;
bit int1Flag;
bit int2Flag;
bit int3Flag;
bit int4Flag;
u8  INT0_cnt, INT1_cnt; //õļ
u8  INT2_cnt, INT3_cnt, INT4_cnt; //õļ

/******************** ڴӡ ********************/
void UartInit(void)
{
#if(PrintUart == 1)
P_SW1&=~S1_S1;//UART1switchto,0x00:P3.0P3.1,0x40:P3.6P3.7,0x80:P1.6P1.7,0xC0:P4.3P4.4
P_SW1&=~S1_S0;
    SCON = (SCON & 0x3f) | 0x40; 
    AUXR |= (1<<6);      //ʱʱ1Tģʽ
AUXR&=~S1BRT;//1ѡʱ1Ϊʷ
    TL1  = TM;
    TH1  = TM>>8;
    TR1 = 1;        //ʱ1ʼʱ

//    SCON = (SCON & 0x3f) | 0x40; 
//    T2L  = TM;
//    T2H  = TM>>8;
//    AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
    P_SW2 |= S2_S;       //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
    S2CON = (S2CON & 0x3f) | 0x40; 
    T2L  = TM;
    T2H  = TM>>8;
    AUXR |= 0x14;   //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
    SBUF = dat; 
    while(TI==0);
    TI = 0;
#else
    S2BUF  = dat; 
while((S2CON & S2TI)==0);
S2CON&=~S2TI;//ClearTxflag
#endif
}

//char putchar(char c)
PUTCHAR_FUN()
{
    UartPutc(c);
    return c;
}

/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    P3PU = 0x0c;    //P3.2,P3.3ʹڲ

    UartInit();
    
    INT0_cnt = 0;
    INT1_cnt = 0;

    IE1  = 0;   //ж1־λ
    IE0  = 0;   //ж0־λ
    EX1 = 1;    //INT1 Enable
    EX0 = 1;    //INT0 Enable

    IT0 = 1;    //INT0 ½ж
//  IT0 = 0;    //INT0 ,½ж  
    IT1 = 1;    //INT1 ½ж
//  IT1 = 0;    //INT1 ,½ж  

    //INT2, INT3, INT4 ʵû԰Ҫʱοʹ
    INTCLKO |= EX2;    //ʹ INT2 ½ж
    INTCLKO |= EX3;    //ʹ INT3 ½ж
    INTCLKO |= EX4;    //ʹ INT4 ½ж

    EA = 1;     //ж

    while(1)
    {
        if(int0Flag)
        {
            int0Flag = 0;
            printf("int0 cnt=%bu\r\n",INT0_cnt);
        }

        if(int1Flag)
        {
            int1Flag = 0;
            printf("int1 cnt=%bu\r\n",INT1_cnt);
        }
    }
}

/********************* INT0жϺ *************************/
//void INT0_int (void) interrupt 0      //жʱѾ־
INTERRUPT(INT0_int,INT0_VECTOR)
{
    INT0_cnt++; //ж+1
    int0Flag = 1;
}

/********************* INT1жϺ *************************/
//void INT1_int (void) interrupt 2      //жʱѾ־
INTERRUPT(INT1_int,INT1_VECTOR)
{
    INT1_cnt++; //ж+1
    int1Flag = 1;
}

/********************* INT2жϺ *************************/
//void INT2_int (void) interrupt 10     //жʱѾ־
INTERRUPT(INT2_int,INT2_VECTOR)
{
    INT2_cnt++; //ж+1
    int2Flag = 1;
}

/********************* INT3жϺ *************************/
//void INT3_int (void) interrupt 11     //жʱѾ־
INTERRUPT(INT3_int,INT3_VECTOR)
{
    INT3_cnt++; //ж+1
    int3Flag = 1;
}

/********************* INT4жϺ *************************/
//void INT4_int (void) interrupt 16     //жʱѾ־
INTERRUPT(INT4_int,INT4_VECTOR)
{
    INT4_cnt++; //ж+1
    int4Flag = 1;
}
