#include "FreeRTOS.h"
#include "task.h"

#include "adc.h"

void vAdcInit( void )
{
    ADCTIM = 0x3f;		                                // ADC ڲʱADCʱ佨ֵ
    ADCCFG = 0x2f;		                                // ADC ʱΪϵͳʱ/2/16/16
    ADC_CONTR = 0x80;                                   //ʹ ADC ģ
}

//========================================================================
// : uint16_t usAdcGetResult(uint8_t ucChannel)
// : ѯһADC.
// : ucChannel: ѡҪתADC.
// : 12λADC.
// 汾: V1.0, 2012-10-22
//========================================================================
uint16_t usAdcGetResult(uint8_t ucChannel)              //ucChannel:ADCͨ,ȡֵΧ0~15
{
    uint16_t usResult;

    ADC_RES = 0;
    ADC_RESL = 0;

    ADC_CONTR = (ADC_CONTR & 0xF0) | 0x40 | ucChannel;  // AD ת
    _nop_();
    _nop_();
    _nop_();
    _nop_();

    while((ADC_CONTR & 0x20) == 0);                     //ȴADCת
    ADC_CONTR &= ~0x20;                                 //ADC־
    usResult = (((uint16_t)ADC_RES << 8) | ADC_RESL);

    return usResult;
}
