/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/


/*************  ˵    **************

̻STC32GΪоƬʵ9бд.

̽ʵϵJ7J8߽в.

3ʱһݸ2.

2Ӵ3յ.

2ݣMCUյӴ2ԭ.

******************************************/

#include "FreeRTOS.h"
#include "task.h"

#include "uart2_3.h"

/****************************** û ***********************************/

#define Baudrate2   (65536 - MAIN_Fosc / 115200 / 4)
#define Baudrate3   (65536 - MAIN_Fosc / 115200 / 4)

#define UART2_BUF_LENGTH    64
#define UART3_BUF_LENGTH    64

bit B_TX2_Busy; //æ־
bit B_TX3_Busy; //æ־
uint8_t  TX2_Send;   //ѷ
uint8_t  TX2_Cnt;    //ͼ
uint8_t  RX2_Cnt;    //ռ
uint8_t  TX3_Send;   //ѷ
uint8_t  TX3_Cnt;    //ͼ
uint8_t  RX3_Cnt;    //ռ
uint8_t  RX2_TimeOut;
uint8_t  RX3_TimeOut;

uint8_t  TX2_Buffer[UART2_BUF_LENGTH]; //ջ
uint8_t  RX2_Buffer[UART2_BUF_LENGTH]; //ջ
uint8_t  TX3_Buffer[UART3_BUF_LENGTH]; //ջ
uint8_t  RX3_Buffer[UART3_BUF_LENGTH]; //ջ

uint16_t Sec_Cnt;    //1

void UART2_config(uint8_t brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void UART3_config(uint8_t brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
void UART2_TxByte(uint8_t dat);
void UART3_TxByte(uint8_t dat);
void PrintString2(uint8_t *puts);
void PrintString3(uint8_t *puts);

/* RTC */
portTASK_FUNCTION_PROTO( vUart2_3Task, pvParameters )
{
    uint8_t i;
    
    Sec_Cnt = 0;
    UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
    UART3_config(3);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.

    PrintString2("STC32G UART2-UART3 Test Programme!\r\n");  //UART2һַ
    PrintString3("STC32G UART3-UART2 Test Programme!\r\n");  //UART3һַ
    while(1)
    {
        Sec_Cnt++;
        if(Sec_Cnt >= (uint16_t)pvParameters)
        {
            Sec_Cnt = 0;
            PrintString3("STC32G UART3-UART2 Test Programme!\r\n");  //UART3һַ
        }

        if(RX2_TimeOut > 0)     //ʱ
        {
            if(--RX2_TimeOut == 0)
            {
                for(i=0; i<RX2_Cnt; i++)    UART2_TxByte(RX2_Buffer[i]);    //յͨ2
                RX2_Cnt  = 0;   //ֽ
            }
        }
        
        vTaskDelay(1);
    }
    
    vTaskDelete(NULL);
}   

//========================================================================
// : void UART2_TxByte(uint8_t dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART2_TxByte(uint8_t dat)
{
	TX2_Buffer[TX2_Cnt] = dat;	//װͻ
	if(++TX2_Cnt >= UART2_BUF_LENGTH)	TX2_Cnt = 0;

	if(B_TX2_Busy == 0)		//
	{  
		B_TX2_Busy = 1;		//־æ
		S2TI = 1;			//ж
	}
}

//========================================================================
// : void UART3_TxByte(uint8_t dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART3_TxByte(uint8_t dat)
{
	TX3_Buffer[TX3_Cnt] = dat;	//װͻ
	if(++TX3_Cnt >= UART3_BUF_LENGTH)	TX3_Cnt = 0;

	if(B_TX3_Busy == 0)		//
	{  
		B_TX3_Busy = 1;		//־æ
		S3TI = 1;			//ж
	}
}

//========================================================================
// : void PrintString2(uint8_t *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString2(uint8_t *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        UART2_TxByte(*puts);
    }
}

//========================================================================
// : void PrintString3(uint8_t *puts)
// : 3ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString3(uint8_t *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        UART3_TxByte(*puts);
    }
}

//========================================================================
// : SetTimer2Baudraye(uint16_t dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(uint16_t dat)
{
    T2R = 0;		//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = (uint8_t)(dat / 256);
    T2L = (uint8_t)(dat % 256);
    ET2 = 0;    //ֹж
    T2R = 1;		//Timer run enable
}

//========================================================================
// : void UART3_config(uint8_t brt)
// : UART3ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART3_config(uint8_t brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
{
    if(brt == 2)
    {
        SetTimer2Baudraye((uint16_t)Baudrate3);
        S3CON = 0x10;       //8λ, ʹTimer2ʷ, 
    }
    else
    {
        T3R = 0;		//Timer stop
        S3CON = 0x50;       //8λ, ʹTimer3ʷ, 
        T3H = (uint8_t)(Baudrate3 / 256);
        T3L = (uint8_t)(Baudrate3 % 256);
        T3_CT = 0;	//Timer3 set As Timer
        T3x12 = 1;	//Timer3 set as 1T mode
        T3R = 1;		//Timer run enable
    }
    ES3  = 1;       //UART3ж
    S3_S = 1;       //UART3 switch bit1 to: 0: P0.0 P0.1,  1: P5.0 P5.1

    B_TX3_Busy = 0;
    TX3_Send = 0;
    TX3_Cnt = 0;
    RX3_Cnt = 0;
}

//========================================================================
// : void UART2_config(uint8_t brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(uint8_t brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    if(brt == 2)
    {
        SetTimer2Baudraye((uint16_t)Baudrate2);

        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
        ES2   = 1;         //ж
        S2REN = 1;         //
        S2_S  = 1;         //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7

        B_TX2_Busy = 0;
        TX2_Send = 0;
        TX2_Cnt = 0;
        RX2_Cnt = 0;
    }
}

//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_int (void) interrupt UART2_VECTOR
{
    if(S2RI)
    {
        S2RI = 0;    //Clear Rx flag
        if(RX2_Cnt >= UART2_BUF_LENGTH)  RX2_Cnt = 0;
        RX2_Buffer[RX2_Cnt] = S2BUF;
        RX2_Cnt++;
        RX2_TimeOut = 5;
    }

    if(S2TI)
    {
        S2TI = 0;    //Clear Tx flag
        if(TX2_Send != TX2_Cnt)
        {
            S2BUF = TX2_Buffer[TX2_Send];
            if(++TX2_Send >= UART2_BUF_LENGTH)  TX2_Send = 0;
        }
        else
        {
            B_TX2_Busy = 0;
        }
    }
}

//========================================================================
// : void UART3_int (void) interrupt UART3_VECTOR
// : UART3жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART3_int (void) interrupt UART3_VECTOR
{
    if(S3RI)
    {
        S3RI = 0;    //Clear Rx flag
        RX3_Buffer[RX3_Cnt] = S3BUF;
        if(++RX3_Cnt >= UART3_BUF_LENGTH)   RX3_Cnt = 0;
        RX3_TimeOut = 5;
    }

    if(S3TI)
    {
        S3TI = 0;   //Clear Tx flag
        if(TX3_Send != TX3_Cnt)
        {
            S3BUF = TX3_Buffer[TX3_Send];
            if(++TX3_Send >= UART3_BUF_LENGTH)  TX3_Send = 0;
        }
        else
        {
            B_TX3_Busy = 0;
        }
    }
}
