/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#ifndef __STC32G_USART_H
#define __STC32G_USART_H	 

#include	"FreeRTOS.h"

//========================================================================
//                              
//========================================================================

#define	USART1	1
#define	USART2	2

#define FRAME_LEN       8    //ݳ: 8 ֽ

#define	LinMasterMode		0
#define	LinSlaveMode		1

//========================================================================
//                              USART
//========================================================================


//========================================================================
//                              
//========================================================================

typedef struct
{ 
	uint8_t	LIN_Enable;				//LINʹ  	ENABLE,DISABLE
	uint8_t	LIN_Mode;					//LINģʽ  	LinMasterMode,LinSlaveMode
	uint8_t	LIN_AutoSync;			//Զͬʹ  	ENABLE,DISABLE
	uint16_t	LIN_Baudrate;			//LIN
} USARTx_LIN_InitDefine; 

//========================================================================
//                              ⲿ
//========================================================================

uint8_t UASRT_LIN_Configuration(uint8_t USARTx, USARTx_LIN_InitDefine *USART);
void UsartLinSendChecksum(uint8_t USARTx, uint8_t *dat);
void UsartLinSendData(uint8_t USARTx, uint8_t *pdat);
void UsartLinSendFrame(uint8_t USARTx, uint8_t lid, uint8_t *pdat);
void UsartLinSendHeader(uint8_t USARTx, uint8_t lid);

#endif

