/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include "STC32G_LIN.h"

//========================================================================
// : uint8_t ReadReg(uint8_t addr)
// : LinܼĴȡ
// : LinܼĴַ.
// : LinܼĴ.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
uint8_t LinReadReg(uint8_t addr)
{
	uint8_t dat;
	LINAR = addr;
	dat = LINDR;
	return dat;
}

//========================================================================
// : void WriteReg(uint8_t addr, uint8_t dat)
// : LinܼĴú
// : LinܼĴַ, LinܼĴ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinWriteReg(uint8_t addr, uint8_t dat)
{
	LINAR = addr;
	LINDR = dat;
}

//========================================================================
// : void LinReadMsg(uint8_t *pdat)
// : Linȡݺ
// : *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinReadMsg(uint8_t *pdat)
{
	uint8_t i;

	LinWriteReg(LSEL,0x80);	//ַ0ʼ
	for(i=0;i<FRAME_LEN;i++)
	{
		pdat[i] = LinReadReg(LBUF);
	}
}

//========================================================================
// : void LinSendMsg(uint8_t *pdat)
// : Linݺ
// : *pdat: ݻ.
// : Lin ID.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSendMsg(uint8_t *pdat)
{
	uint8_t i;

	LinWriteReg(LSEL,0x80);		//ַ0ʼ
	for(i=0;i<FRAME_LEN;i++)
	{
		LinWriteReg(LBUF,pdat[i]);
	}
}

//========================================================================
// : void LinSetID(uint8_t lid)
// : LIN ID
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetID(uint8_t lid)
{
	LinWriteReg(LID,lid);			//ID
}

//========================================================================
// : uint8_t GetLinError(void)
// : ȡLINߴĴ״̬
// : none.
// : Ĵ״̬.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
uint8_t GetLinError(void)
{
	uint8_t sta;
	sta = LinReadReg(LER);		//ȡĴ
	return sta;
}

//========================================================================
// : uint8_t WaitLinReady(void)
// : ȴLIN߾
// : none.
// : LIN״̬.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
uint8_t WaitLinReady(void)
{
	uint8_t lsr;
	do{
		lsr = LinReadReg(LSR);
	}while(!(lsr & 0x02));		//жready״̬
	return lsr;
}

//========================================================================
// : void SendAbortCmd(void)
// : ģʽLinAbort
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendAbortCmd(void)
{
	LinWriteReg(LCR,0x80);		//ģʽ Send Abort
}

//========================================================================
// : void SendHeadCmd(void)
// : ģʽLinHeader
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendHeadCmd(void)
{
	LinWriteReg(LCR,0x81);		//ģʽ Send Header
}

//========================================================================
// : void SendDatCmd(void)
// : ģʽLinݺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendDatCmd(void)
{
	uint8_t lcr_val;
	lcr_val = 0x82+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void ResponseTxCmd(void)
// : ģʽLinTx Response
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void ResponseTxCmd(void)
{
	uint8_t lcr_val;
	lcr_val = 0x02+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void ResponseRxCmd(void)
// : ģʽLinRx Response
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void ResponseRxCmd(void)
{
	uint8_t lcr_val;
	lcr_val = 0x03+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void LinTxResponse(uint8_t *pdat)
// : LinӻӦݣ͵Headerƴһ֡
// : *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinTxResponse(uint8_t *pdat)
{
	LinSendMsg(pdat);
	ResponseTxCmd();					//TX response
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ
}

//========================================================================
// : void LinReadFrame(uint8_t *pdat)
// : Lin֡
// : lid: Lin ID; *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinReadFrame(uint8_t *pdat)
{
	ResponseRxCmd();					//RX response
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ

	LinReadMsg(pdat);					//Lin
}

//========================================================================
// : void LinSendFrame(uint8_t lid, uint8_t *pdat)
// : Lin֡
// : lid: Lin ID; *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSendFrame(uint8_t lid, uint8_t *pdat)
{
	LinSetID(lid);						//ID
	LinSendMsg(pdat);

	SendHeadCmd();						//ģʽ Send Seader
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ

	SendDatCmd();							//Send Data
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ
}

//========================================================================
// : void LinSendHeaderRead(uint8_t lid, uint8_t *pdat)
// : LinHeaderɴӻӦݣƴһ֡
// : lid: ӦӻID; *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSendHeaderRead(uint8_t lid, uint8_t *pdat)
{
	LinSetID(lid);						//÷ResponseӻID

	SendHeadCmd();						//ģʽ send header
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ
	
	ResponseRxCmd();					//RX response
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ

	LinReadMsg(pdat);				//Linߴӻ͵Ӧ
}

//========================================================================
// : void LinSetBaudrate(uint16_t brt)
// : Lin߲ú
// : brt: .
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetBaudrate(uint16_t brt)
{
	uint16_t tmp;
	tmp = (MAIN_Fosc >> 4) / brt;
	LinWriteReg(DLH,(uint8_t)(tmp>>8));
	LinWriteReg(DLL,(uint8_t)tmp);
}

//========================================================================
// : void LinSetHeadDelay(uint8_t base_ms, uint8_t prescaler)
// : Lin֡ͷʱ
// : base_ms:ʱ, prescaler:ʱƵ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetHeadDelay(uint8_t base_ms, uint8_t prescaler)
{
	uint16_t tmp;
	tmp = (MAIN_Fosc * base_ms) / 1000;
	LinWriteReg(HDRH,(uint8_t)(tmp>>8));
	LinWriteReg(HDRL,(uint8_t)tmp);		//֡ͷʱ

	LinWriteReg(HDP,prescaler);		//֡ͷʱƵ
}

//========================================================================
// : void LIN_Inilize(LIN_InitTypeDef *LIN)
// : LIN ʼ.
// : LIN: ṹ,οLIN.hĶ.
// : none.
// 汾: V1.0, 2021-06-02
//========================================================================
void LIN_Inilize(LIN_InitTypeDef *LIN)
{
	if(LIN->LIN_Enable == ENABLE)	LINEN = 1;		//ʹLINģ
	else								LINEN = 0;		//رLINģ

	GetLinError();						//ȡĴ
	LinWriteReg(LIE,LIN->LIN_IE);		//LIEжʹܼĴ
	LinSetBaudrate(LIN->LIN_Baudrate);	//ò
	LinSetHeadDelay(LIN->LIN_HeadDelay,LIN->LIN_HeadPrescaler);	//֡ͷʱ
}
