
/*
 * FreeRTOS STC port V1.0.2
 * 
 * STC32G12K128ܼ飺
 *    2 CAN, 3Lin, USB, 32λ 8051, RMB5,
 *    ߾׼12λADC, DMA ֧(TFT, ADC, 4鴮, SPI, I2C )
 *  
 *  λûںʹùУвȷĵط
 *  пɸƵĵطSTCϵSTCٷͳһ޸Ĳ°汾
 *
 *  ĴҪñеĲֲ룬
 *  עοʹSTCFreeRTOSֲ
*/

#include "FreeRTOS.h"
#include "task.h"

#include "display.h"
#include "rtc.h"
#include "ntc.h"
#include "adckey.h"
#include "uart2_3.h"
#include "MatrixKey.h"
#include "DebugPrintf.h"
#include "usb_cdc.h"

void vSystemInit( void );

void main( void )
{
    /* ϵͳʼ */
    vSystemInit();

	/*  */
    xTaskCreate((TaskFunction_t )vDisplayTask,
                (const char*    )"DISPLAY",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )NULL,
                (UBaseType_t    )(configDEFAULT_PRIORITIES + 1),
                (TaskHandle_t*  )NULL);
    xTaskCreate((TaskFunction_t )vRtcTask,
                (const char*    )"RTC",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )NULL,
                (UBaseType_t    )(configDEFAULT_PRIORITIES + 1),
                (TaskHandle_t*  )NULL);
    xTaskCreate((TaskFunction_t )vAdcKeyTask,
                (const char*    )"ADCKEY",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )NULL,
                (UBaseType_t    )(configDEFAULT_PRIORITIES),
                (TaskHandle_t*  )NULL);
    xTaskCreate((TaskFunction_t )vNtcTask,
                (const char*    )"NTC",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )NULL,
                (UBaseType_t    )(configDEFAULT_PRIORITIES),
                (TaskHandle_t*  )NULL);
    xTaskCreate((TaskFunction_t )vUart2_3Task,
                (const char*    )"UART2_3",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )1000,  //עpvParametersַʱֻе24λЧλ8λʱԶ0. ͨ߳32ֽ.
                (UBaseType_t    )(configDEFAULT_PRIORITIES),
                (TaskHandle_t*  )NULL);
    xTaskCreate((TaskFunction_t )vMatrixKeyTask,
                (const char*    )"MatrixKey",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )NULL,
                (UBaseType_t    )(configDEFAULT_PRIORITIES),
                (TaskHandle_t*  )NULL);
    xTaskCreate((TaskFunction_t )vUsb_CdcTask,
                (const char*    )"USB_CDC",
                (uint16_t       )configDEFAULT_STACK_SIZE,
                (void*          )NULL,
                (UBaseType_t    )(configDEFAULT_PRIORITIES + 2),
                (TaskHandle_t*  )NULL);

    /* ʼ */
    vTaskStartScheduler();

    /* ²е˴ */
    while (1);
}

/* ϵͳʼ */
void vSystemInit( void )
{
    WTST = 0;     //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1;    //չĴ(XFR)ʹ
    CKCON = 0;    //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;     //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;     //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;     //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;     //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;     //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;     //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;     //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;     //Ϊ׼˫
    
//    DebugPrintfInit();
//    printf("STC32G FreeRTOS Գ!\r\n");
}
