/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#ifndef	__STC32G_LIN_H
#define	__STC32G_LIN_H

#include	"FreeRTOS.h"

//========================================================================
//                              
//========================================================================

#define LIN_MODE        1    //0: LIN2.1(ǿУ);  1: LIN1.3
#define FRAME_LEN       8    //ݳ: 8 ֽ

//========================================================================
//                              
//========================================================================

#define LIN_LIDE     0x01  //Headж
#define LIN_RDYE     0x02  //Readyж
#define LIN_ERRE     0x04  //ж
#define LIN_ABORTE   0x08  //ֹж
#define LIN_ALLIE    0x0F  //ж

//========================================================================
//                              
//========================================================================

typedef struct
{
	uint8_t	LIN_Enable;			//LINʹ  	ENABLE,DISABLE
	uint16_t LIN_Baudrate;		//LIN
	uint8_t	LIN_IE;				//LINжʹ  	LIN_LIDE/LIN_RDYE/LIN_ERRE/LIN_ABORTE/LIN_ALLIE,DISABLE
	uint8_t	LIN_HeadDelay;		//֡ͷʱ  	0~(65535*1000)/MAIN_Fosc
	uint8_t	LIN_HeadPrescaler;	//֡ͷʱƵ  	0~63
} LIN_InitTypeDef;


//========================================================================
//                              ⲿ
//========================================================================

void LIN_Inilize(LIN_InitTypeDef *LIN);
uint8_t LinReadReg(uint8_t addr);
void LinReadFrame(uint8_t *pdat);
void LinSendFrame(uint8_t lid, uint8_t *pdat);
void LinSendHeaderRead(uint8_t lid, uint8_t *pdat);
void LinTxResponse(uint8_t *pdat);

#endif
