
/*
 * FreeRTOS STC port V1.0.2
 * 
 * STC32G12K128ܼ飺
 *    2 CAN, 3Lin, USB, 32λ 8051, RMB5,
 *    ߾׼12λADC, DMA ֧(TFT, ADC, 4鴮, SPI, I2C )
 *  
 *  λûںʹùУвȷĵط
 *  пɸƵĵطSTCϵSTCٷͳһ޸Ĳ°汾
 *
 *  ĴҪñеĲֲ룬
 *  עοʹSTCFreeRTOSֲ
*/

#include "FreeRTOS.h"
#include "task.h"
#include "System_init.h"

#include "display.h"
#include "rtc.h"
#include "ntc.h"
#include "adckey.h"
#include "uart2_3.h"
#include "MatrixKey.h"
#include "i2c_ps.h"
#include "pwmb.h"
#include "gfx.h"
#include "lcd.h"
#include "gui.h"
#include "stdlib.h"

/* Handle for the initialization task to delete itself. */
TaskHandle_t uGFXInitTask;
extern uint32_t  tim_cnt;

//ɫ
//#define WHITE       0xFFFF	//ɫ
//#define BLACK      	0x0000	//ɫ	  
//#define BLUE       	0x001F	//ɫ  
//#define BRED        0XF81F
//#define GRED 		0XFFE0
//#define GBLUE		0X07FF	//
//#define RED         0xF800	//ɫ
//#define MAGENTA     0xF81F	// Ʒ Ϻ
//#define GREEN       0x07E0	//ɫ
//#define CYAN        0x7FFF	//ɫ
//#define YELLOW      0xFFE0	//ɫ
//#define BROWN 		0XBC40	//ɫ
//#define BRRED 		0XFC07	//غɫ
//#define GRAY  		0X8430	//ɫ

#define KEY_TIMER 30        //ʱ(ms)

sbit KEY1 = P5 ^ 4;
sbit KEY2 = P3 ^ 2;
sbit KEY3 = P3 ^ 3;
sbit KEY4 = P3 ^ 5;

uint16_t Key1_cnt;
uint16_t Key2_cnt;
uint16_t Key3_cnt;
uint16_t Key4_cnt;
bit Key1_Flag;
bit Key2_Flag;
bit Key3_Flag;
bit Key4_Flag;

uint8_t DisplayMode;

#if 0
static int uitoa(uint32_t value, char * buf, int max) {
    int n = 0;
    int i = 0;
    unsigned int tmp = 0;

    if (!buf)
        return -3;

    if (2 > max)
        return -4;

    i=1;
    tmp = value;
    if (0 > tmp) {
        tmp *= -1;
        i++;
    }
    for (;;) {
        tmp /= 10;
        if (0 >= tmp)
            break;
        i++;
    }
    if (i >= max) {
        buf[0] = '?';
        buf[1] = 0x0;
        return 2;
    }

    n = i;
    tmp = value;
    if (0 > tmp) {
        tmp *= -1;
    }
    buf[i--] = 0x0;
    for (;;) {
        buf[i--] = (tmp % 10) + '0';
        tmp /= 10;
        if (0 >= tmp) {
            break;
        }
    }
    if (-1 != i) {
        buf[i--] = '-';
    }

    return n;
}
#endif

void benchmark(void) {
    uint32_t i;
	coord_t height, width, rx, ry, rcx, rcy;
    color_t random_color;
	font_t font;

    gdispSetOrientation(GDISP_ROTATE_90);

	width = gdispGetWidth();
	height = gdispGetHeight();
	
	gfxSleepMilliseconds(1000);
	
    /* seed for the rand() */
    srand((uint16_t)tim_cnt);

    switch(DisplayMode)
    {
        case 1:
            gdispFillArea(0, 0, 320, 480, Gray);
            gfxSleepMilliseconds(1000);
            if(DisplayMode != 1) break;
            gdispFillArea(0, 0, 320, 480, White);
            gfxSleepMilliseconds(1000);
            if(DisplayMode != 1) break;
            gdispFillArea(0, 0, 320, 480, Red);
            gfxSleepMilliseconds(1000);
            if(DisplayMode != 1) break;
            gdispFillArea(0, 0, 320, 480, Green);
            gfxSleepMilliseconds(1000);
            if(DisplayMode != 1) break;
            gdispFillArea(0, 0, 320, 480, Blue);
            gfxSleepMilliseconds(1000);
            break;
        case 2:
            for (i = 0; i < 5000; i++) {
                random_color = (uint16_t)(rand() % 65535);
                rx = (rand() % (width-10));
                ry = (rand() % (height-10));
                rcx = (rand() % ((width-rx)-10))+10;
                rcy = (rand() % ((height-ry)-10))+10;

                gdispFillArea(rx, ry, rcx, rcy, random_color);
                if(DisplayMode != 2) break;
            }
            break;
        case 3:
            for (i = 0; i < 5000; i++) {
                random_color = (uint16_t)(rand() % 65535);
                rx = (rand() % (width-10));
                ry = (rand() % (height-10));
                rcx = (rand() % ((width-rx)-10))+10;
                rcy = (rand() % ((height-ry)-10))+10;

                gdispDrawBox(rx, ry, rcx, rcy, random_color);
                if(DisplayMode != 3) break;
            }
            break;
        default:
			// Get the fonts we want to use
			font = gdispOpenFont("DejaVu*");

            gfxSleepMilliseconds(1000);
            ry = 200;

			gdispDrawString(140, ry, "MENU", font, White);
			ry += 16;
			gdispDrawString(80, ry, "P32 key show fill full screen", font, White);
			ry += 16;
			gdispDrawString(80, ry, "P33 key show fill area", font, White);
			ry += 16;
			gdispDrawString(80, ry, "P35 key show draw box", font, White);
			ry += 16;
			gdispDrawString(80, ry, "RST key show menu", font, White);
			ry += 16;

            while((DisplayMode == 0) || (DisplayMode > 3))
            {
                gfxSleepMilliseconds(10);
            }
            break;
    }

	gdispClear(Black);
    printf("uGFX redraw the screen.\r\n"); 
}

#pragma WARNING DISABLE = 47                                            //ر47ž: unreferenced local variable

void KeyScan(void)
{
	if(!KEY1)
	{
		if(!Key1_Flag)
		{
			Key1_cnt++;
			if(Key1_cnt >= KEY_TIMER)	//30ms
			{
				Key1_Flag = 1;			//ð״ֹ̬ظ
//				Key1_Function = 1;
				gdispClear(Black);
                DisplayMode = 0;
				printf("Key1 pressed.\r\n"); 
			}
		}
	}
	else
	{
		Key1_cnt = 0;
		Key1_Flag = 0;
	}

	if(!KEY2)
	{
		if(!Key2_Flag)
		{
			Key2_cnt++;
			if(Key2_cnt >= KEY_TIMER)	//30ms
			{
				Key2_Flag = 1;			//ð״ֹ̬ظ
//				Key2_Function = 1;
				gdispClear(Black);
                DisplayMode = 1;
				printf("Key2 pressed.\r\n"); 
			}
		}
	}
	else
	{
		Key2_cnt = 0;
		Key2_Flag = 0;	//ͷ
	}

	if(!KEY3)
	{
		if(!Key3_Flag)
		{
			Key3_cnt++;
			if(Key3_cnt >= KEY_TIMER)	//30ms
			{
				Key3_Flag = 1;				//ð״ֹ̬ظ
				gdispClear(Black);
                DisplayMode = 2;
				printf("Key3 pressed.\r\n"); 
            }
		}
	}
	else
	{
		Key3_cnt = 0;
		Key3_Flag = 0;
	}

	if(!KEY4)
	{
		if(!Key4_Flag)
		{
			Key4_cnt++;
			if(Key4_cnt >= KEY_TIMER)	//30ms
			{
				Key4_Flag = 1;				//ð״ֹ̬ظ
				gdispClear(Black);
                DisplayMode = 3;
				printf("Key4 pressed.\r\n"); 
			}
		}
	}
	else
	{
		Key4_cnt = 0;
		Key4_Flag = 0;	//ͷ
	}
}

/* Task to initialize the demo and uGFX. */
void uGFXInit(void *pvParameters)
{
    if(pvParameters==pvParameters);
    
    gfxInit();
    printf("uGFXInit OK\r\n"); 
    printf("start demo %x\r\n",GDISP); 
    
    while(1){
        benchmark();
    }
}

/* Task to initialize the demo and uGFX. */
void vKeyScan(void *pvParameters)
{
    if(pvParameters==pvParameters);
    
    
    while(1){
        KeyScan();
        vTaskDelay(1);
    }
}

void vSystemInit(void);

void main(void)
{
    vSystemInit();
    printf("\r\nvSystemInit ok!\r\n");
    /* Create the init task. */
    
    xTaskCreate(uGFXInit, "Init", configMINIMAL_STACK_SIZE, NULL, 0, &uGFXInitTask);
    xTaskCreate(vKeyScan, "KeyScan", configMINIMAL_STACK_SIZE, NULL, 0, 0);
    printf("Create the init task ok!\r\n");
    vTaskStartScheduler();

    while (1);
}
