/*
 * File: toolbarIcons.h
 *
 * This file is a part of the Notepad demo application for ChibiOS/GFX
 *
 * This file has a different license from the others.
 *
 * Icons [0-10 and 15] in this set are taken from the fugue-icons-set
 * by Yusuke Kamiyamane [http://p.yusukekamiyamane.com/] .These icons
 * are covered by a Creative Commons Attribution 3.0 License:
 * http://creativecommons.org/licenses/by/3.0/
 * and have been used according to the terms of the license.
 *
 * The file is in a filmstrip format of 16x16 icons converted to GIF Format
 * See toolbarIcons.gif for the GIF source
 *
 * Total 16 icons (256 x 16)
 *  0 -> New
 *  1 -> Open
 *  2 -> Save
 *  3 -> Brush
 *  4 -> Color Palette
 *  5 -> Pencil
 *  6 -> Eraser
 *  7 -> Fill Color
 *  8 -> Cross
 *  9 -> Plus
 * 10 -> Minus
 * 11 -> Cross (Round)
 * 12 -> Info
 * 13 -> Tick
 * 14 -> Warning
 * 15 -> 32-bit processor
 *
 */

static const unsigned char toolbarIcons[] = {
	0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x00, 0x01, 0x10, 0x00, 0xF7, 0x00, 0x00, 0x05, 0x05, 0x05,
	0x18, 0x18, 0x18, 0x00, 0x33, 0x00, 0x0B, 0x2A, 0x2A, 0x17, 0x38, 0x38, 0x31, 0x09, 0x09, 0x2A,
	0x38, 0x1D, 0x29, 0x29, 0x29, 0x29, 0x35, 0x35, 0x32, 0x2E, 0x26, 0x3A, 0x3A, 0x3A, 0x02, 0x4D,
	0x02, 0x00, 0x5B, 0x02, 0x1E, 0x5D, 0x1E, 0x02, 0x70, 0x03, 0x2A, 0x6A, 0x2A, 0x2C, 0x50, 0x50,
	0x3E, 0x65, 0x65, 0x5C, 0x01, 0x01, 0x68, 0x00, 0x00, 0x7D, 0x00, 0x00, 0x7D, 0x3C, 0x06, 0x71,
	0x27, 0x27, 0x45, 0x00, 0x67, 0x51, 0x02, 0x79, 0x45, 0x36, 0x4E, 0x55, 0x47, 0x0A, 0x4F, 0x57,
	0x32, 0x6C, 0x52, 0x01, 0x7A, 0x64, 0x00, 0x46, 0x46, 0x46, 0x52, 0x4F, 0x47, 0x54, 0x54, 0x54,
	0x43, 0x51, 0x7C, 0x5E, 0x70, 0x5E, 0x45, 0x6D, 0x6D, 0x4B, 0x74, 0x74, 0x53, 0x7D, 0x7D, 0x6A,
	0x48, 0x48, 0x67, 0x67, 0x67, 0x78, 0x78, 0x78, 0x09, 0x2B, 0x91, 0x1B, 0x3D, 0xA3, 0x3B, 0x2B,
	0x97, 0x1E, 0x71, 0x8E, 0x19, 0x6C, 0xB7, 0x2A, 0x53, 0xB4, 0x38, 0x6B, 0x9E, 0x37, 0x71, 0xB5,
	0x3C, 0x5E, 0xC4, 0x29, 0x78, 0xC5, 0x5B, 0x02, 0x86, 0x49, 0x55, 0xBC, 0x42, 0x75, 0xA8, 0x7C,
	0x49, 0x95, 0x50, 0x72, 0xD6, 0x5A, 0x7C, 0xE2, 0x00, 0x91, 0x0F, 0x13, 0x9C, 0x24, 0x00, 0xA7,
	0x13, 0x12, 0xA6, 0x23, 0x11, 0xB9, 0x22, 0x2E, 0x83, 0x2E, 0x31, 0x86, 0x31, 0x34, 0x98, 0x34,
	0x28, 0xB3, 0x39, 0x34, 0xBC, 0x45, 0x0F, 0xCC, 0x1F, 0x0F, 0xC8, 0x20, 0x12, 0xC9, 0x23, 0x11,
	0xD5, 0x22, 0x22, 0xC3, 0x34, 0x3B, 0xC4, 0x4C, 0x48, 0x9D, 0x48, 0x54, 0xA9, 0x54, 0x67, 0xAD,
	0x67, 0x60, 0xB5, 0x60, 0x7A, 0xB4, 0x7A, 0x44, 0xCC, 0x55, 0x4D, 0xD5, 0x5E, 0x51, 0xDB, 0x62,
	0x5B, 0xE3, 0x6C, 0x6E, 0xC3, 0x6E, 0x1B, 0xA1, 0xE2, 0x3B, 0x8A, 0xD6, 0x3E, 0x9C, 0xE7, 0x38,
	0xC5, 0xFF, 0x55, 0x88, 0xBA, 0x70, 0x9E, 0xB9, 0x78, 0xA7, 0xB9, 0x4C, 0x91, 0xCD, 0x52, 0x8F,
	0xF6, 0x5F, 0xBC, 0xE8, 0x68, 0x9B, 0xCE, 0x63, 0x85, 0xEB, 0x72, 0xA4, 0xD1, 0x66, 0xA6, 0xFF,
	0x5D, 0xD1, 0xFF, 0x75, 0xC8, 0xEE, 0x88, 0x00, 0x00, 0x95, 0x01, 0x01, 0x9B, 0x11, 0x11, 0x9B,
	0x02, 0x20, 0xA7, 0x00, 0x00, 0xA7, 0x14, 0x14, 0xB3, 0x01, 0x01, 0xB8, 0x11, 0x11, 0xA7, 0x02,
	0x23, 0xB4, 0x02, 0x25, 0xAD, 0x26, 0x26, 0xB5, 0x28, 0x28, 0xBC, 0x34, 0x34, 0x89, 0x45, 0x01,
	0x8A, 0x5B, 0x00, 0x93, 0x49, 0x01, 0x9A, 0x50, 0x05, 0x98, 0x55, 0x11, 0x8E, 0x6B, 0x01, 0x89,
	0x75, 0x04, 0x98, 0x66, 0x00, 0x96, 0x77, 0x03, 0xB0, 0x5C, 0x06, 0xA7, 0x6F, 0x00, 0xAB, 0x65,
	0x13, 0xA6, 0x78, 0x02, 0xA9, 0x7A, 0x1C, 0xBC, 0x61, 0x04, 0xB7, 0x7A, 0x00, 0xB2, 0x78, 0x38,
	0x8A, 0x6A, 0x4B, 0xC9, 0x0C, 0x0C, 0xC9, 0x12, 0x12, 0xD8, 0x01, 0x01, 0xD4, 0x11, 0x11, 0xC6,
	0x27, 0x27, 0xC7, 0x39, 0x39, 0xE4, 0x13, 0x00, 0xD2, 0x5E, 0x28, 0xC0, 0x62, 0x04, 0xC9, 0x78,
	0x26, 0xEA, 0x40, 0x30, 0xCA, 0x42, 0x42, 0xD5, 0x4D, 0x4D, 0xD8, 0x50, 0x50, 0xD1, 0x7B, 0x5A,
	0xE4, 0x59, 0x56, 0xEB, 0x69, 0x5C, 0xF1, 0x6C, 0x6A, 0x80, 0x48, 0x9B, 0x89, 0x56, 0xA2, 0x90,
	0x5D, 0xA9, 0x96, 0x63, 0xAF, 0xA7, 0x74, 0xC0, 0xD2, 0x7D, 0x8E, 0x99, 0x85, 0x0B, 0xA6, 0x8A,
	0x03, 0xAB, 0x94, 0x01, 0xA4, 0x93, 0x1C, 0xB0, 0x82, 0x0B, 0xB8, 0x85, 0x17, 0xB3, 0x9A, 0x03,
	0xAF, 0x8E, 0x2E, 0xB7, 0xA6, 0x30, 0x91, 0x83, 0x48, 0x8B, 0x84, 0x66, 0x9A, 0x88, 0x71, 0x9B,
	0x9A, 0x75, 0x88, 0xA2, 0x56, 0x97, 0xB3, 0x67, 0xB1, 0x94, 0x44, 0xBA, 0x9F, 0x63, 0xBD, 0xA3,
	0x66, 0xA7, 0xC6, 0x79, 0xCA, 0x87, 0x00, 0xD0, 0x88, 0x3C, 0xCE, 0xB0, 0x14, 0xCF, 0xB7, 0x2E,
	0xCA, 0x96, 0x56, 0xC7, 0xAF, 0x4C, 0xD6, 0xAE, 0x6D, 0xE7, 0x93, 0x71, 0xEA, 0xBF, 0x5F, 0xE2,
	0xB1, 0x79, 0xFE, 0xCC, 0x04, 0xE6, 0xCA, 0x34, 0xDE, 0xCD, 0x56, 0xE3, 0xD2, 0x5E, 0xEB, 0xC4,
	0x67, 0xE9, 0xCA, 0x7F, 0xE6, 0xD5, 0x64, 0xFA, 0xF3, 0x58, 0xEB, 0xE0, 0x64, 0xF6, 0xE5, 0x79,
	0x83, 0x83, 0x84, 0x8A, 0x86, 0x95, 0x95, 0x95, 0x96, 0x9C, 0x9C, 0xAD, 0x80, 0xBF, 0x80, 0x96,
	0xAB, 0xAB, 0xB8, 0xB4, 0x8F, 0xA5, 0xA6, 0xA8, 0xA9, 0xA9, 0xB8, 0xA5, 0xB6, 0xB6, 0xBD, 0xAF,
	0xA0, 0xB8, 0xB8, 0xB9, 0x85, 0x80, 0xCB, 0x84, 0xAC, 0xCB, 0x81, 0xB6, 0xE3, 0xBA, 0x87, 0xD3,
	0xB6, 0xB9, 0xC5, 0xB0, 0xD1, 0x84, 0xB0, 0xCA, 0xB0, 0x94, 0xC7, 0xF8, 0x92, 0xE3, 0xFF, 0xAD,
	0xC3, 0xCD, 0xAA, 0xD3, 0xFD, 0xBF, 0xE1, 0xF1, 0xDA, 0x85, 0x96, 0xC7, 0xB6, 0x80, 0xF1, 0x89,
	0x91, 0xE9, 0x9B, 0xAC, 0xE6, 0xB8, 0x84, 0xEB, 0xA4, 0xB5, 0xF2, 0xBE, 0xB9, 0xC3, 0x90, 0xDC,
	0xCD, 0x9A, 0xE6, 0xD9, 0xA6, 0xF2, 0xFB, 0xB3, 0xC4, 0xD8, 0xC7, 0x8B, 0xDB, 0xD4, 0xB0, 0xEA,
	0xC4, 0x89, 0xEE, 0xC4, 0x91, 0xE9, 0xD3, 0x87, 0xEC, 0xD5, 0x91, 0xF0, 0xC8, 0x95, 0xF1, 0xD5,
	0x89, 0xF4, 0xDA, 0x95, 0xFD, 0xEC, 0x84, 0xF8, 0xE2, 0x9B, 0xFF, 0xFF, 0x84, 0xE5, 0xE2, 0xBC,
	0xFC, 0xE9, 0xA4, 0xFF, 0xF1, 0xAC, 0xC9, 0xC9, 0xC9, 0xD9, 0xD9, 0xD9, 0xD8, 0xD8, 0xEA, 0xDB,
	0xEA, 0xEA, 0xDB, 0xEB, 0xFF, 0xF3, 0xE8, 0xCA, 0xE7, 0xE7, 0xE7, 0xE1, 0xE1, 0xF2, 0xE6, 0xF2,
	0xE6, 0xE8, 0xF3, 0xF4, 0xFD, 0xF0, 0xEF, 0xF8, 0xF9, 0xF9, 0x00, 0x00, 0x00, 0x21, 0xF9, 0x04,
	0x01, 0x0A, 0x00, 0xFF, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x08,
	0xFE, 0x00, 0xFF, 0xFD, 0x2B, 0x41, 0xA2, 0x84, 0xC1, 0x83, 0x06, 0x05, 0x2A, 0xFC, 0xD7, 0xAA,
	0xA1, 0xC3, 0x87, 0x0D, 0x17, 0x4A, 0x94, 0x58, 0xA5, 0xCA, 0xC4, 0x8B, 0x0A, 0x0F, 0x8D, 0xC1,
	0xC8, 0xB1, 0xE3, 0x3F, 0x44, 0x88, 0x08, 0x75, 0x5C, 0xC3, 0x86, 0x24, 0x46, 0x0F, 0x20, 0x14,
	0x1C, 0xF0, 0xC8, 0xB2, 0xA5, 0xCB, 0x97, 0x30, 0x63, 0xB6, 0xA4, 0x77, 0xD1, 0x81, 0xCD, 0x9B,
	0x38, 0x73, 0x2A, 0x2C, 0xE1, 0x8F, 0x9F, 0xCF, 0x9F, 0xD6, 0x12, 0x2E, 0x6C, 0xB5, 0x6E, 0x57,
	0xAD, 0x75, 0xEE, 0xE2, 0x29, 0x55, 0xDA, 0x4A, 0xE1, 0x8C, 0x19, 0x08, 0xA3, 0x52, 0xA1, 0x42,
	0xA3, 0xA5, 0x23, 0x32, 0x63, 0x0E, 0x49, 0xF4, 0xA3, 0xA8, 0xAB, 0x57, 0x45, 0x7E, 0x5A, 0x82,
	0x50, 0xB3, 0x2D, 0x4D, 0x1A, 0x8C, 0x6C, 0xD8, 0x8C, 0x1B, 0xB7, 0x66, 0xCD, 0x45, 0x10, 0x02,
	0x03, 0x70, 0x3C, 0x43, 0xB7, 0xAE, 0x5D, 0xBA, 0x0B, 0x77, 0xE8, 0xDD, 0xCB, 0x57, 0xEF, 0xC2,
	0xBB, 0x80, 0xCF, 0x4C, 0xFC, 0x16, 0x09, 0x24, 0xC8, 0x48, 0xDF, 0x30, 0x62, 0xE3, 0x32, 0xA5,
	0xF1, 0x14, 0x2E, 0xD8, 0x2E, 0xD2, 0x9B, 0xB6, 0x04, 0x88, 0x65, 0x20, 0x4B, 0xA6, 0xD1, 0xC4,
	0x48, 0xEF, 0xD6, 0xAD, 0xCD, 0x0B, 0x1D, 0xC4, 0x53, 0x22, 0xA5, 0xB4, 0x69, 0xD3, 0x4A, 0xE2,
	0x39, 0xD8, 0xE9, 0xD3, 0x1E, 0x3F, 0x7B, 0xF6, 0xE8, 0x29, 0xF3, 0x47, 0x70, 0xA8, 0xBC, 0x78,
	0xEE, 0x76, 0xA5, 0x3A, 0xC6, 0x9B, 0xF7, 0x28, 0x52, 0xA4, 0xFE, 0xCD, 0x10, 0xE7, 0xAF, 0x78,
	0xF1, 0x67, 0x5A, 0x92, 0x6B, 0xA9, 0x26, 0x43, 0x86, 0x47, 0x32, 0x58, 0x37, 0x2A, 0xF4, 0xE3,
	0x27, 0x51, 0xA4, 0x48, 0xB4, 0xBA, 0xD9, 0x92, 0x05, 0xEB, 0x53, 0xD8, 0x8E, 0x20, 0x40, 0xFE,
	0xF8, 0x9B, 0x14, 0x49, 0xF0, 0x44, 0x92, 0xE3, 0xBC, 0x79, 0x63, 0xCB, 0x66, 0xA2, 0x07, 0x0F,
	0x07, 0x02, 0x00, 0xB8, 0x78, 0xC6, 0xD0, 0xA4, 0xFB, 0xF8, 0xF3, 0x1B, 0x32, 0xBF, 0xE3, 0x48,
	0x94, 0xFF, 0x00, 0x02, 0x08, 0x45, 0x10, 0x3B, 0x08, 0x54, 0x5F, 0x7E, 0x08, 0x4E, 0xB2, 0xDF,
	0x42, 0x92, 0x18, 0xE6, 0x20, 0x22, 0x93, 0x4C, 0x24, 0x86, 0x63, 0x14, 0x4E, 0x21, 0x86, 0x44,
	0xF4, 0x34, 0x71, 0xD9, 0x86, 0x40, 0x34, 0x01, 0x9A, 0x44, 0xE8, 0x78, 0x86, 0xCE, 0x44, 0x0E,
	0x28, 0xA1, 0x84, 0x34, 0x27, 0xA6, 0x88, 0x22, 0x8A, 0x4A, 0xAC, 0x26, 0x10, 0x09, 0x3D, 0xBD,
	0x06, 0x9B, 0x3D, 0xC6, 0xD4, 0x08, 0xC1, 0x50, 0x4B, 0xC5, 0x33, 0x8B, 0x71, 0x3C, 0x06, 0x37,
	0x43, 0x38, 0x3C, 0xFA, 0xB3, 0x9C, 0x18, 0x61, 0x14, 0x29, 0x86, 0x73, 0x1C, 0x41, 0x37, 0xC6,
	0x18, 0x8E, 0x08, 0x94, 0x87, 0x1F, 0x8B, 0xD8, 0xE2, 0xC8, 0x7D, 0x86, 0xCC, 0x02, 0x0B, 0x30,
	0xC0, 0x84, 0x42, 0x1D, 0x47, 0x9C, 0x68, 0xE2, 0xCF, 0x3C, 0xF4, 0x8C, 0x61, 0xDE, 0x42, 0xE8,
	0xA9, 0xA7, 0x1E, 0x5B, 0x6E, 0x2D, 0x04, 0x5F, 0x3E, 0x28, 0x00, 0x30, 0x9F, 0x44, 0x67, 0x90,
	0x77, 0xDD, 0x9C, 0x74, 0x96, 0x27, 0xD0, 0x0E, 0x50, 0x3C, 0xA1, 0xE7, 0x13, 0x48, 0x20, 0xB1,
	0xE7, 0x13, 0x50, 0x14, 0xF8, 0x4F, 0x9C, 0x75, 0x16, 0x3A, 0xE6, 0x24, 0x88, 0x30, 0xC2, 0x88,
	0x83, 0x8A, 0x42, 0xB8, 0xD0, 0x84, 0x8E, 0x15, 0x47, 0xE1, 0x85, 0x0A, 0x69, 0xC8, 0xE1, 0x86,
	0x1E, 0x4E, 0xD4, 0x99, 0x67, 0x9F, 0x49, 0xE4, 0x00, 0x13, 0x49, 0x90, 0xF3, 0x40, 0x3C, 0xA3,
	0x96, 0x4A, 0x4E, 0x12, 0x4C, 0xB8, 0xF8, 0x0F, 0x8C, 0x3D, 0xF9, 0xE3, 0x1A, 0x6C, 0xFE, 0xF4,
	0xF0, 0x33, 0x02, 0x8E, 0x4B, 0x91, 0xB2, 0xC5, 0x16, 0x60, 0x80, 0x71, 0xCD, 0x35, 0xFE, 0xF8,
	0x08, 0x64, 0xAB, 0xFC, 0x7C, 0xA1, 0x9C, 0x16, 0x56, 0xB8, 0xD0, 0x42, 0x92, 0x4A, 0x4A, 0xF7,
	0x8F, 0x1F, 0xB1, 0x98, 0x63, 0xCB, 0x21, 0x87, 0xB8, 0x01, 0x89, 0x2D, 0xA2, 0x88, 0xD2, 0xC9,
	0x2C, 0xAE, 0xE4, 0x81, 0x11, 0x28, 0x9B, 0xB4, 0x23, 0x0A, 0x3D, 0x01, 0x14, 0x30, 0x51, 0x30,
	0xC1, 0x8C, 0xC3, 0x0D, 0x37, 0xDE, 0xA0, 0x9B, 0x0D, 0x37, 0x69, 0x0A, 0xB4, 0x26, 0x3D, 0x28,
	0xE4, 0xE3, 0x26, 0x9C, 0x93, 0x38, 0xE2, 0x88, 0x3F, 0xF6, 0xDA, 0x8B, 0xAF, 0x23, 0x76, 0xFE,
	0x83, 0xA7, 0x13, 0x00, 0x23, 0x51, 0x1C, 0x12, 0x00, 0x3B, 0x11, 0xA8, 0x81, 0xF5, 0xE6, 0xAB,
	0xB0, 0xBD, 0xFD, 0x7E, 0x93, 0x68, 0x3F, 0xFD, 0x2C, 0xFA, 0x70, 0xC4, 0x88, 0x24, 0xF6, 0x0F,
	0x36, 0x15, 0x4A, 0x4A, 0x61, 0x64, 0xFF, 0x4C, 0x73, 0x29, 0x10, 0xC5, 0xF8, 0xB3, 0x8F, 0x65,
	0xD3, 0x4C, 0x14, 0x22, 0xA7, 0x23, 0x86, 0x26, 0x0D, 0x39, 0x1F, 0xBC, 0xE7, 0xF2, 0x7B, 0x1F,
	0x90, 0x23, 0x8D, 0xAA, 0x23, 0x00, 0x2B, 0x23, 0x6C, 0xFC, 0x90, 0xB0, 0xD0, 0x1F, 0xB8, 0x25,
	0x35, 0x8A, 0x33, 0x40, 0x7F, 0x61, 0xCD, 0x3D, 0xBD, 0x0A, 0x07, 0xA4, 0x6B, 0x3F, 0xBD, 0xC6,
	0x0F, 0x0C, 0x30, 0xAC, 0x80, 0x2C, 0x1A, 0x63, 0x50, 0xA0, 0x50, 0x1E, 0xB3, 0x68, 0x67, 0x0B,
	0x24, 0x68, 0x4C, 0xBB, 0x9D, 0x26, 0xB2, 0xD8, 0x62, 0x8B, 0xB6, 0x13, 0x71, 0xC2, 0x49, 0x3B,
	0xC0, 0xE4, 0x62, 0xC7, 0x9B, 0x0B, 0x91, 0x5B, 0xDC, 0xB9, 0xEA, 0xAE, 0xDB, 0xEE, 0xBB, 0xF3,
	0xA0, 0xC0, 0x0C, 0x3D, 0xF3, 0x2A, 0x44, 0x46, 0x24, 0x8D, 0x18, 0xD7, 0x48, 0xFE, 0xDE, 0xC5,
	0x35, 0x72, 0x95, 0x40, 0x39, 0x40, 0xD1, 0x27, 0x12, 0x42, 0x14, 0x27, 0xC4, 0xE0, 0x4E, 0xE4,
	0x20, 0xD0, 0xDD, 0x7B, 0x37, 0xEE, 0xB8, 0xDF, 0x64, 0x08, 0x54, 0x18, 0x23, 0xFD, 0xF8, 0x13,
	0x31, 0xE5, 0x96, 0x2F, 0x1A, 0x89, 0x40, 0x8C, 0x55, 0xE8, 0x39, 0x17, 0x02, 0x55, 0x76, 0xE9,
	0x3E, 0xFE, 0x14, 0x63, 0xD9, 0x12, 0x18, 0x7A, 0xE6, 0xA6, 0x67, 0x1F, 0x96, 0xF8, 0x80, 0x07,
	0xF4, 0x7C, 0x09, 0xC2, 0x3C, 0xFE, 0xD0, 0xE3, 0xC1, 0x03, 0x2D, 0x2A, 0x54, 0x33, 0xB0, 0xAE,
	0x2A, 0x1D, 0xC1, 0xCE, 0xEE, 0xB0, 0xC3, 0x8E, 0x3B, 0xB1, 0xF0, 0x18, 0x0D, 0x3F, 0x45, 0xFF,
	0x78, 0xF3, 0x8C, 0xB0, 0x5D, 0xD1, 0xCC, 0x0C, 0x18, 0x41, 0xF7, 0x46, 0x19, 0x52, 0x4F, 0xAD,
	0x4E, 0x37, 0xDD, 0x98, 0x83, 0xFD, 0xF6, 0xD8, 0x2F, 0xF3, 0xC5, 0x17, 0x81, 0x4C, 0x04, 0xCA,
	0xD8, 0xC0, 0xF4, 0xC2, 0x09, 0x28, 0x13, 0xA1, 0x80, 0x42, 0x71, 0xF9, 0xF8, 0x83, 0x6E, 0x26,
	0xD9, 0x6C, 0xB3, 0x86, 0x19, 0xEE, 0x1E, 0x90, 0x0F, 0x3D, 0xF3, 0x20, 0x83, 0xC2, 0x30, 0xC8,
	0x80, 0x7B, 0x83, 0x17, 0x8B, 0x7B, 0xC4, 0x1B, 0xDA, 0xC0, 0x3E, 0x7A, 0x18, 0xB0, 0x0C, 0x68,
	0x70, 0x43, 0xE4, 0xFE, 0x91, 0x83, 0x27, 0x08, 0x21, 0x08, 0x10, 0xCC, 0x47, 0x3E, 0x74, 0x40,
	0x41, 0x1D, 0x04, 0x41, 0x71, 0xFF, 0x20, 0x83, 0x00, 0xDF, 0xC0, 0x41, 0x37, 0xA0, 0x01, 0x0D,
	0x65, 0x40, 0xA0, 0x02, 0x05, 0x62, 0x18, 0xCC, 0x41, 0x2C, 0x73, 0x86, 0x11, 0x88, 0xE7, 0x34,
	0x46, 0x21, 0x81, 0x7C, 0x2C, 0x64, 0x23, 0xBB, 0x0C, 0x88, 0x54, 0x07, 0x00, 0x11, 0x85, 0x86,
	0x15, 0xE9, 0x50, 0x00, 0x08, 0x3C, 0xE0, 0x0F, 0x97, 0xF9, 0x43, 0x01, 0xFE, 0xE9, 0x60, 0x85,
	0xAA, 0x22, 0x10, 0x24, 0xE4, 0xE1, 0xCC, 0x04, 0x84, 0x10, 0x84, 0x40, 0xFE, 0x10, 0xBC, 0xE1,
	0x6D, 0xE2, 0x15, 0x50, 0xF4, 0x87, 0x31, 0x7C, 0xE2, 0x23, 0x70, 0xD4, 0x23, 0x69, 0x48, 0xE3,
	0x47, 0x3D, 0xC0, 0x01, 0xBD, 0x89, 0x40, 0xE7, 0x10, 0x68, 0xA8, 0x9E, 0x42, 0xE6, 0x30, 0x0B,
	0x73, 0xC4, 0x22, 0x0F, 0xCD, 0xCA, 0xDE, 0xF6, 0xBA, 0x40, 0x0D, 0x6A, 0x5C, 0x41, 0x22, 0x62,
	0x23, 0x9B, 0x2E, 0x36, 0xC1, 0x89, 0xF4, 0xC5, 0x4B, 0x82, 0xFE, 0x90, 0x60, 0x26, 0x32, 0xB1,
	0x0D, 0x33, 0xD0, 0xEF, 0x1F, 0x70, 0x63, 0xC6, 0x30, 0xE6, 0x11, 0x0C, 0x62, 0x24, 0xA3, 0x1E,
	0x21, 0xC0, 0xC1, 0x0D, 0x32, 0xE8, 0x88, 0x37, 0xB8, 0xA1, 0x0C, 0x60, 0x3A, 0xE0, 0x07, 0xD1,
	0xB0, 0xC0, 0x1C, 0x38, 0x21, 0x08, 0x79, 0x34, 0x20, 0x3D, 0x24, 0x98, 0x0F, 0x1E, 0xF0, 0x00,
	0x83, 0x64, 0x68, 0x64, 0xED, 0x22, 0xC9, 0xC9, 0x0F, 0x2E, 0x90, 0x51, 0x95, 0x43, 0x61, 0x0A,
	0xFF, 0xB1, 0x42, 0x7F, 0x78, 0xCE, 0x85, 0xA3, 0x2B, 0xDD, 0x86, 0x16, 0xB2, 0xA9, 0x5B, 0xAC,
	0x8E, 0x75, 0x0A, 0x71, 0x40, 0x12, 0x1E, 0xA0, 0x00, 0x64, 0xF8, 0x63, 0x18, 0x1E, 0x08, 0x46,
	0x3E, 0x90, 0xA1, 0x80, 0x07, 0x24, 0x61, 0x88, 0x3C, 0x42, 0x9E, 0x11, 0xED, 0x61, 0x82, 0xB2,
	0x2C, 0x51, 0x78, 0xC2, 0xF3, 0x04, 0x2C, 0x60, 0xF1, 0x0A, 0x7F, 0x64, 0xE1, 0x1A, 0xFC, 0x08,
	0x0E, 0x06, 0xC0, 0x01, 0x8D, 0x6E, 0x7A, 0xF3, 0x9B, 0xD0, 0xE8, 0xE2, 0x42, 0xA0, 0xE3, 0x88,
	0x36, 0x88, 0x71, 0x21, 0x70, 0x48, 0xE7, 0x3F, 0xE0, 0xA0, 0x8E, 0x58, 0xD0, 0x21, 0x15, 0xD8,
	0xBB, 0xC2, 0x15, 0x6A, 0x10, 0x3E, 0x85, 0x70, 0xAB, 0x1D, 0xBD, 0xFE, 0xE8, 0x85, 0x26, 0x36,
	0x31, 0x91, 0x13, 0xC4, 0x2B, 0x8F, 0x00, 0x05, 0x53, 0x36, 0xFC, 0x58, 0xBF, 0xFB, 0xCD, 0x23,
	0x19, 0x82, 0x04, 0x81, 0x30, 0x92, 0x91, 0x8C, 0x7C, 0x28, 0xE0, 0x06, 0x8B, 0x24, 0x43, 0x23,
	0x3C, 0x88, 0x06, 0x4D, 0xE6, 0x63, 0x92, 0x6A, 0xA8, 0xE4, 0x25, 0x35, 0xB9, 0x49, 0x4E, 0x7A,
	0x12, 0x94, 0x13, 0xC5, 0x9F, 0x01, 0x39, 0x79, 0xD1, 0x8C, 0x92, 0xB0, 0x84, 0xA9, 0xA4, 0xD8,
	0x2A, 0x5B, 0xF9, 0xCA, 0x7F, 0x5C, 0x86, 0x74, 0xC5, 0x80, 0x21, 0x87, 0x16, 0x72, 0x32, 0x5B,
	0xD6, 0xD0, 0x86, 0x02, 0x61, 0x00, 0x2A, 0xCC, 0xA1, 0x00, 0x0F, 0x28, 0xC0, 0xA1, 0xF9, 0x38,
	0x81, 0x4F, 0xCD, 0x81, 0x0A, 0x06, 0x28, 0x04, 0x02, 0x41, 0x2A, 0x0E, 0x3F, 0xE0, 0xE1, 0x4B,
	0x09, 0x2C, 0xF0, 0x0F, 0xEC, 0x58, 0xC7, 0x3A, 0xD8, 0xF1, 0x09, 0x5F, 0xE0, 0x02, 0x17, 0xFE,
	0xC0, 0x02, 0x35, 0xB2, 0x29, 0x1C, 0x68, 0x54, 0xE2, 0xAB, 0x60, 0x0D, 0x6B, 0x38, 0x30, 0x20,
	0x11, 0x0B, 0x84, 0xD2, 0x0D, 0xE7, 0xBC, 0x08, 0x1C, 0x00, 0xC1, 0x0E, 0x3A, 0xFC, 0x83, 0x0E,
	0xE7, 0xE8, 0xC6, 0x31, 0x5E, 0x50, 0x0A, 0xB0, 0xFD, 0x23, 0x8E, 0xF9, 0xB4, 0x83, 0x26, 0xFA,
	0x79, 0x02, 0x92, 0x4A, 0x70, 0x1E, 0x60, 0x52, 0xC0, 0x1F, 0xFF, 0x61, 0x3F, 0xFC, 0x31, 0x83,
	0x19, 0xC9, 0x40, 0x86, 0x21, 0xA3, 0xA1, 0x8F, 0x9E, 0xC6, 0x20, 0x06, 0xFF, 0xC8, 0x8A, 0x1A,
	0xD4, 0x60, 0x51, 0x09, 0x4E, 0x56, 0x0D, 0xD2, 0xC9, 0x01, 0x12, 0x7A, 0xE0, 0x49, 0x1E, 0x48,
	0xB0, 0xB3, 0x3D, 0xE8, 0x01, 0x06, 0x25, 0x3B, 0xC9, 0xD2, 0xA2, 0x61, 0xB2, 0xD2, 0x41, 0xA9,
	0xE5, 0x2A, 0xA7, 0x52, 0x44, 0xA8, 0x30, 0x63, 0xAE, 0xAC, 0xFE, 0x10, 0x2C, 0x41, 0x26, 0x32,
	0x98, 0xCE, 0x54, 0x20, 0xB5, 0xB4, 0x29, 0xA7, 0x3A, 0xF5, 0x0F, 0x06, 0x00, 0xE1, 0x01, 0x07,
	0x60, 0x46, 0x3E, 0x98, 0xF1, 0x53, 0x09, 0x1E, 0xE0, 0x01, 0x40, 0x30, 0xAA, 0x40, 0x90, 0x5A,
	0x44, 0x78, 0xC8, 0x02, 0x18, 0x08, 0x90, 0x8B, 0x40, 0xF8, 0xB0, 0x0E, 0x74, 0xA0, 0x63, 0x1D,
	0xA1, 0x78, 0xC7, 0x2F, 0x70, 0xC1, 0x8F, 0x29, 0x72, 0x75, 0x9B, 0x95, 0x00, 0xEC, 0x3C, 0xA2,
	0x01, 0x58, 0x4B, 0x60, 0xC2, 0x12, 0xE1, 0x5C, 0xC8, 0x0E, 0x0F, 0xF1, 0x86, 0xB4, 0x4E, 0x44,
	0x0E, 0x80, 0x50, 0x47, 0x5C, 0xAB, 0x16, 0xD7, 0x73, 0x98, 0x63, 0x0F, 0xF6, 0x1C, 0x9B, 0x2E,
	0x7A, 0x61, 0x07, 0x3C, 0x5C, 0xA4, 0xAF, 0x9C, 0xDC, 0x24, 0x60, 0xE9, 0x71, 0x80, 0x95, 0x28,
	0x24, 0x00, 0xF8, 0x43, 0x28, 0x32, 0x92, 0x61, 0xC8, 0x64, 0x34, 0xD6, 0x03, 0xFF, 0x70, 0x81,
	0x0B, 0x22, 0x6B, 0x08, 0xCA, 0x1A, 0xF0, 0x83, 0x9C, 0x44, 0x2D, 0xE0, 0x8E, 0x10, 0xDA, 0xD0,
	0x4A, 0xB0, 0xC3, 0xA1, 0x1D, 0x6D, 0x85, 0x2F, 0x4B, 0xE2, 0xCB, 0x4A, 0x67, 0x72, 0xAC, 0x55,
	0x54, 0x8A, 0x11, 0xB1, 0xB9, 0x7F, 0x74, 0x2E, 0x52, 0xB1, 0x75, 0x0C, 0xE8, 0xFE, 0x21, 0x3A,
	0x20, 0x90, 0x4E, 0x64, 0x1C, 0x42, 0x9D, 0x40, 0x6A, 0xBA, 0x5B, 0x94, 0xE5, 0x14, 0x15, 0xAB,
	0x48, 0x40, 0x00, 0x86, 0x4C, 0xE4, 0x00, 0x24, 0x60, 0x15, 0x45, 0x3D, 0x6A, 0x52, 0x9D, 0x0B,
	0x8C, 0x54, 0x6C, 0x60, 0x21, 0x7A, 0x58, 0x87, 0x39, 0xCC, 0xB1, 0x0E, 0x3E, 0xDC, 0xE2, 0x15,
	0xA0, 0xE0, 0x87, 0x08, 0x58, 0x00, 0x9C, 0x7F, 0x60, 0x00, 0x1A, 0x96, 0x88, 0x86, 0x0D, 0x6C,
	0x70, 0xD8, 0x68, 0x54, 0x02, 0x13, 0x97, 0x00, 0x07, 0xFE, 0x59, 0x05, 0xB2, 0x43, 0x7F, 0x20,
	0xC3, 0xBD, 0xEF, 0xB5, 0xAF, 0x39, 0xCE, 0x21, 0x5F, 0x75, 0xB4, 0xD3, 0xAE, 0x7C, 0xE8, 0x96,
	0x2E, 0x74, 0xD1, 0x01, 0x3B, 0x60, 0x04, 0x04, 0x01, 0xCE, 0x87, 0x78, 0x87, 0x2C, 0x11, 0x37,
	0xCD, 0x03, 0xB1, 0x8A, 0x4D, 0x46, 0x34, 0xEA, 0xD1, 0x53, 0x81, 0xA8, 0x40, 0x05, 0x91, 0x1D,
	0xC4, 0x20, 0x28, 0xAB, 0x06, 0x49, 0xAB, 0x21, 0x1F, 0x95, 0x1E, 0x44, 0x66, 0x8B, 0xC0, 0xE9,
	0x22, 0xF4, 0xE0, 0xC3, 0x9D, 0x2E, 0xC2, 0x68, 0x25, 0x4D, 0xEA, 0x52, 0x93, 0x5A, 0x3A, 0x0E,
	0xA3, 0x9C, 0x4A, 0x55, 0xBD, 0x28, 0x8B, 0x61, 0x8C, 0x42, 0x2C, 0x6C, 0x0C, 0xC7, 0x3C, 0x66,
	0x99, 0x90, 0xC9, 0x72, 0x43, 0x25, 0xFB, 0x47, 0x6E, 0x75, 0xBB, 0x5B, 0x9A, 0xF8, 0xD6, 0x07,
	0xAA, 0x68, 0xC0, 0x2C, 0x84, 0x4D, 0x6C, 0x55, 0xF8, 0x20, 0xB9, 0x4A, 0xE6, 0x11, 0x93, 0x53,
	0x51, 0x8E, 0x1B, 0x29, 0xE4, 0x0E, 0xE8, 0xE0, 0x05, 0x2F, 0xD0, 0x71, 0x87, 0x57, 0x6C, 0x02,
	0x0F, 0xFC, 0x30, 0x45, 0x53, 0x04, 0xF2, 0xE5, 0x4A, 0x30, 0xC3, 0x12, 0x97, 0x60, 0x68, 0x32,
	0x2E, 0x81, 0x09, 0x4C, 0x40, 0x63, 0xCD, 0x7B, 0xD8, 0x83, 0x9B, 0xA5, 0xEB, 0x11, 0x39, 0x34,
	0x4B, 0xBE, 0xDD, 0x98, 0x05, 0x20, 0xE6, 0xB0, 0x10, 0x3C, 0xD4, 0x01, 0x1F, 0xB2, 0xE0, 0x73,
	0x07, 0x38, 0xE2, 0xD3, 0xDA, 0x0D, 0x17, 0xB0, 0xF2, 0xB9, 0x88, 0x9B, 0xA2, 0x91, 0xE8, 0x45,
	0x1F, 0x40, 0x01, 0x0A, 0x49, 0x41, 0x0A, 0xFE, 0x41, 0x81, 0x41, 0x14, 0xA2, 0x10, 0x6A, 0x78,
	0xF8, 0xC3, 0x23, 0x5E, 0x08, 0x41, 0x54, 0xCF, 0x01, 0x45, 0x30, 0x82, 0xC6, 0x8D, 0x10, 0xDA,
	0x8D, 0x1B, 0x81, 0x08, 0x2E, 0x6A, 0xB8, 0xC4, 0xFE, 0x47, 0x2E, 0x71, 0x8B, 0x2B, 0xA4, 0x41,
	0x8D, 0x2A, 0xE1, 0xA2, 0x22, 0xA4, 0x10, 0x48, 0x35, 0x26, 0xD6, 0x94, 0x12, 0x88, 0xA5, 0x3E,
	0xD6, 0xA1, 0xCD, 0xF0, 0x98, 0xD7, 0x3E, 0x5E, 0xC0, 0x0F, 0x7E, 0x70, 0x0A, 0x9E, 0xFB, 0xBC,
	0xE7, 0x3D, 0xFF, 0xC1, 0x02, 0x92, 0x5D, 0x1C, 0x7C, 0x37, 0xB9, 0x1C, 0xFE, 0x70, 0xB6, 0x40,
	0xE2, 0x10, 0x8A, 0x32, 0x9A, 0x23, 0x14, 0x49, 0x7B, 0xB2, 0x42, 0x2E, 0x70, 0x01, 0x4A, 0x8C,
	0x3B, 0xDC, 0x0C, 0x25, 0xB7, 0xB9, 0x2F, 0x20, 0x90, 0x3D, 0xC4, 0x02, 0x10, 0xEC, 0x66, 0x49,
	0x3A, 0xC7, 0x0E, 0x87, 0x89, 0xD4, 0x61, 0x15, 0xF8, 0x28, 0x07, 0x07, 0xF6, 0xDD, 0x91, 0xF8,
	0x08, 0x1A, 0xB0, 0x75, 0x13, 0x38, 0x00, 0x18, 0xBA, 0x68, 0x42, 0x27, 0x5C, 0x20, 0x13, 0x20,
	0x83, 0xC3, 0x49, 0xFE, 0x70, 0x41, 0x90, 0x61, 0x02, 0x02, 0x71, 0x40, 0x0E, 0x32, 0xEE, 0xF1,
	0x8D, 0x0F, 0x21, 0x07, 0x2E, 0xCA, 0xFB, 0xDE, 0xF9, 0xEE, 0x77, 0xC0, 0x2B, 0x04, 0x51, 0x0F,
	0x02, 0x09, 0xCB, 0x1F, 0xE5, 0xB9, 0xC6, 0xC4, 0xBC, 0x52, 0x34, 0xCF, 0x94, 0x40, 0x7A, 0xCC,
	0x79, 0x4E, 0xFD, 0x43, 0x00, 0xB3, 0xF8, 0x01, 0xCD, 0x81, 0xF0, 0x83, 0x59, 0x08, 0x40, 0x21,
	0x04, 0xE0, 0x91, 0x36, 0xF0, 0x91, 0x0A, 0x78, 0x14, 0x87, 0x00, 0x12, 0xB9, 0xC3, 0x1D, 0xFA,
	0x20, 0x0B, 0x0E, 0x78, 0xE2, 0xF6, 0xB7, 0x97, 0x08, 0xD5, 0xDD, 0xC4, 0x7B, 0x00, 0x50, 0xFD,
	0xF7, 0xFF, 0xC0, 0x81, 0x30, 0x52, 0x51, 0x01, 0x99, 0x74, 0x84, 0x03, 0xAC, 0xE7, 0x00, 0x07,
	0x5A, 0x22, 0x9F, 0xDE, 0x7B, 0x64, 0xE0, 0xF5, 0x88, 0xFB, 0x44, 0x24, 0x40, 0xFD, 0xEA, 0x5B,
	0x9F, 0xFA, 0x0B, 0x61, 0x80, 0xF6, 0xB7, 0x56, 0xCF, 0x7D, 0xED, 0x2F, 0xE4, 0xFA, 0xE0, 0x97,
	0xC0, 0x60, 0x0A, 0x63, 0x18, 0xC4, 0x28, 0xE6, 0xC5, 0x8F, 0xE1, 0x18, 0x86, 0x28, 0xB3, 0xA1,
	0xCC, 0x7C, 0xE8, 0xE6, 0x9D, 0x1F, 0x91, 0x00, 0xE6, 0x4F, 0xFF, 0xFA, 0xDB, 0x5F, 0x21, 0x03,
	0xC8, 0x7F, 0xFE, 0x01, 0xA0, 0x01, 0x03, 0xE8, 0x7F, 0x00, 0x17, 0x11, 0x07, 0x71, 0xB0, 0x6D,
	0xC6, 0xA7, 0x10, 0x5B, 0xE0, 0x02, 0x19, 0x50, 0x80, 0x1C, 0x01, 0x00, 0xCA, 0xB7, 0x7C, 0x0A,
	0xD8, 0x11, 0xCE, 0xF7, 0x80, 0x12, 0x38, 0x81, 0x14, 0x58, 0x81, 0x2F, 0x11, 0x10, 0x00, 0x3B,
};
