/*
 * This file is subject to the terms of the GFX License. If a copy of
 * the license was not distributed with this file, you can obtain one at:
 *
 *              http://ugfx.org/license.html
 */

#ifndef _GDISP_LLD_BOARD_H
#define _GDISP_LLD_BOARD_H


/****** LCDӿ *********/
sbit LCD_RS  = P4^5;
sbit LCD_WR  = P4^2;
sbit LCD_CS  = P4^3;
sbit LCD_RST = P4^1;
sfr	 LCD_BUS_H = 0xE8;	//P0--0x80,P1=0x90,P2=0xA0,P3=0x0B0, P6= 0xE8
sfr	 LCD_BUS_L = 0xA0;	//P0--0x80,P1=0x90,P2=0xA0,P3=0x0B0, P6= 0xE8


/**** LCD궨 ***********/

#define LCD_CS_SET()		LCD_CS = 1
#define LCD_CS_CLR()		LCD_CS = 0

#define LCD_RST_SET()		LCD_RST = 1
#define LCD_RST_CLR()		LCD_RST = 0

#define LCD_RS_SET()		LCD_RS = 1
#define LCD_RS_CLR()		LCD_RS = 0

#define LCD_WR_SET()		LCD_WR = 1
#define LCD_WR_CLR()		LCD_WR = 0

#define LCD_RD_SET()		LCD_RD = 1
#define LCD_RD_CLR()		LCD_RD = 0

#define LCD_WriteWord(n) 	LCD_BUS_H = (uint8_t)(n>>8); LCD_BUS_L = (uint8_t)n; NOP(1);	LCD_WR_CLR(); NOP(1);	LCD_WR_SET();	NOP(1);	

#define	LCD_WR_PULSE()		NOP(1);	LCD_WR_CLR(); NOP(1);	LCD_WR_SET()


#define X_DOTS			320		//480: ῴ320

#if (X_DOTS == 320)
	#define Y_DOTS			480
#elif (X_DOTS == 480)
	#define Y_DOTS			320
#endif

//ɫ
#define WHITE       0xFFFF	//ɫ
#define BLACK      	0x0000	//ɫ	  
#define BLUE       	0x001F	//ɫ  
#define BRED        0XF81F
#define GRED 		0XFFE0
#define GBLUE		0X07FF	//
#define RED         0xF800	//ɫ
#define MAGENTA     0xF81F	// Ʒ Ϻ
#define GREEN       0x07E0	//ɫ
#define CYAN        0x7FFF	//ɫ
#define YELLOW      0xFFE0	//ɫ
#define BROWN 		0XBC40	//ɫ
#define BRRED 		0XFC07	//غɫ
#define GRAY  		0X8430	//ɫ


//========================================================================
// : void LCD_delay(uint16_t ms)
// : ʱ
// : ms ʱʱ 1~65535 ms
// : 
// 汾:
//========================================================================
void LCD_delay(uint16_t ms)
{
    uint16_t i;
	do{
	//	i = MAIN_Fosc / 14000;	//STC12F
	//	i = MAIN_Fosc / 13000;	//STC15F
	//	i = MAIN_Fosc / 10000;	//STC8
		i = MAIN_Fosc / 6000;	//STC32G
		while(--i)	;
    }while(--ms);
}


//========================================================================
// : void LCD_WR_REG(uint8_t cmd)
// : дһֽڵLCDеĿƼĴ
// : cmd: Ĵ
// : 
// ע: 
// 汾:
//      2007/04/10      First version
//========================================================================
void LCD_WR_REG(uint16_t cmd)
{
	LCD_RS_CLR();			//point to ID register
	LCD_CS_CLR();
	LCD_BUS_H = (uint8_t)(cmd>>8);
	LCD_BUS_L = (uint8_t)cmd;
	LCD_WR_PULSE();
	LCD_RS_SET();			//point to GRAM
	LCD_CS_SET();
}

//=========== дһֽڵLCDеĿƼĴ ===================
void LCD_WR_DATA(uint16_t dat)
{
//	LCD_RS_SET();			//point to GRAM
	LCD_CS_CLR();
	LCD_BUS_H = (uint8_t)(dat>>8);
	LCD_BUS_L = (uint8_t)dat;
	LCD_WR_PULSE();
	LCD_CS_SET();
}

void	SetView_H(void)		//
{
	LCD_WR_REG(0x36);
//	LCD_WR_DATA(0x28);		//
	LCD_WR_DATA(0x6B);		// ת180

	LCD_WR_REG(0x2A);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(((480-1)>>8));
	LCD_WR_DATA(((480-1)&0xff));

	LCD_WR_REG(0x2B);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(((320-1)>>8));
	LCD_WR_DATA(((320-1)&0xff));
}
void	SetView_V(void)		//
{
	LCD_WR_REG(0x36);
//	LCD_WR_DATA(0x0A);		//
	LCD_WR_DATA(0x49);		// ת180

	LCD_WR_REG(0x2A);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(((320-1)>>8));
	LCD_WR_DATA(((320-1)&0xff));

	LCD_WR_REG(0x2B);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(((480-1)>>8));
	LCD_WR_DATA(((480-1)&0xff));
}


//========================================================================
// : void LCD480x320_Init(void)
// : LCDʼLCDʼҪõĴ
//		 û˽⣬鿴DataSheetиĴ
// :  
// : 
// 汾: V1.0
//========================================================================
void LCD_Init(void)
{
//	P6n_standard(0xff);
//	P2n_standard(0xff);
//	P4n_standard(0x2e);

//	background = 0x00;
//	foreground = 0xffff;

	LCD_RS_SET();
	LCD_CS_SET();
	LCD_BUS_H = 0xFF;
	LCD_BUS_L = 0xFF;
	LCD_WR_SET();

	LCD_RST_SET();
	LCD_delay(150);
	LCD_RST_CLR();
	LCD_delay(150);
	LCD_RST_SET();
	LCD_delay(150);

	//************* ILI9481ʼ**********//
	LCD_WR_REG(0x11);
	LCD_delay(20);
	LCD_WR_REG(0xD0);
	LCD_WR_DATA(0x07);
	LCD_WR_DATA(0x42);
	LCD_WR_DATA(0x18);
	
	LCD_WR_REG(0xD1);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x07);//07
	LCD_WR_DATA(0x10);
	
	LCD_WR_REG(0xD2);
	LCD_WR_DATA(0x01);
	LCD_WR_DATA(0x02);
	
	LCD_WR_REG(0xC0);
	LCD_WR_DATA(0x10);
	LCD_WR_DATA(0x3B);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x02);
	LCD_WR_DATA(0x11);
	
	LCD_WR_REG(0xC5);
	LCD_WR_DATA(0x03);
	
	LCD_WR_REG(0xC8);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x32);
	LCD_WR_DATA(0x36);
	LCD_WR_DATA(0x45);
	LCD_WR_DATA(0x06);
	LCD_WR_DATA(0x16);
	LCD_WR_DATA(0x37);
	LCD_WR_DATA(0x75);
	LCD_WR_DATA(0x77);
	LCD_WR_DATA(0x54);
	LCD_WR_DATA(0x0C);
	LCD_WR_DATA(0x00);
	
	LCD_WR_REG(0x36);
	#if (X_DOTS == 320)
		LCD_WR_DATA(0x0A);
	#endif
	#if (X_DOTS == 480)
		LCD_WR_DATA(0x28);
	#endif
	
	LCD_WR_REG(0x3A);
	LCD_WR_DATA(0x55);
	
	LCD_WR_REG(0x2A);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
//	LCD_WR_DATA(0x01);
//	LCD_WR_DATA(0x3F);
	LCD_WR_DATA(((X_DOTS-1)>>8));
	LCD_WR_DATA(((X_DOTS-1)&0xff));
	
	LCD_WR_REG(0x2B);
	LCD_WR_DATA(0x00);
	LCD_WR_DATA(0x00);
//	LCD_WR_DATA(0x01);
//	LCD_WR_DATA(0xE0);
	LCD_WR_DATA(((Y_DOTS-1)>>8));
	LCD_WR_DATA(((Y_DOTS-1)&0xff));

	LCD_delay(120);
	LCD_WR_REG(0x21);	//ȡʾ, еҪȡʾ
	LCD_WR_REG(0x29);
	LCD_WR_REG(0x2c);

	//LCDԲ
	SetView_V();		//
}


/*************************************************
: void LCD_SetWindows(uint16_t xStar, uint16_t yStar,uint16_t xEnd,uint16_t yEnd)
: lcdʾڣڴдԶ. ÿд xStarʼ yStar, xStar==yStarֻдһ㻻, ڻ.
: xyյ
: 
*************************************************/
void LCD_SetWindows(uint16_t xStar, uint16_t yStar,uint16_t xEnd,uint16_t yEnd)
{
	LCD_WR_REG(0x2a);	
	LCD_WR_DATA((uint8_t)(xStar>>8));
	LCD_WR_DATA((uint8_t)(xStar &0xff));		
	LCD_WR_DATA((uint8_t)(xEnd>>8));
	LCD_WR_DATA((uint8_t)(xEnd &0xff));

	LCD_WR_REG(0x2b);	
	LCD_WR_DATA((uint8_t)(yStar>>8));
	LCD_WR_DATA((uint8_t)(yStar &0xff));		
	LCD_WR_DATA((uint8_t)(yEnd>>8));
	LCD_WR_DATA((uint8_t)(yEnd &0xff)); 

	LCD_WR_REG(0x2c);	//ʼдGRAM
}   

static GFXINLINE void init_board(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
    LCD_Init();
}

static GFXINLINE void post_init_board(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
}

static GFXINLINE void setpin_reset(GDisplay *g, bool_t state) {
	UNUSED(g); /* support KeilC251 */
	LCD_RST=!state;
}

static GFXINLINE void set_backlight(GDisplay *g, uint8_t percent) {
	UNUSED(g); /* support KeilC251 */
	UNUSED(percent); /* support KeilC251 */
}

static GFXINLINE void acquire_bus(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
}

static GFXINLINE void release_bus(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
}

static GFXINLINE void write_index(GDisplay *g, uint16_t index) {
	UNUSED(g); /* support KeilC251 */
	LCD_WR_REG(index);
}

static GFXINLINE void write_data(GDisplay *g, uint16_t _data_) {
	UNUSED(g); /* support KeilC251 */
	LCD_WR_DATA(_data_);
}

static GFXINLINE void setreadmode(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
}

static GFXINLINE void setwritemode(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
}

static GFXINLINE uint16_t read_data(GDisplay *g) {
	UNUSED(g); /* support KeilC251 */
	return 0;
}

#endif /* _GDISP_LLD_BOARD_H */
