#include "spi.h"
#include "system.h"

#if (SPI_DMA_CFG == 1)
bit	SpiDmaFlag;
uint8_t xdata SpiDmaTxBuffer[256]; //_at_ DMA_TX_ADDR;
uint16_t data_index = 0;
#endif

#define SPI_USE_PLL     1       //1:SPIʹøPLLʱ; 0:SPIʹϵͳʱ

//======== PLL ض =========
#define HSCK_MCLK       0
#define HSCK_PLL        1
#define HSCK_SEL        HSCK_PLL

#define PLL_96M         0       //PLLʱ = PLLʱ*8
#define PLL_144M        1       //PLLʱ = PLLʱ*12
#define PLL_SEL         PLL_144M

#define CKMS            0x80
#define HSIOCK          0x40
#define MCK2SEL_MSK     0x0c
#define MCK2SEL_SEL1    0x00
#define MCK2SEL_PLL     0x04
#define MCK2SEL_PLLD2   0x08
#define MCK2SEL_IRC48   0x0c
#define MCKSEL_MSK      0x03
#define MCKSEL_HIRC     0x00
#define MCKSEL_XOSC     0x01
#define MCKSEL_X32K     0x02
#define MCKSEL_IRC32K   0x03

#define ENCKM           0x80
#define PCKI_MSK        0x60
#define PCKI_D1         0x00
#define PCKI_D2         0x20
#define PCKI_D4         0x40
#define PCKI_D8         0x60

#define ENHPLL          0x80

void delay()
{
    int i;
    
    for (i=0; i<100; i++);
}

void PLL_Init(void)
{
    //ѡPLLʱӷƵ,֤ʱΪ6M(Χ4M~8M, 6M +/- 2M)
    USBCLK &= ~PCKI_MSK;
#if (MAIN_Fosc == 6000000UL)
    USBCLK |= PCKI_D1;          //PLLʱ1Ƶ
#elif (MAIN_Fosc == 12000000UL)
    USBCLK |= PCKI_D2;          //PLLʱ2Ƶ
#elif (MAIN_Fosc == 24000000UL)
    USBCLK |= PCKI_D4;          //PLLʱ4Ƶ
#elif (MAIN_Fosc == 48000000UL)
    USBCLK |= PCKI_D8;          //PLLʱ8Ƶ
#else
    USBCLK |= PCKI_D1;          //ĬPLLʱ1Ƶ
#endif

    //PLL
    HPLLCR |= ENHPLL;           //ʹܸPLLƵ(6*52)/2=312/2=156MHz
    
    delay();                    //ȴPLLƵ

    //ѡHSPWM/HSSPIʱ
#if (HSCK_SEL == HSCK_MCLK)
    CLKSEL &= ~HSIOCK;          //HSPWM/HSSPIѡʱΪʱԴ
#elif (HSCK_SEL == HSCK_PLL)
    CLKSEL |= HSIOCK;           //HSPWM/HSSPIѡPLLʱΪʱԴ
#else
    CLKSEL &= ~HSIOCK;          //ĬHSPWM/HSSPIѡʱΪʱԴ
#endif

    //PLL=156M/3=52MHz
    HSCLKDIV = 3;               //HSPWM/HSSPIʱԴ4Ƶ
    
    SPCTL = 0xd3;               //SPIΪģʽ,ٶΪSPIʱ/2(52M/2=26M)
    HSSPI_CFG2 |= 0x20;         //ʹSPIģʽ
}

void HAL_SPI_Init(void)
{
#if (SPI_USE_PLL == 0)
    HSCLKDIV = 0;  //øIOʱӷƵΪ1ƵĬ2ƵʹSPIʱ/2
    SSIG = 1; // SS Źܣʹ MSTR ȷǴӻ
    SPEN = 1; //ʹ SPI 
    DORD = 0; //ȷ/ݵĸλ MSB
    MSTR = 1; //ģʽ
    CPOL = 0; //SCLK ʱΪߵƽSCLK ǰʱΪ½أʱΪ
    CPHA = 0; // SCLK ǰʱʱز
    SPCTL = (SPCTL & ~3) | 3; //SPCTL & 0Xfc;  //SPI ʱƵѡ, 0: 4T, 1: 8T,  2: 16T,  3: 2T
#else
    PLL_Init();     //SPI ʹPLLʱź
#endif
    P2SR = 0x00;                //ƽתٶȿ죨IOڸٷתźţ
    P2DR = 0xff;                //˿ǿ
    
    P_SW1 = (P_SW1 & ~(3<<2)) | (1<<2);     //IOл. 0: P1.2/P5.4 P1.3 P1.4 P1.5, 1: P2.2 P2.3 P2.4 P2.5, 2: P5.4 P4.0 P4.1 P4.3, 3: P3.5 P3.4 P3.3 P3.2
    SPI_SCK = 0;    // set clock to low initial state
    SPI_MOSI = 1;
    SPIF = 1;   //SPIF־
    WCOL = 1;   //WCOL־

#if (SPI_DMA_CFG == 1)
    /*DMA Mode*/
	DMA_SPI_STA = 0x00;
	DMA_SPI_CFG = 0xE0;		//bit7 1:Enable Interrupt
	DMA_SPI_AMT = 0x02;		//ôֽn+1

	DMA_SPI_TXAH = (u8)((u16)&SpiDmaTxBuffer >> 8);	//SPIݴ洢ַ
	DMA_SPI_TXAL = (u8)((u16)&SpiDmaTxBuffer);

	DMA_SPI_CFG2 = 0x00;	//01:P2.2
	DMA_SPI_CR = 0x81;		//bit7 1:ʹ SPI_DMA, bit6 1:ʼ SPI_DMA ģʽ, bit0 1: SPI_DMA FIFO
#endif    
}

void HAL_SPI_Transmit(uint8_t *Mem, uint16_t MemSize, uint32_t Timeout)
{
    uint16_t i = 0; 
    uint32_t TimeoutCnt=Timeout;
#if (SPI_DMA_CFG == 1)
    if(MemSize > 0)
    {
        while(SpiDmaFlag && TimeoutCnt--); 
        for(i = 0; i< MemSize; i++)
        {
            SpiDmaTxBuffer[i] = Mem[i];
        }  
        SpiDmaFlag = 1;
        DMA_SPI_AMT = MemSize - 1;
        DMA_SPI_CR |= 0x40;
    }
#else
    for(i = 0; i< MemSize; i++)
    {
        SPDAT = *(Mem + i);
        while((SPIF == 0) && TimeoutCnt--) ;
        SPIF = 1;   //SPIF־
        WCOL = 1;   //WCOL־
        TimeoutCnt=Timeout;
    }
#endif

}

#if (SPI_DMA_CFG == 1)
void SPI_DMA_Interrupt(void) interrupt 13		
{
	DMA_SPI_STA = 0;
	SpiDmaFlag = 0;
	
}
#endif