/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"APP_DMA_AD.h"
#include	"STC32G_GPIO.h"
#include	"STC32G_ADC.h"
#include	"STC32G_UART.h"
#include	"STC32G_DMA.h"
#include	"STC32G_NVIC.h"


/*************	˵	**************

ʾ·ADC DMA.

ʼʱȰҪADCתΪ.

(DMA)ܣͨһѭɼԶŵDMAxdataռ.

ͨ2(P4.6 P4.7)DMAxdataռյݷ͸λ115200,N,8,1

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾.

ʱ, ѡʱ 24MHz (ļ"config.h"޸).

******************************************/


//========================================================================
//                               س	
//========================================================================

#define	ADC_CH		16			/* 1~16, ADCתͨ, ͬ޸תͨ */
#define	ADC_DATA	12			/* 6~n, ÿͨADCת, 2*ת+4, ͬ޸ת */

//========================================================================
//                               ر
//========================================================================

u8 chn = 0;
u8 xdata DmaAdBuffer[ADC_CH][ADC_DATA];

//========================================================================
//                               غ
//========================================================================


//========================================================================
//                            ⲿͱ
//========================================================================


//========================================================================
// : ADtoUART_init
// : ûʼ.
// : None.
// : None.
// 汾: V1.0, 2020-09-28
//========================================================================
void DMA_AD_init(void)
{
	ADC_InitTypeDef		ADC_InitStructure;		//ṹ
	COMx_InitDefine		COMx_InitStructure;		//ṹ
	DMA_ADC_InitTypeDef		DMA_ADC_InitStructure;		//ṹ

	//----------------------------------------------
	P0_MODE_IN_HIZ(GPIO_Pin_LOW | GPIO_Pin_4 | GPIO_Pin_5 | GPIO_Pin_6);		//P0.0~P0.6 Ϊ
	P1_MODE_IN_HIZ(GPIO_Pin_All);		//P1.0~P1.7 Ϊ
	P4_MODE_IO_PU(GPIO_Pin_6 | GPIO_Pin_7);		//P4.6,P4.7 Ϊ׼˫
	
	//----------------------------------------------
	COMx_InitStructure.UART_Mode      = UART_8bit_BRTx;		//ģʽ,   UART_ShiftRight,UART_8bit_BRTx,UART_9bit,UART_9bit_BRTx
//	COMx_InitStructure.UART_BRT_Use   = BRT_Timer2;			//ѡʷ, BRT_Timer2 (ע: 2̶ʹBRT_Timer2, Բѡ)
	COMx_InitStructure.UART_BaudRate  = 115200ul;			//,     110 ~ 115200
	COMx_InitStructure.UART_RxEnable  = ENABLE;				//,   ENABLE  DISABLE
	UART_Configuration(UART2, &COMx_InitStructure);		//ʼ2 UART1,UART2,UART3,UART4
	NVIC_UART2_Init(ENABLE,Priority_1);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3

	//----------------------------------------------
	ADC_InitStructure.ADC_SMPduty   = 31;		//ADC ģźŲʱ, 0~31ע⣺ SMPDUTY һС 10
	ADC_InitStructure.ADC_CsSetup   = 0;		//ADC ͨѡʱ 0(Ĭ),1
	ADC_InitStructure.ADC_CsHold    = 1;		//ADC ͨѡ񱣳ʱ 0,1(Ĭ),2,3
	ADC_InitStructure.ADC_Speed     = ADC_SPEED_2X16T;		// ADC ʱƵ	ADC_SPEED_2X1T~ADC_SPEED_2X16T
	ADC_InitStructure.ADC_AdjResult = ADC_RIGHT_JUSTIFIED;	//ADC,	ADC_LEFT_JUSTIFIED,ADC_RIGHT_JUSTIFIED
	ADC_Inilize(&ADC_InitStructure);		//ʼ
	ADC_PowerControl(ENABLE);						//ADCԴ, ENABLEDISABLE
	NVIC_ADC_Init(DISABLE,Priority_0);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3

	//----------------------------------------------
	DMA_ADC_InitStructure.DMA_Enable = ENABLE;			//DMAʹ  	ENABLE,DISABLE
	DMA_ADC_InitStructure.DMA_Channel = 0xffff;			//ADCͨʹܼĴ, 1:ʹ, bit15~bit0 Ӧ ADC15~ADC0
	DMA_ADC_InitStructure.DMA_Buffer = (u16)DmaAdBuffer;	//ADCתݴ洢ַ
	DMA_ADC_InitStructure.DMA_Times = ADC_4_Times;	//ÿͨת, ADC_1_Times,ADC_2_Times,ADC_4_Times,ADC_8_Times,ADC_16_Times,ADC_32_Times,ADC_64_Times,ADC_128_Times,ADC_256_Times
	DMA_ADC_Inilize(&DMA_ADC_InitStructure);		//ʼ
	NVIC_DMA_ADC_Init(ENABLE,Priority_0,Priority_0);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0~Priority_3; ȼ(͵) Priority_0~Priority_3
	DMA_ADC_TRIG();		//ת
}

//========================================================================
// : Sample_DMA_AD
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2020-09-24
//========================================================================
void Sample_DMA_AD(void)
{
	u8	i,n;

	if(DmaADCFlag)
	{
		DmaADCFlag = 0;
		for(i=0; i<ADC_CH; i++)
		{
			for(n=0; n<ADC_DATA; n++)
			{
				printf("0x%02bx ",DmaAdBuffer[i][n]);		//1,...,n,ADͨ,ƽ,ƽֵ
			}
			printf("\r\n");
		}
		printf("\r\n");
		DMA_ADC_TRIG();		//´ת
	}
}

