/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"APP_DMA_M2M.h"
#include	"STC32G_GPIO.h"
#include	"STC32G_UART.h"
#include	"STC32G_DMA.h"
#include	"STC32G_NVIC.h"


/*************	˵	**************

ʾDMA Memory to Memoryת.

2洢ռ䣬һһգֱʼ2洢ռ.

M2M DMAϵԶʹ洢д뵽մ洢ռ.

ݲͬĶȡ˳д˳򣬽յͬݽ.

ͨ2(P4.6 P4.7)ӡմ洢(ϵӡһ).

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾.

ʱ, ѡʱ 24MHz (ļ"config.h"޸).

******************************************/


//========================================================================
//                               س	
//========================================================================


//========================================================================
//                               ر
//========================================================================

u8 xdata DmaTxBuffer[256];
u8 xdata DmaRxBuffer[256];

//========================================================================
//                               غ
//========================================================================


//========================================================================
//                            ⲿͱ
//========================================================================


//========================================================================
// : DMA_M2M_init
// : ûʼ.
// : None.
// : None.
// 汾: V1.0, 2020-09-28
//========================================================================
void DMA_M2M_init(void)
{
	u16	i;
	COMx_InitDefine		COMx_InitStructure;		//ṹ
	DMA_M2M_InitTypeDef		DMA_M2M_InitStructure;		//ṹ

	//----------------------------------------------
	P4_MODE_IO_PU(GPIO_Pin_6 | GPIO_Pin_7);		//P4.6,P4.7 Ϊ׼˫
	
	//----------------------------------------------
	COMx_InitStructure.UART_Mode      = UART_8bit_BRTx;		//ģʽ,   UART_ShiftRight,UART_8bit_BRTx,UART_9bit,UART_9bit_BRTx
//	COMx_InitStructure.UART_BRT_Use   = BRT_Timer2;			//ѡʷ, BRT_Timer2 (ע: 2̶ʹBRT_Timer2, Բѡ)
	COMx_InitStructure.UART_BaudRate  = 115200ul;			//,     110 ~ 115200
	COMx_InitStructure.UART_RxEnable  = ENABLE;				//,   ENABLE  DISABLE
	UART_Configuration(UART2, &COMx_InitStructure);		//ʼ2 UART1,UART2,UART3,UART4
	NVIC_UART2_Init(ENABLE,Priority_1);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3
	printf("STC32G Memory to Memory DMA Test Programme!\r\n");  //UARTһַ

	//----------------------------------------------
	DMA_M2M_InitStructure.DMA_Enable = ENABLE;			//DMAʹ  	ENABLE,DISABLE
	DMA_M2M_InitStructure.DMA_Length = 127;					//DMAֽ  	(0~255) + 1

//	DMA_M2M_InitStructure.DMA_Tx_Buffer = (u16)DmaTxBuffer;	//ݴ洢ַ
//	DMA_M2M_InitStructure.DMA_Rx_Buffer = (u16)DmaRxBuffer;	//ݴ洢ַ
//	DMA_M2M_InitStructure.DMA_SRC_Dir = M2M_ADDR_INC;		//Դַı䷽  	M2M_ADDR_INC,M2M_ADDR_DEC
//	DMA_M2M_InitStructure.DMA_DEST_Dir = M2M_ADDR_INC;	//Ŀַı䷽ 	M2M_ADDR_INC,M2M_ADDR_DEC

//	DMA_M2M_InitStructure.DMA_Tx_Buffer = (u16)&DmaTxBuffer[255];	//ݴ洢ַ
//	DMA_M2M_InitStructure.DMA_Rx_Buffer = (u16)DmaRxBuffer;	//ݴ洢ַ
//	DMA_M2M_InitStructure.DMA_SRC_Dir = M2M_ADDR_DEC;		//Դַı䷽  	M2M_ADDR_INC,M2M_ADDR_DEC
//	DMA_M2M_InitStructure.DMA_DEST_Dir = M2M_ADDR_INC;	//Ŀַı䷽ 	M2M_ADDR_INC,M2M_ADDR_DEC

//	DMA_M2M_InitStructure.DMA_Tx_Buffer = (u16)DmaTxBuffer;	//ݴ洢ַ
//	DMA_M2M_InitStructure.DMA_Rx_Buffer = (u16)&DmaRxBuffer[255];	//ݴ洢ַ
//	DMA_M2M_InitStructure.DMA_SRC_Dir = M2M_ADDR_INC;		//Դַı䷽  	M2M_ADDR_INC,M2M_ADDR_DEC
//	DMA_M2M_InitStructure.DMA_DEST_Dir = M2M_ADDR_DEC;	//Ŀַı䷽ 	M2M_ADDR_INC,M2M_ADDR_DEC

	DMA_M2M_InitStructure.DMA_Tx_Buffer = (u16)&DmaTxBuffer[255];	//ݴ洢ַ
	DMA_M2M_InitStructure.DMA_Rx_Buffer = (u16)&DmaRxBuffer[255];	//ݴ洢ַ
	DMA_M2M_InitStructure.DMA_SRC_Dir = M2M_ADDR_DEC;		//Դַı䷽  	M2M_ADDR_INC,M2M_ADDR_DEC
	DMA_M2M_InitStructure.DMA_DEST_Dir = M2M_ADDR_DEC;	//Ŀַı䷽ 	M2M_ADDR_INC,M2M_ADDR_DEC

	DMA_M2M_Inilize(&DMA_M2M_InitStructure);		//ʼ
	NVIC_DMA_M2M_Init(ENABLE,Priority_0,Priority_0);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0~Priority_3; ȼ(͵) Priority_0~Priority_3

	for(i=0; i<256; i++)
	{
		DmaTxBuffer[i] = i;
		DmaRxBuffer[i] = 0;
	}
	DMA_M2M_TRIG();		//ת
}

//========================================================================
// : Sample_DMA_M2M
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2020-09-24
//========================================================================
void Sample_DMA_M2M(void)
{
	u16	i;

	if(DmaM2MFlag)
	{
		DmaM2MFlag = 0;

		for(i=0; i<256; i++)
		{
			printf("%02X ", DmaRxBuffer[i]);
			if((i & 0x0f) == 0x0f)
				printf("\r\n");
		}
	}
}

