/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"APP.h"
#include	"STC32G_GPIO.h"
#include	"STC32G_EEPROM.h"
#include	"STC32G_UART.h"
#include	"STC32G_NVIC.h"

/*************	˵	**************

ͨ2(P4.6 P4.7)STCڲԴEEPROM(FLASH)ждԡ

FLASHд롢Ĳַָ

Ĭϲ:  115200,N,8,1. 

: (ĸִСд)
    E 0x000040             --> 0x000040ַݽв.
    W 0x000040 1234567890  --> 0x000040ַдַ1234567890.
    R 0x000040 10          --> 0x000040ַ10ֽ. 

ע⣺ʱؽ"Ӳѡ"ûEEPROMС

ȷеĵַEEPROMõĴСΧ֮ڡ

ʱ, ѡʱ 24MHz (ļ"config.h"޸).

******************************************/


//========================================================================
//                               س	
//========================================================================

#define     Max_Length       100    //дEEPROM峤

//========================================================================
//                               ر
//========================================================================

u8  tmp[Max_Length];                //EEPROM

//========================================================================
//                               غ
//========================================================================


//========================================================================
//                            ⲿͱ
//========================================================================


//========================================================================
// : EEPROM_init
// : ûʼ.
// : None.
// : None.
// 汾: V1.0, 2020-09-28
//========================================================================
void EEPROM_init(void)
{
	COMx_InitDefine		COMx_InitStructure;					//ṹ

	P4_MODE_IO_PU(GPIO_Pin_6 | GPIO_Pin_7);		//P4.6,P4.7 Ϊ׼˫
	
	COMx_InitStructure.UART_Mode      = UART_8bit_BRTx;		//ģʽ,   UART_ShiftRight,UART_8bit_BRTx,UART_9bit,UART_9bit_BRTx
//	COMx_InitStructure.UART_BRT_Use   = BRT_Timer2;			//ѡʷ, BRT_Timer2 (ע: 2̶ʹBRT_Timer2, Բѡ)
	COMx_InitStructure.UART_BaudRate  = 115200ul;			//,     110 ~ 115200
	COMx_InitStructure.UART_RxEnable  = ENABLE;				//,   ENABLE  DISABLE
	UART_Configuration(UART2, &COMx_InitStructure);		//ʼ2 UART1,UART2,UART3,UART4
	NVIC_UART2_Init(ENABLE,Priority_1);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3

	PrintString2("STC32ϵеƬEEPROMԳ򣬴:\r\n");    //UART2һַ
	PrintString2("E 0x000040             --> 0x000040ַݽв.\r\n");     //UART2һַ
	PrintString2("W 0x000040 1234567890  --> 0x000040ַдַ1234567890.\r\n");  //UART2һַ
	PrintString2("R 0x000040 10          --> 0x000040ַ10ֽ.\r\n");    //UART2һַ
}

//========================================================================
// : CheckData
// : У麯.
// : None.
// : None.
// 汾: V1.0, 2020-09-28
//========================================================================
static u8	CheckData(u8 dat)
{
	if((dat >= '0') && (dat <= '9'))		return (dat-'0');
	if((dat >= 'A') && (dat <= 'F'))		return (dat-'A'+10);
	if((dat >= 'a') && (dat <= 'f'))		return (dat-'a'+10);
	return 0xff;
}

//========================================================================
// : GetAddress
// : 뷽ʽĵַ.
// : .
// : 32λEEPROMַ.
// 汾: V1.0, 2013-6-6
//========================================================================
static u32 GetAddress(void)
{
	u32 address;
	u8  i,j;
	
	address = 0;
	if((RX2_Buffer[2] == '0') && (RX2_Buffer[3] == 'X'))
	{
		for(i=4; i<10; i++)
		{
			j = CheckData(RX2_Buffer[i]);
			if(j >= 0x10)   return 0xffffffff;   //error
			address = (address << 4) + j;
		}
		return (address);
	}
	return  0xffffffff;  //error
}

//========================================================================
// : GetDataLength
// : ȡҪݵֽ.
// : .
// : Ҫݵֽ.
// 汾: V1.0, 2013-6-6
//========================================================================
static u8 GetDataLength(void)
{
	u8  i;
	u8  length;
	
	length = 0;
	for(i=11; i<COM2.RX_Cnt; i++)
	{
		if(CheckData(RX2_Buffer[i]) >= 10)  break;
		length = length * 10 + CheckData(RX2_Buffer[i]);
	}
	return (length);
}

//========================================================================
// : Sample_EEPROM
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2020-09-28
//========================================================================
void Sample_EEPROM(void)
{
	u8  i,j;
	u32 addr;
	u8  status;

	if(COM2.RX_TimeOut > 0)		//ʱ
	{
		if(--COM2.RX_TimeOut == 0)
		{
//			printf("յ£ ");
//			for(i=0; i<COM2.RX_Cnt; i++)    printf("%c", RX2_Buffer[i]);    //յԭ,ڲ
//			printf("\r\n");

			status = 0xff;  //״̬һ0ֵ
			if((COM2.RX_Cnt >= 10) && (RX2_Buffer[1] == ' ')) //Ϊ10ֽ
			{
				for(i=0; i<10; i++)
				{
					if((RX2_Buffer[i] >= 'a') && (RX2_Buffer[i] <= 'z'))    RX2_Buffer[i] = RX2_Buffer[i] - 'a' + 'A';  //Сдתд
				}
				addr = GetAddress();
				if(addr < 0x00ffffff)    //ƵַΧ
				{
					if(RX2_Buffer[0] == 'E')    //дNֽ
					{
						EEPROM_SectorErase(addr);           //
						PrintString2("ɹ\r\n");
						status = 0; //ȷ
					}

					else if((RX2_Buffer[0] == 'W') && (RX2_Buffer[10] == ' '))    //дNֽ
					{
						j = COM2.RX_Cnt - 11;
						if(j > Max_Length)  j = Max_Length; //Խ
						//EEPROM_SectorErase(addr);           //
						EEPROM_write_n(addr,&RX2_Buffer[11],j);      //дNֽ
						PrintString2("д");
						if(j >= 100)    {TX2_write2buff((u8)(j/100+'0'));   j = j % 100;}
						if(j >= 10)     {TX2_write2buff((u8)(j/10+'0'));    j = j % 10;}
						TX2_write2buff((u8)(j%10+'0'));
						PrintString2("ֽڣ\r\n");
						status = 0; //ȷ
					}

					else if((RX2_Buffer[0] == 'R') && (RX2_Buffer[10] == ' '))   //PC󷵻NֽEEPROM
					{
						j = GetDataLength();
						if(j > Max_Length)  j = Max_Length; //Խ
						if(j > 0)
						{
							PrintString2("");
							TX2_write2buff((u8)(j/10+'0'));
							TX2_write2buff((u8)(j%10+'0'));
							PrintString2("ֽ£\r\n");
							EEPROM_read_n(addr,tmp,j);
							for(i=0; i<j; i++)  TX2_write2buff(tmp[i]);
							TX2_write2buff(0x0d);
							TX2_write2buff(0x0a);
							status = 0; //ȷ
						}
					}
				}
			}
			if(status != 0) PrintString2("\r\n");
			COM2.RX_Cnt = 0;
		}
	}
}
