/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"APP.h"
#include	"STC32G_GPIO.h"
#include	"STC32G_I2C.h"
#include	"STC32G_Soft_I2C.h"
#include	"STC32G_NVIC.h"
#include	"STC32G_Switch.h"

/*************	˵	**************

ڲI2C߿ӻģʽSCL->P3.2, SDA->P3.3;
IOģI2CģʽSCL->P0.0, SDA->P0.1;
ͨⲿ P0.0->P3.2, P0.1->P3.3ʵI2CԷչܡ

STCMCUIOʽ8λܡ
ʹTimer016λԶװ1ms,,û޸MCUʱƵʱ,Զʱ1ms.
ÿӼ1, ΧΪ0~9999.

ʾЧΪ: ϵÿӷһμݣ4ʾݣӻյݺұ4ʾ

ʱ, ѡʱ 24MHz (ļ"config.h"޸).

******************************************/

//========================================================================
//                               س	
//========================================================================


//========================================================================
//                               ر
//========================================================================

u8  temp[4];     //ͨ

//========================================================================
//                               غ
//========================================================================


//========================================================================
//                            ⲿͱ
//========================================================================


//========================================================================
// : I2C_PS_init
// : ûʼ.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void I2C_PS_init(void)
{
	u8  i;
	I2C_InitTypeDef		I2C_InitStructure;

	P0_MODE_IO_PU(GPIO_Pin_0 | GPIO_Pin_1);		//P0.0,P0.1 Ϊ׼˫
	P3_MODE_IO_PU(GPIO_Pin_3);			//P3.3 Ϊ׼˫
	P6_MODE_IO_PU(GPIO_Pin_All);		//P6 Ϊ׼˫
	P7_MODE_IO_PU(GPIO_Pin_All);		//P7 Ϊ׼˫
	I2C_SW(I2C_P33_P32);					//I2C_P14_P15,I2C_P24_P25,I2C_P76_P77,I2C_P33_P32

	I2C_InitStructure.I2C_Mode      = I2C_Mode_Slave;		//ѡ   I2C_Mode_Master, I2C_Mode_Slave
	I2C_InitStructure.I2C_Enable    = ENABLE;						//I2Cʹ,   ENABLE, DISABLE
	I2C_InitStructure.I2C_SL_MA     = ENABLE;						//ʹܴӻַȽϹ,   ENABLE, DISABLE
	I2C_InitStructure.I2C_SL_ADR    = 0x2d;							//ӻ豸ַ,  0~127  (0x2d<<1 = 0x5a)
	I2C_Init(&I2C_InitStructure);
	NVIC_I2C_Init(I2C_Mode_Slave,I2C_ESTAI|I2C_ERXI|I2C_ETXI|I2C_ESTOI,Priority_0);	//ģʽ, I2C_Mode_Master, I2C_Mode_Slave; жʹ, I2C_ESTAI/I2C_ERXI/I2C_ETXI/I2C_ESTOI/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3

	display_index = 0;
	DisplayFlag = 0;
	for(i=0; i<8; i++)  LED8[i] = 0x10; //ϵ
}

//========================================================================
// : Sample_I2C_PS
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void Sample_I2C_PS(void)
{
	DisplayScan();
	
	if(DisplayFlag)
	{
		DisplayFlag = 0;
		LED8[4] = I2C_Buffer[0];
		LED8[5] = I2C_Buffer[1];
		LED8[6] = I2C_Buffer[2];
		LED8[7] = I2C_Buffer[3];
	}
	
	if(++msecond >= 1000)   //1뵽
	{
		msecond = 0;        //1000ms
		second++;         //+1
		if(second >= 200)    second = 0;   //ΧΪ0~199

		temp[0] = second / 1000;
		temp[1] = (second % 1000) / 100;
		temp[2] = (second % 100) / 10;
		temp[3] = second % 10;
		LED8[0] = temp[0];
		LED8[1] = temp[1];
		LED8[2] = temp[2];
		LED8[3] = temp[3];

		SI2C_WriteNbyte(SLAW, 0, temp, 4);
	}
}
