/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"APP.h"
#include	"STC32G_RTC.h"
#include	"STC32G_GPIO.h"
#include	"STC32G_UART.h"
#include	"STC32G_NVIC.h"
#include	"STC32G_Switch.h"

/*************	˵	**************

доƬڲɵRTCģ.

STCMCUIOʽ8λܡ

ʹTimer016λԶװ1ms,, û޸MCUʱƵʱ,Զʱ1ms.

8λʾʱ(Сʱ--).

ɨ谴Ϊ25~32.

ֵֻ֧, ֶ֧ͬʱ, вԤ֪Ľ.

³1,10/ٶṩؼ. ûֻҪKeyCodeǷ0жϼǷ.

ʱ:
25: Сʱ+.
26: Сʱ-.
27: +.
28: -.

ʱ, ѡʱ 24MHz (ļ"config.h"޸).

******************************************/

//========================================================================
//                               س	
//========================================================================

#define SleepModeSet  0        //0:ģʽʹʾʱܽ; 1:ʹģʽ

//========================================================================
//                               ر
//========================================================================


//========================================================================
//                               غ
//========================================================================

void IO_KeyScan(void);   //50ms call
void DisplayRTC(void);
void WriteRTC(void);

//========================================================================
//                            ⲿͱ
//========================================================================

extern bit B_1S;
extern bit B_Alarm;

//========================================================================
// : RTC_init
// : ûʼ.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void RTC_init(void)
{
	u8  i;
	RTC_InitTypeDef		RTC_InitStructure;
	COMx_InitDefine		COMx_InitStructure;					//ṹ

	RTC_InitStructure.RTC_Clock  = RTC_IRC32KCR;	//RTC ʱ, RTC_IRC32KCR, RTC_X32KCR
	RTC_InitStructure.RTC_Enable = ENABLE;			//I2Cʹ,   ENABLE, DISABLE
	RTC_InitStructure.RTC_Year   = 21;					//RTC , 00~99, Ӧ2000~2099
	RTC_InitStructure.RTC_Month  = 12;					//RTC , 01~12
	RTC_InitStructure.RTC_Day    = 31;					//RTC , 01~31
	RTC_InitStructure.RTC_Hour   = 23;					//RTC ʱ, 00~23
	RTC_InitStructure.RTC_Min    = 59;					//RTC , 00~59
	RTC_InitStructure.RTC_Sec    = 55;					//RTC , 00~59
	RTC_InitStructure.RTC_Ssec   = 00;					//RTC 1/128, 00~127

	RTC_InitStructure.RTC_ALAHour= 00;					//RTC ʱ, 00~23
	RTC_InitStructure.RTC_ALAMin = 00;					//RTC ӷ, 00~59
	RTC_InitStructure.RTC_ALASec = 00;					//RTC , 00~59
	RTC_InitStructure.RTC_ALASsec= 00;					//RTC 1/128, 00~127
	RTC_Inilize(&RTC_InitStructure);
	NVIC_RTC_Init(RTC_ALARM_INT|RTC_SEC_INT,Priority_0);		//жʹ, RTC_ALARM_INT/RTC_DAY_INT/RTC_HOUR_INT/RTC_MIN_INT/RTC_SEC_INT/RTC_SEC2_INT/RTC_SEC8_INT/RTC_SEC32_INT/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3

	COMx_InitStructure.UART_Mode      = UART_8bit_BRTx;		//ģʽ,   UART_ShiftRight,UART_8bit_BRTx,UART_9bit,UART_9bit_BRTx
	COMx_InitStructure.UART_BRT_Use   = BRT_Timer2;			//ѡʷ, BRT_Timer2 (ע: 2̶ʹBRT_Timer2, Բѡ)
	COMx_InitStructure.UART_BaudRate  = 115200ul;			//,     110 ~ 115200
	COMx_InitStructure.UART_RxEnable  = DISABLE;			//սֹ,   ENABLE  DISABLE
	UART_Configuration(UART1, &COMx_InitStructure);		//ʼ2 UART1,UART2,UART3,UART4
	NVIC_UART1_Init(ENABLE,Priority_1);		//жʹ, ENABLE/DISABLE; ȼ(͵) Priority_0,Priority_1,Priority_2,Priority_3
	
	P0_MODE_IO_PU(GPIO_Pin_All);		//P0 Ϊ׼˫
	P6_MODE_IO_PU(GPIO_Pin_All);		//P6 Ϊ׼˫
	P7_MODE_IO_PU(GPIO_Pin_All);		//P7 Ϊ׼˫
	display_index = 0;
	
	for(i=0; i<8; i++)  LED8[i] = 0x10; //ϵ
    
	KeyHoldCnt = 0; //¼ʱ
	KeyCode = 0;    //ûʹõļ

	IO_KeyState = 0;
	IO_KeyState1 = 0;
	IO_KeyHoldCnt = 0;
	cnt50ms = 0;

	printf("STC32G RTC Test!\r\n");
}

//========================================================================
// : Sample_RTC
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void Sample_RTC(void)
{
	if(B_1S)
	{
		B_1S = 0;
		DisplayRTC();
		printf("Year=20%d,Month=%d,Day=%d,Hour=%d,Minute=%d,Second=%d\r\n",YEAR,MONTH,DAY,HOUR,MIN,SEC);
	}

	if(B_Alarm)
	{
		B_Alarm = 0;
		printf("RTC Alarm!\r\n");
	}

#if(SleepModeSet == 1)
		_nop_();
		_nop_();
		PD = 1;  //STC32G оƬʹڲ32Kʱӣ޷
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#else
	DisplayScan();
	
	if(++cnt50ms >= 50)     //50msɨһм
	{
		cnt50ms = 0;
		IO_KeyScan();
	}
	
	if(KeyCode != 0)        //м
	{
		if(KeyCode == 25)   //hour +1
		{
			if(++hour >= 24)    hour = 0;
			WriteRTC();
			DisplayRTC();
		}
		if(KeyCode == 26)   //hour -1
		{
			if(--hour >= 24)    hour = 23;
			WriteRTC();
			DisplayRTC();
		}
		if(KeyCode == 27)   //minute +1
		{
			second = 0;
			if(++minute >= 60)  minute = 0;
			WriteRTC();
			DisplayRTC();
		}
		if(KeyCode == 28)   //minute -1
		{
			second = 0;
			if(--minute >= 60)  minute = 59;
			WriteRTC();
			DisplayRTC();
		}

		KeyCode = 0;
	}
#endif
}

//========================================================================
// : DisplayRTC
// : ʾʱӺ.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void DisplayRTC(void)
{
    hour = HOUR;
    minute = MIN;

    if(HOUR >= 10)  LED8[0] = HOUR / 10;
    else            LED8[0] = DIS_BLACK;
    LED8[1] = HOUR % 10;
    LED8[2] = DIS_;
    LED8[3] = MIN / 10;
    LED8[4] = MIN % 10;
    LED8[5] = DIS_;
    LED8[6] = SEC / 10;
    LED8[7] = SEC % 10;
}


//========================================================================
// : WriteRTC
// : дRTC.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void WriteRTC(void)
{
    INIYEAR = YEAR;   //̳еǰ
    INIMONTH = MONTH;
    INIDAY = DAY;

    INIHOUR = hour;   //޸ʱ
    INIMIN = minute;
    INISEC = 0;
    INISSEC = 0;
    RTCCFG |= 0x01;   //RTCĴʼ
}


/*****************************************************
    мɨ
    ʹXY4x4ķֻܵٶȿ

   Y     P04      P05      P06      P07
          |        |        |        |
X         |        |        |        |
P00 ---- K00 ---- K01 ---- K02 ---- K03 ----
          |        |        |        |
P01 ---- K04 ---- K05 ---- K06 ---- K07 ----
          |        |        |        |
P02 ---- K08 ---- K09 ---- K10 ---- K11 ----
          |        |        |        |
P03 ---- K12 ---- K13 ---- K14 ---- K15 ----
          |        |        |        |
******************************************************/


//========================================================================
// : IO_KeyDelay
// : ɨӳٳ.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void IO_KeyDelay(void)
{
    u8 i;
    i = 60;
    while(--i)  ;
}

//========================================================================
// : IO_KeyScan
// : ɨ.
// : None.
// : None.
// 汾: V1.0, 2020-09-25
//========================================================================
void IO_KeyScan(void)    //50ms call
{
    u8  j;

    j = IO_KeyState1;   //һ״̬

    P0 = 0xf0;  //XͣY
    IO_KeyDelay();
    IO_KeyState1 = P0 & 0xf0;

    P0 = 0x0f;  //YͣX
    IO_KeyDelay();
    IO_KeyState1 |= (P0 & 0x0f);
    IO_KeyState1 ^= 0xff;   //ȡ
    
    if(j == IO_KeyState1)   //ζ
    {
        j = IO_KeyState;
        IO_KeyState = IO_KeyState1;
        if(IO_KeyState != 0)    //м
        {
            F0 = 0;
            if(j == 0)  F0 = 1; //һΰ
            else if(j == IO_KeyState)
            {
                if(++IO_KeyHoldCnt >= 20)   //1ؼ
                {
                    IO_KeyHoldCnt = 18;
                    F0 = 1;
                }
            }
            if(F0)
            {
                j = T_KeyTable[IO_KeyState >> 4];
                if((j != 0) && (T_KeyTable[IO_KeyState& 0x0f] != 0)) 
                    KeyCode = (j - 1) * 4 + T_KeyTable[IO_KeyState & 0x0f] + 16;    //룬17~32
            }
        }
        else    IO_KeyHoldCnt = 0;
    }
    P0 = 0xff;
}

