/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"STC32G_I2C.h"

u8 I2C_BUF_type I2C_Buffer[I2C_BUF_LENTH];

#define SLAW    0xA2
#define SLAR    0xA3

//========================================================================
// : void I2C_Init(I2C_InitTypeDef *I2Cx)
// : I2Cʼ.
// : I2Cx: ṹ,οI2C.hĶ.
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void I2C_Init(I2C_InitTypeDef *I2Cx)
{
	if(I2Cx->I2C_Mode == I2C_Mode_Master)
	{
		I2C_Master();			//Ϊ	
		I2CMSST = 0x00;		//I2C״̬Ĵ
		I2C_SetSpeed(I2Cx->I2C_Speed);
		if(I2Cx->I2C_MS_WDTA == ENABLE)		I2C_WDTA_EN();	//ʹԶ
		else									I2C_WDTA_DIS();	//ֹԶ
	}
	else
	{
		I2C_Slave();	//Ϊӻ
		I2CSLST = 0x00;		//I2Cӻ״̬Ĵ
		I2C_Address(I2Cx->I2C_SL_ADR);
		if(I2Cx->I2C_SL_MA == ENABLE)		I2C_MATCH_EN();	//ӻַȽϹܣֻƥַ
		else									I2C_MATCH_DIS();	//ֹӻַȽϹܣ豸ַ
	}
	
	I2C_Function(I2Cx->I2C_Enable);
}

//========================================================================
// : u8	Get_MSBusy_Status (void)
// : ȡæµ״̬.
// : none.
// : æµ״̬.
// 汾: V1.0, 2012-11-22
//========================================================================
u8 Get_MSBusy_Status(void)
{
	return (I2CMSST & 0x80);
}

//========================================================================
// : void	Wait (void)
// : ȴģʽI2CִI2CMSCR.
// : none.
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void Wait()
{
	while (!(I2CMSST & 0x40));
	I2CMSST &= ~0x40;
}

//========================================================================
// : void Start (void)
// : I2Cʼ.
// : none.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void Start()
{
	I2CMSCR = 0x01;                         //START
	Wait();
}

//========================================================================
// : void SendData (char dat)
// : I2Cһֽݺ.
// : ͵.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void SendData(char dat)
{
	I2CTXD = dat;                           //дݵݻ
	I2CMSCR = 0x02;                         //SEND
	Wait();
}

//========================================================================
// : void RecvACK (void)
// : I2CȡACK.
// : none.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void RecvACK()
{
	I2CMSCR = 0x03;                         //ͶACK
	Wait();
}

//========================================================================
// : char RecvData (void)
// : I2Cȡһֽݺ.
// : none.
// : ȡ.
// 汾: V1.0, 2020-09-15
//========================================================================
char RecvData()
{
	I2CMSCR = 0x04;                         //RECV
	Wait();
	return I2CRXD;
}

//========================================================================
// : void SendACK (void)
// : I2CACK.
// : none.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void SendACK()
{
	I2CMSST = 0x00;                         //ACKź
	I2CMSCR = 0x05;                         //ACK
	Wait();
}

//========================================================================
// : void SendNAK (void)
// : I2CNAK.
// : none.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void SendNAK()
{
	I2CMSST = 0x01;                         //NAKź
	I2CMSCR = 0x05;                         //ACK
	Wait();
}

//========================================================================
// : void Stop (void)
// : I2Cֹͣ.
// : none.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void Stop()
{
	I2CMSCR = 0x06;                         //STOP
	Wait();
}

//========================================================================
// : void SendCmdData (u8 cmd, u8 dat)
// : I2Cһֽݺ.
// : /.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void SendCmdData(u8 cmd, u8 dat)
{
	I2CTXD = dat;                           //дݵݻ
	I2CMSCR = cmd;                          //
	Wait();
}

//========================================================================
// : void I2C_WriteNbyte(u8 dev_addr, u8 mem_addr, u8 *p, u8 number)
// : I2Cдݺ.
// : dev_addr: 豸ַ, mem_addr: 洢ַ, *pдݴ洢λ, numberдݸ.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void I2C_WriteNbyte(u8 dev_addr, u8 mem_addr, u8 *p, u8 number)  /*  DeviceAddress,WordAddress,First Data Address,Byte lenth   */
{
	Start();                                //ʼ
	SendData(dev_addr);                     //豸ַ+д
	RecvACK();
	SendData(mem_addr);                     //ʹ洢ַ
	RecvACK();
	do
	{
		SendData(*p++);
		RecvACK();
	}
	while(--number);
	Stop();                                 //ֹͣ
}

//========================================================================
// : void I2C_ReadNbyte(u8 dev_addr, u8 mem_addr, u8 *p, u8 number)
// : I2Cȡݺ.
// : dev_addr: 豸ַ, mem_addr: 洢ַ, *pȡݴ洢λ, numberȡݸ.
// : none.
// 汾: V1.0, 2020-09-15
//========================================================================
void I2C_ReadNbyte(u8 dev_addr, u8 mem_addr, u8 *p, u8 number)   /*  DeviceAddress,WordAddress,First Data Address,Byte lenth   */
{
	Start();                                //ʼ
	SendData(dev_addr);                     //豸ַ+д
	RecvACK();
	SendData(mem_addr);                     //ʹ洢ַ
	RecvACK();
	Start();                                //ʼ
	SendData(dev_addr|1);                   //豸ַ+
	RecvACK();
	do
	{
		*p = RecvData();
		p++;
		if(number != 1) SendACK();          //send ACK
	}
	while(--number);
	SendNAK();                              //send no ACK	
	Stop();                                 //ֹͣ
}
