/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include	"STC32G_I2C.h"

//========================================================================
//                               ر
//========================================================================

I2C_IsrTypeDef I2CIsr;
bit DisplayFlag;

//========================================================================
//                            ⲿͱ
//========================================================================


//========================================================================
// : I2C_ISR_Handler
// : I2CжϺ.
// : none.
// : none.
// 汾: V1.0, 2020-09-23
//========================================================================
void I2C_ISR_Handler() interrupt I2C_VECTOR
{
	// TODO: ڴ˴û

	// ģʽ
	I2CMSST &= ~0x40;       //I2Cָ״̬

	if(DMA_I2C_CR & 0x04)   //ACKERR
	{
		DMA_I2C_CR &= ~0x04;  //ݺյNAK
	}

	// ӻģʽ
	if (I2CSLST & 0x40)
	{
		I2CSLST &= ~0x40;                       //START¼
	}
	else if (I2CSLST & 0x20)
	{
		I2CSLST &= ~0x20;                       //RECV¼SLACKOΪ0
		if (I2CIsr.isda)
		{
			I2CIsr.isda = 0;                    //RECV¼RECV DEVICE ADDR
		}
		else if (I2CIsr.isma)
		{
			I2CIsr.isma = 0;                    //RECV¼RECV MEMORY ADDR
			I2CIsr.addr = I2CRXD;
			I2CTXD = I2C_Buffer[I2CIsr.addr];
		}
		else
		{
			I2C_Buffer[I2CIsr.addr++] = I2CRXD; //RECV¼RECV DATA
		}
	}
	else if (I2CSLST & 0x10)
	{
		I2CSLST &= ~0x10;                       //SEND¼
		if (I2CSLST & 0x02)
		{
			I2CTXD = 0xff;
		}
		else
		{
			I2CTXD = I2C_Buffer[++I2CIsr.addr];
		}
	}
	else if (I2CSLST & 0x08)
	{
		I2CSLST &= ~0x08;                       //STOP¼
		I2CIsr.isda = 1;
		I2CIsr.isma = 1;
		DisplayFlag = 1;
	}
}

