
/*------------------------------------------------------------------*/
/* --- STC MCU International Limited -------------------------------*/
/* --- STC 1T Series MCU Demo --------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ---------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ---------------------*/
/* --- Web: www.stcmcudata.com -------------------------------------*/
/* --- QQ:  800003751 ----------------------------------------------*/
/* If you want to use the program or the program referenced in the  */
/* article, please specify in which data and procedures from STC    */
/*------------------------------------------------------------------*/

#ifndef	_STC32G_H
#define	_STC32G_H

#include <intrins.h>

/*  BYTE Registers  */
sfr P0    = 0x80;
sfr SP    = 0x81;
sfr DPL   = 0x82;
sfr DPH   = 0x83;
sfr DPXL  = 0x84;
sfr	SPH   = 0x85;
sfr PCON  = 0x87;

sfr TCON = 0x88;
sfr TMOD = 0x89;
sfr TL0  = 0x8A;
sfr TL1  = 0x8B;
sfr TH0  = 0x8C;
sfr TH1  = 0x8D;
sfr	AUXR = 0x8E;
sfr INTCLKO  = 0x8F;

sfr P1    = 0x90;
sfr P1M1  = 0x91;	//P1M1.n,P1M0.n 	=00--->Standard,	01--->push-pull		ʵ1TĶһ
sfr P1M0  = 0x92;	//					=10--->pure input,	11--->open drain
sfr P0M1  = 0x93;	//P0M1.n,P0M0.n 	=00--->Standard,	01--->push-pull
sfr P0M0  = 0x94;	//					=10--->pure input,	11--->open drain
sfr P2M1  = 0x95;	//P2M1.n,P2M0.n 	=00--->Standard,	01--->push-pull
sfr P2M0  = 0x96;	//					=10--->pure input,	11--->open drain
sfr	AUXR2 = 0x97;

sfr SCON  = 0x98;  //1ƼĴ
sfr SBUF  = 0x99;  //1ݼĴ
sfr S2CON = 0x9A;  //2ƼĴ
sfr S2BUF = 0x9B;  //2ݼĴ
sfr IRCBAND = 0x9D;	//IRCƵѡ
sfr LIRTRIM = 0x9E;	//IRCƵ΢Ĵ
sfr IRTRIM  = 0x9F;	//IRCƵʵĴ

sfr P2    = 0xA0;
sfr BUS_SPEED = 0xA1;
sfr P_SW1 = 0xA2;	//˿лĴ1

sfr IE    = 0xA8;
sfr SADDR = 0xA9;
sfr WKTCL = 0xAA;  //Ѷʱֽ
sfr WKTCH = 0xAB;  //Ѷʱֽ
sfr	S3CON = 0xAC;  //4ƼĴ
sfr S3BUF = 0xAD;  //4ݼĴ
sfr TA    = 0xAE;  //DPTRʱƼĴ
sfr IE2   = 0xAF;  //жĴ2

sfr P3    = 0xB0;
sfr P3M1  = 0xB1;	//P3M1.n,P3M0.n 	=00--->Standard,	01--->push-pull
sfr P3M0  = 0xB2;	//					=10--->pure input,	11--->open drain
sfr P4M1  = 0xB3;	//P4M1.n,P4M0.n 	=00--->Standard,	01--->push-pull
sfr P4M0  = 0xB4;	//					=10--->pure input,	11--->open drain
sfr IP2   = 0xB5;	//
sfr IP2H  = 0xB6;	//
sfr IPH   = 0xB7;

sfr IP        = 0xB8;
sfr SADEN     = 0xB9;
sfr	P_SW2     = 0xBA;	//˿лĴ2
sfr	P_SW3     = 0xBB;	//˿лĴ3
sfr ADC_CONTR = 0xBC;	//ADCƼĴ
sfr ADC_RES   = 0xBD;	//ADCֽ
sfr ADC_RESL  = 0xBE;	//ADCֽ

sfr P4        = 0xC0;
sfr WDT_CONTR = 0xC1;
sfr IAP_DATA  = 0xC2;
sfr IAP_ADDRH = 0xC3;
sfr IAP_ADDRL = 0xC4;
sfr IAP_CMD   = 0xC5;
sfr IAP_TRIG  = 0xC6;
sfr IAP_CONTR = 0xC7;

sfr ISP_DATA  = 0xC2;
sfr ISP_ADDRH = 0xC3;
sfr ISP_ADDRL = 0xC4;
sfr ISP_CMD   = 0xC5;
sfr ISP_TRIG  = 0xC6;
sfr ISP_CONTR = 0xC7;

sfr P5     = 0xC8;	//
sfr P5M1   = 0xC9;	//	P5M1.n,P5M0.n 	=00--->Standard,	01--->push-pull
sfr P5M0   = 0xCA;	//					=10--->pure input,	11--->open drain
sfr P6M1   = 0xCB;	//	P6M1.n,P6M0.n 	=00--->Standard,	01--->push-pull
sfr P6M0   = 0xCC;	//					=10--->pure input,	11--->open drain
sfr SPSTAT = 0xCD;	//SPI״̬Ĵ
sfr SPCTL  = 0xCE;	//SPIƼĴ
sfr SPDAT  = 0xCF;	//SPIݼĴ

sfr PSW    = 0xD0;	//״̬Ĵ
sfr	PSW1   = 0xD1;	//״̬Ĵ1
sfr	T4H    = 0xD2;
sfr	T4L    = 0xD3;
sfr	T3H    = 0xD4;
sfr	T3L    = 0xD5;
sfr	T2H    = 0xD6;
sfr	T2L    = 0xD7;

sfr	TH4    = 0xD2;
sfr	TL4    = 0xD3;
sfr	TH3    = 0xD4;
sfr	TL3    = 0xD5;
sfr	TH2    = 0xD6;
sfr	TL2    = 0xD7;

sfr	IAP_DATA1  = 0xD9;  //IAPݼĴ1
sfr	IAP_DATA2  = 0xDA;  //IAPݼĴ2
sfr	IAP_DATA3  = 0xDB;  //IAPݼĴ3
sfr USBCLK     = 0xDC;  //USBʱӿƼĴ
sfr T4T3M      = 0xDD;
sfr	ADCCFG     = 0xDE;  //ADCüĴ
sfr	IP3        = 0xDF;  //жȼƼĴ3

sfr ACC    = 0xE0;
sfr	P7M1   = 0xE1;	//	P7M1.n,P7M0.n 	=00--->Standard,	01--->push-pull
sfr	P7M0   = 0xE2;	//					=10--->pure input,	11--->open drain
sfr	DPS    = 0xE3;	//DPTRָѡĴ
sfr	DPL1   = 0xE4;	//2ָֽ
sfr	DPH1   = 0xE5;	//2ָֽ
sfr	CMPCR1 = 0xE6;	//ȽƼĴ1
sfr	CMPCR2 = 0xE7;	//ȽƼĴ2

sfr	P6     = 0xE8;
sfr	WTST   = 0xE9;	//ȡƼĴ
sfr	CKCON  = 0xEA;  //XRAMƼĴ
sfr	MXAX   = 0xEB;  //MOVXչַĴ
sfr USBDAT = 0xEC;	//USBݼĴ
sfr	DMAIR  = 0xED;  //FMU DMAָĴ
sfr	IP3H   = 0xEE;	//жȼƼĴ3
sfr	AUXINTIF = 0xEF;	//չⲿжϱ־Ĵ B6-INT4IF, B5-INT3IF, B4-INT2IF, B2-T4IF, B1-T3IF, B0-T2IF

sfr B        = 0xF0;
sfr	CANICR   = 0xF1;  //CANBUSжϿƼĴ
sfr USBCON   = 0xF4;  //USBƼĴ
sfr	IAP_TPS  = 0xF5;  //IAPȴʱƼĴ
sfr	IAP_ADDRE  = 0xF6;  //IAPչߵַĴ
sfr	ICHE     = 0xF7;  //CACHEƼĴ

sfr	P7       = 0xF8;
sfr	LINICR   = 0xF9;  //LINBUSжϿƼĴ
sfr	LINAR    = 0xFA;  //LINBUSַĴ
sfr	LINDR    = 0xFB;  //LINBUSݼĴ
sfr USBADR   = 0xFC;  //USBַĴ
sfr	S4CON    = 0xFD;  //4ƼĴ
sfr	S4BUF    = 0xFE;  //4ݼĴ
sfr	RSTCFG   = 0xFF;  //λüĴ

//=============================================================================================================
#define DMA_M2M_CFG     (*(unsigned char volatile far *)0x7efa00)	/*  M2M_DMAüĴ */
#define DMA_M2M_CR      (*(unsigned char volatile far *)0x7efa01)	/*  M2M_DMAƼĴ */
#define DMA_M2M_STA     (*(unsigned char volatile far *)0x7efa02)	/*  M2M_DMA״̬Ĵ */
#define DMA_M2M_AMT     (*(unsigned char volatile far *)0x7efa03)	/*  M2M_DMAֽ */
#define DMA_M2M_DONE    (*(unsigned char volatile far *)0x7efa04)	/*  M2M_DMAֽ */
#define DMA_M2M_TXAH    (*(unsigned char volatile far *)0x7efa05)	/*  M2M_DMA͸ߵַ */
#define DMA_M2M_TXAL    (*(unsigned char volatile far *)0x7efa06)	/*  M2M_DMA͵͵ַ */
#define DMA_M2M_RXAH    (*(unsigned char volatile far *)0x7efa07)	/*  M2M_DMAոߵַ */
#define DMA_M2M_RXAL    (*(unsigned char volatile far *)0x7efa08)		/*  M2M_DMAյصַ */

#define DMA_ADC_CFG     (*(unsigned char volatile far *)0x7efa10)	/*  ADC_DMAüĴ */
#define DMA_ADC_CR      (*(unsigned char volatile far *)0x7efa11)	/*  ADC_DMAƼĴ */
#define DMA_ADC_STA     (*(unsigned char volatile far *)0x7efa12)	/*  ADC_DMA״̬Ĵ */
#define DMA_ADC_RXAH    (*(unsigned char volatile far *)0x7efa17)	/*  ADC_DMAոߵַ */
#define DMA_ADC_RXAL    (*(unsigned char volatile far *)0x7efa18)	/*  ADC_DMAյصַ */
#define DMA_ADC_CFG2    (*(unsigned char volatile far *)0x7efa19)	/*  ADC_DMAüĴ2 */
#define DMA_ADC_CHSW0   (*(unsigned char volatile far *)0x7efa1a)	/*  ADC_DMAͨʹܼĴ0 */
#define DMA_ADC_CHSW1   (*(unsigned char volatile far *)0x7efa1b)	/*  ADC_DMAͨʹܼĴ1 */

#define DMA_SPI_CFG     (*(unsigned char volatile far *)0x7efa20)	/*  SPI_DMAüĴ */
#define DMA_SPI_CR      (*(unsigned char volatile far *)0x7efa21)	/*  SPI_DMAƼĴ */
#define DMA_SPI_STA     (*(unsigned char volatile far *)0x7efa22)	/*  SPI_DMA״̬Ĵ */
#define DMA_SPI_AMT     (*(unsigned char volatile far *)0x7efa23)	/*  SPI_DMAֽ */
#define DMA_SPI_DONE    (*(unsigned char volatile far *)0x7efa24)	/*  SPI_DMAֽ */
#define DMA_SPI_TXAH    (*(unsigned char volatile far *)0x7efa25)	/*  SPI_DMA͸ߵַ */
#define DMA_SPI_TXAL    (*(unsigned char volatile far *)0x7efa26)	/*  SPI_DMA͵͵ַ */
#define DMA_SPI_RXAH    (*(unsigned char volatile far *)0x7efa27)	/*  SPI_DMAոߵַ */
#define DMA_SPI_RXAL    (*(unsigned char volatile far *)0x7efa28)	/*  SPI_DMAյصַ */
#define DMA_SPI_CFG2    (*(unsigned char volatile far *)0x7efa29)	/*  SPI_DMAüĴ2 */

#define DMA_UR1T_CFG    (*(unsigned char volatile far *)0x7efa30)	/*  UR1T_DMAüĴ */
#define DMA_UR1T_CR     (*(unsigned char volatile far *)0x7efa31)	/*  UR1T_DMAƼĴ */
#define DMA_UR1T_STA    (*(unsigned char volatile far *)0x7efa32)	/*  UR1T_DMA״̬Ĵ */
#define DMA_UR1T_AMT    (*(unsigned char volatile far *)0x7efa33)	/*  UR1T_DMAֽ */
#define DMA_UR1T_DONE   (*(unsigned char volatile far *)0x7efa34)	/*  UR1T_DMAֽ */
#define DMA_UR1T_TXAH   (*(unsigned char volatile far *)0x7efa35)	/*  UR1T_DMA͸ߵַ */
#define DMA_UR1T_TXAL   (*(unsigned char volatile far *)0x7efa36)	/*  UR1T_DMA͵͵ַ */
#define DMA_UR1R_CFG    (*(unsigned char volatile far *)0x7efa38)	/*  UR1R_DMAüĴ */
#define DMA_UR1R_CR     (*(unsigned char volatile far *)0x7efa39)	/*  UR1R_DMAƼĴ */
#define DMA_UR1R_STA    (*(unsigned char volatile far *)0x7efa3a)	/*  UR1R_DMA״̬Ĵ */
#define DMA_UR1R_AMT    (*(unsigned char volatile far *)0x7efa3b)	/*  UR1R_DMAֽ */
#define DMA_UR1R_DONE   (*(unsigned char volatile far *)0x7efa3c)	/*  UR1R_DMAֽ */
#define DMA_UR1R_TXAH   (*(unsigned char volatile far *)0x7efa3d)	/*  UR1R_DMA͸ߵַ */
#define DMA_UR1R_TXAL   (*(unsigned char volatile far *)0x7efa3e)	/*  UR1R_DMA͵͵ַ */

#define DMA_UR2T_CFG    (*(unsigned char volatile far *)0x7efa40)	/*  UR2T_DMAüĴ */
#define DMA_UR2T_CR     (*(unsigned char volatile far *)0x7efa41)	/*  UR2T_DMAƼĴ */
#define DMA_UR2T_STA    (*(unsigned char volatile far *)0x7efa42)	/*  UR2T_DMA״̬Ĵ */
#define DMA_UR2T_AMT    (*(unsigned char volatile far *)0x7efa43)	/*  UR2T_DMAֽ */
#define DMA_UR2T_DONE   (*(unsigned char volatile far *)0x7efa44)	/*  UR2T_DMAֽ */
#define DMA_UR2T_TXAH   (*(unsigned char volatile far *)0x7efa45)	/*  UR2T_DMA͸ߵַ */
#define DMA_UR2T_TXAL   (*(unsigned char volatile far *)0x7efa46)	/*  UR2T_DMA͵͵ַ */
#define DMA_UR2R_CFG    (*(unsigned char volatile far *)0x7efa48)	/*  UR2R_DMAüĴ */
#define DMA_UR2R_CR     (*(unsigned char volatile far *)0x7efa49)	/*  UR2R_DMAƼĴ */
#define DMA_UR2R_STA    (*(unsigned char volatile far *)0x7efa4a)	/*  UR2R_DMA״̬Ĵ */
#define DMA_UR2R_AMT    (*(unsigned char volatile far *)0x7efa4b)	/*  UR2R_DMAֽ */
#define DMA_UR2R_DONE   (*(unsigned char volatile far *)0x7efa4c)	/*  UR2R_DMAֽ */
#define DMA_UR2R_TXAH   (*(unsigned char volatile far *)0x7efa4d)	/*  UR2R_DMA͸ߵַ */
#define DMA_UR2R_TXAL   (*(unsigned char volatile far *)0x7efa4e)	/*  UR2R_DMA͵͵ַ */

#define DMA_UR3T_CFG    (*(unsigned char volatile far *)0x7efa50)	/*  UR3T_DMAüĴ */
#define DMA_UR3T_CR     (*(unsigned char volatile far *)0x7efa51)	/*  UR3T_DMAƼĴ */
#define DMA_UR3T_STA    (*(unsigned char volatile far *)0x7efa52)	/*  UR3T_DMA״̬Ĵ */
#define DMA_UR3T_AMT    (*(unsigned char volatile far *)0x7efa53)	/*  UR3T_DMAֽ */
#define DMA_UR3T_DONE   (*(unsigned char volatile far *)0x7efa54)	/*  UR3T_DMAֽ */
#define DMA_UR3T_TXAH   (*(unsigned char volatile far *)0x7efa55)	/*  UR3T_DMA͸ߵַ */
#define DMA_UR3T_TXAL   (*(unsigned char volatile far *)0x7efa56)	/*  UR3T_DMA͵͵ַ */
#define DMA_UR3R_CFG    (*(unsigned char volatile far *)0x7efa58)	/*  UR3R_DMAüĴ */
#define DMA_UR3R_CR     (*(unsigned char volatile far *)0x7efa59)	/*  UR3R_DMAƼĴ */
#define DMA_UR3R_STA    (*(unsigned char volatile far *)0x7efa5a)	/*  UR3R_DMA״̬Ĵ */
#define DMA_UR3R_AMT    (*(unsigned char volatile far *)0x7efa5b)	/*  UR3R_DMAֽ */
#define DMA_UR3R_DONE   (*(unsigned char volatile far *)0x7efa5c)	/*  UR3R_DMAֽ */
#define DMA_UR3R_TXAH   (*(unsigned char volatile far *)0x7efa5d)	/*  UR3R_DMA͸ߵַ */
#define DMA_UR3R_TXAL   (*(unsigned char volatile far *)0x7efa5e)	/*  UR3R_DMA͵͵ַ */

#define DMA_UR4T_CFG    (*(unsigned char volatile far *)0x7efa60)	/*  UR4T_DMAüĴ */
#define DMA_UR4T_CR     (*(unsigned char volatile far *)0x7efa61)	/*  UR4T_DMAƼĴ */
#define DMA_UR4T_STA    (*(unsigned char volatile far *)0x7efa62)	/*  UR4T_DMA״̬Ĵ */
#define DMA_UR4T_AMT    (*(unsigned char volatile far *)0x7efa63)	/*  UR4T_DMAֽ */
#define DMA_UR4T_DONE   (*(unsigned char volatile far *)0x7efa64)	/*  UR4T_DMAֽ */
#define DMA_UR4T_TXAH   (*(unsigned char volatile far *)0x7efa65)	/*  UR4T_DMA͸ߵַ */
#define DMA_UR4T_TXAL   (*(unsigned char volatile far *)0x7efa66)	/*  UR4T_DMA͵͵ַ */
#define DMA_UR4R_CFG    (*(unsigned char volatile far *)0x7efa68)	/*  UR4R_DMAüĴ */
#define DMA_UR4R_CR     (*(unsigned char volatile far *)0x7efa69)	/*  UR4R_DMAƼĴ */
#define DMA_UR4R_STA    (*(unsigned char volatile far *)0x7efa6a)	/*  UR4R_DMA״̬Ĵ */
#define DMA_UR4R_AMT    (*(unsigned char volatile far *)0x7efa6b)	/*  UR4R_DMAֽ */
#define DMA_UR4R_DONE   (*(unsigned char volatile far *)0x7efa6c)	/*  UR4R_DMAֽ */
#define DMA_UR4R_TXAH   (*(unsigned char volatile far *)0x7efa6d)	/*  UR4R_DMA͸ߵַ */
#define DMA_UR4R_TXAL   (*(unsigned char volatile far *)0x7efa6e)	/*  UR4R_DMA͵͵ַ */

#define DMA_LCM_CFG     (*(unsigned char volatile far *)0x7efa70)	/*  LCM_DMAüĴ */
#define DMA_LCM_CR      (*(unsigned char volatile far *)0x7efa71)	/*  LCM_DMAƼĴ */
#define DMA_LCM_STA     (*(unsigned char volatile far *)0x7efa72)	/*  LCM_DMA״̬Ĵ */
#define DMA_LCM_AMT     (*(unsigned char volatile far *)0x7efa73)	/*  LCM_DMAֽ */
#define DMA_LCM_DONE    (*(unsigned char volatile far *)0x7efa74)	/*  LCM_DMAֽ */
#define DMA_LCM_TXAH    (*(unsigned char volatile far *)0x7efa75)	/*  LCM_DMA͸ߵַ */
#define DMA_LCM_TXAL    (*(unsigned char volatile far *)0x7efa76)	/*  LCM_DMA͵͵ַ */
#define DMA_LCM_RXAH    (*(unsigned char volatile far *)0x7efa77)	/*  LCM_DMAոߵַ */
#define DMA_LCM_RXAL    (*(unsigned char volatile far *)0x7efa78)	/*  LCM_DMAյصַ */

#define DMA_M2M_AMTH    (*(unsigned char volatile far *)0x7efa80)	/*  M2M_DMAֽ */
#define DMA_M2M_DONEH   (*(unsigned char volatile far *)0x7efa81)	/*  M2M_DMAֽ */
#define DMA_SPI_AMTH    (*(unsigned char volatile far *)0x7efa84)	/*  SPI_DMAֽ */
#define DMA_SPI_DONEH   (*(unsigned char volatile far *)0x7efa85)	/*  SPI_DMAֽ */
#define DMA_LCM_AMTH    (*(unsigned char volatile far *)0x7efa86)	/*  LCM_DMAֽ */
#define DMA_LCM_DONEH   (*(unsigned char volatile far *)0x7efa87)	/*  LCM_DMAֽ */
#define DMA_UR1T_AMTH   (*(unsigned char volatile far *)0x7efa88)	/*  UR1T_DMAֽ */
#define DMA_UR1T_DONEH  (*(unsigned char volatile far *)0x7efa89)	/*  UR1T_DMAֽ */
#define DMA_UR1R_AMTH   (*(unsigned char volatile far *)0x7efa8a)	/*  UR1R_DMAֽ */
#define DMA_UR1R_DONEH  (*(unsigned char volatile far *)0x7efa8b)	/*  UR1R_DMAֽ */
#define DMA_UR2T_AMTH   (*(unsigned char volatile far *)0x7efa8c)	/*  UR2T_DMAֽ */
#define DMA_UR2T_DONEH  (*(unsigned char volatile far *)0x7efa8d)	/*  UR2T_DMAֽ */
#define DMA_UR2R_AMTH   (*(unsigned char volatile far *)0x7efa8e)	/*  UR2R_DMAֽ */
#define DMA_UR2R_DONEH  (*(unsigned char volatile far *)0x7efa8f)	/*  UR2R_DMAֽ */
#define DMA_UR3T_AMTH   (*(unsigned char volatile far *)0x7efa90)	/*  UR3T_DMAֽ */
#define DMA_UR3T_DONEH  (*(unsigned char volatile far *)0x7efa91)	/*  UR3T_DMAֽ */
#define DMA_UR3R_AMTH   (*(unsigned char volatile far *)0x7efa92)	/*  UR3R_DMAֽ */
#define DMA_UR3R_DONEH  (*(unsigned char volatile far *)0x7efa93)	/*  UR3R_DMAֽ */
#define DMA_UR4T_AMTH   (*(unsigned char volatile far *)0x7efa94)	/*  UR4T_DMAֽ */
#define DMA_UR4T_DONEH  (*(unsigned char volatile far *)0x7efa95)	/*  UR4T_DMAֽ */
#define DMA_UR4R_AMTH   (*(unsigned char volatile far *)0x7efa96)	/*  UR4R_DMAֽ */
#define DMA_UR4R_DONEH  (*(unsigned char volatile far *)0x7efa97)	/*  UR4R_DMAֽ */

#define DMA_I2CT_CFG    (*(unsigned char volatile far *)0x7efa98)	/*  I2CT_DMAüĴ */
#define DMA_I2CT_CR     (*(unsigned char volatile far *)0x7efa99)	/*  I2CT_DMAƼĴ */
#define DMA_I2CT_STA    (*(unsigned char volatile far *)0x7efa9a)	/*  I2CT_DMA״̬Ĵ */
#define DMA_I2CT_AMT    (*(unsigned char volatile far *)0x7efa9b)	/*  I2CT_DMAֽ   */
#define DMA_I2CT_DONE   (*(unsigned char volatile far *)0x7efa9c)	/*  I2CT_DMAֽ */
#define DMA_I2CT_TXAH   (*(unsigned char volatile far *)0x7efa9d)	/*  I2CT_DMA͸ߵַ */
#define DMA_I2CT_TXAL   (*(unsigned char volatile far *)0x7efa9e)	/*  I2CT_DMA͵͵ַ */
#define DMA_I2CR_CFG    (*(unsigned char volatile far *)0x7efaa0)	/*  I2CR_DMAüĴ */
#define DMA_I2CR_CR     (*(unsigned char volatile far *)0x7efaa1)	/*  I2CR_DMAƼĴ */
#define DMA_I2CR_STA    (*(unsigned char volatile far *)0x7efaa2)	/*  I2CR_DMA״̬Ĵ */
#define DMA_I2CR_AMT    (*(unsigned char volatile far *)0x7efaa3)	/*  I2CR_DMAֽ   */
#define DMA_I2CR_DONE   (*(unsigned char volatile far *)0x7efaa4)	/*  I2CR_DMAֽ */
#define DMA_I2CR_TXAH   (*(unsigned char volatile far *)0x7efaa5)	/*  I2CR_DMA͸ߵַ */
#define DMA_I2CR_TXAL   (*(unsigned char volatile far *)0x7efaa6)	/*  I2CR_DMA͵͵ַ */

#define DMA_I2CT_AMTH   (*(unsigned char volatile far *)0x7efaa8)	/*  I2CT_DMAֽ   */
#define DMA_I2CT_DONEH  (*(unsigned char volatile far *)0x7efaa9)	/*  I2CT_DMAֽ */
#define DMA_I2CR_AMTH   (*(unsigned char volatile far *)0x7efaaa)	/*  I2CR_DMAֽ   */
#define DMA_I2CR_DONEH  (*(unsigned char volatile far *)0x7efaab)	/*  I2CR_DMAֽ */
#define DMA_I2C_CR      (*(unsigned char volatile far *)0x7efaad)	/*  I2C_DMAƼĴ */
#define DMA_I2C_ST1     (*(unsigned char volatile far *)0x7efaae)	/*  I2C_DMA״̬Ĵ */
#define DMA_I2C_ST2     (*(unsigned char volatile far *)0x7efaaf)	/*  I2C_DMA״̬Ĵ */

#define DMA_I2ST_CFG    (*(unsigned char volatile far *)0x7efab0)	/*  I2ST_DMAüĴ */
#define DMA_I2ST_CR     (*(unsigned char volatile far *)0x7efab1)	/*  I2ST_DMAƼĴ */
#define DMA_I2ST_STA    (*(unsigned char volatile far *)0x7efab2)	/*  I2ST_DMA״̬Ĵ */
#define DMA_I2ST_AMT    (*(unsigned char volatile far *)0x7efab3)	/*  I2ST_DMAֽ   */
#define DMA_I2ST_DONE   (*(unsigned char volatile far *)0x7efab4)	/*  I2ST_DMAֽ */
#define DMA_I2ST_TXAH   (*(unsigned char volatile far *)0x7efab5)	/*  I2ST_DMA͸ߵַ */
#define DMA_I2ST_TXAL   (*(unsigned char volatile far *)0x7efab6)	/*  I2ST_DMA͵͵ַ */
#define DMA_I2SR_CFG    (*(unsigned char volatile far *)0x7efab8)	/*  I2SR_DMAüĴ */
#define DMA_I2SR_CR     (*(unsigned char volatile far *)0x7efab9)	/*  I2SR_DMAƼĴ */
#define DMA_I2SR_STA    (*(unsigned char volatile far *)0x7efaba)	/*  I2SR_DMA״̬Ĵ */
#define DMA_I2SR_AMT    (*(unsigned char volatile far *)0x7efabb)	/*  I2SR_DMAֽ   */
#define DMA_I2SR_DONE   (*(unsigned char volatile far *)0x7efabc)	/*  I2SR_DMAֽ */
#define DMA_I2SR_TXAH   (*(unsigned char volatile far *)0x7efabd)	/*  I2SR_DMA͸ߵַ */
#define DMA_I2SR_TXAL   (*(unsigned char volatile far *)0x7efabe)	/*  I2SR_DMA͵͵ַ */

#define DMA_I2ST_AMTH   (*(unsigned char volatile far *)0x7efac0)	/*  I2ST_DMAֽ */
#define DMA_I2ST_DONEH  (*(unsigned char volatile far *)0x7efac1)	/*  I2ST_DMAֽ */
#define DMA_I2SR_AMTH   (*(unsigned char volatile far *)0x7efac2)	/*  I2SR_DMAֽ */
#define DMA_I2SR_DONEH  (*(unsigned char volatile far *)0x7efac3)	/*  I2SR_DMAֽ */

#define DMA_ARB_CFG     (*(unsigned char volatile far *)0x7efaf8)	/*  DMAܲüĴ */
#define DMA_ARB_STA     (*(unsigned char volatile far *)0x7efaf9)	/*  DMAܲ״̬Ĵ */

#define HSPWMA_CFG  (*(unsigned char volatile far *)0x7efbf0)	/*  PWMAüĴ */
#define HSPWMA_ADR  (*(unsigned char volatile far *)0x7efbf1)	/*  PWMAַĴ */
#define HSPWMA_DAT  (*(unsigned char volatile far *)0x7efbf2)	/*  PWMAݼĴ */
#define HSPWMB_CFG  (*(unsigned char volatile far *)0x7efbf4)	/*  PWMBüĴ */
#define HSPWMB_ADR  (*(unsigned char volatile far *)0x7efbf5)	/*  PWMBַĴ */
#define HSPWMB_DAT  (*(unsigned char volatile far *)0x7efbf6)	/*  PWMBݼĴ */
#define HSSPI_CFG   (*(unsigned char volatile far *)0x7efbf8)	/*  SPIüĴ */
#define HSSPI_CFG2  (*(unsigned char volatile far *)0x7efbf9)	/*  SPIüĴ2 */
#define HSSPI_STA   (*(unsigned char volatile far *)0x7efbfa)	/*  SPI״̬Ĵ */

#define P0INTE      (*(unsigned char volatile far *)0x7efd00)	/* P0жʹܼĴ */
#define P1INTE      (*(unsigned char volatile far *)0x7efd01)	/* P1жʹܼĴ */
#define P2INTE      (*(unsigned char volatile far *)0x7efd02)	/* P2жʹܼĴ */
#define P3INTE      (*(unsigned char volatile far *)0x7efd03)	/* P3жʹܼĴ */
#define P4INTE      (*(unsigned char volatile far *)0x7efd04)	/* P4жʹܼĴ */
#define P5INTE      (*(unsigned char volatile far *)0x7efd05)	/* P5жʹܼĴ */
#define P6INTE      (*(unsigned char volatile far *)0x7efd06)	/* P6жʹܼĴ */
#define P7INTE      (*(unsigned char volatile far *)0x7efd07)	/* P7жʹܼĴ */

#define P0INTF      (*(unsigned char volatile far *)0x7efd10)	/* P0жϱ־Ĵ */
#define P1INTF      (*(unsigned char volatile far *)0x7efd11)	/* P1жϱ־Ĵ */
#define P2INTF      (*(unsigned char volatile far *)0x7efd12)	/* P2жϱ־Ĵ */
#define P3INTF      (*(unsigned char volatile far *)0x7efd13)	/* P3жϱ־Ĵ */
#define P4INTF      (*(unsigned char volatile far *)0x7efd14)	/* P4жϱ־Ĵ */
#define P5INTF      (*(unsigned char volatile far *)0x7efd15)	/* P5жϱ־Ĵ */
#define P6INTF      (*(unsigned char volatile far *)0x7efd16)	/* P6жϱ־Ĵ */
#define P7INTF      (*(unsigned char volatile far *)0x7efd17)	/* P7жϱ־Ĵ */

#define P0IM0       (*(unsigned char volatile far *)0x7efd20)	/* P0жģʽĴ0 */
#define P1IM0       (*(unsigned char volatile far *)0x7efd21)	/* P1жģʽĴ0 */
#define P2IM0       (*(unsigned char volatile far *)0x7efd22)	/* P2жģʽĴ0 */
#define P3IM0       (*(unsigned char volatile far *)0x7efd23)	/* P3жģʽĴ0 */
#define P4IM0       (*(unsigned char volatile far *)0x7efd24)	/* P4жģʽĴ0 */
#define P5IM0       (*(unsigned char volatile far *)0x7efd25)	/* P5жģʽĴ0 */
#define P6IM0       (*(unsigned char volatile far *)0x7efd26)	/* P6жģʽĴ0 */
#define P7IM0       (*(unsigned char volatile far *)0x7efd27)	/* P7жģʽĴ0 */

#define P0IM1       (*(unsigned char volatile far *)0x7efd30)	/* P0жģʽĴ1 */
#define P1IM1       (*(unsigned char volatile far *)0x7efd31)	/* P1жģʽĴ1 */
#define P2IM1       (*(unsigned char volatile far *)0x7efd32)	/* P2жģʽĴ1 */
#define P3IM1       (*(unsigned char volatile far *)0x7efd33)	/* P3жģʽĴ1 */
#define P4IM1       (*(unsigned char volatile far *)0x7efd34)	/* P4жģʽĴ1 */
#define P5IM1       (*(unsigned char volatile far *)0x7efd35)	/* P5жģʽĴ1 */
#define P6IM1       (*(unsigned char volatile far *)0x7efd36)	/* P6жģʽĴ1 */
#define P7IM1       (*(unsigned char volatile far *)0x7efd37)	/* P7жģʽĴ1 */

#define INTE_0       0x01	/* ʹPx.0жϹ */
#define INTE_1       0x02	/* ʹPx.1жϹ */
#define INTE_2       0x04	/* ʹPx.2жϹ */
#define INTE_3       0x08	/* ʹPx.3жϹ */
#define INTE_4       0x10	/* ʹPx.4жϹ */
#define INTE_5       0x20	/* ʹPx.5жϹ */
#define INTE_6       0x40	/* ʹPx.6жϹ */
#define INTE_7       0x80	/* ʹPx.7жϹ */

#define INTF_0       0x01	/* ʹPx.0жϱ־ */
#define INTF_1       0x02	/* ʹPx.1жϱ־ */
#define INTF_2       0x04	/* ʹPx.2жϱ־ */
#define INTF_3       0x08	/* ʹPx.3жϱ־ */
#define INTF_4       0x10	/* ʹPx.4жϱ־ */
#define INTF_5       0x20	/* ʹPx.5жϱ־ */
#define INTF_6       0x40	/* ʹPx.6жϱ־ */
#define INTF_7       0x80	/* ʹPx.7жϱ־ */

#define	INT_FALL	0		/* ½ж   */
#define	INT_RISE	1		/* ж   */
#define	INT_LOW		2		/* ͵ƽж   */
#define	INT_HIGH	3		/* ߵƽж   */

#define P0WKUE      (*(unsigned char volatile far *)0x7efd40)	/* P0жϻʹܼĴ */
#define P1WKUE      (*(unsigned char volatile far *)0x7efd41)	/* P1жϻʹܼĴ */
#define P2WKUE      (*(unsigned char volatile far *)0x7efd42)	/* P2жϻʹܼĴ */
#define P3WKUE      (*(unsigned char volatile far *)0x7efd43)	/* P3жϻʹܼĴ */
#define P4WKUE      (*(unsigned char volatile far *)0x7efd44)	/* P4жϻʹܼĴ */
#define P5WKUE      (*(unsigned char volatile far *)0x7efd45)	/* P5жϻʹܼĴ */
#define P6WKUE      (*(unsigned char volatile far *)0x7efd46)	/* P6жϻʹܼĴ */
#define P7WKUE      (*(unsigned char volatile far *)0x7efd47)	/* P7жϻʹܼĴ */

#define PINIPL      (*(unsigned char volatile far *)0x7efd60)	/* IOжȼͼĴ */
#define PINIPH      (*(unsigned char volatile far *)0x7efd61)	/* IOжȼ߼Ĵ */

#define FSHWUPPRD   (*(unsigned char volatile far *)0x7efd68)	/* FLASHѵȴʱĴ */

#define UR1TOCR     (*(unsigned char volatile far *)0x7efd70)	/* 1ʱƼĴ */
#define UR1TOSR     (*(unsigned char volatile far *)0x7efd71)	/* 1ʱ״̬Ĵ */
#define UR1TOTH     (*(unsigned char volatile far *)0x7efd72)	/* 1ʱȿƼĴ */
#define UR1TOTL     (*(unsigned char volatile far *)0x7efd73)	/* 1ʱȿƼĴ */
#define UR2TOCR     (*(unsigned char volatile far *)0x7efd74)	/* 2ʱƼĴ */
#define UR2TOSR     (*(unsigned char volatile far *)0x7efd75)	/* 2ʱ״̬Ĵ */
#define UR2TOTH     (*(unsigned char volatile far *)0x7efd76)	/* 2ʱȿƼĴ */
#define UR2TOTL     (*(unsigned char volatile far *)0x7efd77)	/* 2ʱȿƼĴ */
#define UR3TOCR     (*(unsigned char volatile far *)0x7efd78)	/* 3ʱƼĴ */
#define UR3TOSR     (*(unsigned char volatile far *)0x7efd79)	/* 3ʱ״̬Ĵ */
#define UR3TOTH     (*(unsigned char volatile far *)0x7efd7a)	/* 3ʱȿƼĴ */
#define UR3TOTL     (*(unsigned char volatile far *)0x7efd7b)	/* 3ʱȿƼĴ */
#define UR4TOCR     (*(unsigned char volatile far *)0x7efd7c)	/* 4ʱƼĴ */
#define UR4TOSR     (*(unsigned char volatile far *)0x7efd7d)	/* 4ʱ״̬Ĵ */
#define UR4TOTH     (*(unsigned char volatile far *)0x7efd7e)	/* 4ʱȿƼĴ */
#define UR4TOTL     (*(unsigned char volatile far *)0x7efd7f)	/* 4ʱȿƼĴ */

#define SPITOCR     (*(unsigned char volatile far *)0x7efd80)	/* SPIʱƼĴ */
#define SPITOSR     (*(unsigned char volatile far *)0x7efd81)	/* SPIʱ״̬Ĵ */
#define SPITOTH     (*(unsigned char volatile far *)0x7efd82)	/* SPIʱȿƼĴ */
#define SPITOTL     (*(unsigned char volatile far *)0x7efd83)	/* SPIʱȿƼĴ */
#define I2CTOCR     (*(unsigned char volatile far *)0x7efd84)	/* I2CʱƼĴ */
#define I2CTOSR     (*(unsigned char volatile far *)0x7efd85)	/* I2Cʱ״̬Ĵ */
#define I2CTOTH     (*(unsigned char volatile far *)0x7efd86)	/* I2CʱȿƼĴ */
#define I2CTOTL     (*(unsigned char volatile far *)0x7efd87)	/* I2CʱȿƼĴ */

#define I2SCR       (*(unsigned char volatile far *)0x7efd98)	/* I2SƼĴ */
#define I2SSR       (*(unsigned char volatile far *)0x7efd99)	/* I2S״̬Ĵ */
#define I2SDRH      (*(unsigned char volatile far *)0x7efd9a)	/* I2SݼĴֽ */
#define I2SDRL      (*(unsigned char volatile far *)0x7efd9b)	/* I2SݼĴֽ */
#define I2SPRH      (*(unsigned char volatile far *)0x7efd9c)	/* I2SƵĴֽ */
#define I2SPRL      (*(unsigned char volatile far *)0x7efd9d)	/* I2SƵĴֽ */
#define I2SCFGH     (*(unsigned char volatile far *)0x7efd9e)	/* I2SüĴֽ */
#define I2SCFGL     (*(unsigned char volatile far *)0x7efd9f)	/* I2SüĴֽ */
#define I2SMD       (*(unsigned char volatile far *)0x7efda0)	/* I2SģʽƼĴ */

#define CRECR       (*(unsigned char volatile far *)0x7efda8)	/* CREƼĴ */
#define CRECNTH     (*(unsigned char volatile far *)0x7efda9)	/* CREУ׼ĿĴ */
#define CRECNTL     (*(unsigned char volatile far *)0x7efdaa)	/* CREУ׼ĿĴ */
#define CRERES      (*(unsigned char volatile far *)0x7efdab)	/* CREֱʿƼĴ */

#define S2CFG       (*(unsigned char volatile far *)0x7efdb4)	/* 2üĴ */
#define S2ADDR      (*(unsigned char volatile far *)0x7efdb5)	/* 2ӻַĴ */
#define S2ADEN      (*(unsigned char volatile far *)0x7efdb6)	/* 2ӻַμĴ */

#define USARTCR1    (*(unsigned char volatile far *)0x7efdc0)	/* 1ƼĴ1 */
#define USARTCR2    (*(unsigned char volatile far *)0x7efdc1)	/* 1ƼĴ2 */
#define USARTCR3    (*(unsigned char volatile far *)0x7efdc2)	/* 1ƼĴ3 */
#define USARTCR4    (*(unsigned char volatile far *)0x7efdc3)	/* 1ƼĴ4 */
#define USARTCR5    (*(unsigned char volatile far *)0x7efdc4)	/* 1ƼĴ5 */
#define USARTGTR    (*(unsigned char volatile far *)0x7efdc5)	/* 1ʱĴ */
#define USARTBRH    (*(unsigned char volatile far *)0x7efdc6)	/* 1ʼĴֽ */
#define USARTBRL    (*(unsigned char volatile far *)0x7efdc7)	/* 1ʼĴֽ */

#define USART2CR1   (*(unsigned char volatile far *)0x7efdc8)	/* 2ƼĴ1 */
#define USART2CR2   (*(unsigned char volatile far *)0x7efdc9)	/* 2ƼĴ2 */
#define USART2CR3   (*(unsigned char volatile far *)0x7efdca)	/* 2ƼĴ3 */
#define USART2CR4   (*(unsigned char volatile far *)0x7efdcb)	/* 2ƼĴ4 */
#define USART2CR5   (*(unsigned char volatile far *)0x7efdcc)	/* 2ƼĴ5 */
#define USART2GTR   (*(unsigned char volatile far *)0x7efdcd)	/* 2ʱĴ */
#define USART2BRH   (*(unsigned char volatile far *)0x7efdce)	/* 2ʼĴֽ */
#define USART2BRL   (*(unsigned char volatile far *)0x7efdcf)	/* 2ʼĴֽ */

#define CHIPID0     (*(unsigned char volatile far *)0x7efde0) /* ӲID0 */
#define CHIPID1     (*(unsigned char volatile far *)0x7efde1) /* ӲID1 */
#define CHIPID2     (*(unsigned char volatile far *)0x7efde2) /* ӲID2 */
#define CHIPID3     (*(unsigned char volatile far *)0x7efde3) /* ӲID3 */
#define CHIPID4     (*(unsigned char volatile far *)0x7efde4) /* ӲID4 */
#define CHIPID5     (*(unsigned char volatile far *)0x7efde5) /* ӲID5 */
#define CHIPID6     (*(unsigned char volatile far *)0x7efde6) /* ӲID6 */
#define CHIPID7     (*(unsigned char volatile far *)0x7efde7) /* ӲID7 */
#define CHIPID8     (*(unsigned char volatile far *)0x7efde8) /* ӲID8 */
#define CHIPID9     (*(unsigned char volatile far *)0x7efde9) /* ӲID9 */
#define CHIPID10    (*(unsigned char volatile far *)0x7efdea) /* ӲID10 */
#define CHIPID11    (*(unsigned char volatile far *)0x7efdeb) /* ӲID11 */
#define CHIPID12    (*(unsigned char volatile far *)0x7efdec) /* ӲID12 */
#define CHIPID13    (*(unsigned char volatile far *)0x7efded) /* ӲID13 */
#define CHIPID14    (*(unsigned char volatile far *)0x7efdee) /* ӲID14 */
#define CHIPID15    (*(unsigned char volatile far *)0x7efdef) /* ӲID15 */
#define CHIPID16    (*(unsigned char volatile far *)0x7efdf0) /* ӲID16 */
#define CHIPID17    (*(unsigned char volatile far *)0x7efdf1) /* ӲID17 */
#define CHIPID18    (*(unsigned char volatile far *)0x7efdf2) /* ӲID18 */
#define CHIPID19    (*(unsigned char volatile far *)0x7efdf3) /* ӲID19 */
#define CHIPID20    (*(unsigned char volatile far *)0x7efdf4) /* ӲID20 */
#define CHIPID21    (*(unsigned char volatile far *)0x7efdf5) /* ӲID21 */
#define CHIPID22    (*(unsigned char volatile far *)0x7efdf6) /* ӲID22 */
#define CHIPID23    (*(unsigned char volatile far *)0x7efdf7) /* ӲID23 */
#define CHIPID24    (*(unsigned char volatile far *)0x7efdf8) /* ӲID24 */
#define CHIPID25    (*(unsigned char volatile far *)0x7efdf9) /* ӲID25 */
#define CHIPID26    (*(unsigned char volatile far *)0x7efdfa) /* ӲID26 */
#define CHIPID27    (*(unsigned char volatile far *)0x7efdfb) /* ӲID27 */
#define CHIPID28    (*(unsigned char volatile far *)0x7efdfc) /* ӲID28 */
#define CHIPID29    (*(unsigned char volatile far *)0x7efdfd) /* ӲID29 */
#define CHIPID30    (*(unsigned char volatile far *)0x7efdfe) /* ӲID30 */
#define CHIPID31    (*(unsigned char volatile far *)0x7efdff) /* ӲID31 */

#define CLKSEL      (*(unsigned char volatile far *)0x7efe00)	/* ʱԴѡĴ    */
#define	CLKDIV		(*(unsigned char volatile far *)0x7efe01)	/* ʱӷƵĴ      */
#define	HIRCCR		(*(unsigned char volatile far *)0x7efe02)	/* ڲƼĴ */
#define	XOSCCR		(*(unsigned char volatile far *)0x7efe03)	/* ⲿپƼĴ    */
#define	IRC32KCR	(*(unsigned char volatile far *)0x7efe04)	/* ڲ32KIRCʱӿƼĴ   */
#define	MCLKOCR		(*(unsigned char volatile far *)0x7efe05)	/* ʱƼĴ  */
#define	IRCDB		(*(unsigned char volatile far *)0x7efe06)	/* ڲȥƼĴ   */
#define	IRC48MCR	(*(unsigned char volatile far *)0x7efe07)	/* ڲ48MƼĴ  */
#define	X32KCR		(*(unsigned char volatile far *)0x7efe08)	/* ⲿ32KƼĴ   */
#define	HSCLKDIV	(*(unsigned char volatile far *)0x7efe0b)	/* ʱӷƵĴ  */
#define	HPLLCR		(*(unsigned char volatile far *)0x7efe0c)	/* PLLƼĴ  */
#define	HPLLPSCR	(*(unsigned char volatile far *)0x7efe0d)	/* PLLԤƵĴ  */

#define	P0PU		(*(unsigned char volatile far *)0x7efe10)	/* P0ƼĴ, 0: ֹ(Ĭ), 1:   */
#define	P1PU		(*(unsigned char volatile far *)0x7efe11)	/* P1ƼĴ  */
#define	P2PU		(*(unsigned char volatile far *)0x7efe12)	/* P2ƼĴ  */
#define	P3PU		(*(unsigned char volatile far *)0x7efe13)	/* P3ƼĴ  */
#define	P4PU		(*(unsigned char volatile far *)0x7efe14)	/* P4ƼĴ  */
#define	P5PU		(*(unsigned char volatile far *)0x7efe15)	/* P5ƼĴ  */
#define	P6PU		(*(unsigned char volatile far *)0x7efe16)	/* P6ƼĴ  */
#define	P7PU		(*(unsigned char volatile far *)0x7efe17)	/* P7ƼĴ  */

#define	P0NCS		(*(unsigned char volatile far *)0x7efe18)	/* P0 Non Schmit Trigger  0: ʹܶ˿ʩش(Ĭ), 1: ֹ  */
#define	P1NCS		(*(unsigned char volatile far *)0x7efe19)	/* P1 Non Schmit Trigger  */
#define	P2NCS		(*(unsigned char volatile far *)0x7efe1a)	/* P2 Non Schmit Trigger  */
#define	P3NCS		(*(unsigned char volatile far *)0x7efe1b)	/* P3 Non Schmit Trigger  */
#define	P4NCS		(*(unsigned char volatile far *)0x7efe1c)	/* P4 Non Schmit Trigger  */
#define	P5NCS		(*(unsigned char volatile far *)0x7efe1d)	/* P5 Non Schmit Trigger  */
#define	P6NCS		(*(unsigned char volatile far *)0x7efe1e)	/* P6 Non Schmit Trigger  */
#define	P7NCS		(*(unsigned char volatile far *)0x7efe1f)	/* P7 Non Schmit Trigger  */

#define	P0SR		(*(unsigned char volatile far *)0x7efe20)	/* P0ڵƽתʼĴ Ĭ1: ͨģʽ, 0:ģʽ */
#define	P1SR		(*(unsigned char volatile far *)0x7efe21)	/* P1ڵƽתʼĴ  */
#define	P2SR		(*(unsigned char volatile far *)0x7efe22)	/* P2ڵƽתʼĴ  */
#define	P3SR		(*(unsigned char volatile far *)0x7efe23)	/* P3ڵƽתʼĴ  */
#define	P4SR		(*(unsigned char volatile far *)0x7efe24)	/* P4ڵƽתʼĴ  */
#define	P5SR		(*(unsigned char volatile far *)0x7efe25)	/* P5ڵƽתʼĴ  */
#define	P6SR		(*(unsigned char volatile far *)0x7efe26)	/* P6ڵƽתʼĴ  */
#define	P7SR		(*(unsigned char volatile far *)0x7efe27)	/* P7ڵƽתʼĴ  */

#define	P0DR		(*(unsigned char volatile far *)0x7efe28)	/* P0ƼĴ Ĭ1: ͨģʽ, 0:ģʽ*/
#define	P1DR		(*(unsigned char volatile far *)0x7efe29)	/* P1ƼĴ */
#define	P2DR		(*(unsigned char volatile far *)0x7efe2a)	/* P2ƼĴ */
#define	P3DR		(*(unsigned char volatile far *)0x7efe2b)	/* P3ƼĴ */
#define	P4DR		(*(unsigned char volatile far *)0x7efe2c)	/* P4ƼĴ */
#define	P5DR		(*(unsigned char volatile far *)0x7efe2d)	/* P5ƼĴ */
#define	P6DR		(*(unsigned char volatile far *)0x7efe2e)	/* P6ƼĴ */
#define	P7DR		(*(unsigned char volatile far *)0x7efe2f)	/* P7ƼĴ */

#define	P0IE		(*(unsigned char volatile far *)0x7efe30)	/* P0ʹܿƼĴ, 1(Ĭ), 0ֹ */
#define	P1IE		(*(unsigned char volatile far *)0x7efe31)	/* P1ʹܿƼĴ */
#define	P2IE		(*(unsigned char volatile far *)0x7efe32)	/* P2ʹܿƼĴ */
#define	P3IE		(*(unsigned char volatile far *)0x7efe33)	/* P3ʹܿƼĴ */
#define	P4IE		(*(unsigned char volatile far *)0x7efe34)	/* P4ʹܿƼĴ */
#define	P5IE		(*(unsigned char volatile far *)0x7efe35)	/* P5ʹܿƼĴ */
#define	P6IE		(*(unsigned char volatile far *)0x7efe36)	/* P6ʹܿƼĴ */
#define	P7IE		(*(unsigned char volatile far *)0x7efe37)	/* P7ʹܿƼĴ */

#define	P0PD		(*(unsigned char volatile far *)0x7efe40)	/* P0ƼĴ, 0: ֹ(Ĭ), 1:   */
#define	P1PD		(*(unsigned char volatile far *)0x7efe41)	/* P1ƼĴ  */
#define	P2PD		(*(unsigned char volatile far *)0x7efe42)	/* P2ƼĴ  */
#define	P3PD		(*(unsigned char volatile far *)0x7efe43)	/* P3ƼĴ  */
#define	P4PD		(*(unsigned char volatile far *)0x7efe44)	/* P4ƼĴ  */
#define	P5PD		(*(unsigned char volatile far *)0x7efe45)	/* P5ƼĴ  */
#define	P6PD		(*(unsigned char volatile far *)0x7efe46)	/* P6ƼĴ  */
#define	P7PD		(*(unsigned char volatile far *)0x7efe47)	/* P7ƼĴ  */

#define	LCMIFCFG	(*(unsigned char volatile far *)0x7efe50)	/* LCMӿüĴ */
#define	LCMIFCFG2	(*(unsigned char volatile far *)0x7efe51)	/* LCMӿüĴ2 */
#define	LCMIFCR		(*(unsigned char volatile far *)0x7efe52)	/* LCMӿڿƼĴ */
#define	LCMIFSTA	(*(unsigned char volatile far *)0x7efe53)	/* LCMӿ״̬Ĵ */
#define	LCMIDDATL	(*(unsigned char volatile far *)0x7efe54)	/* LCMӿڵֽ */
#define	LCMIDDATH	(*(unsigned char volatile far *)0x7efe55)	/* LCMӿڸֽ */

#define	RTCCR		(*(unsigned char volatile far *)0x7efe60)	/* RTCƼĴ */
#define	RTCCFG		(*(unsigned char volatile far *)0x7efe61)	/* RTCüĴ */
#define	RTCIEN		(*(unsigned char volatile far *)0x7efe62)	/* RTCжʹܼĴ */
#define	RTCIF		(*(unsigned char volatile far *)0x7efe63)	/* RTCжĴ */
#define	ALAHOUR		(*(unsigned char volatile far *)0x7efe64)	/* RTCӵСʱֵ */
#define	ALAMIN		(*(unsigned char volatile far *)0x7efe65)	/* RTCӵķֵ */
#define	ALASEC		(*(unsigned char volatile far *)0x7efe66)	/* RTCӵֵ */
#define	ALASSEC		(*(unsigned char volatile far *)0x7efe67)	/* RTCӵ1/128ֵ */
#define	INIYEAR		(*(unsigned char volatile far *)0x7efe68)	/* RTCʼ */
#define	INIMONTH	(*(unsigned char volatile far *)0x7efe69)	/* RTC³ʼ */
#define	INIDAY		(*(unsigned char volatile far *)0x7efe6a)	/* RTCճʼ */
#define	INIHOUR		(*(unsigned char volatile far *)0x7efe6b)	/* RTCʱʼ */
#define	INIMIN		(*(unsigned char volatile far *)0x7efe6c)	/* RTCֳʼ */
#define	INISEC		(*(unsigned char volatile far *)0x7efe6d)	/* RTCʼ */
#define	INISSEC		(*(unsigned char volatile far *)0x7efe6e)	/* RTC1/128ʼ */
#define	RTC_YEAR	(*(unsigned char volatile far *)0x7efe70)	/* RTCֵ */
#define	RTC_MONTH	(*(unsigned char volatile far *)0x7efe71)	/* RTC¼ֵ */
#define	RTC_DAY		(*(unsigned char volatile far *)0x7efe72)	/* RTCռֵ */
#define	RTC_HOUR	(*(unsigned char volatile far *)0x7efe73)	/* RTCʱֵ */
#define	RTC_MIN		(*(unsigned char volatile far *)0x7efe74)	/* RTCķֵּ */
#define	RTC_SEC		(*(unsigned char volatile far *)0x7efe75)	/* RTCֵ */
#define	RTC_SSEC	(*(unsigned char volatile far *)0x7efe76)	/* RTC1/128ֵ */

#define	I2CCFG		(*(unsigned char volatile far *)0x7efe80)	/* I2CüĴ  */
#define	I2CMSCR		(*(unsigned char volatile far *)0x7efe81)	/* I2CƼĴ  */
#define	I2CMSST		(*(unsigned char volatile far *)0x7efe82)	/* I2C״̬Ĵ  */
#define	I2CSLCR		(*(unsigned char volatile far *)0x7efe83)	/* I2CӻƼĴ  */
#define	I2CSLST		(*(unsigned char volatile far *)0x7efe84)	/* I2Cӻ״̬Ĵ  */
#define	I2CSLADR	(*(unsigned char volatile far *)0x7efe85)	/* I2CӻַĴ  */
#define	I2CTXD		(*(unsigned char volatile far *)0x7efe86)	/* I2CݷͼĴ  */
#define	I2CRXD		(*(unsigned char volatile far *)0x7efe87)	/* I2CݽռĴ  */
#define	I2CMSAUX	(*(unsigned char volatile far *)0x7efe88)	/* I2CƼĴ  */

#define	SPFUNC		(*(unsigned char volatile far *)0x7efe98)	/* ƼĴ  */
#define	RSTFLAG		(*(unsigned char volatile far *)0x7efe99)	/* λ־Ĵ  */
#define	RSTCR0		(*(unsigned char volatile far *)0x7efe9a)	/* λƼĴ0  */
#define	RSTCR1		(*(unsigned char volatile far *)0x7efe9b)	/* λƼĴ1  */
#define	RSTCR2		(*(unsigned char volatile far *)0x7efe9c)	/* λƼĴ2  */
#define	RSTCR3		(*(unsigned char volatile far *)0x7efe9d)	/* λƼĴ3  */
#define	RSTCR4		(*(unsigned char volatile far *)0x7efe9e)	/* λƼĴ4  */
#define	RSTCR5		(*(unsigned char volatile far *)0x7efe9f)	/* λƼĴ5  */

#define	TM0PS		(*(unsigned char volatile far *)0x7efea0)	/* ʱ0ʱԤƵĴ  */
#define	TM1PS		(*(unsigned char volatile far *)0x7efea1)	/* ʱ1ʱԤƵĴ  */
#define	TM2PS		(*(unsigned char volatile far *)0x7efea2)	/* ʱ2ʱԤƵĴ  */
#define	TM3PS		(*(unsigned char volatile far *)0x7efea3)	/* ʱ3ʱԤƵĴ  */
#define	TM4PS		(*(unsigned char volatile far *)0x7efea4)	/* ʱ4ʱԤƵĴ  */
#define	ADCTIM		(*(unsigned char volatile far *)0x7efea8)	/* ADCʱƼĴ  */
#define	T3T4PIN		(*(unsigned char volatile far *)0x7efeac)	/* T3/T4ѡĴ  */
#define	ADCEXCFG	(*(unsigned char volatile far *)0x7efead)	/* ADCչüĴ  */
#define	CMPEXCFG	(*(unsigned char volatile far *)0x7efeae)	/* ȽչüĴ  */

#define	PWMA_ETRPS	(*(unsigned char volatile far *)0x7efeb0)	/* PWMAETRѡĴ  */
#define	PWMA_ENO	(*(unsigned char volatile far *)0x7efeb1)	/* PWMAʹܼĴ   */
#define	PWMA_PS		(*(unsigned char volatile far *)0x7efeb2)	/* PWMAѡĴ */
#define	PWMA_IOAUX	(*(unsigned char volatile far *)0x7efeb3)	/* PWMAĴ       */
#define	PWMB_ETRPS	(*(unsigned char volatile far *)0x7efeb4)	/* PWMBETRѡĴ  */
#define	PWMB_ENO	(*(unsigned char volatile far *)0x7efeb5)	/* PWMBʹܼĴ   */
#define	PWMB_PS		(*(unsigned char volatile far *)0x7efeb6)	/* PWMBѡĴ */
#define	PWMB_IOAUX	(*(unsigned char volatile far *)0x7efeb7)	/* PWMBĴ       */

#define	CANAR		(*(unsigned char volatile far *)0x7efebb)	/* CANBUSַĴ */
#define	CANDR		(*(unsigned char volatile far *)0x7efebc)	/* CANBUSݼĴ       */

#define	PWMA_CR1	(*(unsigned char volatile far *)0x7efec0)	/* PWMAƼĴ1  */
#define	PWMA_CR2	(*(unsigned char volatile far *)0x7efec1)	/* PWMAƼĴ2  */
#define	PWMA_SMCR	(*(unsigned char volatile far *)0x7efec2)	/* PWMAģʽƼĴ  */
#define	PWMA_ETR	(*(unsigned char volatile far *)0x7efec3)	/* PWMAⲿĴ  */
#define	PWMA_IER	(*(unsigned char volatile far *)0x7efec4)	/* PWMAжʹܼĴ  */
#define	PWMA_SR1	(*(unsigned char volatile far *)0x7efec5)	/* PWMA״̬Ĵ1  */
#define	PWMA_SR2	(*(unsigned char volatile far *)0x7efec6)	/* PWMA״̬Ĵ2  */
#define	PWMA_EGR	(*(unsigned char volatile far *)0x7efec7)	/* PWMA¼Ĵ  */

#define	PWMA_CCMR1	(*(unsigned char volatile far *)0x7efec8)	/* PWMA/ȽģʽĴ1  */
#define	PWMA_CCMR2	(*(unsigned char volatile far *)0x7efec9)	/* PWMA/ȽģʽĴ2  */
#define	PWMA_CCMR3	(*(unsigned char volatile far *)0x7efeca)	/* PWMA/ȽģʽĴ3  */
#define	PWMA_CCMR4	(*(unsigned char volatile far *)0x7efecb)	/* PWMA/ȽģʽĴ4  */
#define	PWMA_CCER1	(*(unsigned char volatile far *)0x7efecc)	/* PWMAȽʹܼĴ1  */
#define	PWMA_CCER2	(*(unsigned char volatile far *)0x7efecd)	/* PWMAȽʹܼĴ2  */
#define	PWMA_CNTRH	(*(unsigned char volatile far *)0x7efece)	/* PWMAֽ   */
#define	PWMA_CNTRL	(*(unsigned char volatile far *)0x7efecf)	/* PWMAֽ   */

#define PWMA_PSCRH  (*(unsigned char volatile far *)0x7efed0)	/* PWMAԤƵֽ */
#define PWMA_PSCRL  (*(unsigned char volatile far *)0x7efed1)	/* PWMAԤƵֽ */
#define PWMA_ARRH   (*(unsigned char volatile far *)0x7efed2)	/* PWMAԶװĴֽ */
#define PWMA_ARRL   (*(unsigned char volatile far *)0x7efed3)	/* PWMAԶװĴֽ */
#define PWMA_RCR    (*(unsigned char volatile far *)0x7efed4)	/* PWMAظĴ */
#define PWMA_CCR1H  (*(unsigned char volatile far *)0x7efed5)	/* PWMAȽϲĴ1ֽ */
#define PWMA_CCR1L  (*(unsigned char volatile far *)0x7efed6)	/* PWMAȽϲĴ1ֽ */
#define PWMA_CCR2H  (*(unsigned char volatile far *)0x7efed7)	/* PWMAȽϲĴ2ֽ */
#define PWMA_CCR2L  (*(unsigned char volatile far *)0x7efed8)	/* PWMAȽϲĴ2ֽ */
#define PWMA_CCR3H  (*(unsigned char volatile far *)0x7efed9)	/* PWMAȽϲĴ3ֽ */
#define PWMA_CCR3L  (*(unsigned char volatile far *)0x7efeda)	/* PWMAȽϲĴ3ֽ */
#define PWMA_CCR4H  (*(unsigned char volatile far *)0x7efedb)	/* PWMAȽϲĴ4ֽ */
#define PWMA_CCR4L  (*(unsigned char volatile far *)0x7efedc)	/* PWMAȽϲĴ4ֽ */
#define PWMA_BKR    (*(unsigned char volatile far *)0x7efedd)	/* PWMAɲĴ */
#define PWMA_DTR    (*(unsigned char volatile far *)0x7efede)	/* PWMAƼĴ */
#define PWMA_OISR   (*(unsigned char volatile far *)0x7efedf)	/* PWMA״̬Ĵ */

#define	PWMB_CR1	(*(unsigned char volatile far *)0x7efee0)	/* PWMBƼĴ1  */
#define	PWMB_CR2	(*(unsigned char volatile far *)0x7efee1)	/* PWMBƼĴ2  */
#define	PWMB_SMCR	(*(unsigned char volatile far *)0x7efee2)	/* PWMBģʽƼĴ  */
#define	PWMB_ETR	(*(unsigned char volatile far *)0x7efee3)	/* PWMBⲿĴ  */
#define	PWMB_IER	(*(unsigned char volatile far *)0x7efee4)	/* PWMBжʹܼĴ  */
#define	PWMB_SR1	(*(unsigned char volatile far *)0x7efee5)	/* PWMB״̬Ĵ1  */
#define	PWMB_SR2	(*(unsigned char volatile far *)0x7efee6)	/* PWMB״̬Ĵ2  */
#define	PWMB_EGR	(*(unsigned char volatile far *)0x7efee7)	/* PWMB¼Ĵ  */

#define	PWMB_CCMR1	(*(unsigned char volatile far *)0x7efee8)	/* PWMB/ȽģʽĴ1  */
#define	PWMB_CCMR2	(*(unsigned char volatile far *)0x7efee9)	/* PWMB/ȽģʽĴ2  */
#define	PWMB_CCMR3	(*(unsigned char volatile far *)0x7efeea)	/* PWMB/ȽģʽĴ3  */
#define	PWMB_CCMR4	(*(unsigned char volatile far *)0x7efeeb)	/* PWMB/ȽģʽĴ4  */
#define	PWMB_CCER1	(*(unsigned char volatile far *)0x7efeec)	/* PWMBȽʹܼĴ1  */
#define	PWMB_CCER2	(*(unsigned char volatile far *)0x7efeed)	/* PWMBȽʹܼĴ2  */
#define	PWMB_CNTRH	(*(unsigned char volatile far *)0x7efeee)	/* PWMBֽ   */
#define	PWMB_CNTRL	(*(unsigned char volatile far *)0x7efeef)	/* PWMBֽ   */

#define PWMB_PSCRH  (*(unsigned char volatile far *)0x7efef0)	/* PWMBԤƵֽ */
#define PWMB_PSCRL  (*(unsigned char volatile far *)0x7efef1)	/* PWMBԤƵֽ */
#define PWMB_ARRH   (*(unsigned char volatile far *)0x7efef2)	/* PWMBԶװĴֽ */
#define PWMB_ARRL   (*(unsigned char volatile far *)0x7efef3)	/* PWMBԶװĴֽ */
#define PWMB_RCR    (*(unsigned char volatile far *)0x7efef4)	/* PWMBظĴ */
#define PWMB_CCR1H  (*(unsigned char volatile far *)0x7efef5)	/* PWMBȽϲĴ1ֽ */
#define PWMB_CCR1L  (*(unsigned char volatile far *)0x7efef6)	/* PWMBȽϲĴ1ֽ */
#define PWMB_CCR2H  (*(unsigned char volatile far *)0x7efef7)	/* PWMBȽϲĴ2ֽ */
#define PWMB_CCR2L  (*(unsigned char volatile far *)0x7efef8)	/* PWMBȽϲĴ2ֽ */
#define PWMB_CCR3H  (*(unsigned char volatile far *)0x7efef9)	/* PWMBȽϲĴ3ֽ */
#define PWMB_CCR3L  (*(unsigned char volatile far *)0x7efefa)	/* PWMBȽϲĴ3ֽ */
#define PWMB_CCR4H  (*(unsigned char volatile far *)0x7efefb)	/* PWMBȽϲĴ4ֽ */
#define PWMB_CCR4L  (*(unsigned char volatile far *)0x7efefc)	/* PWMBȽϲĴ4ֽ */
#define PWMB_BKR    (*(unsigned char volatile far *)0x7efefd)	/* PWMBɲĴ */
#define PWMB_DTR    (*(unsigned char volatile far *)0x7efefe)	/* PWMBƼĴ */
#define PWMB_OISR   (*(unsigned char volatile far *)0x7efeff)	/* PWMB״̬Ĵ */

/*
#define PWMA_CNTR   (*(unsigned int  volatile far *)0x7efece)	//* PWMA16λ *
#define PWMA_PSCR   (*(unsigned int  volatile far *)0x7efed0)	//* PWMAԤƵ16λ *
#define PWMA_ARR    (*(unsigned int  volatile far *)0x7efed2)	//* PWMAԶװĴ16λ *
#define PWMA_CCR1   (*(unsigned int  volatile far *)0x7efed5)	//* PWMAȽϲĴ1 16λ *
#define PWMA_CCR2   (*(unsigned int  volatile far *)0x7efed7)	//* PWMAȽϲĴ2 16λ *
#define PWMA_CCR3   (*(unsigned int  volatile far *)0x7efed9)	//* PWMAȽϲĴ3 16λ *
#define PWMA_CCR4   (*(unsigned int  volatile far *)0x7efedB)	//* PWMAȽϲĴ4 16λ *

#define PWMB_CNTR   (*(unsigned int  volatile far *)0x7efeee)	//* PWMA16λ *
#define PWMB_PSCR   (*(unsigned int  volatile far *)0x7efef0)	//* PWMAԤƵ16λ *
#define PWMB_ARR    (*(unsigned int  volatile far *)0x7efef2)	//* PWMAԶװĴ16λ *
#define PWMB_CCR1   (*(unsigned int  volatile far *)0x7efef5)	//* PWMAȽϲĴ1 16λ *
#define PWMB_CCR2   (*(unsigned int  volatile far *)0x7efef7)	//* PWMAȽϲĴ2 16λ *
#define PWMB_CCR3   (*(unsigned int  volatile far *)0x7efef9)	//* PWMAȽϲĴ3 16λ *
#define PWMB_CCR4   (*(unsigned int  volatile far *)0x7efefB)	//* PWMAȽϲĴ4 16λ *
*/
//=============================================================================================================

#define	EAXSFR()		P_SW2 |=  0x80		/* MOVX A,@DPTR/MOVX @DPTR,AָĲΪչSFR(XSFR) */
#define	EAXRAM()		P_SW2 &= ~0x80		/* MOVX A,@DPTR/MOVX @DPTR,AָĲΪչRAM(XRAM) */

#define	I2C_USE_P15P14()	P_SW2 &= ~0x30						/* I2CлP1.5(SCL) P1.4(SDA)(ϵĬ).*/
#define	I2C_USE_P25P24()	P_SW2  = (P_SW2 & ~0x30) | 0x10		/* I2CлP2.5(SCL) P2.4(SDA).*/
#define	I2C_USE_P32P33()	P_SW2 |= 0x30						/* I2CлP3.2(SCL) P3.3(SDA).*/

#define	MainFosc_IRC24M()	CKSEL = (CKSEL & ~0x03)			/* ѡڲ24MHZʱ */
#define	MainFosc_XTAL()		CKSEL = (CKSEL & ~0x03) | 0x01	/* ѡⲿʱ */
#define	EXT_CLOCK()			XOSCCR = 0x80					/* ѡⲿʱ */
#define	EXT_CRYSTAL()		XOSCCR = 0xC0					/* ѡⲿ */
#define	MainFosc_IRC32K()	CKSEL =  CKSEL | 0x03			/* ѡڲ32Kʱ */
#define	MCLKO_None()		MCLKOCR = 0						/* ʱӲ 	    */
#define	MCLKO54_DIV(n)		MCLKOCR = n						/* ʱӴP5.4Ƶ */
#define	MCLKO16_DIV(n)		MCLKOCR = n | 0x80				/* ʱӴP1.6Ƶ */


/*  BIT Registers  */
/*  PSW   */
sbit CY   = PSW^7;
sbit AC   = PSW^6;
sbit F0   = PSW^5;
sbit RS1  = PSW^4;
sbit RS0  = PSW^3;
sbit OV   = PSW^2;
sbit F1   = PSW^1;
sbit P    = PSW^0;

/*  TCON  */
sbit TF1  = TCON^7;	//ʱ1жϱ־λ
sbit TR1  = TCON^6;	//ʱ1пλ
sbit TF0  = TCON^5;	//ʱ0жϱ־λ
sbit TR0  = TCON^4;	//ʱ0пλ
sbit IE1  = TCON^3;	//ж1־λ
sbit IT1  = TCON^2;	//ж1źŷʽλ1½жϣ0½жϡ
sbit IE0  = TCON^1;	//ж0־λ
sbit IT0  = TCON^0;	//ж0źŷʽλ1½жϣ0½жϡ

/*  P0  */
sbit  P00 = P0^0;
sbit  P01 = P0^1;
sbit  P02 = P0^2;
sbit  P03 = P0^3;
sbit  P04 = P0^4;
sbit  P05 = P0^5;
sbit  P06 = P0^6;
sbit  P07 = P0^7;

/*  P1  */
sbit  P10 = P1^0;
sbit  P11 = P1^1;
sbit  P12 = P1^2;
sbit  P13 = P1^3;
sbit  P14 = P1^4;
sbit  P15 = P1^5;
sbit  P16 = P1^6;
sbit  P17 = P1^7;

/*  P2  */
sbit  P20 = P2^0;
sbit  P21 = P2^1;
sbit  P22 = P2^2;
sbit  P23 = P2^3;
sbit  P24 = P2^4;
sbit  P25 = P2^5;
sbit  P26 = P2^6;
sbit  P27 = P2^7;

/*  P3  */
sbit  P30 = P3^0;
sbit  P31 = P3^1;
sbit  P32 = P3^2;
sbit  P33 = P3^3;
sbit  P34 = P3^4;
sbit  P35 = P3^5;
sbit  P36 = P3^6;
sbit  P37 = P3^7;

/*  P4  */
sbit  P40 = P4^0;
sbit  P41 = P4^1;
sbit  P42 = P4^2;
sbit  P43 = P4^3;
sbit  P44 = P4^4;
sbit  P45 = P4^5;
sbit  P46 = P4^6;
sbit  P47 = P4^7;

/*  P5  */
sbit  P50 = P5^0;
sbit  P51 = P5^1;
sbit  P52 = P5^2;
sbit  P53 = P5^3;
sbit  P54 = P5^4;
sbit  P55 = P5^5;
sbit  P56 = P5^6;
sbit  P57 = P5^7;

/*  P6  */
sbit  P60 = P6^0;
sbit  P61 = P6^1;
sbit  P62 = P6^2;
sbit  P63 = P6^3;
sbit  P64 = P6^4;
sbit  P65 = P6^5;
sbit  P66 = P6^6;
sbit  P67 = P6^7;

/*  P7  */
sbit  P70 = P7^0;
sbit  P71 = P7^1;
sbit  P72 = P7^2;
sbit  P73 = P7^3;
sbit  P74 = P7^4;
sbit  P75 = P7^5;
sbit  P76 = P7^6;
sbit  P77 = P7^7;

sbit  RXD2      = P1^0;
sbit  TXD2      = P1^1;
sbit  ECI       = P1^2;
sbit  CCP0      = P1^1;
sbit  CCP1      = P1^0;
sbit  CCP2      = P3^7;
sbit  ECI_2     = P3^4;
sbit  CCP0_2    = P3^5;
sbit  CCP1_2    = P3^6;
sbit  CCP2_2    = P3^7;

sbit  SPI_SS    = P1^2;
sbit  SPI_MOSI  = P1^3;
sbit  SPI_MISO  = P1^4;
sbit  SPI_SCLK  = P1^5;

sbit  SPI_SS_2    = P2^2;
sbit  SPI_MOSI_2  = P2^3;
sbit  SPI_MISO_2  = P2^4;
sbit  SPI_SCLK_2  = P2^5;

sbit  SPI_SS_4    = P3^5;
sbit  SPI_MOSI_4  = P3^4;
sbit  SPI_MISO_4  = P3^3;
sbit  SPI_SCLK_4  = P3^2;

sbit RXD  = P3^0;
sbit TXD  = P3^1;
sbit INT0 = P3^2;
sbit INT1 = P3^3;
sbit T0   = P3^4;
sbit T1   = P3^5;

sbit INT2 = P3^6;
sbit INT3 = P3^7;
sbit INT4 = P3^0;

sbit CLKOUT0   = P3^5;
sbit CLKOUT1   = P3^4;


/*  SCON  */
sbit SM0  = SCON^7;	//SM0/FE		SM0 SM1 = 00 ~ 11: ʽ0~3
sbit SM1  = SCON^6;	//
sbit SM2  = SCON^5;	//ͨѶ
sbit REN  = SCON^4;	//
sbit TB8  = SCON^3;	//ݵ8λ
sbit RB8  = SCON^2;	//ݵ8λ
sbit TI   = SCON^1;	//жϱ־λ
sbit RI   = SCON^0;	//жϱ־λ

/*  IE   */
sbit EA   = IE^7;	//жܿλ
sbit ELVD = IE^6;	//ѹжλ
sbit EADC = IE^5;	//ADC ж λ
sbit ES   = IE^4;	//ж λ
sbit ET1  = IE^3;	//ʱж1λ
sbit EX1  = IE^2;	//ⲿж1λ
sbit ET0  = IE^1;	//ʱж0λ
sbit EX0  = IE^0;	//ⲿж0λ

sbit ACC0 = ACC^0;
sbit ACC1 = ACC^1;
sbit ACC2 = ACC^2;
sbit ACC3 = ACC^3;
sbit ACC4 = ACC^4;
sbit ACC5 = ACC^5;
sbit ACC6 = ACC^6;
sbit ACC7 = ACC^7;

sbit B0 = B^0;
sbit B1 = B^1;
sbit B2 = B^2;
sbit B3 = B^3;
sbit B4 = B^4;
sbit B5 = B^5;
sbit B6 = B^6;
sbit B7 = B^7;

//                                     7    6    5    4    3     2       1       0      Reset Value
//INT_CLKO:  жʱƼĴ  -   EX4  EX3  EX2   -   T2CLKO  T1CLKO  T0CLKO    0000,0000
#define	INT4_Enable()	INT_CLKO |= (1 << 6)
#define	INT3_Enable()	INT_CLKO |= (1 << 5)
#define	INT2_Enable()	INT_CLKO |= (1 << 4)
#define	INT1_Enable()	EX1 = 1
#define	INT0_Enable()	EX0 = 1

#define	INT4_Disable()	INT_CLKO &= ~(1 << 6)
#define	INT3_Disable()	INT_CLKO &= ~(1 << 5)
#define	INT2_Disable()	INT_CLKO &= ~(1 << 4)
#define	INT1_Disable()	EX1 = 0
#define	INT0_Disable()	EX0 = 0

//                               7    6       5       4      3    2     1     0      Reset Value
//AUXINTIF:  жϱ־Ĵ  -  INT4IF  INT3IF  INT2IF   -   T4IF  T3IF  T2IF    0000,0000
#define	INT4IF	0x40
#define	INT3IF	0x20
#define	INT2IF	0x10
#define	T4IF	0x04
#define	T3IF	0x02
#define	T2IF	0x01

#define	INT4_Clear()	AUXINTIF &= ~INT4IF		/* ж4־λ */
#define	INT3_Clear()	AUXINTIF &= ~INT3IF		/* ж3־λ */
#define	INT2_Clear()	AUXINTIF &= ~INT2IF		/* ж2־λ */
#define	INT1_Clear()	IE1 = 0					/* ж1־λ */
#define	INT0_Clear()	IE0 = 0					/* ж0־λ */

#define	INT0_Fall()		IT0 = 1		/* INT0 ½ж           */
#define	INT0_RiseFall()	IT0 = 0		/* INT0 ½ؾж   */
#define	INT1_Fall()		IT1 = 1		/* INT1 ½ж           */
#define	INT1_RiseFall()	IT0 = 0		/* INT1 ½ؾж   */


//							7     6     5    4    3    2    1     0    Reset Value
//sfr IE2       = 0xAF;		-     -     -    -    -    -   ESPI  ES2   0000,0000B	//Auxiliary Interrupt
#define		SPI_INT_ENABLE()		IE2 |=  2	/* SPIж		*/
#define		SPI_INT_DISABLE()		IE2 &= ~2	/* SPIж		*/
#define		UART2_INT_ENABLE()		IE2 |=  1	/* 2ж	*/
#define		UART2_INT_DISABLE()		IE2 &= ~1	/* 2ж	*/

//                                          7     6     5    4    3    2    1    0    Reset Value
//sfr IP      = 0xB8; //жȼλ      PPCA  PLVD  PADC  PS   PT1  PX1  PT0  PX0   0000,0000
//--------
sbit PPCA	= IP^7;	//PCA ģжȼ
sbit PLVD	= IP^6;	//ѹжȼ
sbit PADC	= IP^5;	//ADC жȼ
sbit PS   	= IP^4;	//ж0ȼ趨λ
sbit PT1	= IP^3;	//ʱж1ȼ趨λ
sbit PX1	= IP^2;	//ⲿж1ȼ趨λ
sbit PT0	= IP^1;	//ʱж0ȼ趨λ
sbit PX0	= IP^0;	//ⲿж0ȼ趨λ

//                                           7      6      5     4     3     2    1     0        Reset Value
//sfr IPH   = 0xB7; //жȼλ       PPCAH  PLVDH  PADCH  PSH  PT1H  PX1H  PT0H  PX0H   0000,0000
//sfr IP2   = 0xB5; //                       -      -      -     -     -     -   PSPI   PS2   xxxx,xx00
//sfr IP2H  = 0xB6; //                       -      -      -     -     -     -   PSPIH  PS2H  xxxx,xx00
#define		PPCAH	0x80
#define		PLVDH	0x40
#define		PADCH	0x20
#define		PSH		0x10
#define		PT1H	0x08
#define		PX1H	0x04
#define		PT0H	0x02
#define		PX0H	0x01

#define		PCA_InterruptFirst()	PPCA = 1
#define		LVD_InterruptFirst()	PLVD = 1
#define		ADC_InterruptFirst()	PADC = 1
#define		UART1_InterruptFirst()	PS   = 1
#define		Timer1_InterruptFirst()	PT1  = 1
#define		INT1_InterruptFirst()	PX1  = 1
#define		Timer0_InterruptFirst()	PT0  = 1
#define		INT0_InterruptFirst()	PX0  = 1


/*************************************************************************************************/


//                       7      6     5    4    3    2     1      0        Reset Value
//sfr CMPCR1 = 0xE6;   CMPEN  CMPIF  PIE  NIE  PIS  NIS  CMPOE  CMPRES      00000000B
#define	CMPEN	0x80	//1: Ƚ, 0: ֹ,رձȽԴ
#define	CMPIF	0x40	//Ƚжϱ־, ػ½ж, 0
#define	PIE		0x20	//1: ȽϽ01, ж
#define	NIE		0x10	//1: ȽϽ10, ½ж
#define	PIS		0x08	//ѡ, 0: ѡڲP3.7,           1: ADC_CHS[3:0]ѡADC.
#define	NIS		0x04	//븺ѡ, 0: ѡڲBandGapѹBGv, 1: ѡⲿP3.6.
#define	CMPOE	0x02	//1: ȽϽ, 0: ֹ.
#define	CMPRES	0x01	//ȽϽ, 1: CMP+ƽCMP-,  0: CMP+ƽCMP-,  ֻ

#define	CMP_P_P37	0x00	//ѡ, 0: ѡڲP3.7
#define	CMP_P_ADC	0x08	//ѡ, 1: ADC_CHS[3:0]ѡADC.
#define	CMP_N_GAP	0x00	//븺ѡ, 0: ѡڲBandGapѹBGv.
#define	CMP_N_P36	0x04	//븺ѡ, 1: ѡⲿP3.6.

#define	CMPO_P34()	P_SW2 &= ~0x08	//P3.4.

//                       7        6       5  4  3  2  1  0    Reset Value
//sfr CMPCR2 = 0xE7;   INVCMPO  DISFLT       LCDTY[5:0]       00001001B
#define	INVCMPO	0x80	//1: ȽIOȡ,  0: ȡ
#define	DISFLT	0x40	//1: ر0.1uF˲,   	0: 
#define	LCDTY	0x00	//0~63, ȽϽ仯ʱ



/*************************************************************************************************/
//                     7     6     5    4    3    2   1   0       Reset Value
//sfr SCON  = 0x98;   SM0   SM1   SM2  REN  TB8  RB8  TI  RI      00000000B		 //S1 Control

#define		S1_DoubleRate()		PCON  |=  0x80
#define		S1_SHIFT()			SCON  &=  0x3f

#define		S1_8bit()			SCON   =  (SCON & 0x3f) | 0x40
#define		S1_9bit()			SCON   =  (SCON & 0x3f) | 0xc0
#define		S1_RX_Enable()		SCON  |=  0x10
#define		S1_RX_Disable()		SCON  &= ~0x10
#define		TI1					TI					/* жTI1Ƿ								 */
#define		RI1					RI					/* жRI1Ƿ								 */
#define		SET_TI1()			TI = 1				/* TI1(ж)								 */
#define		CLR_TI1()			TI = 0				/* TI1											 */
#define		CLR_RI1()			RI = 0				/* RI1											 */
#define		S1TB8_SET()			TB8 = 1				/* TB8											 */
#define		S1TB8_CLR()			TB8 = 0				/* TB8											 */
#define		S1_Int_Enable()		ES     =  1			/* 1ж									 */
#define		S1_Int_Disable()	ES     =  0			/* 1ֹж									 */
#define 	S1_BRT_UseTimer1()	AUXR  &= ~1
#define 	S1_BRT_UseTimer2()	AUXR  |=  1
#define		S1_USE_P30P31()		P_SW1 &= ~0xc0						//UART1 ʹP30 P31	Ĭ
#define		S1_USE_P36P37()		P_SW1  =  (P_SW1 & ~0xc0) | 0x40	//UART1 ʹP36 P37
#define		S1_USE_P16P17()		P_SW1  =  (P_SW1 & ~0xc0) | 0x80	//UART1 ʹP16 P17
#define		S1_USE_P43P44()		P_SW1  =  (P_SW1 & ~0xc0) | 0xc0	//UART1 ʹP4.3 P4.4

//						  7      6      5      4      3      2     1     0        Reset Value
//sfr S2CON = 0x9A;		S2SM0    -    S2SM2  S2REN  S2TB8  S2RB8  S2TI  S2RI      00000000B		 //S2 Control

#define		S2_MODE0()			S2CON &= ~(1<<7)	/* 2ģʽ08λUART = ʱ2 / 4 */
#define		S2_MODE1()			S2CON |=  (1<<7)	/* 2ģʽ19λUART = ʱ2 / 4 */
#define		S2_8bit()			S2CON &= ~(1<<7)	/* 2ģʽ08λUART = ʱ2 / 4 */
#define		S2_9bit()			S2CON |=  (1<<7)	/* 2ģʽ19λUART = ʱ2 / 4 */
#define		S2_RX_Enable()		S2CON |=  (1<<4)	/* 2										 */
#define		S2_RX_Disable()		S2CON &= ~(1<<4)	/* ֹ2										 */
#define		TI2					(S2CON & 2) 		/* жTI2Ƿ								 */
#define		RI2					(S2CON & 1) 		/* жRI2Ƿ								 */
#define		SET_TI2()			S2CON |=  (1<<1)	/* TI2(ж)								 */
#define		CLR_TI2()			S2CON &= ~(1<<1)	/* TI2											 */
#define		CLR_RI2()			S2CON &= ~1			/* RI2											 */
#define		S2TB8_SET()			S2CON |=  (1<<3)	/* TB8											 */
#define		S2TB8_CLR()			S2CON &= ~(1<<3)	/* TB8											 */
#define		S2_Int_Enable()		IE2   |=  1			/* 2ж									 */
#define		S2_Int_Disable()	IE2   &= ~1			/* 2ֹж									 */
#define		S2_USE_P10P11()		P_SW2 &= ~1			/* UART2 ʹP1	Ĭ							 */
#define		S2_USE_P46P47()		P_SW2 |=  1			/* UART2 ʹP4.6 P4.7							 */

//						  7      6      5      4      3      2     1     0        Reset Value
//sfr S3CON = 0xAC;		S3SM0  S3ST3  S3SM2  S3REN  S3TB8  S3RB8  S3TI  S3RI      00000000B		 //S3 Control

#define		S3_MODE0()			S3CON &= ~(1<<7)	/* 3ģʽ08λUART = ʱ / 4  */
#define		S3_MODE1()			S3CON |=  (1<<7)	/* 3ģʽ19λUART = ʱ / 4  */
#define		S3_8bit()			S3CON &= ~(1<<7)	/* 3ģʽ08λUART = ʱ / 4  */
#define		S3_9bit()			S3CON |=  (1<<7)	/* 3ģʽ19λUART = ʱ / 4  */
#define		S3_RX_Enable()		S3CON |=  (1<<4)	/* 3									     */
#define		S3_RX_Disable()		S3CON &= ~(1<<4)	/* ֹ3									     */
#define		TI3					(S3CON & 2) != 0	/* жTI3Ƿ								 */
#define		RI3					(S3CON & 1) != 0	/* жRI3Ƿ								 */
#define		SET_TI3()			S3CON |=  (1<<1)	/* TI3(ж)								 */
#define		CLR_TI3()			S3CON &= ~(1<<1)	/* TI3											 */
#define		CLR_RI3()			S3CON &= ~1			/* RI3											 */
#define		S3TB8_SET()			S3CON |=  (1<<3)	/* TB8											 */
#define		S3TB8_CLR()			S3CON &= ~(1<<3)	/* TB8											 */
#define		S3_Int_Enable()		IE2   |=  (1<<3)	/* 3ж								     */
#define		S3_Int_Disable()	IE2   &= ~(1<<3)	/* 3ֹж								     */
#define 	S3_BRT_UseTimer3()	S3CON |=  (1<<6)	/* BRT select Timer3								 */
#define 	S3_BRT_UseTimer2()	S3CON &= ~(1<<6)	/* BRT select Timer2								 */
#define		S3_USE_P00P01()		P_SW2 &= ~2			/* UART3 ʹP0.0 P0.1	Ĭ				     */
#define		S3_USE_P50P51()		P_SW2 |=  2			/* UART3 ʹP5.0 P5.1						     */

//						  7      6      5      4      3      2     1     0        Reset Value
//sfr S4CON = 0x84;		S4SM0  S4ST4  S4SM2  S4REN  S4TB8  S4RB8  S4TI  S4RI      00000000B		 //S4 Control

#define		S4_MODE0()			S4CON &= ~(1<<7)	/* 4ģʽ08λUART = ʱ / 4  */
#define		S4_MODE1()			S4CON |=  (1<<7)	/* 4ģʽ19λUART = ʱ / 4  */
#define		S4_8bit()			S4CON &= ~(1<<7)	/* 4ģʽ08λUART = ʱ / 4  */
#define		S4_9bit()			S4CON |=  (1<<7)	/* 4ģʽ19λUART = ʱ / 4  */
#define		S4_RX_Enable()		S4CON |=  (1<<4)	/* 4									     */
#define		S4_RX_Disable()		S4CON &= ~(1<<4)	/* ֹ4									     */
#define		TI4					(S4CON & 2) != 0	/* жTI3Ƿ							     */
#define		RI4					(S4CON & 1) != 0	/* жRI3Ƿ							     */
#define		SET_TI4()			S4CON |=  2			/* TI3(ж)							     */
#define		CLR_TI4()			S4CON &= ~2			/* TI3										     */
#define		CLR_RI4()			S4CON &= ~1			/* RI3										     */
#define		S4TB8_SET()			S4CON |=  8			/* TB8										     */
#define		S4TB8_CLR()			S4CON &= ~8			/* TB8										     */
#define		S4_Int_Enable()		IE2   |=  (1<<4)	/* 4ж								     */
#define		S4_Int_Disable()	IE2   &= ~(1<<4)	/* 4ֹж								     */
#define 	S4_BRT_UseTimer4()	S4CON |=  (1<<6)	/* BRT select Timer4								 */
#define 	S4_BRT_UseTimer2()	S4CON &= ~(1<<6)	/* BRT select Timer2								 */
#define		S4_USE_P02P03()		P_SW2 &= ~4			/* UART4 ʹP0.2 P0.3	Ĭ				     */
#define		S4_USE_P52P53()		P_SW2 |=  4			/* UART4 ʹP5.2 P5.3						     */


/**********************************************************/
//						   7     6       5      4     3      2      1      0    Reset Value
//sfr AUXR  = 0x8E;		T0x12 T1x12 UART_M0x6  T2R  T2_C/T T2x12 EXTRAM  S1ST2  0000,0000	//Auxiliary Register

#define 	InternalXdata_Disable()		AUXR |=  2		/* ֹʹڲxdata, зxdataǷⲿxdata  */
#define 	InternalXdata_Enable()		AUXR &= ~2		/* ʹڲxdata, ʵĵַڲxdataΧʱ, ڲxadta, ַڲxdataʱ, ⲿxdata  */
#define		S1_M0x6()					AUXR |=  (1<<5)	/* UART Mode0 Speed is 6x Standard       */
#define		S1_M0x1()					AUXR &= ~(1<<5)	/* default,	UART Mode0 Speed is Standard */

//====================================
#define		Timer0_16bitAutoReload()	TMOD &= ~0x03					/* 16λԶװ	*/
#define		Timer0_16bit()				TMOD  = (TMOD & ~0x03) | 0x01	/* 16λ         */
#define		Timer0_8bitAutoReload()		TMOD  = (TMOD & ~0x03) | 0x02	/* 8λԶװ	*/
#define		Timer0_16bitAutoRL_NoMask()	TMOD |=  0x03		/* 16λԶװж	*/
#define 	Timer0_Run()	 			TR0 = 1				/* ʱ0			*/
#define 	Timer0_Stop()	 			TR0 = 0				/* ֹʱ0			*/
#define		Timer0_Gate_INT0_P32()		TMOD |=  (1<<3)		/* ʱ0ⲿINT0ߵƽʱ */
#define		Timer0_AsTimer()			TMOD &= ~(1<<2)		/* ʱ0ʱ	*/
#define		Timer0_AsCounter()			TMOD |=  (1<<2)		/* ʱ0	*/
#define		Timer0_AsCounterP34()		TMOD |=  (1<<2)		/* ʱ0	*/
#define 	Timer0_1T()					AUXR |=  (1<<7)		/* Timer0 clodk = fo	*/
#define 	Timer0_12T()				AUXR &= ~(1<<7)		/* Timer0 clodk = fo/12	12Ƶ,	default	*/
#define		Timer0_CLKO_Enable()		INT_CLKO |=  1			/*  T0 T0(P3.5)Fck0 = 1/2 T0 ʣT01T12T	*/
#define		Timer0_CLKO_Disable()		INT_CLKO &= ~1
#define		Timer0_CLKO_Enable_P35()	INT_CLKO |=  1			/*  T0 T0(P3.5)Fck0 = 1/2 T0 ʣT01T12T	*/
#define		Timer0_CLKO_Disable_P35()	INT_CLKO &= ~1
#define 	Timer0_InterruptEnable()	ET0 = 1				/* Timer1ж.*/
#define 	Timer0_InterruptDisable()	ET0 = 0				/* ֹTimer1ж.*/

#define		T0_Load(n)					TH0 = (n) / 256,	TL0 = (n) % 256
#define		T0_Load_us_1T(n)			Timer0_AsTimer(),Timer0_1T(), Timer0_16bitAutoReload(),TH0=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)/256, TL0=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)%256
#define		T0_Load_us_12T(n)			Timer0_AsTimer(),Timer0_12T(),Timer0_16bitAutoReload(),TH0=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)/256,TL0=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)%256
#define		T0_Frequency_1T_P35(n)		ET0=0,Timer0_AsTimer(),Timer0_1T(),Timer0_16bitAutoReload(),TH0=(65536-(n/2+MAIN_Fosc/2)/(n))/256,TL0=(65536-(n/2+MAIN_Fosc/2)/(n))%256,INT_CLKO |= 1,TR0=1		/* fx=fosc/(2*M)/n,  M=1 or M=12 */
#define		T0_Frequency_12T_P35(n)		ET0=0,Timer0_AsTimer(),Timer0_12T(),Timer0_16bitAutoReload(),TH0=(65536-(n/2+MAIN_Fosc/24)/(n))/256,TL0=(65536-(n/2+MAIN_Fosc/24)/(n))%256,INT_CLKO |= 1,TR0=1	/* fx=fosc/(2*M)/n,  M=1 or M=12 */

//====================================
#define		Timer1_16bitAutoReload()	TMOD &= ~0x30					/* 16λԶװ	*/
#define		Timer1_16bit()				TMOD  = (TMOD & ~0x30) | 0x10	/* 16λ			*/
#define		Timer1_8bitAutoReload()		TMOD  = (TMOD & ~0x30) | 0x20	/* 8λԶװ	*/
#define 	Timer1_Run()	 			TR1 = 1				/* ʱ1			*/
#define 	Timer1_Stop()	 			TR1 = 0				/* ֹʱ1			*/
#define		Timer1_Gate_INT1_P33()		TMOD |=  (1<<7)		/* ʱ1ⲿINT1ߵƽʱ	*/
#define		Timer1_AsTimer()			TMOD &= ~(1<<6)		/* ʱ1ʱ			*/
#define		Timer1_AsCounter()			TMOD |=  (1<<6)		/* ʱ1			*/
#define		Timer1_AsCounterP35()		TMOD |=  (1<<6)		/* ʱ1			*/
#define 	Timer1_1T()					AUXR |=  (1<<6)		/* Timer1 clodk = fo		*/
#define 	Timer1_12T()				AUXR &= ~(1<<6)		/* Timer1 clodk = fo/12	12Ƶ,	default	*/
#define		Timer1_CLKO_Enable()		INT_CLKO |=  2			/*  T1 T1(P3.4)Fck1 = 1/2 T1 ʣT11T12T	*/
#define		Timer1_CLKO_Disable()		INT_CLKO &= ~2
#define		Timer1_CLKO_Enable_P34()	INT_CLKO |=  2			/*  T1 T1(P3.4)Fck1 = 1/2 T1 ʣT11T12T	*/
#define		Timer1_CLKO_Disable_P34()	INT_CLKO &= ~2
#define 	Timer1_InterruptEnable()	ET1 = 1				/* Timer1ж.	*/
#define 	Timer1_InterruptDisable()	ET1 = 0				/* ֹTimer1ж.	*/

#define		T1_Load(n)					TH1 = (n) / 256,	TL1 = (n) % 256
#define		T1_Load_us_1T(n)			Timer1_AsTimer(),Timer1_1T(), Timer1_16bitAutoReload(),TH1=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)/256, TL1=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)%256
#define		T1_Load_us_12T(n)			Timer1_AsTimer(),Timer1_12T(),Timer1_16bitAutoReload(),TH1=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)/256,TL1=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)%256
#define		T1_Frequency_1T_P34(n)		ET1=0,Timer1_AsTimer(),Timer1_1T(),Timer1_16bitAutoReload(),TH1=(65536-(n/2+MAIN_Fosc/2)/(n))/256,TL1=(65536-(n/2+MAIN_Fosc/2)/(n))%256,INT_CLKO |= 2,TR1=1		/* fx=fosc/(2*M)/n,  M=1 or M=12 */
#define		T1_Frequency_12T_P34(n)		ET1=0,Timer1_AsTimer(),Timer1_12T(),Timer1_16bitAutoReload(),TH1=(65536-(n/2+MAIN_Fosc/24)/(n))/256,TL1=(65536-(n/2+MAIN_Fosc/24)/(n))%256,INT_CLKO |= 2,TR1=1	/* fx=fosc/(2*M)/n,  M=1 or M=12 */

//====================================
#define 	Timer2_Run()	 			AUXR |=  (1<<4)	/* ʱ2	*/
#define 	Timer2_Stop()	 			AUXR &= ~(1<<4)	/* ֹʱ2	*/
#define		Timer2_AsTimer()			AUXR &= ~(1<<3)	/* ʱ2ʱ	*/
#define		Timer2_AsCounter()			AUXR |=  (1<<3)	/* ʱ2	*/
#define		Timer2_AsCounterP31()		AUXR |=  (1<<3)	/* ʱ2	*/
#define 	Timer2_1T()					AUXR |=  (1<<2)	/* Timer0 clock = fo	*/
#define 	Timer2_12T()				AUXR &= ~(1<<2)	/* Timer0 clock = fo/12	12Ƶ,	default	*/
#define		Timer2_CLKO_Enable()		INT_CLKO |=  4		/*  T2 P1.3Fck2 = 1/2 T2 ʣT21T12T	*/
#define		Timer2_CLKO_Disable()		INT_CLKO &= ~4
#define		Timer2_CLKO_Enable_P13()	INT_CLKO |=  4		/*  T2 P1.3Fck2 = 1/2 T2 ʣT21T12T	*/
#define		Timer2_CLKO_Disable_P13()	INT_CLKO &= ~4
#define 	Timer2_InterruptEnable()	IE2  |=  (1<<2)	/* Timer2ж.	*/
#define 	Timer2_InterruptDisable()	IE2  &= ~(1<<2)	/* ֹTimer2ж.	*/

#define		T2_Load(n)					TH2 = (n) / 256,	TL2 = (n) % 256
#define		T2_Load_us_1T(n)			Timer2_AsTimer(),Timer2_1T(), TH2=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)/256, TL2=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)%256
#define		T2_Load_us_12T(n)			Timer2_AsTimer(),Timer2_12T(),TH2=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)/256,TL2=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)%256
#define		T2_Frequency_1T_P13(n)		Timer2_InterruptDisable(),Timer2_AsTimer(),Timer2_1T(), TH2=(65536-(n/2+MAIN_Fosc/2)/(n))/256, TL2=(65536-(n/2+MAIN_Fosc/2)/(n))%256, Timer2_CLKO_Enable_P13(),Timer2_Run()	/* fx=fosc/(2*M)/n,  M=1 or M=12 */
#define		T2_Frequency_12T_P13(n)		Timer2_InterruptDisable(),Timer2_AsTimer(),Timer2_12T(),TH2=(65536-(n/2+MAIN_Fosc/24)/(n))/256,TL2=(65536-(n/2+MAIN_Fosc/24)/(n))%256,Timer2_CLKO_Enable_P13(),Timer2_Run()	/* fx=fosc/(2*M)/n,  M=1 or M=12 */

//====================================
#define 	Timer3_Run()	 			T4T3M |=  (1<<3)	/* ʱ3	*/
#define 	Timer3_Stop()	 			T4T3M &= ~(1<<3)	/* ֹʱ3	*/
#define		Timer3_AsTimer()			T4T3M &= ~(1<<2)	/* ʱ3ʱ	*/
#define		Timer3_AsCounter()			T4T3M |=  (1<<2)	/* ʱ3, P0.5Ϊⲿ	*/
#define		Timer3_AsCounterP05()		T4T3M |=  (1<<2)	/* ʱ3, P0.5Ϊⲿ	*/
#define 	Timer3_1T()					T4T3M |=  (1<<1)	/* 1Tģʽ	*/
#define 	Timer3_12T()				T4T3M &= ~(1<<1)	/* 12Tģʽ,	default	*/
#define		Timer3_CLKO_Enable()		T4T3M |=  1			/* T3T3(P0.4)Fck = 1/2 T2 ʣT21T12T	*/
#define		Timer3_CLKO_Disable()		T4T3M &= ~1			/* ֹT3T3(P0.4)	*/
#define		Timer3_CLKO_Enable_P04()	T4T3M |=  1			/* T3T3(P0.4)Fck = 1/2 T2 ʣT21T12T	*/
#define		Timer3_CLKO_Disable_P04()	T4T3M &= ~1			/* ֹT3T3(P0.4)	*/
#define 	Timer3_InterruptEnable()	IE2  |=  (1<<5)		/* Timer3ж.	*/
#define 	Timer3_InterruptDisable()	IE2  &= ~(1<<5)		/* ֹTimer3ж.	*/

#define		T3_Load(n)					TH3 = (n) / 256,	TL3 = (n) % 256
#define		T3_Load_us_1T(n)			Timer3_AsTimer(),Timer3_1T(), TH3=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)/256, TL3=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)%256
#define		T3_Load_us_12T(n)			Timer3_AsTimer(),Timer3_12T(),TH3=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)/256,TL3=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)%256
#define		T3_Frequency_1T_P04(n)		Timer3_InterruptDisable(),Timer3_AsTimer(),Timer3_1T(), TH3=(65536-(n/2+MAIN_Fosc/2)/(n))/256, TL3=(65536-(n/2+MAIN_Fosc/2)/(n))%256, Timer3_CLKO_P04_Enable,Timer3_Run()	/* fx=fosc/(2*M)/n,  M=1 or M=12 */
#define		T3_Frequency_12T_P04(n)		Timer3_InterruptDisable(),Timer3_AsTimer(),Timer3_12T(),TH3=(65536-(n/2+MAIN_Fosc/24)/(n))/256,TL3=(65536-(n/2+MAIN_Fosc/24)/(n))%256,Timer3_CLKO_P04_Enable,Timer3_Run()	/* fx=fosc/(2*M)/n,  M=1 or M=12 */

//====================================
#define 	Timer4_Run()	 			T4T3M |=  (1<<7)	/* ʱ4	*/
#define 	Timer4_Stop()	 			T4T3M &= ~(1<<7)	/* ֹʱ4	*/
#define		Timer4_AsTimer()			T4T3M &= ~(1<<6)	/* ʱ4ʱ  */
#define		Timer4_AsCounter()			T4T3M |=  (1<<6)	/* ʱ4, P0.7Ϊⲿ	*/
#define		Timer4_AsCounterP07()		T4T3M |=  (1<<6)	/* ʱ4, P0.7Ϊⲿ	*/
#define 	Timer4_1T()					T4T3M |=  (1<<5)	/* 1Tģʽ	*/
#define 	Timer4_12T()				T4T3M &= ~(1<<5)	/* 12Tģʽ,	default	*/
#define		Timer4_CLKO_Enable()		T4T3M |=  (1<<4)	/* T4T4(P0.6)Fck = 1/2 T2 ʣT21T12T	*/
#define		Timer4_CLKO_Disable()		T4T3M &= ~(1<<4)	/* ֹT4T4(P0.6)	*/
#define		Timer4_CLKO_Enable_P06()	T4T3M |=  (1<<4)	/* T4T4(P0.6)Fck = 1/2 T2 ʣT21T12T	*/
#define		Timer4_CLKO_Disable_P06()	T4T3M &= ~(1<<4)	/* ֹT4T4(P0.6)	*/
#define 	Timer4_InterruptEnable()	IE2  |=  (1<<6)		/* Timer4ж.	*/
#define 	Timer4_InterruptDisable()	IE2  &= ~(1<<6)		/* ֹTimer4ж.	*/

#define		T4_Load(n)					TH4 = (n) / 256,	TL4 = (n) % 256
#define		T4_Load_us_1T(n)			Timer4_AsTimer(),Timer4_1T(), TH4=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)/256, TL4=(65536-((MAIN_Fosc/1000)*(n)+500)/1000)%256
#define		T4_Load_us_12T(n)			Timer4_AsTimer(),Timer4_12T(),TH4=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)/256,TL4=(65536-((MAIN_Fosc/12000)*(n)+500)/1000)%256
#define		T4_Frequency_1T_P06(n)		Timer4_InterruptDisable(),Timer4_AsTimer(),Timer4_1T(), TH4=(65536-(n/2+MAIN_Fosc/2)/(n))/256, TL4=(65536-(n/2+MAIN_Fosc/2)/(n))%256, Timer4_CLKO_P06_Enable(),Timer4_Run()	/* fx=fosc/(2*M)/n,  M=1 or M=12 */
#define		T4_Frequency_12T_P06(n)		Timer4_InterruptDisable(),Timer4_AsTimer(),Timer4_12T(),TH4=(65536-(n/2+MAIN_Fosc/24)/(n))/256,TL4=(65536-(n/2+MAIN_Fosc/24)/(n))%256,Timer4_CLKO_P06_Enable(),Timer4_Run()	/* fx=fosc/(2*M)/n,  M=1 or M=12 */
//====================================================================================================================

//sfr WDT_CONTR = 0xC1; //Watch-Dog-Timer Control register
//                                      7     6     5      4       3      2   1   0     Reset Value
//                                  WDT_FLAG  -  EN_WDT CLR_WDT IDLE_WDT PS2 PS1 PS0    xx00,0000
#define D_WDT_FLAG			(1<<7)
#define D_EN_WDT			(1<<5)
#define D_CLR_WDT			(1<<4)	/* auto clear	*/
#define D_IDLE_WDT			(1<<3)	/* WDT counter when Idle	*/
#define D_WDT_SCALE_2		0
#define D_WDT_SCALE_4		1
#define D_WDT_SCALE_8		2		/* T=393216*N/fo	*/
#define D_WDT_SCALE_16		3
#define D_WDT_SCALE_32		4
#define D_WDT_SCALE_64		5
#define D_WDT_SCALE_128		6
#define D_WDT_SCALE_256		7

#define	WDT_reset(n)	WDT_CONTR = D_EN_WDT + D_CLR_WDT + D_IDLE_WDT + (n)		/* ʼWDTι */


//						  7     6      5    4     3      2    1     0     Reset Value
//sfr PCON   = 0x87;	SMOD  SMOD0  LVDF  POF   GF1    GF0   PD   IDL    0001,0000	 //Power Control
//SMOD		//˫
//SMOD0
#define		LVDF		(1<<5)	/* P4.6ѹ־ */
//POF
//GF1
//GF0
//#define 	D_PD		2		/* set 1, power down mode */
//#define 	D_IDLE		1		/* set 1, idle mode */
#define		MCU_IDLE()			PCON |= 1	/* MCU  IDLE ģʽ */
#define		MCU_POWER_DOWN()	PCON |= 2	/* MCU  ˯ ģʽ */


//sfr ISP_CMD   = 0xC5;
#define		ISP_STANDBY()	ISP_CMD = 0		/* ISPֹ*/
#define		ISP_READ()		ISP_CMD = 1		/* ISP		*/
#define		ISP_WRITE()		ISP_CMD = 2		/* ISPд		*/
#define		ISP_ERASE()		ISP_CMD = 3		/* ISP		*/

//sfr ISP_TRIG  = 0xC6;
#define 	ISP_TRIG()	ISP_TRIG = 0x5A,	ISP_TRIG = 0xA5		/* ISP */

//							  7    6    5      4    3    2    1     0    Reset Value
//sfr IAP_CONTR = 0xC7;		IAPEN SWBS SWRST CFAIL  -    -    -     -    0000,x000	//IAP Control Register
#define ISP_EN			(1<<7)
#define ISP_SWBS		(1<<6)
#define ISP_SWRST		(1<<5)
#define ISP_CMD_FAIL	(1<<4)


/* ADC Register */
//								7       6      5       4         3      2    1    0   Reset Value
//sfr ADC_CONTR = 0xBC;		ADC_POWER SPEED1 SPEED0 ADC_FLAG ADC_START CHS2 CHS1 CHS0 0000,0000	/* AD תƼĴ */
//sfr ADC_RES  = 0xBD;		ADCV.9 ADCV.8 ADCV.7 ADCV.6 ADCV.5 ADCV.4 ADCV.3 ADCV.2	  0000,0000	/* A/D ת8λ */
//sfr ADC_RESL = 0xBE;												  ADCV.1 ADCV.0	  0000,0000	/* A/D ת2λ */
//sfr ADC_CONTR  = 0xBC;	//ֱMOVҪ


//sfr SPCTL  = 0xCE;	SPIƼĴ
//   7       6       5       4       3       2       1       0    	Reset Value
//	SSIG	SPEN	DORD	MSTR	CPOL	CPHA	SPR1	SPR0		0x00

#define	SPI_SSIG_None()		SPCTL |=  (1<<7)		/* 1: SS	*/
#define	SPI_SSIG_Enable()	SPCTL &= ~(1<<7)		/* 0: SSھӻ	*/
#define	SPI_Enable()		SPCTL |=  (1<<6)		/* 1: SPI	*/
#define	SPI_Disable()		SPCTL &= ~(1<<6)		/* 0: ֹSPI	*/
#define	SPI_LSB_First()		SPCTL |=  (1<<5)		/* 1: LSBȷ	*/
#define	SPI_MSB_First()		SPCTL &= ~(1<<5)		/* 0: MSBȷ	*/
#define	SPI_Master()		SPCTL |=  (1<<4)		/* 1: Ϊ	*/
#define	SPI_Slave()			SPCTL &= ~(1<<4)		/* 0: Ϊӻ	*/
#define	SPI_SCLK_NormalH()	SPCTL |=  (1<<3)		/* 1: ʱSCLKΪߵƽ	*/
#define	SPI_SCLK_NormalL()	SPCTL &= ~(1<<3)		/* 0: ʱSCLKΪ͵ƽ	*/
#define	SPI_PhaseH()		SPCTL |=  (1<<2)		/* 1: 	*/
#define	SPI_PhaseL()		SPCTL &= ~(1<<2)		/* 0: 	*/
#define	SPI_Speed(n)		SPCTL = (SPCTL & ~3) | (n)	/*ٶ, 0 -- fosc/4, 1 -- fosc/8, 2 -- fosc/16, 3 -- fosc/32	*/

//sfr SPDAT  = 0xCF; //SPI Data Register                                                     0000,0000
//sfr SPSTAT  = 0xCD;	//SPI״̬Ĵ
//   7       6      5   4   3   2   1   0    	Reset Value
//	SPIF	WCOL	-	-	-	-	-	-
#define	SPIF	0x80		/* SPIɱ־д10*/
#define	WCOL	0x40		/* SPIдͻ־д10  */

#define		SPI_USE_P12P13P14P15()	P_SW1 &= ~0x0c					/* SPIлP12(SS) P13(MOSI) P14(MISO) P15(SCLK)(ϵĬ)*/
#define		SPI_USE_P22P23P24P25()	P_SW1 = (P_SW1 & ~0x0c) | 0x04	/* SPIлP22(SS) P23(MOSI) P24(MISO) P25(SCLK)*/
#define		SPI_USE_P35P34P33P32()	P_SW1 =  P_SW1 | 0x0C			/* SPIлP35(SS) P34(MOSI) P33(MISO) P32(SCLK)*/


/*
;PCA_PWMn:    7       6     5   4   3   2     1       0
;			EBSn_1	EBSn_0	-	-	-	-	EPCnH	EPCnL
;B5-B2:		
;B1(EPCnH):	PWMģʽ£CCAPnH9λ
;B0(EPCnL):	PWMģʽ£CCAPnL9λ
*/
#define		PWM0_NORMAL()	PCA_PWM0 &= ~3					/* PWM0(Ĭ)	*/
#define		PWM0_OUT_0()	PCA_PWM0 |=  3, CCAP0H = 0xff	/* PWM0һֱ0		*/
#define		PWM0_OUT_1()	PCA_PWM0 &= 0xc0, CCAP0H = 0	/* PWM0һֱ1		*/

#define		PWMA_NORMAL()	PCA_PWMA &= ~3					/* PWMA(Ĭ)	*/
#define		PWMA_OUT_0()	PCA_PWMA |=  3, CCAP1H = 0xff	/* PWMAһֱ0		*/
#define		PWMA_OUT_1()	PCA_PWMA &= 0xc0, CCAP1H = 0	/* PWMAһֱ1		*/

#define		PWMB_NORMAL()	PCA_PWMB &= ~3					/* PWMB(Ĭ)	*/
#define		PWMB_OUT_0()	PCA_PWMB |=  3, CCAP2H = 0xff	/* PWMBһֱ0		*/
#define		PWMB_OUT_1()	PCA_PWMB &= 0xc0, CCAP2H = 0	/* PWMBһֱ1		*/


/**********************************************************/
typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

/**********************************************************/
#define NOP1()  _nop_()
#define NOP2()  NOP1(),NOP1()
#define NOP3()  NOP2(),NOP1()
#define NOP4()  NOP3(),NOP1()
#define NOP5()  NOP4(),NOP1()
#define NOP6()  NOP5(),NOP1()
#define NOP7()  NOP6(),NOP1()
#define NOP8()  NOP7(),NOP1()
#define NOP9()  NOP8(),NOP1()
#define NOP10() NOP9(),NOP1()
#define NOP11() NOP10(),NOP1()
#define NOP12() NOP11(),NOP1()
#define NOP13() NOP12(),NOP1()
#define NOP14() NOP13(),NOP1()
#define NOP15() NOP14(),NOP1()
#define NOP16() NOP15(),NOP1()
#define NOP17() NOP16(),NOP1()
#define NOP18() NOP17(),NOP1()
#define NOP19() NOP18(),NOP1()
#define NOP20() NOP19(),NOP1()
#define NOP21() NOP20(),NOP1()
#define NOP22() NOP21(),NOP1()
#define NOP23() NOP22(),NOP1()
#define NOP24() NOP23(),NOP1()
#define NOP25() NOP24(),NOP1()
#define NOP26() NOP25(),NOP1()
#define NOP27() NOP26(),NOP1()
#define NOP28() NOP27(),NOP1()
#define NOP29() NOP28(),NOP1()
#define NOP30() NOP29(),NOP1()
#define NOP31() NOP30(),NOP1()
#define NOP32() NOP31(),NOP1()
#define NOP33() NOP32(),NOP1()
#define NOP34() NOP33(),NOP1()
#define NOP35() NOP34(),NOP1()
#define NOP36() NOP35(),NOP1()
#define NOP37() NOP36(),NOP1()
#define NOP38() NOP37(),NOP1()
#define NOP39() NOP38(),NOP1()
#define NOP40() NOP39(),NOP1()
#define NOP(N)  NOP##N()


/**********************************************/
#define	Pin0		0x01	//IO Px.0
#define	Pin1		0x02	//IO Px.1
#define	Pin2		0x04	//IO Px.2
#define	Pin3		0x08	//IO Px.3
#define	Pin4		0x10	//IO Px.4
#define	Pin5		0x20	//IO Px.5
#define	Pin6		0x40	//IO Px.6
#define	Pin7		0x80	//IO Px.7
#define	PinAll		0xFF	//IO

#define	GPIO_Pin_0		0x01	//IO Px.0
#define	GPIO_Pin_1		0x02	//IO Px.1
#define	GPIO_Pin_2		0x04	//IO Px.2
#define	GPIO_Pin_3		0x08	//IO Px.3
#define	GPIO_Pin_4		0x10	//IO Px.4
#define	GPIO_Pin_5		0x20	//IO Px.5
#define	GPIO_Pin_6		0x40	//IO Px.6
#define	GPIO_Pin_7		0x80	//IO Px.7
#define	GPIO_Pin_All	0xFF	//IO

#define	GPIO_PullUp		0	//׼˫
#define	GPIO_HighZ		1	//
#define	GPIO_OUT_OD		2	//©
#define	GPIO_OUT_PP		3	//

#define	GPIO_P0			0		//
#define	GPIO_P1			1
#define	GPIO_P2			2
#define	GPIO_P3			3
#define	GPIO_P4			4
#define	GPIO_P5			5
#define	GPIO_P6			6
#define	GPIO_P7			7

#define P0n_standard(bitn)			P0M1 &= ~(bitn),	P0M0 &= ~(bitn)	/* 00  */
#define P0n_push_pull(bitn)			P0M1 &= ~(bitn),	P0M0 |=  (bitn)	/* 01  */
#define P0n_pure_input(bitn)		P0M1 |=  (bitn),	P0M0 &= ~(bitn)	/* 10  */
#define P0n_open_drain(bitn)		P0M1 |=  (bitn),	P0M0 |=  (bitn)	/* 11  */

#define P1n_standard(bitn)			P1M1 &= ~(bitn),	P1M0 &= ~(bitn)
#define P1n_push_pull(bitn)			P1M1 &= ~(bitn),	P1M0 |=  (bitn)
#define P1n_pure_input(bitn)		P1M1 |=  (bitn),	P1M0 &= ~(bitn)
#define P1n_open_drain(bitn)		P1M1 |=  (bitn),	P1M0 |=  (bitn)

#define P2n_standard(bitn)			P2M1 &= ~(bitn),	P2M0 &= ~(bitn)
#define P2n_push_pull(bitn)			P2M1 &= ~(bitn),	P2M0 |=  (bitn)
#define P2n_pure_input(bitn)		P2M1 |=  (bitn),	P2M0 &= ~(bitn)
#define P2n_open_drain(bitn)		P2M1 |=  (bitn),	P2M0 |=  (bitn)

#define P3n_standard(bitn)			P3M1 &= ~(bitn),	P3M0 &= ~(bitn)
#define P3n_push_pull(bitn)			P3M1 &= ~(bitn),	P3M0 |=  (bitn)
#define P3n_pure_input(bitn)		P3M1 |=  (bitn),	P3M0 &= ~(bitn)
#define P3n_open_drain(bitn)		P3M1 |=  (bitn),	P3M0 |=  (bitn)

#define P4n_standard(bitn)			P4M1 &= ~(bitn),	P4M0 &= ~(bitn)
#define P4n_push_pull(bitn)			P4M1 &= ~(bitn),	P4M0 |=  (bitn)
#define P4n_pure_input(bitn)		P4M1 |=  (bitn),	P4M0 &= ~(bitn)
#define P4n_open_drain(bitn)		P4M1 |=  (bitn),	P4M0 |=  (bitn)

#define P5n_standard(bitn)			P5M1 &= ~(bitn),	P5M0 &= ~(bitn)
#define P5n_push_pull(bitn)			P5M1 &= ~(bitn),	P5M0 |=  (bitn)
#define P5n_pure_input(bitn)		P5M1 |=  (bitn),	P5M0 &= ~(bitn)
#define P5n_open_drain(bitn)		P5M1 |=  (bitn),	P5M0 |=  (bitn)

#define P6n_standard(bitn)			P6M1 &= ~(bitn),	P6M0 &= ~(bitn)
#define P6n_push_pull(bitn)			P6M1 &= ~(bitn),	P6M0 |=  (bitn)
#define P6n_pure_input(bitn)		P6M1 |=  (bitn),	P6M0 &= ~(bitn)
#define P6n_open_drain(bitn)		P6M1 |=  (bitn),	P6M0 |=  (bitn)

#define P7n_standard(bitn)			P7M1 &= ~(bitn),	P7M0 &= ~(bitn)
#define P7n_push_pull(bitn)			P7M1 &= ~(bitn),	P7M0 |=  (bitn)
#define P7n_pure_input(bitn)		P7M1 |=  (bitn),	P7M0 &= ~(bitn)
#define P7n_open_drain(bitn)		P7M1 |=  (bitn),	P7M0 |=  (bitn)


/****************************************************************/


//sfr INT_CLKO = 0x8F;	//ӵ SFR WAKE_CLKO (ַ0x8F)
/*
    7   6    5    4   3     2        1       0         Reset Value
    -  EX4  EX3  EX2  -   T2CLKO   T1CLKO  T0CLKO      0000,0000B
b6 -  EX4      : жINT4
b5 -  EX3      : жINT3
b4 -  EX2      : жINT2
b2 - T1CLKO    :  T2 P3.0Fck1 = 1/2 T1 
b1 - T1CLKO    :  T1 P3.4Fck1 = 1/2 T1 
b0 - T0CLKO    :  T0 P3.5Fck0 = 1/2 T0 
*/

#define		LVD_InterruptEnable()		ELVD = 1
#define		LVD_InterruptDisable()		ELVD = 0


//sfr WKTCL = 0xAA;	//STC11F\10STC15ϵ Ѷʱֽ
//sfr WKTCH = 0xAB;	//STC11F\10STC15ϵ Ѷʱֽ
//	B7		B6	B5	B4	B3	B2	B1	B0		B7	B6	B5	B4	B3	B2	B1	B0
//	WKTEN				S11	S10	S9	S8		S7	S6	S5	S4	S3	S2	S1	S0	n * 560us
#define		WakeTimerDisable()		WKTCH &= 0x7f	/* WKTEN = 0		ֹ˯߻Ѷʱ */
#define		WakeTimerSet(scale)		WKTCL = (scale) % 256,WKTCH = (scale) / 256 | 0x80	/* WKTEN = 1	˯߻Ѷʱ */



/////////////////////////////////////////////////
//Interrupt Vector
/////////////////////////////////////////////////
#define INT0_VECTOR         0       //FF0003H
#define TMR0_VECTOR         1       //FF000BH
#define INT1_VECTOR         2       //FF0013H
#define TMR1_VECTOR         3       //FF001BH
#define UART1_VECTOR        4       //FF0023H
#define ADC_VECTOR          5       //FF002BH
#define LVD_VECTOR          6       //FF0033H
#define UART2_VECTOR        8       //FF0043H
#define SPI_VECTOR          9       //FF004BH
#define INT2_VECTOR         10      //FF0053H
#define INT3_VECTOR         11      //FF005BH
#define TMR2_VECTOR         12      //FF0063H
#define USER_VECTOR         13      //FF006BH
#define INT4_VECTOR         16      //FF0083H
#define UART3_VECTOR        17      //FF008BH
#define UART4_VECTOR        18      //FF0093H
#define TMR3_VECTOR         19      //FF009BH
#define TMR4_VECTOR         20      //FF00A3H
#define CMP_VECTOR          21      //FF00ABH
#define I2C_VECTOR          24      //FF00C3H
#define USB_VECTOR          25      //FF00CBH
#define PWMA_VECTOR         26      //FF00D3H
#define PWMB_VECTOR         27      //FF00DBH
#define CANBUS_VECTOR       28      //FF00E3H
#define CAN2BUS_VECTOR      29      //FF00EBH
#define LINBUS_VECTOR       30      //FF00F3H

#define RTC_VECTOR          36      //FF0123H
#define P0_VECTOR           37      //FF012BH
#define P1_VECTOR           38      //FF0133H
#define P2_VECTOR           39      //FF013BH
#define P3_VECTOR           40      //FF0143H
#define P4_VECTOR           41      //FF014BH
#define P5_VECTOR           42      //FF0153H
#define P6_VECTOR           43      //FF015BH
#define P7_VECTOR           44      //FF0163H
#define DMA_M2M_VECTOR      47      //FF017BH
#define DMA_ADC_VECTOR      48      //FF0183H
#define DMA_SPI_VECTOR      49      //FF018BH
#define DMA_UR1T_VECTOR     50      //FF0193H
#define DMA_UR1R_VECTOR     51      //FF019BH
#define DMA_UR2T_VECTOR     52      //FF01A3H
#define DMA_UR2R_VECTOR     53      //FF01ABH
#define DMA_UR3T_VECTOR     54      //FF01B3H
#define DMA_UR3R_VECTOR     55      //FF01BBH
#define DMA_UR4T_VECTOR     56      //FF01C3H
#define DMA_UR4R_VECTOR     57      //FF01CBH
#define DMA_LCM_VECTOR      58      //FF01D3H
#define LCM_VECTOR          59      //FF01DBH
#define DMA_I2CT_VECTOR     60      //FF01E3H
#define DMA_I2CR_VECTOR     61      //FF01EBH
#define I2S_VECTOR          62      //FF01F3H
#define DMA_I2ST_VECTOR     63      //FF01FBH
#define DMA_I2SR_VECTOR     64      //FF0203H

//=============================================================

#define	TRUE	1
#define	FALSE	0

#define	PolityLow			0	//ȼж
#define	PolityHigh			1	//ȼж

#define		ENABLE		1
#define		DISABLE		0

#endif
