// #include "u8g2_porting.h"

#include "u8g2_test.h"

uint8_t index = 0;

//---------------U8g2测试函数

#define SEND_BUFFER_DISPLAY_MS(u8g2, ms) \
	do                                   \
	{                                    \
		u8g2_SendBuffer(u8g2);           \
		HAL_Delay(ms);                   \
	} while (0);

#if 0

// width: 128, height: 48
code unsigned char bilibili[] U8X8_PROGMEM = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xe0, 0x03, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0x01, 0xfc, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0xfc, 0x00, 0x00, 0x3c, 0xc0, 0x0f, 0x00, 0x80, 0x03, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x07, 0xfc, 0x00, 0x00, 0x3c, 0xc0, 0x0f, 0x00, 0xc0, 0x07, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xfc, 0x00, 0x00, 0x3c, 0x80, 0x0f, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x0f, 0x00, 0x00, 0x80, 0x0f, 0xf8, 0x00, 0x00, 0x3c, 0x80, 0x0f, 0x00, 0x80, 0x07, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0x00, 0x78, 0x80, 0x0f, 0x00, 0x80, 0x07, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0x00, 0x78, 0x80, 0x0f, 0x00, 0x80, 0x07, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0x80, 0x79, 0x80, 0x0f, 0x00, 0x98, 0x07, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0xe0, 0x79, 0x9f, 0x0f, 0x00, 0xbe, 0xe7, 0x01, 0xc0, 0x07, 0x10, 0x40, 0x00, 0x1f, 0xf8, 0x00, 0xe0, 0x7b, 0x1f, 0x0f, 0x00, 0xbe, 0xe7, 0x01, 0xc0, 0x87, 0x1f, 0xe0, 0x0f, 0x1f, 0xf8, 0x00, 0xe0, 0x7b, 0x1e, 0x0f, 0x00, 0x3e, 0xe7, 0x01, 0xc0, 0xe7, 0x3f, 0xe0, 0x3f, 0x1f, 0xf0, 0x00, 0xe0, 0x7b, 0x1e, 0x0f, 0x00, 0x3e, 0xe7, 0x01, 0xc0, 0xe7, 0x3f, 0xe0, 0x3f, 0x1f, 0xf0, 0x00, 0x60, 0x71, 0x1e, 0x0f, 0x00, 0x34, 0xe7, 0x01, 0xc0, 0xe7, 0x07, 0x00, 0x3f, 0x1f, 0xf0, 0x00, 0x00, 0x70, 0x00, 0x1f, 0x00, 0x00, 0x07, 0x00, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0xc0, 0x73, 0x1e, 0x1f, 0x00, 0x3c, 0xc7, 0x01, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0xc0, 0x73, 0x1e, 0x1f, 0x00, 0x7c, 0xe7, 0x01, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x00, 0xc0, 0x73, 0x1e, 0x1f, 0x00, 0x7c, 0xef, 0x01, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x01, 0xc0, 0x77, 0x1e, 0x1e, 0x00, 0x7c, 0xef, 0x01, 0xc0, 0x07, 0x00, 0x03, 0x00, 0x1f, 0xf0, 0xff, 0xc1, 0xf7, 0x1e, 0xfe, 0x1f, 0x78, 0xef, 0x01, 0xc0, 0x07, 0x70, 0x37, 0x00, 0x1f, 0xe0, 0xff, 0x87, 0xf7, 0x1e, 0xfe, 0xff, 0x78, 0xee, 0x01, 0xc0, 0x07, 0xe0, 0x3f, 0x00, 0x1f, 0xe0, 0xff, 0x9f, 0xf7, 0x1e, 0xfe, 0xff, 0x79, 0xce, 0x01, 0xc0, 0x07, 0xc0, 0x18, 0x00, 0x1f, 0xe0, 0xff, 0xbf, 0xe7, 0x1e, 0xfe, 0xff, 0x7b, 0xce, 0x01, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0xc7, 0xbf, 0xe7, 0x1e, 0xfe, 0xf8, 0x77, 0xce, 0x01, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x0f, 0x3f, 0xe7, 0x1c, 0xfe, 0xf0, 0x77, 0xce, 0x03, 0xc0, 0x07, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0xcf, 0x3f, 0xe7, 0x1c, 0xfe, 0xf8, 0xf3, 0xce, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xe0, 0xef, 0x1f, 0xe7, 0x1c, 0xfe, 0xfe, 0xf1, 0xce, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xe0, 0xff, 0x0f, 0xcf, 0x1c, 0xfc, 0xff, 0xf0, 0xc0, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff, 0x07, 0xe0, 0xff, 0x03, 0x06, 0x1c, 0xfc, 0x7f, 0x60, 0xc0, 0x01, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x03, 0xe0, 0xff, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
// width: 128, height: 48
code unsigned char three_support[] U8X8_PROGMEM = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xfe, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x80, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x80, 0x0f, 0xf0, 0x01, 0x00, 0x00, 0xfc, 0xff, 0x01, 0x00, 0x00, 0xc0, 0xfd, 0xff, 0x00, 0x00, 0xc0, 0x7f, 0xfe, 0x01, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x01, 0x00, 0xc0, 0x1f, 0xf8, 0x03, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x01, 0x00, 0xc0, 0x0f, 0xf0, 0x03, 0x00, 0x00, 0xfe, 0xff, 0x07, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x01, 0x00, 0xc0, 0x67, 0xe6, 0x03, 0x00, 0x00, 0xfc, 0xff, 0x03, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x01, 0x00, 0xc0, 0x67, 0xe6, 0x03, 0x00, 0x00, 0xf8, 0xff, 0x01, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x00, 0x00, 0xc0, 0x67, 0xe6, 0x03, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x00, 0x00, 0xc0, 0x67, 0xee, 0x03, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x00, 0x00, 0x80, 0x7f, 0xfe, 0x01, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0xe0, 0xfd, 0xff, 0x00, 0x00, 0x80, 0x7f, 0xfe, 0x01, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0xe0, 0xfd, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0x00, 0xe0, 0xfd, 0x7f, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0x00, 0xf8, 0xf9, 0x01, 0x00, 0x00, 0xe0, 0xfd, 0x7f, 0x00, 0x00, 0x00, 0xfe, 0x7f, 0x00, 0x00, 0x00, 0xf8, 0xf0, 0x00, 0x00, 0x00, 0xe0, 0xfd, 0x1f, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0x30, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };


void draw(u8g2_t *u8g2)
{
	u8g2_ClearBuffer(u8g2); 
	
    u8g2_SetFontMode(u8g2, 1); /*字体模式选择*/
    u8g2_SetFontDirection(u8g2, 0); /*字体方向选择*/
     u8g2_SetFont(u8g2, u8g2_font_u8glib_4_tf); /*字库选择*/
    u8g2_DrawStr(u8g2, 0, 20, "U");
    
    u8g2_SetFontDirection(u8g2, 1);
    u8g2_SetFont(u8g2, u8g2_font_u8glib_4_tf);
    u8g2_DrawStr(u8g2, 21,8,"8");
        
    u8g2_SetFontDirection(u8g2, 0);
    u8g2_SetFont(u8g2, u8g2_font_u8glib_4_tf);
    u8g2_DrawStr(u8g2, 51,30,"g");
    u8g2_DrawStr(u8g2, 67,30,"\xb2");
    
    u8g2_DrawHLine(u8g2, 2, 35, 47);
    u8g2_DrawHLine(u8g2, 3, 36, 47);
    u8g2_DrawVLine(u8g2, 45, 32, 12);
    u8g2_DrawVLine(u8g2, 46, 33, 12);
  
    u8g2_SetFont(u8g2, u8g2_font_u8glib_4_tf);
    u8g2_DrawStr(u8g2, 1,54,"github.com/olikraus/u8g2");
	
	u8g2_SendBuffer(u8g2);
	HAL_Delay(1000);
}






//进度条显示
void testDrawProcess(u8g2_t *u8g2)
{
    char buff[20] = {0};
    uint16_t i = 0;
	for( i=10;i<=80;i=i+2)
	{
		u8g2_ClearBuffer(u8g2); 

		sprintf(buff,"%d%%",(int)(i/80.0*100));
        // sprintf(buff,"%d%%",i);

		u8g2_SetFont(u8g2,u8g2_font_u8glib_4_tf);
		u8g2_DrawStr(u8g2,16,10,"STM32 U8g2");//字符显示

		u8g2_SetFont(u8g2,u8g2_font_u8glib_4_tf);
		u8g2_DrawStr(u8g2,100,29,buff);//当前进度显示

		u8g2_DrawRBox(u8g2,16,20,i,10,4);//圆角填充框矩形框
		u8g2_DrawRFrame(u8g2,16,20,80,10,4);//圆角矩形

		u8g2_SendBuffer(u8g2);
	}
	HAL_Delay(500);
}


//字体测试 数字英文可选用 u8g2_font_ncenB..(粗) 系列字体
//u8g2_font_unifont_t_symbols/u8g2_font_unifont_h_symbols(细 圆润)
void testShowFont(u8g2_t *u8g2)
{
	uint16_t t = 1000;
	char testStr[14] = "STC32G12K128";
	
	u8g2_ClearBuffer(u8g2);

	u8g2_SetFont(u8g2,u8g2_font_u8glib_4_tf);
	u8g2_DrawStr(u8g2,16,5,testStr);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	
	u8g2_SetFont(u8g2,u8g2_font_5x8_mf);
	u8g2_DrawStr(u8g2,16,30,testStr);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	
    u8g2_SetFont(u8g2,u8g2_font_5x7_t_cyrillic);
	u8g2_DrawStr(u8g2,16,60,testStr);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
    u8g2_SendBuffer(u8g2);
	
}

//画空心矩形
void testDrawFrame(u8g2_t *u8g2)
{
	uint16_t t = 1000;
	uint16_t x = 16;
	uint16_t y = 32;
	uint16_t w = 50;
	uint16_t h = 20;
	u8g2_ClearBuffer(u8g2);
	u8g2_DrawStr(u8g2,0, 15, "DrawFrame");

	u8g2_DrawFrame(u8g2, x, y, w, h);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawFrame(u8g2, x+w+5, y-10, w-20, h+20);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
}

//画实心圆角矩形
void testDrawRBox(u8g2_t *u8g2)
{
	uint16_t t = 1000;
	uint16_t x = 16;
	uint16_t y = 32;
	uint16_t w = 50;
	uint16_t h = 20;
	uint16_t r = 3;
	u8g2_ClearBuffer(u8g2);
	u8g2_DrawStr(u8g2,0, 15, "DrawRBox");

	u8g2_DrawRBox(u8g2, x, y, w, h, r);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawRBox(u8g2, x+w+5, y-10, w-20, h+20, r);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
}

//画空心圆
void testDrawCircle(u8g2_t *u8g2)
{
	uint16_t t = 600;
	uint16_t stx = 0;  //画图起始x
	uint16_t sty = 16; //画图起始y
	uint16_t with = 16;//一个图块的间隔
	uint16_t r = 15;   //圆的半径

    uint16_t temp = 0;
	u8g2_ClearBuffer(u8g2);
	u8g2_DrawStr(u8g2, 0, 15, "DrawCircle");

	u8g2_DrawCircle(u8g2, stx, sty - 1 + with, r, U8G2_DRAW_UPPER_RIGHT); //右上
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawCircle(u8g2, stx + with, sty, r, U8G2_DRAW_LOWER_RIGHT); //右下
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
#if 1 //此处注意传递参数一定为uint16
	u8g2_DrawCircle(u8g2, stx - 1 + with * 3, sty - 1 + with, r, U8G2_DRAW_UPPER_LEFT); //左上
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
#else
	u8g2_DrawCircle(u8g2, temp, (sty - 1) + with, r, U8G2_DRAW_UPPER_LEFT); //左上
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
#endif
	u8g2_DrawCircle(u8g2, stx - 1 + with * 4, sty, r, U8G2_DRAW_LOWER_LEFT); //左下
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawCircle(u8g2, stx - 1 + with * 2, sty - 1 + with * 2, r, U8G2_DRAW_ALL);//整个圆
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	
    u8g2_DrawCircle(u8g2, 32*3, 32, 31, U8G2_DRAW_ALL);//右侧整个圆
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
}

//画实心椭圆
void testDrawFilledEllipse(u8g2_t *u8g2)
{
	int t = 800;
	int with = 16;//一个图块的间隔
	int rx = 27;  //椭圆x方向的半径
	int ry = 22;  //椭圆y方向的半径
	u8g2_ClearBuffer(u8g2);
	u8g2_DrawStr(u8g2,0, 14, "DrawFilledEllipse");

	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawFilledEllipse(u8g2, 0, with, rx, ry, U8G2_DRAW_LOWER_RIGHT);//右下
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawFilledEllipse(u8g2, with * 4 - 1, with, rx, ry, U8G2_DRAW_LOWER_LEFT); //左下
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawFilledEllipse(u8g2, 0, with * 4 - 1, rx, ry, U8G2_DRAW_UPPER_RIGHT); //右上
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawFilledEllipse(u8g2, with * 4 - 1, with * 4 - 1, rx, ry, U8G2_DRAW_UPPER_LEFT); //左上
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
	u8g2_DrawFilledEllipse(u8g2, with * 6, with * 2.5, rx, ry, U8G2_DRAW_ALL);//整个椭圆
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
}

//环形测试
void testDrawMulti(u8g2_t *u8g2)
{
    uint16_t i = 0; 
    uint16_t j = 0;
	u8g2_ClearBuffer(u8g2);
	for (j = 0; j < 64; j+=16)          //打点
	{
		for (i = 0; i < 128; i+=16)
		{
			u8g2_DrawPixel(u8g2, i, j);
			u8g2_SendBuffer(u8g2);
		}
	}

#if 1
	//实心矩形逐渐变大
    u8g2_ClearBuffer(u8g2);
	for( i=30; i>0; i-=2)
	{
		u8g2_DrawBox(u8g2,i*2,i,128-i*4,64-2*i);
		u8g2_SendBuffer(u8g2);
	}
	//空心矩形逐渐变小
	u8g2_ClearBuffer(u8g2);
	for( i=0; i<32; i+=2)
	{
		u8g2_DrawFrame(u8g2,i*2,i,128-i*4,64-2*i);
		u8g2_SendBuffer(u8g2);
	}

	//实心圆角矩形逐渐变大
	u8g2_ClearBuffer(u8g2);
	for( i=30; i>0; i-=2)
	{
		u8g2_DrawRBox(u8g2,i*2,i,128-i*4,64-2*i,10-i/3);
		u8g2_SendBuffer(u8g2);
	}
#endif
#if 0
    //空心圆角矩形逐渐变小
	u8g2_ClearBuffer(u8g2);
	for( i=0; i<32; i+=2)
	{
		u8g2_DrawRFrame(u8g2,i*2,i,128-i*4,64-2*i,10-i/3);
		u8g2_SendBuffer(u8g2);
	}
#endif
#if 0	    
	//实心圆逐渐变大
	u8g2_ClearBuffer(u8g2);
	for( i=2; i<50; i+=3)
	{
		u8g2_DrawDisc(u8g2,64,32,i, U8G2_DRAW_ALL);
		u8g2_SendBuffer(u8g2);
	}

	//空心圆逐渐变小
	u8g2_ClearBuffer(u8g2);
	for( i=62; i>0; i-=3)
	{
		u8g2_DrawCircle(u8g2,64,32,i, U8G2_DRAW_ALL);
		u8g2_SendBuffer(u8g2);
	}
#endif
#if 0 
	//实心椭圆逐渐变大
    u8g2_ClearBuffer(u8g2);
	for( i=2; i<32; i+=3)
	{
		u8g2_DrawFilledEllipse(u8g2,64,32, i*2, i, U8G2_DRAW_ALL);
		u8g2_SendBuffer(u8g2);
	}
  
   
    //空心椭圆逐渐变小
    u8g2_ClearBuffer(u8g2);
	for( i=32; i>0; i-=3)
	{
		u8g2_DrawEllipse(u8g2,64,32, i*2, i, U8G2_DRAW_ALL);
		u8g2_SendBuffer(u8g2);
	}
#endif    
}



void testDrawXBM(u8g2_t *u8g2)
{
	int t = 1000;
	u8g2_ClearBuffer(u8g2);
	u8g2_DrawStr(u8g2,0, 14, "DrawXBM");

	u8g2_DrawXBM(u8g2,0, 16, 128, 48, bilibili);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);

	u8g2_ClearBuffer(u8g2);
	u8g2_DrawStr(u8g2,0, 14, "bilibili");
	u8g2_DrawXBM(u8g2,0, 16, 128, 48, three_support);
	SEND_BUFFER_DISPLAY_MS(u8g2,t);
}

#endif

void u8g2_prepare(u8g2_t *u8g2)
{
	//u8g2_ClearBuffer(u8g2);
	u8g2_SetFont(u8g2, u8g2_font_6x10_tf);
	u8g2_SetFontRefHeightExtendedText(u8g2);
	u8g2_SetDrawColor(u8g2, 1);
	u8g2_SetFontPosTop(u8g2);
	u8g2_SetFontDirection(u8g2, 0);
}

static void u8g2_box_title(u8g2_t *u8g2, uint8_t a)
{
	u8g2_DrawStr(u8g2, 10 + a * 2, 5, "U8g2");
	u8g2_DrawStr(u8g2, 10, 20, "GraphicsTest");
	u8g2_DrawFrame(u8g2, 0, 0, u8g2_GetDisplayWidth(u8g2), u8g2_GetDisplayHeight(u8g2));
}

static void u8g2_box_frame(u8g2_t *u8g2, uint8_t a)
{
	u8g2_DrawStr(u8g2, 0, 0, "drawBox");
	u8g2_DrawBox(u8g2, 5, 10, 20, 10);
	u8g2_DrawBox(u8g2, 10 + a, 15, 30, 7);
	u8g2_DrawStr(u8g2, 0, 30, "drawFrame");
	u8g2_DrawFrame(u8g2, 5, 10 + 30, 20, 10);
	u8g2_DrawFrame(u8g2, 10 + a, 15 + 30, 30, 7);
}

static void u8g2_disc_circle(u8g2_t *u8g2, uint8_t a)
{
	u8g2_DrawStr(u8g2, 0, 0, "drawDisc");
	u8g2_DrawDisc(u8g2, 10, 18, 9, U8G2_DRAW_ALL);
	u8g2_DrawDisc(u8g2, 24 + a, 16, 7, U8G2_DRAW_ALL);
	u8g2_DrawStr(u8g2, 0, 30, "drawCircle");

	u8g2_DrawCircle(u8g2, 10, 18 + 30, 9, U8G2_DRAW_ALL);
	u8g2_DrawCircle(u8g2, 24 + a, 16 + 30, 7, U8G2_DRAW_ALL);
	//   u8g2.drawCircle(24+a,16+30,7);
}

static void u8g2_r_frame(u8g2_t *u8g2, uint8_t a)
{
	u8g2_DrawStr(u8g2, 0, 0, "drawRFrame/Box");

	u8g2_DrawRFrame(u8g2, 5, 10, 40, 30, a + 1);  //圆角矩形
	u8g2_DrawRFrame(u8g2, 50, 10, 25, 40, a + 1); //圆角矩形
												  //   u8g2.drawRBox(50, 10,25,40, a+1);
}

static void u8g2_string(u8g2_t *u8g2, uint8_t a)
{
	u8g2_SetFontDirection(u8g2, 0);
	u8g2_DrawStr(u8g2, 30 + a, 31, " 0");
	u8g2_SetFontDirection(u8g2, 1);
	u8g2_DrawStr(u8g2, 30, 31 + a, " 90");
	u8g2_SetFontDirection(u8g2, 2);
	u8g2_DrawStr(u8g2, 30 - a, 31, " 180");
	u8g2_SetFontDirection(u8g2, 3);
	u8g2_DrawStr(u8g2, 30, 31 - a, " 270");
}

static void u8g2_line(u8g2_t *u8g2, uint8_t a)
{
	u8g2_DrawStr(u8g2, 0, 0, " drawLine");
	u8g2_DrawLine(u8g2, 7 + a, 10, 40, 55);
	u8g2_DrawLine(u8g2, 7 + a * 2, 10, 60, 55);
	u8g2_DrawLine(u8g2, 7 + a * 3, 10, 80, 55);
	u8g2_DrawLine(u8g2, 7 + a * 4, 10, 100, 55);
}

static void u8g2_triangle(u8g2_t *u8g2, uint8_t a)
{
	uint16_t offset = a;
	u8g2_DrawStr(u8g2, 0, 0, " drawTriangle");

	u8g2_DrawTriangle(u8g2, 14, 7, 45, 30, 10, 40);
	u8g2_DrawTriangle(u8g2, (14 + offset), (7 - offset), (45 + offset), (30 - offset), (57 + offset), (10 - offset));
	u8g2_DrawTriangle(u8g2, (57 + offset * 2), 10, (45 + offset * 2), 30, (86 + offset * 2), 53);
	u8g2_DrawTriangle(u8g2, (10 + offset), (40 + offset), (45 + offset), (30 + offset), (86 + offset), (53 + offset));
}

static void u8g2_ascii_1(u8g2_t *u8g2)
{
	uint8_t x, y;
	char s[2] = " ";

	u8g2_DrawStr(u8g2, 0, 0, "ASCII page 1");

	for (y = 0; y < 6; y++)
	{
		for (x = 0; x < 16; x++)
		{
			s[0] = y * 16 + x + 32;
			u8g2_DrawStr(u8g2, x * 7, y * 10 + 10, s);
		}
	}
}

static void u8g2_ascii_2(u8g2_t *u8g2)
{
	uint8_t x, y;
	char s[2] = " ";
	u8g2_DrawStr(u8g2, 0, 0, "ASCII page 2");
	for (y = 0; y < 6; y++)
	{
		for (x = 0; x < 16; x++)
		{
			s[0] = y * 16 + x + 160;
			u8g2_DrawStr(u8g2, x * 7, y * 10 + 10, s);
		}
	}
}

static void u8g2_extra_page(u8g2_t *u8g2, uint8_t a)
{
	u8g2_DrawStr(u8g2, 0, 0, "Unicode");
	u8g2_SetFont(u8g2, u8g2_font_unifont_t_symbols);
	u8g2_SetFontPosTop(u8g2);
	u8g2_DrawGlyph(u8g2, 0, 24, 0x2600);
	u8g2_DrawStr(u8g2, 5, 24, " ");
	u8g2_DrawGlyph(u8g2, 8, 24, 0x2601);
	switch (a)
	{
	case 0:
	case 1:
	case 2:
	case 3:
		u8g2_DrawGlyph(u8g2, a * 3, 36, 0x2602);
		break;
	case 4:
	case 5:
	case 6:
	case 7:
		u8g2_DrawGlyph(u8g2, a * 3, 36, 0x2614);
		break;
	}
}

static void u8g2_xor(u8g2_t *u8g2, uint8_t a)
{
	uint8_t i;
	u8g2_DrawStr(u8g2, 0, 0, "XOR");
	u8g2_SetFontMode(u8g2, 1); /*字体模式选择*/
	u8g2_SetDrawColor(u8g2, 2);

	for (i = 0; i < 5; i++)
	{
		u8g2_DrawBox(&u8g2, 10 + i * 16, 18 + (i & 1) * 4, 21, 31);
	}
	u8g2_DrawStr(u8g2, 5 + a, 19, "XOR XOR XOR XOR");
	u8g2_SetDrawColor(u8g2, 0);
	u8g2_DrawStr(u8g2, 5 + a, 29, "CLR CLR CLR CLR");
	u8g2_SetDrawColor(u8g2, 1);
	u8g2_DrawStr(u8g2, 5 + a, 39, "SET SET SET SET");
	u8g2_SetFontMode(u8g2, 0);
}

#define cross_width 24
#define cross_height 24
static unsigned char code cross_bits[] U8X8_PROGMEM = {
	0x00,
	0x18,
	0x00,
	0x00,
	0x24,
	0x00,
	0x00,
	0x24,
	0x00,
	0x00,
	0x42,
	0x00,
	0x00,
	0x42,
	0x00,
	0x00,
	0x42,
	0x00,
	0x00,
	0x81,
	0x00,
	0x00,
	0x81,
	0x00,
	0xC0,
	0x00,
	0x03,
	0x38,
	0x3C,
	0x1C,
	0x06,
	0x42,
	0x60,
	0x01,
	0x42,
	0x80,
	0x01,
	0x42,
	0x80,
	0x06,
	0x42,
	0x60,
	0x38,
	0x3C,
	0x1C,
	0xC0,
	0x00,
	0x03,
	0x00,
	0x81,
	0x00,
	0x00,
	0x81,
	0x00,
	0x00,
	0x42,
	0x00,
	0x00,
	0x42,
	0x00,
	0x00,
	0x42,
	0x00,
	0x00,
	0x24,
	0x00,
	0x00,
	0x24,
	0x00,
	0x00,
	0x18,
	0x00,
};

#define cross_fill_width 24
#define cross_fill_height 24
static unsigned char code cross_fill_bits[] U8X8_PROGMEM = {
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x00,
	0x18,
	0x64,
	0x00,
	0x26,
	0x84,
	0x00,
	0x21,
	0x08,
	0x81,
	0x10,
	0x08,
	0x42,
	0x10,
	0x10,
	0x3C,
	0x08,
	0x20,
	0x00,
	0x04,
	0x40,
	0x00,
	0x02,
	0x80,
	0x00,
	0x01,
	0x80,
	0x18,
	0x01,
	0x80,
	0x18,
	0x01,
	0x80,
	0x00,
	0x01,
	0x40,
	0x00,
	0x02,
	0x20,
	0x00,
	0x04,
	0x10,
	0x3C,
	0x08,
	0x08,
	0x42,
	0x10,
	0x08,
	0x81,
	0x10,
	0x84,
	0x00,
	0x21,
	0x64,
	0x00,
	0x26,
	0x18,
	0x00,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
};

#define cross_block_width 14
#define cross_block_height 14
static unsigned char code cross_block_bits[] U8X8_PROGMEM = {
	0xFF,
	0x3F,
	0x01,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0xC1,
	0x20,
	0xC1,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0x01,
	0x20,
	0xFF,
	0x3F,
};

static void u8g2_bitmap_overlay(u8g2_t *u8g2, uint8_t a)
{
	uint8_t frame_size = 28;
	u8g2_DrawStr(u8g2, 0, 0, "Bitmap overlay");

	u8g2_DrawStr(u8g2, frame_size + 12, "Solid / transparent");
	//   u8g2.drawStr(0, frame_size + 12, "Solid / transparent");
	u8g2_SetBitmapMode(u8g2, false /* solid */);
	u8g2_DrawFrame(u8g2, 0, 10, frame_size, frame_size);

	u8g2_DrawXBMP(u8g2, 2, 12, cross_width, cross_height, cross_bits);
	// u8g2.drawXBMP(2, 12, cross_width, cross_height, cross_bits);
	if (a & 4)
		u8g2_DrawXBMP(u8g2, 7, 17, cross_block_width, cross_block_height, cross_block_bits);
	// u8g2.drawXBMP(7, 17, cross_block_width, cross_block_height, cross_block_bits);

	u8g2_SetBitmapMode(u8g2, true /* transparent */);
	// u8g2.setBitmapMode(true /* transparent*/);
	u8g2_DrawFrame(u8g2, frame_size + 5, 10, frame_size, frame_size);
	// u8g2.drawFrame(frame_size + 5, 10, frame_size, frame_size);
	u8g2_DrawXBMP(u8g2, frame_size + 7, 12, cross_width, cross_height, cross_bits);
	// u8g2.drawXBMP(frame_size + 7, 12, cross_width, cross_height, cross_bits);
	if (a & 4)
		u8g2_DrawXBMP(u8g2, frame_size + 12, 17, cross_block_width, cross_block_height, cross_block_bits);
	// u8g2.drawXBMP(frame_size + 12, 17, cross_block_width, cross_block_height, cross_block_bits);
}

static void u8g2_bitmap_modes(u8g2_t *u8g2, uint8_t transparent)
{
	const uint8_t frame_size = 24;

	u8g2_DrawBox(u8g2, 0, frame_size * 0.5, frame_size * 5, frame_size);
	u8g2_DrawStr(u8g2, frame_size * 0.5, 50, "Black");
	u8g2_DrawStr(u8g2, frame_size * 2, 50, "White");
	u8g2_DrawStr(u8g2, frame_size * 3.5, 50, "XOR");

	if (!transparent)
	{
		u8g2_SetBitmapMode(u8g2, false /* solid */);
		u8g2_DrawStr(u8g2, 0, 0, "Solid bitmap");
	}
	else
	{
		u8g2_SetBitmapMode(u8g2, true /* transparent */);
		u8g2_DrawStr(u8g2, 0, 0, "Transparent bitmap");
	}
	u8g2_SetDrawColor(u8g2, 0);
	u8g2_DrawXBMP(u8g2, frame_size * 0.5, 24, cross_width, cross_height, cross_bits);

	u8g2_SetDrawColor(u8g2, 1);
	u8g2_DrawXBMP(u8g2, frame_size * 2, 24, cross_width, cross_height, cross_bits);

	u8g2_SetDrawColor(u8g2, 2);
	u8g2_DrawXBMP(u8g2, frame_size * 3.5, 24, cross_width, cross_height, cross_bits);
}

void test_Display(u8g2_t *u8g2, uint8_t draw_state)
{
	u8g2_prepare();
	switch (draw_state >> 3)
	{
	case 0:
		u8g2_box_title(u8g2, draw_state & 7);
		break;
	case 1:
		u8g2_box_frame(u8g2, draw_state & 7);
		break;
	case 2:
		u8g2_disc_circle(u8g2, draw_state & 7);
		break;
	case 3:
		u8g2_r_frame(u8g2, draw_state & 7);
		break;
	case 4:
		u8g2_string(u8g2, draw_state & 7);
		break;
	case 5:
		u8g2_line(u8g2, draw_state & 7);
		break;
	case 6:
		u8g2_triangle(u8g2, draw_state & 7);
		break;
	case 7:
		u8g2_ascii_1(u8g2);
		break;
	case 8:
		u8g2_ascii_2(u8g2);
		break;
	case 9:
		u8g2_extra_page(u8g2, draw_state & 7);
		break;
	case 10:
		u8g2_xor(u8g2, draw_state & 7);
		break;
	case 11:
		u8g2_bitmap_modes(u8g2, 0);
		break;
	case 12:
		u8g2_bitmap_modes(u8g2, 1);
		break;
	case 13:
		u8g2_bitmap_overlay(u8g2, draw_state & 7);
		break;
	}
}
