/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ͨADCɼADCֵADCֵüΪ1~16.

ֵֻ֧, ֶ֧ͬʱ, вԤ֪Ľ.

³1,10/ٶṩؼ. ûֻҪKeyCodeǷ0жϼǷ.

ʱ:
1: Сʱ+.
2: Сʱ-.
3: +.
4: -.

******************************************/

#include "FreeRTOS.h"
#include "task.h"

#include "STC32G_ADC.h"

#include "adckey.h"
#include "rtc.h"
//#include "display.h"

#define ADCKEY_CHANNEL          0                       //ADCͨP1.0
#define ADC_OFFSET              64                      //ADCɨʱƫΧ


static void prvAdcKeyInit( void );
static void prvAdcCalculateKey( void );
static void prvAdcKeyEvent( void );


static uint8_t ucKeyState;                              //ADC״̬
static uint8_t ucKeyState1;
static uint8_t ucKeyState2;
static uint8_t ucKeyState3;
static uint8_t ucKeyHoldCnt;                            //¼ʱ

uint8_t ucKeyCode;                                      //ûʹõļ, 1~16Ч

/* ADCɨ */
portTASK_FUNCTION( vAdcKeyTask, pvParameters )
{
    
	UNUSED( pvParameters );

    prvAdcKeyInit();
    while(1)
    {
        prvAdcCalculateKey();
        prvAdcKeyEvent();

        vTaskDelay(10);
    }
    
    vTaskDelete(NULL);
}   

static void prvAdcKeyInit( void )
{
//    P1M1 |= 0x01;                                       // P1.0 Ϊ ADC 
//    P1M0 &= ~0x01;

    ucKeyState  = 0;
    ucKeyState1 = 0;
    ucKeyState2 = 0;
    ucKeyState3 = 0;                                    //״̬
    ucKeyHoldCnt = 0;                                   //¼ʱ
    ucKeyCode = 0;                                      //ûʹõļ, 1~16Ч
}

/***************** ADC̼ *****************************
·㷨: Coody
ADC̷ںܶʵʲƷ, ֤ȶɿ, ʹʹõĤ,ܿɿ.
16,ϸӦADCֵΪ (4096 / 16) * k = 256 * k, k = 1 ~ 16, ر, k=16ʱ,ӦADCֵ4095.
ʵʻƫ,жʱƫ, ADC_OFFSETΪ+-ƫ, ADCֵ (256*k-ADC_OFFSET)  (256*k+ADC_OFFSET)֮ΪЧ.
һʱ,ͲһADC,10ms.
Ϊ˱żȻADCֵ, ߱ADC½ʱ, ʹ3ADCֵƫΧʱ, ADCֵΪЧ.
㷨, ܱ֤ǳɿ.
**********************************************/
static void prvAdcCalculateKey( void )
{
    uint16_t usResult;
    uint8_t i;
    uint16_t j;
    
    usResult = Get_ADCResult(ADCKEY_CHANNEL);
    
    if(usResult < (256 - ADC_OFFSET))
    {
        ucKeyState = 0;                                 //״̬0
        ucKeyHoldCnt = 0;
    }
    
    j = 256;
    for (i = 1; i <= 16; i++)
    {
        if ((usResult >= (j - ADC_OFFSET)) &&
            (usResult <= (j + ADC_OFFSET)))
           break;                                       //жǷƫΧ
        j += 256;
    }
    
    ucKeyState3 = ucKeyState2;
    ucKeyState2 = ucKeyState1;
    
    if (i > 16)
        ucKeyState1 = 0;                                //Ч
    else                                                //Ч
    {
        ucKeyState1 = i;
        if ((ucKeyState3 == ucKeyState2) &&
            (ucKeyState2 == ucKeyState1) &&
            (ucKeyState3 > 0) &&
            (ucKeyState2 > 0) &&
            (ucKeyState1 > 0))
        {
            if (ucKeyState == 0)                        //һμ⵽
            {
                ucKeyCode = i;                          //
                ucKeyState = i;                         //״̬
                ucKeyHoldCnt = 0;
            }
            
            if (ucKeyState == i)                        //⵽ͬһ
            {
                if (++ucKeyHoldCnt >= 100)              //1,10ÿٶRepeat Key
                {
                    ucKeyHoldCnt = 90;
                    ucKeyCode  = i;                     //
                }
            }
            else
                ucKeyHoldCnt = 0;                       //ʱ0
        }
    }
}

static void prvAdcKeyEvent( void )
{
    uint8_t ucCode;
    
    ucCode = ucKeyCode;
    ucKeyCode = 0;
    
    if (ucCode > 0)                                     //м
    {
//        pucLEDBuffer[6] = ucCode / 10;                  //ʾ
//        pucLEDBuffer[7] = ucCode % 10;                  //ʾ

        switch (ucCode)
        {
        case 1:                                         //hour +1
            if (++ucHour >= 24)
                ucHour = 0;
            break;
        case 2:                                         //hour -1
            if (--ucHour >= 24)
                ucHour = 23;
            break;
        case 3:                                         //minute +1
            ucSecond = 0;
            if (++ucMinute >= 60)
                ucMinute = 0;
            break;
        case 4:                                         //minute -1
            ucSecond = 0;
            if (--ucMinute >= 60)
                ucMinute = 59;
            break;
        default:
            return;
        }
        
        vRtcUpdateDisplay();
    }
}


