/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#ifndef	__STC32G_LCM_H
#define	__STC32G_LCM_H

#include	"FreeRTOS.h"

//========================================================================
//                              λ
//========================================================================

sbit LCD_RS = P4^5;      ///л
sbit LCD_WR = P4^2;      //д
sbit LCD_RD = P4^4;      //
sbit LCD_CS = P3^4;      //Ƭѡ
sbit LCD_RESET = P4^3;   //λ

//========================================================================
//                              
//========================================================================

#define LCM_WRITE_CMD()					LCMIFCR = ((LCMIFCR & ~0x07) | 0x84)
#define LCM_WRITE_DAT()					LCMIFCR = ((LCMIFCR & ~0x07) | 0x85)
#define LCM_READ_CMD()					LCMIFCR = ((LCMIFCR & ~0x07) | 0x86)
#define LCM_READ_DAT()					LCMIFCR = ((LCMIFCR & ~0x07) | 0x87)

#define SET_LCM_DAT_LOW(n)			LCMIFDATL = (n)
#define SET_LCM_DAT_HIGH(n)			LCMIFDATH = (n)

//========================================================================
//                              
//========================================================================

#define	MODE_I8080			0	//I8080ģʽ
#define	MODE_M6800			1	//M6800ģʽ

#define	BIT_WIDE_8			0	//8λݿ
#define	BIT_WIDE_16			2	//16λݿ

//========================================================================
//                              
//========================================================================

typedef struct
{
	uint8_t	LCM_Enable;				//LCMӿʹ  	ENABLE,DISABLE
	uint8_t	LCM_Mode;				//LCMӿģʽ  	MODE_I8080,MODE_M6800
	uint8_t	LCM_Bit_Wide;			//LCMݿ  	BIT_WIDE_8,BIT_WIDE_16
	uint8_t	LCM_Setup_Time;			//LCMͨݽʱ  	0~7
	uint8_t	LCM_Hold_Time;			//LCMͨݱʱ  	0~3
} LCM_InitTypeDef;


//========================================================================
//                              ⲿ
//========================================================================
extern bit LcmFlag;
extern uint16_t LCM_Cnt;

void LCM_Inilize(LCM_InitTypeDef *LCM);

#endif
