/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCMCU.com --------------------------------------------*/
/* --- Web: www.STCMCUDATA.com  ---------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/


/*************  ˵    **************

̻STC32GΪоƬʵ9бд.

ڲI2C߿ӻģʽSCL->P3.2, SDA->P3.3;
IOģI2CģʽSCL->P0.0, SDA->P0.1;
ͨⲿ P0.0->P3.2, P0.1->P3.3ʵI2CԷչܡ

ÿӼ1, ΧΪ0~9999.
ϵÿӷһμݣӻյֵͨ2.

******************************************/

#include "FreeRTOS.h"
#include "task.h"

#include "STC32G_UART.h"
#include "STC32G_I2C.h"
#include "STC32G_Soft_I2C.h"
#include "i2c_ps.h"

static uint16_t second;
static uint8_t temp[4];


/* RTC */
portTASK_FUNCTION( vI2C_PsTask, pvParameters )
{
    UNUSED( pvParameters );
    
    second = 0;
    while(1)
    {
        if(I2C_DisplayFlag)
        {
            I2C_DisplayFlag = 0;
            printf("UART2: %d%d%d%d\r\n", I2C_Buffer[0], I2C_Buffer[1], I2C_Buffer[2], I2C_Buffer[3]);
        }

		second++;         //+1
		if(second >= 9999)    second = 0;   //ΧΪ0~9999

		temp[0] = second / 1000;
		temp[1] = (second % 1000) / 100;
		temp[2] = (second % 100) / 10;
		temp[3] = second % 10;

		SI2C_WriteNbyte(0, temp, 4);
        
        vTaskDelay(1000);
    }
    
    vTaskDelete(NULL);
}   
