/*
 * FreeRTOS V202112.00
 * Copyright (C) 2020 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * http://www.FreeRTOS.org
 * http://aws.amazon.com/freertos
 *
 * 1 tab == 4 spaces!
 */

#ifndef FREERTOS_CONFIG_H
#define FREERTOS_CONFIG_H

#include "stc32g.h"
#include "intrins.h"

/*-----------------------------------------------------------
 * Application specific definitions.
 *
 * These definitions should be adjusted for your particular hardware and
 * application requirements.
 *
 * THESE PARAMETERS ARE DESCRIBED WITHIN THE 'CONFIGURATION' SECTION OF THE
 * FreeRTOS API DOCUMENTATION AVAILABLE ON THE FreeRTOS.org WEB SITE.
 *
 * See http://www.freertos.org/a00110.html
 *----------------------------------------------------------*/

/*-----------------------------------------------------------
 * 汾ʷ
 *
 * V1.0.2 (2022-4-27)
 *     pvParametersʼѹջ
 *     (עpvParametersַʱֻе24λЧλ8λʱԶ0)
 *
 * V1.0.1 (2022-4-26)
 *     ޷ʹxdata
 *
 * V1.0.0 (2022-4-24)
 *     ֲɹ
 *----------------------------------------------------------*/


/***************************************************************************************************************/
/*                                        STC32-251ѡ                                            */
/***************************************************************************************************************/
#define configPORT_VERSION_NUMBER               "V1.0.2"                //STCֲ汾

#define configUSE_ROMHUGE                       0                       //1 ROMʹHUGEģʽ0ʹLARGEģʽ
#define MAIN_Fosc                               ( 24000000UL )          //ϵͳƵ

#if ( configUSE_ROMHUGE == 0 )
    #pragma ROM ( LARGE )
#else
    #pragma ROM ( HUGE )
#endif

#pragma WARNING DISABLE = 47                                            //ر47ž: unreferenced local variable
#pragma WARNING DISABLE = 138                                           //ر138ž: expression with possibly no effect
#pragma WARNING DISABLE = 183                                           //ر183ž: dead assignment eliminated

#ifndef configUSE_ROMHUGE
    #error Missing definition:  configUSE_ROMHUGE must be defined in FreeRTOSConfig.h as either 1 or 0.
#endif

//#define UNUSED(expr)      (void)(expr)
#define UNUSED(expr)        if ((expr) == 0)


/***************************************************************************************************************/
/*                                        FreeRTOSѡ                                             */
/***************************************************************************************************************/

#define configUSE_PREEMPTION                    1                       //1ʹռʽںˣ0ʹЭ
#define configUSE_TIME_SLICING                  1                       //1ʹʱƬ(Ĭʽʹܵ)
#define configUSE_PORT_OPTIMISED_TASK_SELECTION	0                       //1ⷽѡһҪе
                                                                        //һӲǰָʹõ
                                                                        //MCUûЩӲָĻ˺ӦΪ0
#define configUSE_TICKLESS_IDLE                 0                       //1õ͹ticklessģʽ
#define configUSE_QUEUE_SETS                    0                       //Ϊ1ʱö
#define configCPU_CLOCK_HZ                      (MAIN_Fosc)             //CPUƵ
#define configTICK_RATE_HZ                      ((TickType_t)1000)      //ʱӽƵʣΪ1000,ھ1ms
#define configMAX_PRIORITIES                    (32)                    //ʹõȼ
#define configDEFAULT_PRIORITIES                (tskIDLE_PRIORITY + 1)  //Ĭȼ
#define configMINIMAL_STACK_SIZE                ((unsigned short)256)   //ʹõĶջС
#define configDEFAULT_STACK_SIZE                ((unsigned short)256)   //Ĭ϶ջС
#define configMAX_TASK_NAME_LEN                 (8)                     //ַ
#define configUSE_IDLE_HOOK						0                       //1ʹÿй,0ʹ /*void vApplicationIdleHook( void );*/
#define configUSE_TICK_HOOK						0                       //1ʹʱƬ,0ʹ /*void vApplicationTickHook( void );*/
#define configSUPPORT_DYNAMIC_ALLOCATION        1                       //ֶ֧̬ڴ
#define configTOTAL_HEAP_SIZE					((size_t)(2*1024))      // ϵͳܵĶѴС

#define configUSE_16_BIT_TICKS                  0                       //ϵͳļͣ
                                                                        //1ʾΪ16λ޷Σ0ʾΪ32λ޷
#define configIDLE_SHOULD_YIELD                 1                       //Ϊ1ʱCPUʹȨͬȼû
#define configUSE_TASK_NOTIFICATIONS            1                       //Ϊ1ʱ֪ͨܣĬϿ
#define configUSE_MUTEXES                       1                       //Ϊ1ʱʹûź
#define configQUEUE_REGISTRY_SIZE               0                       //Ϊ0ʱʾöм¼ֵǿ
                                                                        //¼ĶкźĿ
#define configCHECK_FOR_STACK_OVERFLOW          0                       //0ʱöջ⹦ܣʹô˹
                                                                        //ûṩһջӺʹõĻ
                                                                        //ֵΪ12Ϊջⷽ
#define configUSE_RECURSIVE_MUTEXES             0                       //Ϊ1ʱʹõݹ黥ź
#define configUSE_MALLOC_FAILED_HOOK            0                       //1ʹڴʧܹӺ
#define configUSE_APPLICATION_TASK_TAG          0
#define configUSE_COUNTING_SEMAPHORES           0                       //Ϊ1ʱʹüź

#define configGENERATE_RUN_TIME_STATS	        0                       //Ϊ1ʱʱͳƹ
#define configUSE_TRACE_FACILITY				0                       //Ϊ1ÿӻٵ
#define configUSE_STATS_FORMATTING_FUNCTIONS	0                       //configUSE_TRACE_FACILITYͬʱΪ1ʱ3
                                                                        //prvWriteNameToBuffer(),vTaskList(),
                                                                        //vTaskGetRunTimeStats()
/* Co-routine definitions. */
#define configUSE_CO_ROUTINES 			        0                       //Ϊ1ʱЭ̣ЭԺļcroutine.c
#define configMAX_CO_ROUTINE_PRIORITIES         (2)                     //Э̵ЧȼĿ

/* Set the following definitions to 1 to include the API function, or zero
to exclude the API function. */

#define INCLUDE_xTaskGetSchedulerState          0
#define INCLUDE_vTaskPrioritySet                1
#define INCLUDE_uxTaskPriorityGet               1
#define INCLUDE_vTaskDelete                     1
#define INCLUDE_vTaskCleanUpResources           0
#define INCLUDE_vTaskSuspend                    1
#define INCLUDE_vTaskDelayUntil                 1
#define INCLUDE_vTaskDelay                      1
#define INCLUDE_eTaskGetState                   0
#define INCLUDE_xTimerPendFunctionCall          0



#endif /* FREERTOS_CONFIG_H */
