
$INCLUDE(STC8H.INC)

;************************************************

    DEVSTATE_ATTACHED       EQU     0
    DEVSTATE_POWERED        EQU     1
    DEVSTATE_DEFAULT        EQU     2
    DEVSTATE_ADDRESS        EQU     3
    DEVSTATE_CONFIGURED     EQU     4
    DEVSTATE_SUSPENDED      EQU     5
    
    EXTRN   CODE(USB_INIT)
    EXTRN   CODE(USB_OUT_DONE)
    EXTRN   CODE(_USB_SENDDATA)
    
    EXTRN   DATA(DEVICESTATE)
    EXTRN   DATA(OUTNUMBER)
    
    EXTRN   BIT(BUSBFEATUREREADY)
    EXTRN   BIT(BUSBINBUSY)
    EXTRN   BIT(BUSBOUTREADY)
    EXTRN   XDATA(USBFEATUREBUFFER)
    EXTRN   XDATA(USBINBUFFER)
    EXTRN   XDATA(USBOUTBUFFER)
    
    PUBLIC  USER_DEVICEDESC
    PUBLIC  USER_PRODUCTDESC
    PUBLIC  USER_STCISPCMD

;************************************************

?DT?MAIN    SEGMENT DATA                ;ݶ
    RSEG    ?DT?MAIN
USER_DEVICEDESC:
    DS      3
USER_PRODUCTDESC:
    DS      3
USER_STCISPCMD:
    DS      3

;************************************************

    CSEG    AT  0000H
    LJMP    RESET                       ;λת

;************************************************

?PR?MAIN    SEGMENT CODE                ;
    RSEG    ?PR?MAIN
RESET:
    MOV     R0,#7FH
    CLR     A
CLEARRAM:
    MOV     @R0,A
    DJNZ    R0,CLEARRAM
    
    MOV     SP,#7FH

    ORL     P_SW2,#80H
    CLR     A
    MOV     P0M0,A
    MOV     P0M1,A
    MOV     P1M0,A
    MOV     P1M1,A
    MOV     P2M0,A
    MOV     P2M1,A
    MOV     P3M0,A
    MOV     P3M1,A
    MOV     P4M0,A
    MOV     P4M1,A
    MOV     P5M0,A
    MOV     P5M1,A
    MOV     P6M0,A
    MOV     P6M1,A
    MOV     P7M0,A
    MOV     P7M1,A
    
    MOV     USER_DEVICEDESC+0,#0
    MOV     USER_DEVICEDESC+1,#0
    MOV     USER_DEVICEDESC+2,#0
    
    MOV     USER_PRODUCTDESC+0,#0
    MOV     USER_PRODUCTDESC+1,#0
    MOV     USER_PRODUCTDESC+2,#0
    
    MOV     USER_STCISPCMD+0,#0FFH      ;ʼͣظλ
    MOV     USER_STCISPCMD+1,#HIGH TAB_STCISPCMD
    MOV     USER_STCISPCMD+2,#LOW TAB_STCISPCMD
    
    LCALL   USB_INIT                    ;ʼUSBģ
    
    ORL     IE2,#80H                    ;ʹUSBж
    SETB    EA

WAITUSBCFG:
    MOV     A,DEVICESTATE               ;ȴUSB
    CJNE    A,#DEVSTATE_CONFIGURED,WAITUSBCFG
    
MAIN:
    JNB     BUSBOUTREADY,MAIN           ;ѯǷнյ
    
    MOV     R3,#01H
    MOV     R2,#HIGH USBOUTBUFFER
    MOV     R1,#LOW USBOUTBUFFER
    MOV     R5,OUTNUMBER
    MOV     R4,#00H
    LCALL   _USB_SENDDATA               ;ԭ·
 
    CALL    USB_OUT_DONE                ;յݴɺٵô˺
    
    JMP     MAIN

;************************************************

TAB_STCISPCMD:
    DB      "@STCISP#",0

;************************************************

    END
