
$INCLUDE(STC8H.INC)

;************************************************

    DEVSTATE_ATTACHED       EQU     0
    DEVSTATE_POWERED        EQU     1
    DEVSTATE_DEFAULT        EQU     2
    DEVSTATE_ADDRESS        EQU     3
    DEVSTATE_CONFIGURED     EQU     4
    DEVSTATE_SUSPENDED      EQU     5
    
    EXTRN   CODE(USB_INIT)
    EXTRN   CODE(USB_OUT_DONE)
    EXTRN   CODE(_USB_SENDDATA)
    
    EXTRN   XDATA(DEVICESTATE)
    EXTRN   XDATA(OUTNUMBER)
    
    EXTRN   BIT(BUSBFEATUREREADY)
    EXTRN   BIT(BUSBINBUSY)
    EXTRN   BIT(BUSBOUTREADY)
    EXTRN   XDATA(USBFEATUREBUFFER)
    EXTRN   XDATA(USBINBUFFER)
    EXTRN   XDATA(USBOUTBUFFER)
    
    PUBLIC  USER_DEVICEDESC
    PUBLIC  USER_PRODUCTDESC
    PUBLIC  USER_STCISPCMD
    PUBLIC  USB_OUT_CALLBACK

;************************************************

?XD?MAIN    SEGMENT XDATA              ;ݶ

    RSEG    ?XD?MAIN
USER_DEVICEDESC:
    DS      3
USER_PRODUCTDESC:
    DS      3
USER_STCISPCMD:
    DS      3

;************************************************

    CSEG    AT  0000H
    LJMP    RESET                       ;λת

;************************************************

?PR?MAIN    SEGMENT CODE                ;
    RSEG    ?PR?MAIN
RESET:
    MOV     R0,#7FH
    CLR     A
CLEARRAM:
    MOV     @R0,A
    DJNZ    R0,CLEARRAM
    
    MOV     SP,#7FH

    ORL     P_SW2,#80H
    CLR     A
    MOV     P0M0,A
    MOV     P0M1,A
    MOV     P1M0,A
    MOV     P1M1,A
    MOV     P2M0,A
    MOV     P2M1,A
    MOV     P3M0,A
    MOV     P3M1,A
    MOV     P4M0,A
    MOV     P4M1,A
    MOV     P5M0,A
    MOV     P5M1,A
    MOV     P6M0,A
    MOV     P6M1,A
    MOV     P7M0,A
    MOV     P7M1,A
    
    MOV     DPTR,#USER_DEVICEDESC
    CLR     A
    MOVX    @DPTR,A
    INC     DPTR
    MOVX    @DPTR,A
    INC     DPTR
    MOVX    @DPTR,A
    
    MOV     DPTR,#USER_PRODUCTDESC
    CLR     A
    MOVX    @DPTR,A
    INC     DPTR
    MOVX    @DPTR,A
    INC     DPTR
    MOVX    @DPTR,A
    
    MOV     DPTR,#USER_STCISPCMD        ;ʼͣظλ
    MOV     A,#0FFH
    MOVX    @DPTR,A
    INC     DPTR
    MOV     A,#HIGH TAB_STCISPCMD
    MOVX    @DPTR,A
    INC     DPTR
    MOV     A,#LOW TAB_STCISPCMD
    MOVX    @DPTR,A
    
    LCALL   USB_INIT                    ;ʼUSBģ
    
    ORL     IE2,#80H                    ;ʹUSBж
    SETB    EA

    MOV     DPTR,#DEVICESTATE
WAITUSBCFG:
    MOVX    A,@DPTR                     ;ȴUSB
    CJNE    A,#DEVSTATE_CONFIGURED,WAITUSBCFG
    
MAIN:
    JMP     MAIN

;************************************************
;ܣUSB-CDCڽݵĻص
;صUSBжڽյʱԶ
;          صɴݺҪ1
;أ1USBжϷԶɺβ
;          0USBͣմݣֱûе
;                 usb_OUT_done()USBŻ»ָ
;ע1ʱûusb_OUT_done()
;          ֻз0ʱҪusb_OUT_done()ֶβ
;          ǿҽusb_OUT_callback1
;************************************************
USB_OUT_CALLBACK:                       ;ʵUSBص
    MOV     R3,#01H
    MOV     R2,#HIGH USBOUTBUFFER
    MOV     R1,#LOW USBOUTBUFFER
    MOV     DPTR,#OUTNUMBER
    MOVX    A,@DPTR
    MOV     R5,A
    MOV     R4,#00H
    LCALL   _USB_SENDDATA               ;ԭ·
    SETB    C                           ;1
    RET

;************************************************

TAB_STCISPCMD:
    DB      "@STCISP#",0

;************************************************

    END
