
$INCLUDE(STC32G.INC)

;************************************************

    DEVSTATE_ATTACHED       EQU     0
    DEVSTATE_POWERED        EQU     1
    DEVSTATE_DEFAULT        EQU     2
    DEVSTATE_ADDRESS        EQU     3
    DEVSTATE_CONFIGURED     EQU     4
    DEVSTATE_SUSPENDED      EQU     5
    
    EXTRN   CODE(USB_INIT)
    EXTRN   CODE(USB_OUT_DONE)
    EXTRN   CODE(USB_SENDDATA)
    
    EXTRN   EDATA(DEVICESTATE)
    EXTRN   EDATA(OUTNUMBER)
    
    EXTRN   BIT(BUSBFEATUREREADY)
    EXTRN   BIT(BUSBINBUSY)
    EXTRN   BIT(BUSBOUTREADY)
    EXTRN   XDATA(USBFEATUREBUFFER)
    EXTRN   XDATA(USBINBUFFER)
    EXTRN   XDATA(USBOUTBUFFER)
    
    PUBLIC  USER_DEVICEDESC
    PUBLIC  USER_PRODUCTDESC
    PUBLIC  USER_STCISPCMD
    PUBLIC  USB_OUT_CALLBACK

;************************************************

?ED?MAIN    SEGMENT EDATA               ;ݶ
    RSEG    ?ED?MAIN
USER_DEVICEDESC:
    DS      4
USER_PRODUCTDESC:
    DS      4
USER_STCISPCMD:
    DS      4

;************************************************

    CSEG    AT  0000H
    LJMP    RESET                       ;λת

;************************************************

?PR?MAIN    SEGMENT CODE                ;
    RSEG    ?PR?MAIN
RESET:
    MOV     R0,#7FH
    CLR     A
CLEARRAM:
    MOV     @R0,A
    DJNZ    R0,CLEARRAM
    
    MOV     DR60,#0100H

    MOV     WTST,#00H
    MOV     CKCON,#00H
    SETB    EAXFR

    CLR     A
    MOV     P0M0,A
    MOV     P0M1,A
    MOV     P1M0,A
    MOV     P1M1,A
    MOV     P2M0,A
    MOV     P2M1,A
    MOV     P3M0,A
    MOV     P3M1,A
    MOV     P4M0,A
    MOV     P4M1,A
    MOV     P5M0,A
    MOV     P5M1,A
    MOV     P6M0,A
    MOV     P6M1,A
    MOV     P7M0,A
    MOV     P7M1,A
    
    MOV     DR0,#0
    MOV     USER_DEVICEDESC,DR0
    
    MOV     DR0,#0
    MOV     USER_PRODUCTDESC,DR0
    
    MOV     WR0,#WORD2 TAB_STCISPCMD
    MOV     WR2,#WORD0 TAB_STCISPCMD
    MOV     USER_STCISPCMD,DR0          ;ʼͣظλ
    
    LCALL   USB_INIT                    ;ʼUSBģ
    
    SETB    EA
    
WAITUSBCFG:
    MOV     R11,DEVICESTATE               ;ȴUSB
    CJNE    A,#DEVSTATE_CONFIGURED,WAITUSBCFG
    
MAIN:
    JMP     MAIN

;************************************************
;ܣUSB-CDCڽݵĻص
;صUSBжڽյʱԶ
;          صɴݺҪ1
;أ1USBжϷԶɺβ
;          0USBͣմݣֱûе
;                 usb_OUT_done()USBŻ»ָ
;ע1ʱûusb_OUT_done()
;          ֻз0ʱҪusb_OUT_done()ֶβ
;          ǿҽusb_OUT_callback1
;************************************************
USB_OUT_CALLBACK:                       ;ʵUSBص
    MOV     WR0,#WORD2 USBOUTBUFFER
    MOV     WR2,#WORD0 USBOUTBUFFER
    MOV     R6,#00H
    MOV     R7,OUTNUMBER
    LCALL   USB_SENDDATA                ;ԭ·
    SETB    C                           ;1
    RET

;************************************************

TAB_STCISPCMD:
    DB      "@STCISP#",0

;************************************************

    END
