#include "stc8h.h"
#include "string.h"

#define PRINTF_SEGLED
#include "stc32_stc8_usb.h"

#include "vk.h"

void sys_init();
void DelayXms(int n);

char *USER_DEVICEDESC = NULL;
char *USER_PRODUCTDESC = NULL;
char *USER_STCISPCMD = "@STCISP#";                      //ԶλISPûӿ


BYTE code OLED12864_IMG[8][128] =
{
	0x00,0x00,0x00,0xe0,0xf0,0xf8,0xf8,0x9c,0x1c,0x1c,0x1c,0x1c,0x1c,0x38,0x38,0x18,
	0x00,0x10,0x18,0x1c,0x1c,0xdc,0xfc,0xfc,0xfc,0x1c,0x1c,0x1c,0x1c,0x0c,0x04,0xc0,
	0xe0,0xf0,0x78,0x38,0x38,0x1c,0x1c,0x1c,0x1c,0x3c,0x38,0x08,0x00,0x00,0xc0,0xf0,
	0xfc,0xfc,0x7c,0xfc,0xf0,0x00,0x00,0xc0,0xc0,0xe0,0xf8,0xfc,0xfc,0xfc,0x7c,0x0c,
	0x00,0xc0,0xc0,0xf0,0xf0,0x78,0x38,0x1c,0x1c,0x1c,0x1c,0x1c,0x38,0x38,0x08,0x00,
	0x80,0xf0,0xfc,0xfc,0xfc,0x00,0x00,0x00,0x00,0x00,0xc0,0xfc,0xfc,0xfc,0x0c,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x70,0x70,0xf0,0xe1,0xe3,0xe3,0xe3,0xe3,0xe7,0x7f,0x7f,0x3e,0x1c,0x00,0x00,
	0x00,0x00,0x00,0xf0,0xfe,0xff,0x7f,0x0f,0x03,0x00,0x00,0x00,0x00,0x00,0x1f,0x3f,
	0x7f,0x7f,0xf0,0xe0,0xe0,0xe0,0xe0,0x70,0x70,0x10,0x00,0x00,0xc0,0xf0,0xff,0xff,
	0x7f,0x03,0x00,0x03,0x0f,0x0f,0x0f,0x03,0xc3,0xf0,0xff,0xff,0x7f,0x03,0x00,0x00,
	0x1f,0x3f,0x3f,0x7f,0xf0,0xf0,0xe0,0xe0,0xe0,0x70,0x70,0x70,0x00,0x00,0x00,0x3c,
	0x3f,0x7f,0xff,0xf3,0xe0,0xe0,0xe0,0xe0,0x70,0x7e,0x3f,0x1f,0x0f,0x03,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x18,0x30,0x60,0xe0,
	0x40,0x00,0xf0,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
	0x30,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xf8,0x00,0x00,0x00,0x00,0x00,
	0xf8,0xf8,0x00,0x00,0x00,0x00,0xf0,0xf0,0x00,0x00,0x00,0x00,0xf8,0xf8,0x00,0x00,
	0x00,0x00,0xf0,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
	0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xf0,0xf0,0x00,0x00,0x00,0xc0,0xc0,0xc0,0xc0,
	0xc0,0xc0,0xc0,0xfe,0xfe,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xfe,0xfe,0xc0,
	0xc0,0xc0,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x1c,0x18,0x38,0x70,0x20,
	0x00,0x00,0x90,0xb0,0x98,0x9c,0x8c,0x86,0x83,0x82,0xf0,0xf0,0x82,0x83,0x86,0x8c,
	0x9c,0xb8,0x90,0x80,0x00,0x06,0x06,0x06,0x06,0xff,0xff,0x06,0x06,0x06,0x00,0x00,
	0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,
	0x00,0x00,0xff,0xff,0x00,0x00,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xff,0xff,0xc3,
	0xc3,0xc3,0xc3,0xc3,0xc3,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
	0x80,0x00,0x80,0x8f,0x0f,0x00,0x00,0x10,0x78,0xf0,0xc0,0x00,0x00,0x0f,0x0f,0x00,
	0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xf8,0x7e,0x0c,
	0x00,0x00,0x81,0xc1,0xc1,0x61,0x31,0x19,0x0d,0x07,0xff,0xff,0x07,0x1d,0x31,0x61,
	0xc1,0xc1,0x81,0x01,0x00,0x60,0x60,0x30,0x30,0x3f,0x1f,0x18,0x18,0x0c,0xcc,0xf0,
	0x7f,0x0f,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,
	0x00,0x00,0xff,0xff,0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3f,0x3f,0x30,
	0x33,0x36,0x3e,0x34,0x30,0x30,0x00,0xff,0xff,0x00,0x00,0x00,0x40,0xf0,0x7e,0x0f,
	0x01,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x02,0x00,0x00,0xf0,0xe0,
	0x01,0x07,0x3f,0xf8,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x0f,0x03,0x00,0x00,
	0x01,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x00,0x00,0x00,0x00,
	0x00,0x01,0x03,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x0e,0x07,0x03,0x01,
	0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x0f,0x0f,0x00,0x00,
	0x00,0x00,0x0f,0x0f,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
	0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x07,0x0f,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0f,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x08,0x44,0x44,0xc4,0xb8,0x00,0x00,0x00,0x00,0x08,0x04,0x04,
	0xc4,0x78,0x00,0xc0,0x60,0xfc,0x06,0x08,0x68,0xc8,0x0a,0x0a,0x0c,0x88,0x68,0x08,
	0x00,0x38,0xc4,0x44,0xc4,0xa4,0x38,0x00,0x00,0xf0,0x08,0x04,0x04,0x0c,0xf0,0x00,
	0x00,0x7c,0x44,0x44,0x44,0xc4,0x84,0x00,0x00,0x00,0x08,0x0c,0xfc,0x00,0x00,0x00,
	0xfe,0x02,0x4a,0x4a,0x4a,0x4a,0xfa,0x4a,0xca,0x4a,0x4a,0x02,0xfe,0x00,0x08,0x08,
	0x88,0x08,0xbe,0x08,0x08,0xc8,0x88,0x08,0x3e,0x08,0x88,0x08,0x08,0x00,0x00,0xfc,
	0x24,0x24,0x24,0x24,0x26,0x26,0x24,0x24,0x24,0x24,0x3c,0x00,0x80,0xfc,0x84,0x96,
	0xa4,0xfc,0x00,0x08,0xe8,0x2a,0x2c,0x28,0xe8,0x08,0x08,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x04,0x08,0x08,0x0c,0x07,0x00,0x00,0x00,0x08,0x0c,0x0a,0x09,
	0x08,0x08,0x00,0x00,0x00,0x1f,0x00,0x10,0x10,0x11,0x16,0x10,0x1c,0x13,0x10,0x10,
	0x00,0x07,0x0c,0x08,0x08,0x08,0x07,0x00,0x00,0x03,0x0c,0x08,0x08,0x04,0x03,0x00,
	0x00,0x04,0x08,0x08,0x08,0x04,0x07,0x00,0x00,0x00,0x08,0x08,0x0f,0x08,0x08,0x00,
	0x3f,0x10,0x14,0x14,0x14,0x14,0x17,0x14,0x15,0x17,0x14,0x10,0x3f,0x00,0x08,0x07,
	0x01,0x00,0x3f,0x20,0x20,0x20,0x21,0x20,0x30,0x1e,0x00,0x07,0x0c,0x20,0x1c,0x07,
	0x00,0x3f,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x3f,0x00,0x30,0x1f,0x20,0x26,
	0x20,0x3f,0x20,0x18,0x07,0x00,0x00,0x00,0x3f,0x20,0x3e,0x00,0x00,0x00,0x00,0x00,
};

BYTE code LCD12864_IMG[64][16] =
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x7F,0xC0,0xFF,0xFF,0x80,0x7F,0x00,0xFC,0x01,0xF8,0x01,0xFC,0x07,0xC0,0x3E,
    0x01,0xFF,0xF8,0xFF,0xFF,0x83,0xFF,0xE0,0xFC,0x03,0xF8,0x0F,0xFF,0x87,0xC0,0x3E,
    0x03,0xFF,0xF9,0xFF,0xFF,0x07,0xFF,0xE1,0xFE,0x07,0xF8,0x1F,0xFF,0x87,0xC0,0x7E,
    0x07,0xFF,0xF9,0xFF,0xFF,0x0F,0xFF,0xC1,0xFE,0x07,0xF0,0x3F,0xFF,0x0F,0xC0,0x7C,
    0x0F,0xC0,0x70,0x07,0xC0,0x1F,0x81,0xC1,0xFE,0x0F,0xF0,0x7E,0x07,0x0F,0x80,0x7C,
    0x0F,0x80,0x10,0x07,0xC0,0x3F,0x00,0x41,0xFE,0x1F,0xF0,0xFC,0x01,0x0F,0x80,0x7C,
    0x0F,0x80,0x00,0x0F,0xC0,0x7E,0x00,0x03,0xFE,0x3F,0xF1,0xF8,0x00,0x0F,0x80,0xFC,
    0x0F,0xE0,0x00,0x0F,0x80,0x7C,0x00,0x03,0xEE,0x3F,0xE1,0xF0,0x00,0x1F,0x80,0xF8,
    0x0F,0xFC,0x00,0x0F,0x80,0x7C,0x00,0x03,0xEF,0x7B,0xE1,0xF0,0x00,0x1F,0x00,0xF8,
    0x07,0xFF,0x80,0x0F,0x80,0xF8,0x00,0x03,0xEF,0xF3,0xE3,0xE0,0x00,0x1F,0x00,0xF8,
    0x01,0xFF,0xC0,0x1F,0x80,0xF8,0x00,0x07,0xEF,0xF7,0xE3,0xE0,0x00,0x1F,0x01,0xF8,
    0x00,0x7F,0xE0,0x1F,0x00,0xF8,0x00,0x07,0xCF,0xE7,0xC3,0xE0,0x00,0x3F,0x01,0xF0,
    0x00,0x0F,0xE0,0x1F,0x00,0xF8,0x00,0x07,0xC7,0xC7,0xC3,0xE0,0x00,0x3E,0x01,0xF0,
    0x00,0x03,0xE0,0x1F,0x00,0xF8,0x00,0x07,0xC7,0xC7,0xC3,0xE0,0x00,0x3E,0x01,0xF0,
    0x20,0x03,0xE0,0x3F,0x00,0xFC,0x01,0x0F,0xC7,0x8F,0xC3,0xF0,0x04,0x3E,0x03,0xE0,
    0x3C,0x07,0xE0,0x3E,0x00,0xFE,0x0F,0x0F,0x80,0x0F,0x83,0xF8,0x3C,0x3F,0x07,0xE0,
    0x7F,0xFF,0xC0,0x3E,0x00,0x7F,0xFE,0x0F,0x80,0x0F,0x81,0xFF,0xF8,0x3F,0xFF,0xC0,
    0x7F,0xFF,0x80,0x3E,0x00,0x3F,0xFE,0x0F,0x80,0x0F,0x80,0xFF,0xF8,0x1F,0xFF,0xC0,
    0x7F,0xFF,0x00,0x7E,0x00,0x1F,0xFE,0x1F,0x80,0x1F,0x80,0x7F,0xF8,0x0F,0xFF,0x00,
    0x0F,0xF8,0x00,0x7C,0x00,0x07,0xF0,0x1F,0x00,0x1F,0x00,0x1F,0xC0,0x03,0xFC,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

BYTE xdata cod[8];

void main()
{
    sys_init();
    usb_init();
    EA = 1;

    while (1)
    {
        if (bUsbOutReady)
        {
            if ((UsbOutBuffer[0] == 'K') &&
                (UsbOutBuffer[1] == 'E') &&
                (UsbOutBuffer[2] == 'Y') &&
                (UsbOutBuffer[3] == 'P'))
            {
                switch (UsbOutBuffer[5])
                {
                case VK_DIGIT_1:
                    printf("%08lx", 0x1234abcdL);
                    break;
                case VK_DIGIT_2:
                    SEG7_ShowLong(0x98765432, 16);
                    break;
                case VK_DIGIT_3:
                    SEG7_ShowFloat(3.1415);
                    break;
                case VK_DIGIT_4:
                    cod[0] = 0x3f;
                    cod[1] = 0x06;
                    cod[2] = 0x5b;
                    cod[3] = 0x4f;
                    cod[4] = 0x66;
                    cod[5] = 0x6d;
                    cod[6] = 0x7d;
                    cod[7] = 0x27;
                    SEG7_ShowCode(cod);
                    break;
                case VK_DIGIT_5:
                    cod[0] = 0x01;
                    cod[1] = 0xaa;
                    LED40_SendData(cod, 2);
                    break;
                case VK_DIGIT_6:
                    cod[0] = 0x0f;
                    cod[1] = 0x12;
                    cod[2] = 0x34;
                    cod[3] = 0x56;
                    cod[4] = 0x78;
                    LED40_SendData(cod, 5);
                    break;
                case VK_DIGIT_7:
                    cod[0] = 0x01;
                    cod[1] = 0xaa;
                    LED64_SendData(cod, 2);
                    break;
                case VK_DIGIT_8:
                    cod[0] = 0x0f;
                    cod[1] = 0x12;
                    cod[2] = 0x34;
                    cod[3] = 0x56;
                    cod[4] = 0x78;
                    LED64_SendData(cod, 5);
                    break;
                case VK_ALPHA_A:
                    LCD12864_DisplayOff();
                    break;
                case VK_ALPHA_B:
                    LCD12864_DisplayOn();
                    break;
                case VK_ALPHA_C:
                    LCD12864_CursorOff();
                    break;
                case VK_ALPHA_D:
                    LCD12864_CursorOn();
                    break;
                case VK_ALPHA_E:
                    LCD12864_CursorMoveLeft();
                    break;
                case VK_ALPHA_F:
                    LCD12864_CursorMoveRight();
                    break;
                case VK_ALPHA_G:
                    LCD12864_CursorReturnHome();
                    break;
                case VK_ALPHA_H:
                    LCD12864_ScrollLeft();
                    break;
                case VK_ALPHA_I:
                    LCD12864_ScrollRight();
                    break;
                case VK_ALPHA_J:
                    LCD12864_ScrollUp(16);
                    break;
                case VK_ALPHA_K:
                    LCD12864_AutoWrapOff();
                    break;
                case VK_ALPHA_L:
                    LCD12864_AutoWrapOn();
                    break;
                case VK_ALPHA_M:
                    LCD12864_ReverseLine(2);
                    break;
                case VK_ALPHA_N:
                    LCD12864_DisplayClear();
                    break;
                case VK_ALPHA_O:
                    LCD12864_ShowString(0, 0, "ڹо˹");
                    break;
                case VK_ALPHA_P:
                    LCD12864_ShowPicture(0, 0, 8, 64, (BYTE *)&LCD12864_IMG);
                    break;
                case VK_ALPHA_Q:
                    OLED12864_DisplayOff();
                    break;
                case VK_ALPHA_R:
                    OLED12864_DisplayOn();
                    break;
                case VK_ALPHA_S:
                    OLED12864_DisplayContent();
                    break;
                case VK_ALPHA_T:
                    OLED12864_DisplayEntire();
                    break;
                case VK_ALPHA_U:
                    OLED12864_HorizontalMirror();
                    break;
                case VK_ALPHA_V:
                    OLED12864_VerticalMirror();
                    break;
                case VK_ALPHA_W:
                    OLED12864_DisplayReverse();
                    break;
                case VK_ALPHA_X:
                    OLED12864_SetContrast(0x10);
                    break;
                case VK_ALPHA_Y:
                    OLED12864_SetContrast(0x80);
                    break;
                case VK_ALPHA_Z:
                    OLED12864_SetContrast(0xf0);
                    break;
                case VK_UP:
                    OLED12864_ScrollUp(1, 6, 200);
                    break;
                case VK_DOWN:
                    OLED12864_ScrollStart();
                    break;
                case VK_LEFT:
                    OLED12864_ScrollLeft(0, 2, 200);
                    break;
                case VK_RIGHT:
                OLED12864_ScrollRight(0, 2, 200);
                    break;
                case VK_HOME:
                    OLED12864_SetAddressMode(0);
                    break;
                case VK_END:
                    OLED12864_SetAddressMode(1);
                    break;
                case VK_PRIOR:
                    OLED12864_ScrollStop();
                    break;
                case VK_NEXT:
//                    OLED12864_ShowPicture(0, 0, 128, 8, (BYTE *)&OLED12864_IMG);
                    break;
                }
            }
            else
            {
                USB_SendData(UsbOutBuffer, 64);      //ԭ·, ڲHID
            }
            usb_OUT_done();
        }
    }
}

void sys_init()
{
    P_SW2 = 0x80;
    P3M0 = 0x00;
    P3M1 = 0x00;
}
