/*-------------------------------------------------------------------------
REG51U2.H

Header file for AtmelWM TS80C51U2
  
-------------------------------------------------------------------------*/

sfr		P0			=   0x80;			 

sbit  P0_7    =   P0^7;
sbit  P0_6    =   P0^6;
sbit  P0_5    =   P0^5;
sbit  P0_4    =   P0^4;
sbit  P0_3    =   P0^3;
sbit  P0_2    =   P0^2;
sbit  P0_1    =   P0^1;
sbit  P0_0    =   P0^0;

sfr		SP      =   0x81;
sfr		DPL     =   0x82;
sfr		DPH     =   0x83;

sfr		PCON    =   0x87;			 

sfr		TCON    =   0x88;             

sbit  TF1			=   TCON^7;
sbit  TR1			=   TCON^6;
sbit  TF0			=   TCON^5;
sbit  TR0			=   TCON^4;
sbit  IE1_		=   TCON^3;
sbit  IT1			=   TCON^2;
sbit  IE0_		=   TCON^1;
sbit  IT0			=   TCON^0;

sfr 	TMOD		=   0x89;			 

sfr 	TL0			=   0x8A;			 

sfr 	TL1			=   0x8B;			 

sfr 	TH0			=   0x8C;			 

sfr 	TH1			=   0x8D;			 

sfr 	AUXRR		=   0x8E; 			 

sfr 	CKCON		=   0x8F;			 

sfr		P1			=   0x90;			 

sbit  P1_7    =   P1^7;
sbit  P1_6    =   P1^6;
sbit  P1_5    =   P1^5;
sbit  P1_4    =   P1^4;
sbit  P1_3    =   P1^3;
sbit  P1_2    =   P1^2;
sbit  P1_1    =   P1^1;
sbit  P1_0    =   P1^0;

sbit  TXD_1B  =   P1^7;
sbit  RXD_1B  =   P1^6;
sbit  TXD_1A  =   P1^3;
sbit  RXD_1A  =   P1^2;
sbit  T2EX    =   P1^1;
sbit  T2      =   P1^0;

sfr 	SCON_0	=   0x98;			 

sbit  FE_0		=   SCON_0^7;
sbit  SM0_0		=   SCON_0^7;
sbit  SM1_0		=   SCON_0^6;
sbit  SM2_0		=   SCON_0^5;
sbit  REN_0		=   SCON_0^4;
sbit  TB8_0		=   SCON_0^3;
sbit  RB8_0		=   SCON_0^2;
sbit  TI_0		=   SCON_0^1;
sbit  RI_0		=   SCON_0^0;

sfr 	SBUF_0	=   0x99;			 

sfr 	BRL			=   0x9A;

sfr 	BDRCON	=   0x9B;

sfr 	BDRCON_1=   0x9C;

sfr 	P2			=   0xA0;			 

sbit  P2_7    =   P2^7;
sbit  P2_6    =   P2^6;
sbit  P2_5    =   P2^5;
sbit  P2_4    =   P2^4;
sbit  P2_3    =   P2^3;
sbit  P2_2    =   P2^2;
sbit  P2_1    =   P2^1;
sbit  P2_0    =   P2^0;

sfr 	AUXR1		=   0xA2;              

sfr 	WDTRST	=   0xA6;
			 
sfr 	WDTPRG	=   0xA7;			 

sfr 	IE			=   0xA8;			     

sbit  EA			=   IE^7;
sbit  ES_1		=   IE^6;
sbit  ET2			=   IE^5;
sbit  ES_0		=   IE^4;
sbit  ET1			=   IE^3;
sbit  EX1			=   IE^2;
sbit  ET0			=   IE^1;
sbit  EX0			=   IE^0;

sfr 	SADDR_0	=   0xA9;			 

sfr 	SADDR_1 =   0xAA;			 

sfr 	P3			=   0xB0;			 

sbit  P3_7    =   P3^7;
sbit  P3_6    =   P3^6;
sbit  P3_5    =   P3^5;
sbit  P3_4    =   P3^4;
sbit  P3_3    =   P3^3;
sbit  P3_2    =   P3^2;
sbit  P3_1    =   P3^1;
sbit  P3_0    =   P3^0;

sbit  RD      =   P3^7;
sbit  WR      =   P3^6;
sbit  T1      =   P3^5;
sbit  T0      =   P3^4;
sbit  INT1    =   P3^3;
sbit  INT0    =   P3^2;
sbit  TXD_0   =   P3^1;
sbit  RXD_0   =   P3^0;

sfr 	IPH			=   0xB7;			     

sfr 	IP			=   0xB8;			     

sbit  PS_1		=   IP^6;
sbit  PT2     =   IP^5;
sbit  PS_0		=   IP^4;
sbit  PT1			=   IP^3;
sbit  PX1			=   IP^2;
sbit  PT0			=   IP^1;
sbit  PX0			=   IP^0;

sfr 	SADEN_0	=   0xB9;	
		 
sfr 	SADEN_1 =   0xBA;

sfr 	SCON_1  =   0xC0;

sbit  FE_1		=   SCON_1^7;
sbit  SM0_1		=   SCON_1^7;
sbit  SM1_1		=   SCON_1^6;
sbit  SM2_1		=   SCON_1^5;
sbit  REN_1		=   SCON_1^4;
sbit  TB8_1		=   SCON_1^3;
sbit  RB8_1		=   SCON_1^2;
sbit  TI_1		=   SCON_1^1;
sbit  RI_1		=   SCON_1^0;

sfr 	SBUF_1  =   0xC1;

sfr 	T2CON		=   0xC8;             

sbit  TF2			=   T2CON^7;
sbit  EXF2		=   T2CON^6;
sbit  RCLK_0	=   T2CON^5;
sbit  TCLK_0	=   T2CON^4;
sbit  EXEN2		=   T2CON^3;
sbit  TR2			=   T2CON^2;
sbit  CT2			=   T2CON^1;
sbit  CPRL2		=   T2CON^0;

sfr 	T2MOD		=   0xC9;			 

sfr 	RCAP2L	=   0xCA;			 
sfr 	RCAP2H	=   0xCB;			 
sfr 	TL2			=   0xCC;			 
sfr 	TH2			=   0xCD;			 

sfr		PSW			=   0xD0;
			 
sbit  CY			=   PSW^7;
sbit  AC			=   PSW^6;
sbit  F0			=   PSW^5;
sbit  RS1			=   PSW^4;
sbit  RS0			=   PSW^3;
sbit  OV			=   PSW^2;
sbit  UD			=   PSW^1;
sbit  P				=   PSW^0;

sfr 	ACC			=   0xE0;			 

sfr 	B				=   0xF0;			 

